from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingCore

class vtkGridAxesActor2D(vtkmodules.vtkRenderingCore.vtkProp3D):
    bounds:'getset_descriptor'
    face:'getset_descriptor'
    force_opaque:'getset_descriptor'
    generate_edges:'getset_descriptor'
    generate_grid:'getset_descriptor'
    generate_ticks:'getset_descriptor'
    grid_bounds:'getset_descriptor'
    label_display_offset:'getset_descriptor'
    label_mask:'getset_descriptor'
    m_time:'getset_descriptor'
    notation:'getset_descriptor'
    precision:'getset_descriptor'
    property:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def GenerateEdgesOff(self) -> None: ...
    def GenerateEdgesOn(self) -> None: ...
    def GenerateGridOff(self) -> None: ...
    def GenerateGridOn(self) -> None: ...
    def GenerateTicksOff(self) -> None: ...
    def GenerateTicksOn(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetFace(self) -> int: ...
    def GetFaceMaxValue(self) -> int: ...
    def GetFaceMinValue(self) -> int: ...
    def GetForceOpaque(self) -> bool: ...
    def GetGenerateEdges(self) -> bool: ...
    def GetGenerateGrid(self) -> bool: ...
    def GetGenerateTicks(self) -> bool: ...
    def GetGridBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetLabelDisplayOffset(self) -> Tuple[int, int]: ...
    def GetLabelMask(self) -> int: ...
    def GetLabelTextProperty(self, axis:int) -> 'vtkTextProperty': ...
    def GetMTime(self) -> int: ...
    def GetNotation(self, axis:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPrecision(self, axis:int) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetTitle(self, axis:int) -> str: ...
    def GetTitleTextProperty(self, axis:int) -> 'vtkTextProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGridAxesActor2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGridAxesActor2D': ...
    def SetCustomTickPositions(self, axis:int, positions:'vtkDoubleArray') -> None: ...
    def SetFace(self, _arg:int) -> None: ...
    def SetForceOpaque(self, _arg:bool) -> None: ...
    def SetGenerateEdges(self, val:bool) -> None: ...
    def SetGenerateGrid(self, val:bool) -> None: ...
    def SetGenerateTicks(self, val:bool) -> None: ...
    @overload
    def SetGridBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetGridBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetLabelDisplayOffset(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetLabelDisplayOffset(self, _arg:Sequence[int]) -> None: ...
    def SetLabelMask(self, _arg:int) -> None: ...
    def SetLabelTextProperty(self, axis:int, __b:'vtkTextProperty') -> None: ...
    def SetNotation(self, axis:int, notation:int) -> None: ...
    def SetPrecision(self, axis:int, val:int) -> None: ...
    def SetProperty(self, __a:'vtkProperty') -> None: ...
    def SetTitle(self, axis:int, title:str) -> None: ...
    def SetTitleTextProperty(self, axis:int, __b:'vtkTextProperty') -> None: ...
    def UpdateGeometry(self, viewport:'vtkViewport', doRegularUpdate:bool) -> None: ...

class vtkGridAxesActor3D(vtkmodules.vtkRenderingCore.vtkProp3D):
    bounds:'getset_descriptor'
    face_mask:'getset_descriptor'
    force_opaque:'getset_descriptor'
    generate_edges:'getset_descriptor'
    generate_grid:'getset_descriptor'
    generate_ticks:'getset_descriptor'
    grid_bounds:'getset_descriptor'
    label_display_offset:'getset_descriptor'
    label_mask:'getset_descriptor'
    label_unique_edges_only:'getset_descriptor'
    notation:'getset_descriptor'
    number_of_x_labels:'getset_descriptor'
    number_of_y_labels:'getset_descriptor'
    number_of_z_labels:'getset_descriptor'
    precision:'getset_descriptor'
    property:'getset_descriptor'
    x_label_text_property:'getset_descriptor'
    x_notation:'getset_descriptor'
    x_precision:'getset_descriptor'
    x_title:'getset_descriptor'
    x_title_text_property:'getset_descriptor'
    x_use_custom_labels:'getset_descriptor'
    y_label_text_property:'getset_descriptor'
    y_notation:'getset_descriptor'
    y_precision:'getset_descriptor'
    y_title:'getset_descriptor'
    y_title_text_property:'getset_descriptor'
    y_use_custom_labels:'getset_descriptor'
    z_label_text_property:'getset_descriptor'
    z_notation:'getset_descriptor'
    z_precision:'getset_descriptor'
    z_title:'getset_descriptor'
    z_title_text_property:'getset_descriptor'
    z_use_custom_labels:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def GenerateEdgesOff(self) -> None: ...
    def GenerateEdgesOn(self) -> None: ...
    def GenerateGridOff(self) -> None: ...
    def GenerateGridOn(self) -> None: ...
    def GenerateTicksOff(self) -> None: ...
    def GenerateTicksOn(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetFaceMask(self) -> int: ...
    def GetForceOpaque(self) -> bool: ...
    def GetGenerateEdges(self) -> bool: ...
    def GetGenerateGrid(self) -> bool: ...
    def GetGenerateTicks(self) -> bool: ...
    def GetGridBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetLabelDisplayOffset(self) -> Tuple[int, int]: ...
    def GetLabelMask(self) -> int: ...
    def GetLabelTextProperty(self, axis:int) -> 'vtkTextProperty': ...
    def GetLabelUniqueEdgesOnly(self) -> bool: ...
    def GetNotation(self, axis:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPrecision(self, axis:int) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetRenderedBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetTitle(self, axis:int) -> str: ...
    def GetTitleTextProperty(self, axis:int) -> 'vtkTextProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGridAxesActor3D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGridAxesActor3D': ...
    def SetFaceMask(self, mask:int) -> None: ...
    def SetForceOpaque(self, _arg:bool) -> None: ...
    def SetGenerateEdges(self, val:bool) -> None: ...
    def SetGenerateGrid(self, val:bool) -> None: ...
    def SetGenerateTicks(self, val:bool) -> None: ...
    @overload
    def SetGridBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetGridBounds(self, _arg:Sequence[float]) -> None: ...
    def SetLabel(self, axis:int, index:int, value:float) -> None: ...
    @overload
    def SetLabelDisplayOffset(self, xoffset:int, yoffset:int) -> None: ...
    @overload
    def SetLabelDisplayOffset(self, offset:Sequence[int]) -> None: ...
    def SetLabelMask(self, mask:int) -> None: ...
    def SetLabelTextProperty(self, axis:int, __b:'vtkTextProperty') -> None: ...
    def SetLabelUniqueEdgesOnly(self, _arg:bool) -> None: ...
    def SetNotation(self, axis:int, notation:int) -> None: ...
    def SetNumberOfLabels(self, axis:int, val:int) -> None: ...
    def SetNumberOfXLabels(self, val:int) -> None: ...
    def SetNumberOfYLabels(self, val:int) -> None: ...
    def SetNumberOfZLabels(self, val:int) -> None: ...
    def SetPrecision(self, axis:int, val:int) -> None: ...
    def SetProperty(self, __a:'vtkProperty') -> None: ...
    def SetTitle(self, axis:int, title:str) -> None: ...
    def SetTitleTextProperty(self, axis:int, __b:'vtkTextProperty') -> None: ...
    def SetUseCustomLabels(self, axis:int, val:bool) -> None: ...
    def SetXLabel(self, index:int, value:float) -> None: ...
    def SetXLabelTextProperty(self, prop:'vtkTextProperty') -> None: ...
    def SetXNotation(self, notation:int) -> None: ...
    def SetXPrecision(self, val:int) -> None: ...
    def SetXTitle(self, title:str) -> None: ...
    def SetXTitleTextProperty(self, prop:'vtkTextProperty') -> None: ...
    def SetXUseCustomLabels(self, val:bool) -> None: ...
    def SetYLabel(self, index:int, value:float) -> None: ...
    def SetYLabelTextProperty(self, prop:'vtkTextProperty') -> None: ...
    def SetYNotation(self, notation:int) -> None: ...
    def SetYPrecision(self, val:int) -> None: ...
    def SetYTitle(self, title:str) -> None: ...
    def SetYTitleTextProperty(self, prop:'vtkTextProperty') -> None: ...
    def SetYUseCustomLabels(self, val:bool) -> None: ...
    def SetZLabel(self, index:int, value:float) -> None: ...
    def SetZLabelTextProperty(self, prop:'vtkTextProperty') -> None: ...
    def SetZNotation(self, notation:int) -> None: ...
    def SetZPrecision(self, val:int) -> None: ...
    def SetZTitle(self, title:str) -> None: ...
    def SetZTitleTextProperty(self, prop:'vtkTextProperty') -> None: ...
    def SetZUseCustomLabels(self, val:bool) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def UpdateGeometry(self, vp:'vtkViewport') -> None: ...

class vtkGridAxesHelper(vtkmodules.vtkCommonCore.vtkObject):
    class Faces(int): ...
    class LabelMasks(int): ...
    MAX_X:'LabelMasks'
    MAX_XY:'Faces'
    MAX_Y:'LabelMasks'
    MAX_YZ:'Faces'
    MAX_Z:'LabelMasks'
    MAX_ZX:'Faces'
    MIN_X:'LabelMasks'
    MIN_XY:'Faces'
    MIN_Y:'LabelMasks'
    MIN_YZ:'Faces'
    MIN_Z:'LabelMasks'
    MIN_ZX:'Faces'
    active_axes:'getset_descriptor'
    backface:'getset_descriptor'
    face:'getset_descriptor'
    grid_bounds:'getset_descriptor'
    label_mask:'getset_descriptor'
    label_visibilities:'getset_descriptor'
    matrix:'getset_descriptor'
    points:'getset_descriptor'
    transformed_face_normal:'getset_descriptor'
    transformed_points:'getset_descriptor'
    viewport_normals:'getset_descriptor'
    viewport_points:'getset_descriptor'
    viewport_points_as_double:'getset_descriptor'
    viewport_vectors:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetActiveAxes(self) -> 'vtkVector2i': ...
    def GetBackface(self) -> bool: ...
    def GetFace(self) -> int: ...
    def GetFaceMaxValue(self) -> int: ...
    def GetFaceMinValue(self) -> int: ...
    def GetGridBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetLabelMask(self) -> int: ...
    def GetLabelVisibilities(self) -> 'vtkTuple_IbLi4EE': ...
    def GetMatrix(self) -> 'vtkMatrix4x4': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoints(self) -> 'vtkTuple_I11vtkVector3dLi4EE': ...
    def GetTransformedFaceNormal(self) -> 'vtkVector3d': ...
    def GetTransformedPoints(self) -> 'vtkTuple_I11vtkVector3dLi4EE': ...
    def GetViewportNormals(self) -> 'vtkTuple_I11vtkVector2dLi4EE': ...
    def GetViewportPoints(self) -> 'vtkTuple_I11vtkVector2iLi4EE': ...
    def GetViewportPointsAsDouble(self) -> 'vtkTuple_I11vtkVector2dLi4EE': ...
    def GetViewportVectors(self) -> 'vtkTuple_I11vtkVector2dLi4EE': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGridAxesHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGridAxesHelper': ...
    def SetFace(self, _arg:int) -> None: ...
    @overload
    def SetGridBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetGridBounds(self, _arg:Sequence[float]) -> None: ...
    def SetLabelMask(self, _arg:int) -> None: ...
    def SetMatrix(self, __a:'vtkMatrix4x4') -> None: ...
    def TransformPoint(self, point:'vtkVector3d') -> 'vtkVector3d': ...
    def UpdateForViewport(self, viewport:'vtkViewport') -> bool: ...

class vtkGridAxesPlaneActor2D(vtkmodules.vtkRenderingCore.vtkProp3D):
    TICK_DIRECTION_BOTH:int
    TICK_DIRECTION_INWARDS:int
    TICK_DIRECTION_OUTWARDS:int
    bounds:'getset_descriptor'
    face:'getset_descriptor'
    generate_edges:'getset_descriptor'
    generate_grid:'getset_descriptor'
    generate_ticks:'getset_descriptor'
    grid_bounds:'getset_descriptor'
    property:'getset_descriptor'
    tick_direction:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateEdgesOff(self) -> None: ...
    def GenerateEdgesOn(self) -> None: ...
    def GenerateGridOff(self) -> None: ...
    def GenerateGridOn(self) -> None: ...
    def GenerateTicksOff(self) -> None: ...
    def GenerateTicksOn(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetFace(self) -> int: ...
    def GetFaceMaxValue(self) -> int: ...
    def GetFaceMinValue(self) -> int: ...
    def GetGenerateEdges(self) -> bool: ...
    def GetGenerateGrid(self) -> bool: ...
    def GetGenerateTicks(self) -> bool: ...
    def GetGridBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetTickDirection(self) -> int: ...
    def GetTickDirectionMaxValue(self) -> int: ...
    def GetTickDirectionMinValue(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGridAxesPlaneActor2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGridAxesPlaneActor2D': ...
    def SetFace(self, _arg:int) -> None: ...
    def SetGenerateEdges(self, _arg:bool) -> None: ...
    def SetGenerateGrid(self, _arg:bool) -> None: ...
    def SetGenerateTicks(self, _arg:bool) -> None: ...
    @overload
    def SetGridBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetGridBounds(self, _arg:Sequence[float]) -> None: ...
    def SetProperty(self, __a:'vtkProperty') -> None: ...
    def SetTickDirection(self, _arg:int) -> None: ...
    def SetTickPositions(self, axis:int, data:'vtkDoubleArray') -> None: ...
    def UpdateGeometry(self, vp:'vtkViewport') -> None: ...

