"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mode import Mode
from .profile_review_status_response import ProfileReviewStatusResponse
from .profile_status import ProfileStatus
from .url import URL, URLTypedDict
from mollie.types import BaseModel
from mollie.utils import validate_open_enum
import pydantic
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ReviewTypedDict(TypedDict):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    status: NotRequired[ProfileReviewStatusResponse]
    r"""The status of the requested changes."""


class Review(BaseModel):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    status: Annotated[
        Optional[ProfileReviewStatusResponse], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The status of the requested changes."""


class ProfileResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    chargebacks: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    methods: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    refunds: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    checkout_preview_url: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ProfileResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    chargebacks: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    methods: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    refunds: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    checkout_preview_url: Annotated[
        Optional[URL], pydantic.Field(alias="checkoutPreviewUrl")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ProfileResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    name: str
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """
    website: str
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """
    email: str
    r"""The email address associated with the profile's trade name or brand."""
    phone: str
    r"""The phone number associated with the profile's trade name or brand."""
    business_category: str
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """
    status: ProfileStatus
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: ProfileResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    description: NotRequired[str]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[List[str]]
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """
    review: NotRequired[ReviewTypedDict]
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """


class ProfileResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    name: str
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """

    website: str
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """

    email: str
    r"""The email address associated with the profile's trade name or brand."""

    phone: str
    r"""The phone number associated with the profile's trade name or brand."""

    business_category: Annotated[str, pydantic.Field(alias="businessCategory")]
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """

    status: Annotated[ProfileStatus, PlainValidator(validate_open_enum(False))]
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[ProfileResponseLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    description: Optional[str] = None
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        Optional[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = None
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """

    review: Optional[Review] = None
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """
