"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .metadata import Metadata, MetadataTypedDict
from .mode import Mode
from .subscription_method_response import SubscriptionMethodResponse
from .subscription_status import SubscriptionStatus
from .url import URL, URLTypedDict
from .url_nullable import URLNullable, URLNullableTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SubscriptionResponseApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str


class SubscriptionResponseApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str


class SubscriptionResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: Nullable[URLNullableTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    profile: Nullable[URLNullableTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    mandate: NotRequired[Nullable[URLNullableTypedDict]]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[Nullable[URLNullableTypedDict]]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class SubscriptionResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: Nullable[URLNullable]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    profile: Nullable[URLNullable]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    mandate: OptionalNullable[URLNullable] = UNSET
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: OptionalNullable[URLNullable] = UNSET
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["mandate", "payments"]
        nullable_fields = ["customer", "mandate", "profile", "payments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SubscriptionResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a subscription object. Will always contain the string `subscription` for this
    endpoint.
    """
    id: str
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    status: SubscriptionStatus
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    times: Nullable[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """
    times_remaining: Nullable[int]
    r"""Number of payments left for the subscription."""
    interval: str
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days`, `... weeks`, `... months`.
    """
    start_date: str
    r"""The start date of the subscription in `YYYY-MM-DD` format."""
    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """
    method: Nullable[SubscriptionMethodResponse]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""
    metadata: Nullable[MetadataTypedDict]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    webhook_url: str
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """
    customer_id: str
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: SubscriptionResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    next_payment_date: NotRequired[Nullable[str]]
    r"""The date of the next scheduled payment in `YYYY-MM-DD` format. If the subscription has been completed or canceled,
    this parameter will not be returned.
    """
    application_fee: NotRequired[SubscriptionResponseApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """
    mandate_id: NotRequired[str]
    canceled_at: NotRequired[Nullable[str]]
    r"""The subscription's date and time of cancellation, in ISO 8601 format. This parameter is omitted if the
    subscription is not canceled (yet).
    """


class SubscriptionResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a subscription object. Will always contain the string `subscription` for this
    endpoint.
    """

    id: str

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    status: Annotated[SubscriptionStatus, PlainValidator(validate_open_enum(False))]
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    times: Nullable[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """

    times_remaining: Annotated[Nullable[int], pydantic.Field(alias="timesRemaining")]
    r"""Number of payments left for the subscription."""

    interval: str
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days`, `... weeks`, `... months`.
    """

    start_date: Annotated[str, pydantic.Field(alias="startDate")]
    r"""The start date of the subscription in `YYYY-MM-DD` format."""

    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """

    method: Annotated[
        Nullable[SubscriptionMethodResponse], PlainValidator(validate_open_enum(False))
    ]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    metadata: Nullable[Metadata]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    webhook_url: Annotated[str, pydantic.Field(alias="webhookUrl")]
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """

    customer_id: Annotated[str, pydantic.Field(alias="customerId")]

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[SubscriptionResponseLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    next_payment_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="nextPaymentDate")
    ] = UNSET
    r"""The date of the next scheduled payment in `YYYY-MM-DD` format. If the subscription has been completed or canceled,
    this parameter will not be returned.
    """

    application_fee: Annotated[
        Optional[SubscriptionResponseApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    mandate_id: Annotated[Optional[str], pydantic.Field(alias="mandateId")] = None

    canceled_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="canceledAt")
    ] = UNSET
    r"""The subscription's date and time of cancellation, in ISO 8601 format. This parameter is omitted if the
    subscription is not canceled (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "nextPaymentDate",
            "applicationFee",
            "mandateId",
            "canceledAt",
        ]
        nullable_fields = [
            "times",
            "timesRemaining",
            "nextPaymentDate",
            "method",
            "metadata",
            "canceledAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
