import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeletePublicIpv4PoolRequest, DeletePublicIpv4PoolResult } from "../models/models_3";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeletePublicIpv4PoolCommand}.
 */
export interface DeletePublicIpv4PoolCommandInput extends DeletePublicIpv4PoolRequest {
}
/**
 * @public
 *
 * The output of {@link DeletePublicIpv4PoolCommand}.
 */
export interface DeletePublicIpv4PoolCommandOutput extends DeletePublicIpv4PoolResult, __MetadataBearer {
}
declare const DeletePublicIpv4PoolCommand_base: {
    new (input: DeletePublicIpv4PoolCommandInput): import("@smithy/smithy-client").CommandImpl<DeletePublicIpv4PoolCommandInput, DeletePublicIpv4PoolCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeletePublicIpv4PoolCommandInput): import("@smithy/smithy-client").CommandImpl<DeletePublicIpv4PoolCommandInput, DeletePublicIpv4PoolCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeletePublicIpv4PoolCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeletePublicIpv4PoolCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeletePublicIpv4PoolRequest
 *   DryRun: true || false,
 *   PoolId: "STRING_VALUE", // required
 *   NetworkBorderGroup: "STRING_VALUE",
 * };
 * const command = new DeletePublicIpv4PoolCommand(input);
 * const response = await client.send(command);
 * // { // DeletePublicIpv4PoolResult
 * //   ReturnValue: true || false,
 * // };
 *
 * ```
 *
 * @param DeletePublicIpv4PoolCommandInput - {@link DeletePublicIpv4PoolCommandInput}
 * @returns {@link DeletePublicIpv4PoolCommandOutput}
 * @see {@link DeletePublicIpv4PoolCommandInput} for command's `input` shape.
 * @see {@link DeletePublicIpv4PoolCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DeletePublicIpv4PoolCommand extends DeletePublicIpv4PoolCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeletePublicIpv4PoolRequest;
            output: DeletePublicIpv4PoolResult;
        };
        sdk: {
            input: DeletePublicIpv4PoolCommandInput;
            output: DeletePublicIpv4PoolCommandOutput;
        };
    };
}
