import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeLocalGatewayVirtualInterfacesRequest, DescribeLocalGatewayVirtualInterfacesResult } from "../models/models_5";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeLocalGatewayVirtualInterfacesCommand}.
 */
export interface DescribeLocalGatewayVirtualInterfacesCommandInput extends DescribeLocalGatewayVirtualInterfacesRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeLocalGatewayVirtualInterfacesCommand}.
 */
export interface DescribeLocalGatewayVirtualInterfacesCommandOutput extends DescribeLocalGatewayVirtualInterfacesResult, __MetadataBearer {
}
declare const DescribeLocalGatewayVirtualInterfacesCommand_base: {
    new (input: DescribeLocalGatewayVirtualInterfacesCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeLocalGatewayVirtualInterfacesCommandInput, DescribeLocalGatewayVirtualInterfacesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeLocalGatewayVirtualInterfacesCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeLocalGatewayVirtualInterfacesCommandInput, DescribeLocalGatewayVirtualInterfacesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the specified local gateway virtual interfaces.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeLocalGatewayVirtualInterfacesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeLocalGatewayVirtualInterfacesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeLocalGatewayVirtualInterfacesRequest
 *   LocalGatewayVirtualInterfaceIds: [ // LocalGatewayVirtualInterfaceIdSet
 *     "STRING_VALUE",
 *   ],
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 *   DryRun: true || false,
 * };
 * const command = new DescribeLocalGatewayVirtualInterfacesCommand(input);
 * const response = await client.send(command);
 * // { // DescribeLocalGatewayVirtualInterfacesResult
 * //   LocalGatewayVirtualInterfaces: [ // LocalGatewayVirtualInterfaceSet
 * //     { // LocalGatewayVirtualInterface
 * //       LocalGatewayVirtualInterfaceId: "STRING_VALUE",
 * //       LocalGatewayId: "STRING_VALUE",
 * //       LocalGatewayVirtualInterfaceGroupId: "STRING_VALUE",
 * //       LocalGatewayVirtualInterfaceArn: "STRING_VALUE",
 * //       OutpostLagId: "STRING_VALUE",
 * //       Vlan: Number("int"),
 * //       LocalAddress: "STRING_VALUE",
 * //       PeerAddress: "STRING_VALUE",
 * //       LocalBgpAsn: Number("int"),
 * //       PeerBgpAsn: Number("int"),
 * //       PeerBgpAsnExtended: Number("long"),
 * //       OwnerId: "STRING_VALUE",
 * //       Tags: [ // TagList
 * //         { // Tag
 * //           Key: "STRING_VALUE",
 * //           Value: "STRING_VALUE",
 * //         },
 * //       ],
 * //       ConfigurationState: "pending" || "available" || "deleting" || "deleted",
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeLocalGatewayVirtualInterfacesCommandInput - {@link DescribeLocalGatewayVirtualInterfacesCommandInput}
 * @returns {@link DescribeLocalGatewayVirtualInterfacesCommandOutput}
 * @see {@link DescribeLocalGatewayVirtualInterfacesCommandInput} for command's `input` shape.
 * @see {@link DescribeLocalGatewayVirtualInterfacesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DescribeLocalGatewayVirtualInterfacesCommand extends DescribeLocalGatewayVirtualInterfacesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeLocalGatewayVirtualInterfacesRequest;
            output: DescribeLocalGatewayVirtualInterfacesResult;
        };
        sdk: {
            input: DescribeLocalGatewayVirtualInterfacesCommandInput;
            output: DescribeLocalGatewayVirtualInterfacesCommandOutput;
        };
    };
}
