import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DetachClassicLinkVpcRequest, DetachClassicLinkVpcResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DetachClassicLinkVpcCommand}.
 */
export interface DetachClassicLinkVpcCommandInput extends DetachClassicLinkVpcRequest {
}
/**
 * @public
 *
 * The output of {@link DetachClassicLinkVpcCommand}.
 */
export interface DetachClassicLinkVpcCommandOutput extends DetachClassicLinkVpcResult, __MetadataBearer {
}
declare const DetachClassicLinkVpcCommand_base: {
    new (input: DetachClassicLinkVpcCommandInput): import("@smithy/smithy-client").CommandImpl<DetachClassicLinkVpcCommandInput, DetachClassicLinkVpcCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DetachClassicLinkVpcCommandInput): import("@smithy/smithy-client").CommandImpl<DetachClassicLinkVpcCommandInput, DetachClassicLinkVpcCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <note>
 *             <p>This action is deprecated.</p>
 *          </note>
 *          <p>Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked,
 * 		    the VPC security groups are no longer associated with it. An instance is automatically unlinked from
 * 		    a VPC when it's stopped.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DetachClassicLinkVpcCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DetachClassicLinkVpcCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DetachClassicLinkVpcRequest
 *   DryRun: true || false,
 *   InstanceId: "STRING_VALUE", // required
 *   VpcId: "STRING_VALUE", // required
 * };
 * const command = new DetachClassicLinkVpcCommand(input);
 * const response = await client.send(command);
 * // { // DetachClassicLinkVpcResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param DetachClassicLinkVpcCommandInput - {@link DetachClassicLinkVpcCommandInput}
 * @returns {@link DetachClassicLinkVpcCommandOutput}
 * @see {@link DetachClassicLinkVpcCommandInput} for command's `input` shape.
 * @see {@link DetachClassicLinkVpcCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DetachClassicLinkVpcCommand extends DetachClassicLinkVpcCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DetachClassicLinkVpcRequest;
            output: DetachClassicLinkVpcResult;
        };
        sdk: {
            input: DetachClassicLinkVpcCommandInput;
            output: DetachClassicLinkVpcCommandOutput;
        };
    };
}
