import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisableRouteServerPropagationRequest, DisableRouteServerPropagationResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DisableRouteServerPropagationCommand}.
 */
export interface DisableRouteServerPropagationCommandInput extends DisableRouteServerPropagationRequest {
}
/**
 * @public
 *
 * The output of {@link DisableRouteServerPropagationCommand}.
 */
export interface DisableRouteServerPropagationCommandOutput extends DisableRouteServerPropagationResult, __MetadataBearer {
}
declare const DisableRouteServerPropagationCommand_base: {
    new (input: DisableRouteServerPropagationCommandInput): import("@smithy/smithy-client").CommandImpl<DisableRouteServerPropagationCommandInput, DisableRouteServerPropagationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DisableRouteServerPropagationCommandInput): import("@smithy/smithy-client").CommandImpl<DisableRouteServerPropagationCommandInput, DisableRouteServerPropagationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Disables route propagation from a route server to a specified route table.</p>
 *          <p>When enabled, route server propagation installs the routes in the FIB on the route table you've specified. Route server supports IPv4 and IPv6 route propagation.</p>
 *          <p>Amazon VPC Route Server simplifies routing for traffic between workloads that are deployed within a VPC and its internet gateways. With this feature,
 * VPC Route Server dynamically updates VPC and internet gateway route tables with your preferred IPv4 or IPv6 routes to achieve routing fault tolerance for those workloads. This enables you to automatically reroute traffic within a VPC, which increases the manageability of VPC routing and interoperability with third-party workloads.</p>
 *          <p>Route server supports the follow route table types:</p>
 *          <ul>
 *             <li>
 *                <p>VPC route tables not associated with subnets</p>
 *             </li>
 *             <li>
 *                <p>Subnet route tables</p>
 *             </li>
 *             <li>
 *                <p>Internet gateway route tables</p>
 *             </li>
 *          </ul>
 *          <p>Route server does not support route tables associated with virtual private gateways. To propagate routes into a transit gateway route table, use <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html">Transit Gateway Connect</a>.</p>
 *          <p>For more information see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html">Dynamic routing in your VPC with VPC Route Server</a> in the <i>Amazon VPC User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisableRouteServerPropagationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisableRouteServerPropagationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DisableRouteServerPropagationRequest
 *   RouteServerId: "STRING_VALUE", // required
 *   RouteTableId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DisableRouteServerPropagationCommand(input);
 * const response = await client.send(command);
 * // { // DisableRouteServerPropagationResult
 * //   RouteServerPropagation: { // RouteServerPropagation
 * //     RouteServerId: "STRING_VALUE",
 * //     RouteTableId: "STRING_VALUE",
 * //     State: "pending" || "available" || "deleting",
 * //   },
 * // };
 *
 * ```
 *
 * @param DisableRouteServerPropagationCommandInput - {@link DisableRouteServerPropagationCommandInput}
 * @returns {@link DisableRouteServerPropagationCommandOutput}
 * @see {@link DisableRouteServerPropagationCommandInput} for command's `input` shape.
 * @see {@link DisableRouteServerPropagationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DisableRouteServerPropagationCommand extends DisableRouteServerPropagationCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DisableRouteServerPropagationRequest;
            output: DisableRouteServerPropagationResult;
        };
        sdk: {
            input: DisableRouteServerPropagationCommandInput;
            output: DisableRouteServerPropagationCommandOutput;
        };
    };
}
