import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableImageDeregistrationProtectionRequest, EnableImageDeregistrationProtectionResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link EnableImageDeregistrationProtectionCommand}.
 */
export interface EnableImageDeregistrationProtectionCommandInput extends EnableImageDeregistrationProtectionRequest {
}
/**
 * @public
 *
 * The output of {@link EnableImageDeregistrationProtectionCommand}.
 */
export interface EnableImageDeregistrationProtectionCommandOutput extends EnableImageDeregistrationProtectionResult, __MetadataBearer {
}
declare const EnableImageDeregistrationProtectionCommand_base: {
    new (input: EnableImageDeregistrationProtectionCommandInput): import("@smithy/smithy-client").CommandImpl<EnableImageDeregistrationProtectionCommandInput, EnableImageDeregistrationProtectionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: EnableImageDeregistrationProtectionCommandInput): import("@smithy/smithy-client").CommandImpl<EnableImageDeregistrationProtectionCommandInput, EnableImageDeregistrationProtectionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Enables deregistration protection for an AMI. When deregistration protection is enabled,
 *       the AMI can't be deregistered.</p>
 *          <p>To allow the AMI to be deregistered, you must first disable deregistration protection.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deregistration-protection.html">Protect an
 *       Amazon EC2 AMI from deregistration</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableImageDeregistrationProtectionCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableImageDeregistrationProtectionCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // EnableImageDeregistrationProtectionRequest
 *   ImageId: "STRING_VALUE", // required
 *   WithCooldown: true || false,
 *   DryRun: true || false,
 * };
 * const command = new EnableImageDeregistrationProtectionCommand(input);
 * const response = await client.send(command);
 * // { // EnableImageDeregistrationProtectionResult
 * //   Return: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param EnableImageDeregistrationProtectionCommandInput - {@link EnableImageDeregistrationProtectionCommandInput}
 * @returns {@link EnableImageDeregistrationProtectionCommandOutput}
 * @see {@link EnableImageDeregistrationProtectionCommandInput} for command's `input` shape.
 * @see {@link EnableImageDeregistrationProtectionCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class EnableImageDeregistrationProtectionCommand extends EnableImageDeregistrationProtectionCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: EnableImageDeregistrationProtectionRequest;
            output: EnableImageDeregistrationProtectionResult;
        };
        sdk: {
            input: EnableImageDeregistrationProtectionCommandInput;
            output: EnableImageDeregistrationProtectionCommandOutput;
        };
    };
}
