import {
  AccessScopeAnalysisFinding,
  ActiveVpnTunnelStatus,
  AddressTransfer,
  AllowedImagesSettingsDisabledState,
  AllowedImagesSettingsEnabledState,
  AllowedPrincipal,
  AsnAssociation,
  AssociationStatus,
  CurrencyCodeValues,
  DeviceTrustProviderType,
  IamInstanceProfileAssociation,
  InstanceEventWindow,
  IpamPoolAllocation,
  IpamResourceDiscoveryAssociation,
  NatGatewayAddress,
  RouteServerAssociation,
  SecurityGroupVpcAssociationState,
  SubnetIpv6CidrBlockAssociation,
  Tag,
  TagSpecification,
  TransitGatewayAssociation,
  TransitGatewayAttachmentResourceType,
  TransitGatewayMulticastDomainAssociations,
  TransitGatewayPolicyTableAssociation,
  UserTrustProviderType,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
  VpcCidrBlockAssociation,
  VpcIpv6CidrBlockAssociation,
  VpcPeeringConnection,
} from "./models_0";
import {
  CapacityReservationState,
  DiskImageFormat,
  InstanceRequirementsRequest,
  IpAddressType,
  IpamResourceTag,
  RequestIpamResourceTag,
  Vpc,
} from "./models_1";
import {
  ResponseLaunchTemplateData,
  SSEType,
  VpcBlockPublicAccessExclusion,
} from "./models_2";
import {
  ConnectionNotification,
  DnsEntry,
  DnsNameState,
  Filter,
  IpamPoolCidr,
  MetricType,
  PayerResponsibility,
  PeriodType,
  ServiceConfiguration,
  ServiceConnectivityType,
  ServiceTypeDetail,
  State,
  StatisticType,
  VpcEndpoint,
  VpnConnection,
  VpnGateway,
} from "./models_3";
import {
  AttributeBooleanValue,
  ExportTaskS3Location,
  FastLaunchLaunchTemplateSpecificationResponse,
  FastLaunchResourceType,
  FastLaunchSnapshotConfigurationResponse,
  FastLaunchStateCode,
  FastSnapshotRestoreStateCode,
  HttpTokensState,
  InstanceMetadataEndpointState,
  InstanceMetadataTagsState,
  PaymentOption,
  VirtualizationType,
} from "./models_4";
import { AnalysisStatus, ArchitectureType, VpcAttributeName } from "./models_5";
export interface DescribeVpcAttributeRequest {
  Attribute: VpcAttributeName | undefined;
  VpcId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeVpcAttributeResult {
  EnableDnsHostnames?: AttributeBooleanValue | undefined;
  EnableDnsSupport?: AttributeBooleanValue | undefined;
  EnableNetworkAddressUsageMetrics?: AttributeBooleanValue | undefined;
  VpcId?: string | undefined;
}
export interface DescribeVpcBlockPublicAccessExclusionsRequest {
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  ExclusionIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface DescribeVpcBlockPublicAccessExclusionsResult {
  VpcBlockPublicAccessExclusions?: VpcBlockPublicAccessExclusion[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcBlockPublicAccessOptionsRequest {
  DryRun?: boolean | undefined;
}
export declare const VpcBlockPublicAccessExclusionsAllowed: {
  readonly allowed: "allowed";
  readonly not_allowed: "not-allowed";
};
export type VpcBlockPublicAccessExclusionsAllowed =
  (typeof VpcBlockPublicAccessExclusionsAllowed)[keyof typeof VpcBlockPublicAccessExclusionsAllowed];
export declare const InternetGatewayBlockMode: {
  readonly block_bidirectional: "block-bidirectional";
  readonly block_ingress: "block-ingress";
  readonly off: "off";
};
export type InternetGatewayBlockMode =
  (typeof InternetGatewayBlockMode)[keyof typeof InternetGatewayBlockMode];
export declare const ManagedBy: {
  readonly account: "account";
  readonly declarative_policy: "declarative-policy";
};
export type ManagedBy = (typeof ManagedBy)[keyof typeof ManagedBy];
export declare const VpcBlockPublicAccessState: {
  readonly default_state: "default-state";
  readonly update_complete: "update-complete";
  readonly update_in_progress: "update-in-progress";
};
export type VpcBlockPublicAccessState =
  (typeof VpcBlockPublicAccessState)[keyof typeof VpcBlockPublicAccessState];
export interface VpcBlockPublicAccessOptions {
  AwsAccountId?: string | undefined;
  AwsRegion?: string | undefined;
  State?: VpcBlockPublicAccessState | undefined;
  InternetGatewayBlockMode?: InternetGatewayBlockMode | undefined;
  Reason?: string | undefined;
  LastUpdateTimestamp?: Date | undefined;
  ManagedBy?: ManagedBy | undefined;
  ExclusionsAllowed?: VpcBlockPublicAccessExclusionsAllowed | undefined;
}
export interface DescribeVpcBlockPublicAccessOptionsResult {
  VpcBlockPublicAccessOptions?: VpcBlockPublicAccessOptions | undefined;
}
export interface DescribeVpcClassicLinkRequest {
  DryRun?: boolean | undefined;
  VpcIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
}
export interface VpcClassicLink {
  ClassicLinkEnabled?: boolean | undefined;
  Tags?: Tag[] | undefined;
  VpcId?: string | undefined;
}
export interface DescribeVpcClassicLinkResult {
  Vpcs?: VpcClassicLink[] | undefined;
}
export interface DescribeVpcClassicLinkDnsSupportRequest {
  VpcIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ClassicLinkDnsSupport {
  ClassicLinkDnsSupported?: boolean | undefined;
  VpcId?: string | undefined;
}
export interface DescribeVpcClassicLinkDnsSupportResult {
  NextToken?: string | undefined;
  Vpcs?: ClassicLinkDnsSupport[] | undefined;
}
export interface DescribeVpcEndpointAssociationsRequest {
  DryRun?: boolean | undefined;
  VpcEndpointIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface VpcEndpointAssociation {
  Id?: string | undefined;
  VpcEndpointId?: string | undefined;
  ServiceNetworkArn?: string | undefined;
  ServiceNetworkName?: string | undefined;
  AssociatedResourceAccessibility?: string | undefined;
  FailureReason?: string | undefined;
  FailureCode?: string | undefined;
  DnsEntry?: DnsEntry | undefined;
  PrivateDnsEntry?: DnsEntry | undefined;
  AssociatedResourceArn?: string | undefined;
  ResourceConfigurationGroupArn?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeVpcEndpointAssociationsResult {
  VpcEndpointAssociations?: VpcEndpointAssociation[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointConnectionNotificationsRequest {
  DryRun?: boolean | undefined;
  ConnectionNotificationId?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointConnectionNotificationsResult {
  ConnectionNotificationSet?: ConnectionNotification[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointConnectionsRequest {
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface VpcEndpointConnection {
  ServiceId?: string | undefined;
  VpcEndpointId?: string | undefined;
  VpcEndpointOwner?: string | undefined;
  VpcEndpointState?: State | undefined;
  CreationTimestamp?: Date | undefined;
  DnsEntries?: DnsEntry[] | undefined;
  NetworkLoadBalancerArns?: string[] | undefined;
  GatewayLoadBalancerArns?: string[] | undefined;
  IpAddressType?: IpAddressType | undefined;
  VpcEndpointConnectionId?: string | undefined;
  Tags?: Tag[] | undefined;
  VpcEndpointRegion?: string | undefined;
}
export interface DescribeVpcEndpointConnectionsResult {
  VpcEndpointConnections?: VpcEndpointConnection[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointsRequest {
  DryRun?: boolean | undefined;
  VpcEndpointIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointsResult {
  VpcEndpoints?: VpcEndpoint[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointServiceConfigurationsRequest {
  DryRun?: boolean | undefined;
  ServiceIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointServiceConfigurationsResult {
  ServiceConfigurations?: ServiceConfiguration[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointServicePermissionsRequest {
  DryRun?: boolean | undefined;
  ServiceId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointServicePermissionsResult {
  AllowedPrincipals?: AllowedPrincipal[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcEndpointServicesRequest {
  DryRun?: boolean | undefined;
  ServiceNames?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  ServiceRegions?: string[] | undefined;
}
export interface PrivateDnsDetails {
  PrivateDnsName?: string | undefined;
}
export interface ServiceDetail {
  ServiceName?: string | undefined;
  ServiceId?: string | undefined;
  ServiceType?: ServiceTypeDetail[] | undefined;
  ServiceRegion?: string | undefined;
  AvailabilityZoneIds?: string[] | undefined;
  AvailabilityZones?: string[] | undefined;
  Owner?: string | undefined;
  BaseEndpointDnsNames?: string[] | undefined;
  PrivateDnsName?: string | undefined;
  PrivateDnsNames?: PrivateDnsDetails[] | undefined;
  VpcEndpointPolicySupported?: boolean | undefined;
  AcceptanceRequired?: boolean | undefined;
  ManagesVpcEndpoints?: boolean | undefined;
  PayerResponsibility?: PayerResponsibility | undefined;
  Tags?: Tag[] | undefined;
  PrivateDnsNameVerificationState?: DnsNameState | undefined;
  SupportedIpAddressTypes?: ServiceConnectivityType[] | undefined;
}
export interface DescribeVpcEndpointServicesResult {
  ServiceNames?: string[] | undefined;
  ServiceDetails?: ServiceDetail[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcPeeringConnectionsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
  VpcPeeringConnectionIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
}
export interface DescribeVpcPeeringConnectionsResult {
  VpcPeeringConnections?: VpcPeeringConnection[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeVpcsRequest {
  Filters?: Filter[] | undefined;
  VpcIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeVpcsResult {
  NextToken?: string | undefined;
  Vpcs?: Vpc[] | undefined;
}
export interface DescribeVpnConnectionsRequest {
  Filters?: Filter[] | undefined;
  VpnConnectionIds?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeVpnConnectionsResult {
  VpnConnections?: VpnConnection[] | undefined;
}
export interface DescribeVpnGatewaysRequest {
  Filters?: Filter[] | undefined;
  VpnGatewayIds?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeVpnGatewaysResult {
  VpnGateways?: VpnGateway[] | undefined;
}
export interface DetachClassicLinkVpcRequest {
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  VpcId: string | undefined;
}
export interface DetachClassicLinkVpcResult {
  Return?: boolean | undefined;
}
export interface DetachInternetGatewayRequest {
  DryRun?: boolean | undefined;
  InternetGatewayId: string | undefined;
  VpcId: string | undefined;
}
export interface DetachNetworkInterfaceRequest {
  DryRun?: boolean | undefined;
  AttachmentId: string | undefined;
  Force?: boolean | undefined;
}
export interface DetachVerifiedAccessTrustProviderRequest {
  VerifiedAccessInstanceId: string | undefined;
  VerifiedAccessTrustProviderId: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DetachVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider | undefined;
  VerifiedAccessInstance?: VerifiedAccessInstance | undefined;
}
export interface DetachVolumeRequest {
  Device?: string | undefined;
  Force?: boolean | undefined;
  InstanceId?: string | undefined;
  VolumeId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DetachVpnGatewayRequest {
  VpcId: string | undefined;
  VpnGatewayId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableAddressTransferRequest {
  AllocationId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableAddressTransferResult {
  AddressTransfer?: AddressTransfer | undefined;
}
export interface DisableAllowedImagesSettingsRequest {
  DryRun?: boolean | undefined;
}
export interface DisableAllowedImagesSettingsResult {
  AllowedImagesSettingsState?: AllowedImagesSettingsDisabledState | undefined;
}
export interface DisableAwsNetworkPerformanceMetricSubscriptionRequest {
  Source?: string | undefined;
  Destination?: string | undefined;
  Metric?: MetricType | undefined;
  Statistic?: StatisticType | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableAwsNetworkPerformanceMetricSubscriptionResult {
  Output?: boolean | undefined;
}
export interface DisableEbsEncryptionByDefaultRequest {
  DryRun?: boolean | undefined;
}
export interface DisableEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean | undefined;
}
export interface DisableFastLaunchRequest {
  ImageId: string | undefined;
  Force?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableFastLaunchResult {
  ImageId?: string | undefined;
  ResourceType?: FastLaunchResourceType | undefined;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse | undefined;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse | undefined;
  MaxParallelLaunches?: number | undefined;
  OwnerId?: string | undefined;
  State?: FastLaunchStateCode | undefined;
  StateTransitionReason?: string | undefined;
  StateTransitionTime?: Date | undefined;
}
export interface DisableFastSnapshotRestoresRequest {
  AvailabilityZones: string[] | undefined;
  SourceSnapshotIds: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableFastSnapshotRestoreSuccessItem {
  SnapshotId?: string | undefined;
  AvailabilityZone?: string | undefined;
  State?: FastSnapshotRestoreStateCode | undefined;
  StateTransitionReason?: string | undefined;
  OwnerId?: string | undefined;
  OwnerAlias?: string | undefined;
  EnablingTime?: Date | undefined;
  OptimizingTime?: Date | undefined;
  EnabledTime?: Date | undefined;
  DisablingTime?: Date | undefined;
  DisabledTime?: Date | undefined;
}
export interface DisableFastSnapshotRestoreStateError {
  Code?: string | undefined;
  Message?: string | undefined;
}
export interface DisableFastSnapshotRestoreStateErrorItem {
  AvailabilityZone?: string | undefined;
  Error?: DisableFastSnapshotRestoreStateError | undefined;
}
export interface DisableFastSnapshotRestoreErrorItem {
  SnapshotId?: string | undefined;
  FastSnapshotRestoreStateErrors?:
    | DisableFastSnapshotRestoreStateErrorItem[]
    | undefined;
}
export interface DisableFastSnapshotRestoresResult {
  Successful?: DisableFastSnapshotRestoreSuccessItem[] | undefined;
  Unsuccessful?: DisableFastSnapshotRestoreErrorItem[] | undefined;
}
export interface DisableImageRequest {
  ImageId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableImageResult {
  Return?: boolean | undefined;
}
export interface DisableImageBlockPublicAccessRequest {
  DryRun?: boolean | undefined;
}
export declare const ImageBlockPublicAccessDisabledState: {
  readonly unblocked: "unblocked";
};
export type ImageBlockPublicAccessDisabledState =
  (typeof ImageBlockPublicAccessDisabledState)[keyof typeof ImageBlockPublicAccessDisabledState];
export interface DisableImageBlockPublicAccessResult {
  ImageBlockPublicAccessState?: ImageBlockPublicAccessDisabledState | undefined;
}
export interface DisableImageDeprecationRequest {
  ImageId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableImageDeprecationResult {
  Return?: boolean | undefined;
}
export interface DisableImageDeregistrationProtectionRequest {
  ImageId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableImageDeregistrationProtectionResult {
  Return?: string | undefined;
}
export interface DisableIpamOrganizationAdminAccountRequest {
  DryRun?: boolean | undefined;
  DelegatedAdminAccountId: string | undefined;
}
export interface DisableIpamOrganizationAdminAccountResult {
  Success?: boolean | undefined;
}
export interface DisableRouteServerPropagationRequest {
  RouteServerId: string | undefined;
  RouteTableId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const RouteServerPropagationState: {
  readonly AVAILABLE: "available";
  readonly DELETING: "deleting";
  readonly PENDING: "pending";
};
export type RouteServerPropagationState =
  (typeof RouteServerPropagationState)[keyof typeof RouteServerPropagationState];
export interface RouteServerPropagation {
  RouteServerId?: string | undefined;
  RouteTableId?: string | undefined;
  State?: RouteServerPropagationState | undefined;
}
export interface DisableRouteServerPropagationResult {
  RouteServerPropagation?: RouteServerPropagation | undefined;
}
export interface DisableSerialConsoleAccessRequest {
  DryRun?: boolean | undefined;
}
export interface DisableSerialConsoleAccessResult {
  SerialConsoleAccessEnabled?: boolean | undefined;
}
export interface DisableSnapshotBlockPublicAccessRequest {
  DryRun?: boolean | undefined;
}
export declare const SnapshotBlockPublicAccessState: {
  readonly block_all_sharing: "block-all-sharing";
  readonly block_new_sharing: "block-new-sharing";
  readonly unblocked: "unblocked";
};
export type SnapshotBlockPublicAccessState =
  (typeof SnapshotBlockPublicAccessState)[keyof typeof SnapshotBlockPublicAccessState];
export interface DisableSnapshotBlockPublicAccessResult {
  State?: SnapshotBlockPublicAccessState | undefined;
}
export interface DisableTransitGatewayRouteTablePropagationRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  DryRun?: boolean | undefined;
  TransitGatewayRouteTableAnnouncementId?: string | undefined;
}
export declare const TransitGatewayPropagationState: {
  readonly disabled: "disabled";
  readonly disabling: "disabling";
  readonly enabled: "enabled";
  readonly enabling: "enabling";
};
export type TransitGatewayPropagationState =
  (typeof TransitGatewayPropagationState)[keyof typeof TransitGatewayPropagationState];
export interface TransitGatewayPropagation {
  TransitGatewayAttachmentId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
  TransitGatewayRouteTableId?: string | undefined;
  State?: TransitGatewayPropagationState | undefined;
  TransitGatewayRouteTableAnnouncementId?: string | undefined;
}
export interface DisableTransitGatewayRouteTablePropagationResult {
  Propagation?: TransitGatewayPropagation | undefined;
}
export interface DisableVgwRoutePropagationRequest {
  GatewayId: string | undefined;
  RouteTableId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisableVpcClassicLinkRequest {
  DryRun?: boolean | undefined;
  VpcId: string | undefined;
}
export interface DisableVpcClassicLinkResult {
  Return?: boolean | undefined;
}
export interface DisableVpcClassicLinkDnsSupportRequest {
  VpcId?: string | undefined;
}
export interface DisableVpcClassicLinkDnsSupportResult {
  Return?: boolean | undefined;
}
export interface DisassociateAddressRequest {
  AssociationId?: string | undefined;
  PublicIp?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateCapacityReservationBillingOwnerRequest {
  DryRun?: boolean | undefined;
  CapacityReservationId: string | undefined;
  UnusedReservationBillingOwnerId: string | undefined;
}
export interface DisassociateCapacityReservationBillingOwnerResult {
  Return?: boolean | undefined;
}
export interface DisassociateClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  AssociationId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateClientVpnTargetNetworkResult {
  AssociationId?: string | undefined;
  Status?: AssociationStatus | undefined;
}
export interface DisassociateEnclaveCertificateIamRoleRequest {
  CertificateArn: string | undefined;
  RoleArn: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateEnclaveCertificateIamRoleResult {
  Return?: boolean | undefined;
}
export interface DisassociateIamInstanceProfileRequest {
  AssociationId: string | undefined;
}
export interface DisassociateIamInstanceProfileResult {
  IamInstanceProfileAssociation?: IamInstanceProfileAssociation | undefined;
}
export interface InstanceEventWindowDisassociationRequest {
  InstanceIds?: string[] | undefined;
  InstanceTags?: Tag[] | undefined;
  DedicatedHostIds?: string[] | undefined;
}
export interface DisassociateInstanceEventWindowRequest {
  DryRun?: boolean | undefined;
  InstanceEventWindowId: string | undefined;
  AssociationTarget: InstanceEventWindowDisassociationRequest | undefined;
}
export interface DisassociateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow | undefined;
}
export interface DisassociateIpamByoasnRequest {
  DryRun?: boolean | undefined;
  Asn: string | undefined;
  Cidr: string | undefined;
}
export interface DisassociateIpamByoasnResult {
  AsnAssociation?: AsnAssociation | undefined;
}
export interface DisassociateIpamResourceDiscoveryRequest {
  DryRun?: boolean | undefined;
  IpamResourceDiscoveryAssociationId: string | undefined;
}
export interface DisassociateIpamResourceDiscoveryResult {
  IpamResourceDiscoveryAssociation?:
    | IpamResourceDiscoveryAssociation
    | undefined;
}
export interface DisassociateNatGatewayAddressRequest {
  NatGatewayId: string | undefined;
  AssociationIds: string[] | undefined;
  MaxDrainDurationSeconds?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateNatGatewayAddressResult {
  NatGatewayId?: string | undefined;
  NatGatewayAddresses?: NatGatewayAddress[] | undefined;
}
export interface DisassociateRouteServerRequest {
  RouteServerId: string | undefined;
  VpcId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateRouteServerResult {
  RouteServerAssociation?: RouteServerAssociation | undefined;
}
export interface DisassociateRouteTableRequest {
  DryRun?: boolean | undefined;
  AssociationId: string | undefined;
}
export interface DisassociateSecurityGroupVpcRequest {
  GroupId: string | undefined;
  VpcId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateSecurityGroupVpcResult {
  State?: SecurityGroupVpcAssociationState | undefined;
}
export interface DisassociateSubnetCidrBlockRequest {
  AssociationId: string | undefined;
}
export interface DisassociateSubnetCidrBlockResult {
  Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation | undefined;
  SubnetId?: string | undefined;
}
export interface DisassociateTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  SubnetIds: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateTransitGatewayMulticastDomainResult {
  Associations?: TransitGatewayMulticastDomainAssociations | undefined;
}
export interface DisassociateTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateTransitGatewayPolicyTableResult {
  Association?: TransitGatewayPolicyTableAssociation | undefined;
}
export interface DisassociateTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateTransitGatewayRouteTableResult {
  Association?: TransitGatewayAssociation | undefined;
}
export interface DisassociateTrunkInterfaceRequest {
  AssociationId: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DisassociateTrunkInterfaceResult {
  Return?: boolean | undefined;
  ClientToken?: string | undefined;
}
export interface DisassociateVpcCidrBlockRequest {
  AssociationId: string | undefined;
}
export interface DisassociateVpcCidrBlockResult {
  Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation | undefined;
  CidrBlockAssociation?: VpcCidrBlockAssociation | undefined;
  VpcId?: string | undefined;
}
export interface EnableAddressTransferRequest {
  AllocationId: string | undefined;
  TransferAccountId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableAddressTransferResult {
  AddressTransfer?: AddressTransfer | undefined;
}
export interface EnableAllowedImagesSettingsRequest {
  AllowedImagesSettingsState: AllowedImagesSettingsEnabledState | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableAllowedImagesSettingsResult {
  AllowedImagesSettingsState?: AllowedImagesSettingsEnabledState | undefined;
}
export interface EnableAwsNetworkPerformanceMetricSubscriptionRequest {
  Source?: string | undefined;
  Destination?: string | undefined;
  Metric?: MetricType | undefined;
  Statistic?: StatisticType | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableAwsNetworkPerformanceMetricSubscriptionResult {
  Output?: boolean | undefined;
}
export interface EnableEbsEncryptionByDefaultRequest {
  DryRun?: boolean | undefined;
}
export interface EnableEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean | undefined;
}
export interface FastLaunchLaunchTemplateSpecificationRequest {
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  Version: string | undefined;
}
export interface FastLaunchSnapshotConfigurationRequest {
  TargetResourceCount?: number | undefined;
}
export interface EnableFastLaunchRequest {
  ImageId: string | undefined;
  ResourceType?: string | undefined;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationRequest | undefined;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationRequest | undefined;
  MaxParallelLaunches?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableFastLaunchResult {
  ImageId?: string | undefined;
  ResourceType?: FastLaunchResourceType | undefined;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse | undefined;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse | undefined;
  MaxParallelLaunches?: number | undefined;
  OwnerId?: string | undefined;
  State?: FastLaunchStateCode | undefined;
  StateTransitionReason?: string | undefined;
  StateTransitionTime?: Date | undefined;
}
export interface EnableFastSnapshotRestoresRequest {
  AvailabilityZones: string[] | undefined;
  SourceSnapshotIds: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableFastSnapshotRestoreSuccessItem {
  SnapshotId?: string | undefined;
  AvailabilityZone?: string | undefined;
  State?: FastSnapshotRestoreStateCode | undefined;
  StateTransitionReason?: string | undefined;
  OwnerId?: string | undefined;
  OwnerAlias?: string | undefined;
  EnablingTime?: Date | undefined;
  OptimizingTime?: Date | undefined;
  EnabledTime?: Date | undefined;
  DisablingTime?: Date | undefined;
  DisabledTime?: Date | undefined;
}
export interface EnableFastSnapshotRestoreStateError {
  Code?: string | undefined;
  Message?: string | undefined;
}
export interface EnableFastSnapshotRestoreStateErrorItem {
  AvailabilityZone?: string | undefined;
  Error?: EnableFastSnapshotRestoreStateError | undefined;
}
export interface EnableFastSnapshotRestoreErrorItem {
  SnapshotId?: string | undefined;
  FastSnapshotRestoreStateErrors?:
    | EnableFastSnapshotRestoreStateErrorItem[]
    | undefined;
}
export interface EnableFastSnapshotRestoresResult {
  Successful?: EnableFastSnapshotRestoreSuccessItem[] | undefined;
  Unsuccessful?: EnableFastSnapshotRestoreErrorItem[] | undefined;
}
export interface EnableImageRequest {
  ImageId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableImageResult {
  Return?: boolean | undefined;
}
export declare const ImageBlockPublicAccessEnabledState: {
  readonly block_new_sharing: "block-new-sharing";
};
export type ImageBlockPublicAccessEnabledState =
  (typeof ImageBlockPublicAccessEnabledState)[keyof typeof ImageBlockPublicAccessEnabledState];
export interface EnableImageBlockPublicAccessRequest {
  ImageBlockPublicAccessState: ImageBlockPublicAccessEnabledState | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableImageBlockPublicAccessResult {
  ImageBlockPublicAccessState?: ImageBlockPublicAccessEnabledState | undefined;
}
export interface EnableImageDeprecationRequest {
  ImageId: string | undefined;
  DeprecateAt: Date | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableImageDeprecationResult {
  Return?: boolean | undefined;
}
export interface EnableImageDeregistrationProtectionRequest {
  ImageId: string | undefined;
  WithCooldown?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableImageDeregistrationProtectionResult {
  Return?: string | undefined;
}
export interface EnableIpamOrganizationAdminAccountRequest {
  DryRun?: boolean | undefined;
  DelegatedAdminAccountId: string | undefined;
}
export interface EnableIpamOrganizationAdminAccountResult {
  Success?: boolean | undefined;
}
export interface EnableReachabilityAnalyzerOrganizationSharingRequest {
  DryRun?: boolean | undefined;
}
export interface EnableReachabilityAnalyzerOrganizationSharingResult {
  ReturnValue?: boolean | undefined;
}
export interface EnableRouteServerPropagationRequest {
  RouteServerId: string | undefined;
  RouteTableId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableRouteServerPropagationResult {
  RouteServerPropagation?: RouteServerPropagation | undefined;
}
export interface EnableSerialConsoleAccessRequest {
  DryRun?: boolean | undefined;
}
export interface EnableSerialConsoleAccessResult {
  SerialConsoleAccessEnabled?: boolean | undefined;
}
export interface EnableSnapshotBlockPublicAccessRequest {
  State: SnapshotBlockPublicAccessState | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableSnapshotBlockPublicAccessResult {
  State?: SnapshotBlockPublicAccessState | undefined;
}
export interface EnableTransitGatewayRouteTablePropagationRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  DryRun?: boolean | undefined;
  TransitGatewayRouteTableAnnouncementId?: string | undefined;
}
export interface EnableTransitGatewayRouteTablePropagationResult {
  Propagation?: TransitGatewayPropagation | undefined;
}
export interface EnableVgwRoutePropagationRequest {
  GatewayId: string | undefined;
  RouteTableId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface EnableVolumeIORequest {
  DryRun?: boolean | undefined;
  VolumeId: string | undefined;
}
export interface EnableVpcClassicLinkRequest {
  DryRun?: boolean | undefined;
  VpcId: string | undefined;
}
export interface EnableVpcClassicLinkResult {
  Return?: boolean | undefined;
}
export interface EnableVpcClassicLinkDnsSupportRequest {
  VpcId?: string | undefined;
}
export interface EnableVpcClassicLinkDnsSupportResult {
  Return?: boolean | undefined;
}
export interface ExportClientVpnClientCertificateRevocationListRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const ClientCertificateRevocationListStatusCode: {
  readonly active: "active";
  readonly pending: "pending";
};
export type ClientCertificateRevocationListStatusCode =
  (typeof ClientCertificateRevocationListStatusCode)[keyof typeof ClientCertificateRevocationListStatusCode];
export interface ClientCertificateRevocationListStatus {
  Code?: ClientCertificateRevocationListStatusCode | undefined;
  Message?: string | undefined;
}
export interface ExportClientVpnClientCertificateRevocationListResult {
  CertificateRevocationList?: string | undefined;
  Status?: ClientCertificateRevocationListStatus | undefined;
}
export interface ExportClientVpnClientConfigurationRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ExportClientVpnClientConfigurationResult {
  ClientConfiguration?: string | undefined;
}
export interface ExportTaskS3LocationRequest {
  S3Bucket: string | undefined;
  S3Prefix?: string | undefined;
}
export interface ExportImageRequest {
  ClientToken?: string | undefined;
  Description?: string | undefined;
  DiskImageFormat: DiskImageFormat | undefined;
  DryRun?: boolean | undefined;
  ImageId: string | undefined;
  S3ExportLocation: ExportTaskS3LocationRequest | undefined;
  RoleName?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface ExportImageResult {
  Description?: string | undefined;
  DiskImageFormat?: DiskImageFormat | undefined;
  ExportImageTaskId?: string | undefined;
  ImageId?: string | undefined;
  RoleName?: string | undefined;
  Progress?: string | undefined;
  S3ExportLocation?: ExportTaskS3Location | undefined;
  Status?: string | undefined;
  StatusMessage?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface ExportTransitGatewayRoutesRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[] | undefined;
  S3Bucket: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ExportTransitGatewayRoutesResult {
  S3Location?: string | undefined;
}
export interface ExportVerifiedAccessInstanceClientConfigurationRequest {
  VerifiedAccessInstanceId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface VerifiedAccessInstanceOpenVpnClientConfigurationRoute {
  Cidr?: string | undefined;
}
export interface VerifiedAccessInstanceOpenVpnClientConfiguration {
  Config?: string | undefined;
  Routes?: VerifiedAccessInstanceOpenVpnClientConfigurationRoute[] | undefined;
}
export interface VerifiedAccessInstanceUserTrustProviderClientConfiguration {
  Type?: UserTrustProviderType | undefined;
  Scopes?: string | undefined;
  Issuer?: string | undefined;
  AuthorizationEndpoint?: string | undefined;
  PublicSigningKeyEndpoint?: string | undefined;
  TokenEndpoint?: string | undefined;
  UserInfoEndpoint?: string | undefined;
  ClientId?: string | undefined;
  ClientSecret?: string | undefined;
  PkceEnabled?: boolean | undefined;
}
export interface ExportVerifiedAccessInstanceClientConfigurationResult {
  Version?: string | undefined;
  VerifiedAccessInstanceId?: string | undefined;
  Region?: string | undefined;
  DeviceTrustProviders?: DeviceTrustProviderType[] | undefined;
  UserTrustProvider?:
    | VerifiedAccessInstanceUserTrustProviderClientConfiguration
    | undefined;
  OpenVpnConfigurations?:
    | VerifiedAccessInstanceOpenVpnClientConfiguration[]
    | undefined;
}
export interface GetActiveVpnTunnelStatusRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetActiveVpnTunnelStatusResult {
  ActiveVpnTunnelStatus?: ActiveVpnTunnelStatus | undefined;
}
export interface GetAllowedImagesSettingsRequest {
  DryRun?: boolean | undefined;
}
export interface ImageCriterion {
  ImageProviders?: string[] | undefined;
}
export interface GetAllowedImagesSettingsResult {
  State?: string | undefined;
  ImageCriteria?: ImageCriterion[] | undefined;
  ManagedBy?: ManagedBy | undefined;
}
export interface GetAssociatedEnclaveCertificateIamRolesRequest {
  CertificateArn: string | undefined;
  DryRun?: boolean | undefined;
}
export interface AssociatedRole {
  AssociatedRoleArn?: string | undefined;
  CertificateS3BucketName?: string | undefined;
  CertificateS3ObjectKey?: string | undefined;
  EncryptionKmsKeyId?: string | undefined;
}
export interface GetAssociatedEnclaveCertificateIamRolesResult {
  AssociatedRoles?: AssociatedRole[] | undefined;
}
export interface GetAssociatedIpv6PoolCidrsRequest {
  PoolId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface Ipv6CidrAssociation {
  Ipv6Cidr?: string | undefined;
  AssociatedResource?: string | undefined;
}
export interface GetAssociatedIpv6PoolCidrsResult {
  Ipv6CidrAssociations?: Ipv6CidrAssociation[] | undefined;
  NextToken?: string | undefined;
}
export interface DataQuery {
  Id?: string | undefined;
  Source?: string | undefined;
  Destination?: string | undefined;
  Metric?: MetricType | undefined;
  Statistic?: StatisticType | undefined;
  Period?: PeriodType | undefined;
}
export interface GetAwsNetworkPerformanceDataRequest {
  DataQueries?: DataQuery[] | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface MetricPoint {
  StartDate?: Date | undefined;
  EndDate?: Date | undefined;
  Value?: number | undefined;
  Status?: string | undefined;
}
export interface DataResponse {
  Id?: string | undefined;
  Source?: string | undefined;
  Destination?: string | undefined;
  Metric?: MetricType | undefined;
  Statistic?: StatisticType | undefined;
  Period?: PeriodType | undefined;
  MetricPoints?: MetricPoint[] | undefined;
}
export interface GetAwsNetworkPerformanceDataResult {
  DataResponses?: DataResponse[] | undefined;
  NextToken?: string | undefined;
}
export interface GetCapacityReservationUsageRequest {
  CapacityReservationId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface InstanceUsage {
  AccountId?: string | undefined;
  UsedInstanceCount?: number | undefined;
}
export interface GetCapacityReservationUsageResult {
  NextToken?: string | undefined;
  CapacityReservationId?: string | undefined;
  InstanceType?: string | undefined;
  TotalInstanceCount?: number | undefined;
  AvailableInstanceCount?: number | undefined;
  State?: CapacityReservationState | undefined;
  InstanceUsages?: InstanceUsage[] | undefined;
}
export interface GetCoipPoolUsageRequest {
  PoolId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface CoipAddressUsage {
  AllocationId?: string | undefined;
  AwsAccountId?: string | undefined;
  AwsService?: string | undefined;
  CoIp?: string | undefined;
}
export interface GetCoipPoolUsageResult {
  CoipPoolId?: string | undefined;
  CoipAddressUsages?: CoipAddressUsage[] | undefined;
  LocalGatewayRouteTableId?: string | undefined;
  NextToken?: string | undefined;
}
export interface GetConsoleOutputRequest {
  InstanceId: string | undefined;
  Latest?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export interface GetConsoleOutputResult {
  InstanceId?: string | undefined;
  Timestamp?: Date | undefined;
  Output?: string | undefined;
}
export interface GetConsoleScreenshotRequest {
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  WakeUp?: boolean | undefined;
}
export interface GetConsoleScreenshotResult {
  ImageData?: string | undefined;
  InstanceId?: string | undefined;
}
export interface GetDeclarativePoliciesReportSummaryRequest {
  DryRun?: boolean | undefined;
  ReportId: string | undefined;
}
export interface RegionalSummary {
  RegionName?: string | undefined;
  NumberOfMatchedAccounts?: number | undefined;
  NumberOfUnmatchedAccounts?: number | undefined;
}
export interface AttributeSummary {
  AttributeName?: string | undefined;
  MostFrequentValue?: string | undefined;
  NumberOfMatchedAccounts?: number | undefined;
  NumberOfUnmatchedAccounts?: number | undefined;
  RegionalSummaries?: RegionalSummary[] | undefined;
}
export interface GetDeclarativePoliciesReportSummaryResult {
  ReportId?: string | undefined;
  S3Bucket?: string | undefined;
  S3Prefix?: string | undefined;
  TargetId?: string | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  NumberOfAccounts?: number | undefined;
  NumberOfFailedAccounts?: number | undefined;
  AttributeSummaries?: AttributeSummary[] | undefined;
}
export declare const UnlimitedSupportedInstanceFamily: {
  readonly t2: "t2";
  readonly t3: "t3";
  readonly t3a: "t3a";
  readonly t4g: "t4g";
};
export type UnlimitedSupportedInstanceFamily =
  (typeof UnlimitedSupportedInstanceFamily)[keyof typeof UnlimitedSupportedInstanceFamily];
export interface GetDefaultCreditSpecificationRequest {
  DryRun?: boolean | undefined;
  InstanceFamily: UnlimitedSupportedInstanceFamily | undefined;
}
export interface InstanceFamilyCreditSpecification {
  InstanceFamily?: UnlimitedSupportedInstanceFamily | undefined;
  CpuCredits?: string | undefined;
}
export interface GetDefaultCreditSpecificationResult {
  InstanceFamilyCreditSpecification?:
    | InstanceFamilyCreditSpecification
    | undefined;
}
export interface GetEbsDefaultKmsKeyIdRequest {
  DryRun?: boolean | undefined;
}
export interface GetEbsDefaultKmsKeyIdResult {
  KmsKeyId?: string | undefined;
}
export interface GetEbsEncryptionByDefaultRequest {
  DryRun?: boolean | undefined;
}
export interface GetEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean | undefined;
  SseType?: SSEType | undefined;
}
export declare const PartitionLoadFrequency: {
  readonly DAILY: "daily";
  readonly MONTHLY: "monthly";
  readonly NONE: "none";
  readonly WEEKLY: "weekly";
};
export type PartitionLoadFrequency =
  (typeof PartitionLoadFrequency)[keyof typeof PartitionLoadFrequency];
export interface AthenaIntegration {
  IntegrationResultS3DestinationArn: string | undefined;
  PartitionLoadFrequency: PartitionLoadFrequency | undefined;
  PartitionStartDate?: Date | undefined;
  PartitionEndDate?: Date | undefined;
}
export interface IntegrateServices {
  AthenaIntegrations?: AthenaIntegration[] | undefined;
}
export interface GetFlowLogsIntegrationTemplateRequest {
  DryRun?: boolean | undefined;
  FlowLogId: string | undefined;
  ConfigDeliveryS3DestinationArn: string | undefined;
  IntegrateServices: IntegrateServices | undefined;
}
export interface GetFlowLogsIntegrationTemplateResult {
  Result?: string | undefined;
}
export interface GetGroupsForCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface CapacityReservationGroup {
  GroupArn?: string | undefined;
  OwnerId?: string | undefined;
}
export interface GetGroupsForCapacityReservationResult {
  NextToken?: string | undefined;
  CapacityReservationGroups?: CapacityReservationGroup[] | undefined;
}
export interface GetHostReservationPurchasePreviewRequest {
  HostIdSet: string[] | undefined;
  OfferingId: string | undefined;
}
export interface Purchase {
  CurrencyCode?: CurrencyCodeValues | undefined;
  Duration?: number | undefined;
  HostIdSet?: string[] | undefined;
  HostReservationId?: string | undefined;
  HourlyPrice?: string | undefined;
  InstanceFamily?: string | undefined;
  PaymentOption?: PaymentOption | undefined;
  UpfrontPrice?: string | undefined;
}
export interface GetHostReservationPurchasePreviewResult {
  CurrencyCode?: CurrencyCodeValues | undefined;
  Purchase?: Purchase[] | undefined;
  TotalHourlyPrice?: string | undefined;
  TotalUpfrontPrice?: string | undefined;
}
export interface GetImageBlockPublicAccessStateRequest {
  DryRun?: boolean | undefined;
}
export interface GetImageBlockPublicAccessStateResult {
  ImageBlockPublicAccessState?: string | undefined;
  ManagedBy?: ManagedBy | undefined;
}
export interface GetInstanceMetadataDefaultsRequest {
  DryRun?: boolean | undefined;
}
export interface InstanceMetadataDefaultsResponse {
  HttpTokens?: HttpTokensState | undefined;
  HttpPutResponseHopLimit?: number | undefined;
  HttpEndpoint?: InstanceMetadataEndpointState | undefined;
  InstanceMetadataTags?: InstanceMetadataTagsState | undefined;
  ManagedBy?: ManagedBy | undefined;
  ManagedExceptionMessage?: string | undefined;
}
export interface GetInstanceMetadataDefaultsResult {
  AccountLevel?: InstanceMetadataDefaultsResponse | undefined;
}
export declare const EkPubKeyFormat: {
  readonly der: "der";
  readonly tpmt: "tpmt";
};
export type EkPubKeyFormat =
  (typeof EkPubKeyFormat)[keyof typeof EkPubKeyFormat];
export declare const EkPubKeyType: {
  readonly ECC_SEC_P384: "ecc-sec-p384";
  readonly RSA_2048: "rsa-2048";
};
export type EkPubKeyType = (typeof EkPubKeyType)[keyof typeof EkPubKeyType];
export interface GetInstanceTpmEkPubRequest {
  InstanceId: string | undefined;
  KeyType: EkPubKeyType | undefined;
  KeyFormat: EkPubKeyFormat | undefined;
  DryRun?: boolean | undefined;
}
export interface GetInstanceTpmEkPubResult {
  InstanceId?: string | undefined;
  KeyType?: EkPubKeyType | undefined;
  KeyFormat?: EkPubKeyFormat | undefined;
  KeyValue?: string | undefined;
}
export interface GetInstanceTypesFromInstanceRequirementsRequest {
  DryRun?: boolean | undefined;
  ArchitectureTypes: ArchitectureType[] | undefined;
  VirtualizationTypes: VirtualizationType[] | undefined;
  InstanceRequirements: InstanceRequirementsRequest | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  Context?: string | undefined;
}
export interface InstanceTypeInfoFromInstanceRequirements {
  InstanceType?: string | undefined;
}
export interface GetInstanceTypesFromInstanceRequirementsResult {
  InstanceTypes?: InstanceTypeInfoFromInstanceRequirements[] | undefined;
  NextToken?: string | undefined;
}
export interface GetInstanceUefiDataRequest {
  InstanceId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetInstanceUefiDataResult {
  InstanceId?: string | undefined;
  UefiData?: string | undefined;
}
export interface GetIpamAddressHistoryRequest {
  DryRun?: boolean | undefined;
  Cidr: string | undefined;
  IpamScopeId: string | undefined;
  VpcId?: string | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export declare const IpamComplianceStatus: {
  readonly compliant: "compliant";
  readonly ignored: "ignored";
  readonly noncompliant: "noncompliant";
  readonly unmanaged: "unmanaged";
};
export type IpamComplianceStatus =
  (typeof IpamComplianceStatus)[keyof typeof IpamComplianceStatus];
export declare const IpamOverlapStatus: {
  readonly ignored: "ignored";
  readonly nonoverlapping: "nonoverlapping";
  readonly overlapping: "overlapping";
};
export type IpamOverlapStatus =
  (typeof IpamOverlapStatus)[keyof typeof IpamOverlapStatus];
export declare const IpamAddressHistoryResourceType: {
  readonly eip: "eip";
  readonly instance: "instance";
  readonly network_interface: "network-interface";
  readonly subnet: "subnet";
  readonly vpc: "vpc";
};
export type IpamAddressHistoryResourceType =
  (typeof IpamAddressHistoryResourceType)[keyof typeof IpamAddressHistoryResourceType];
export interface IpamAddressHistoryRecord {
  ResourceOwnerId?: string | undefined;
  ResourceRegion?: string | undefined;
  ResourceType?: IpamAddressHistoryResourceType | undefined;
  ResourceId?: string | undefined;
  ResourceCidr?: string | undefined;
  ResourceName?: string | undefined;
  ResourceComplianceStatus?: IpamComplianceStatus | undefined;
  ResourceOverlapStatus?: IpamOverlapStatus | undefined;
  VpcId?: string | undefined;
  SampledStartTime?: Date | undefined;
  SampledEndTime?: Date | undefined;
}
export interface GetIpamAddressHistoryResult {
  HistoryRecords?: IpamAddressHistoryRecord[] | undefined;
  NextToken?: string | undefined;
}
export interface GetIpamDiscoveredAccountsRequest {
  DryRun?: boolean | undefined;
  IpamResourceDiscoveryId: string | undefined;
  DiscoveryRegion: string | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export declare const IpamDiscoveryFailureCode: {
  readonly assume_role_failure: "assume-role-failure";
  readonly throttling_failure: "throttling-failure";
  readonly unauthorized_failure: "unauthorized-failure";
};
export type IpamDiscoveryFailureCode =
  (typeof IpamDiscoveryFailureCode)[keyof typeof IpamDiscoveryFailureCode];
export interface IpamDiscoveryFailureReason {
  Code?: IpamDiscoveryFailureCode | undefined;
  Message?: string | undefined;
}
export interface IpamDiscoveredAccount {
  AccountId?: string | undefined;
  DiscoveryRegion?: string | undefined;
  FailureReason?: IpamDiscoveryFailureReason | undefined;
  LastAttemptedDiscoveryTime?: Date | undefined;
  LastSuccessfulDiscoveryTime?: Date | undefined;
  OrganizationalUnitId?: string | undefined;
}
export interface GetIpamDiscoveredAccountsResult {
  IpamDiscoveredAccounts?: IpamDiscoveredAccount[] | undefined;
  NextToken?: string | undefined;
}
export interface GetIpamDiscoveredPublicAddressesRequest {
  DryRun?: boolean | undefined;
  IpamResourceDiscoveryId: string | undefined;
  AddressRegion: string | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export declare const IpamPublicAddressType: {
  readonly AMAZON_OWNED_CONTIG: "amazon-owned-contig";
  readonly AMAZON_OWNED_EIP: "amazon-owned-eip";
  readonly BYOIP: "byoip";
  readonly EC2_PUBLIC_IP: "ec2-public-ip";
  readonly SERVICE_MANAGED_BYOIP: "service-managed-byoip";
  readonly SERVICE_MANAGED_IP: "service-managed-ip";
};
export type IpamPublicAddressType =
  (typeof IpamPublicAddressType)[keyof typeof IpamPublicAddressType];
export declare const IpamPublicAddressAssociationStatus: {
  readonly ASSOCIATED: "associated";
  readonly DISASSOCIATED: "disassociated";
};
export type IpamPublicAddressAssociationStatus =
  (typeof IpamPublicAddressAssociationStatus)[keyof typeof IpamPublicAddressAssociationStatus];
export interface IpamPublicAddressSecurityGroup {
  GroupName?: string | undefined;
  GroupId?: string | undefined;
}
export declare const IpamPublicAddressAwsService: {
  readonly AGA: "global-accelerator";
  readonly DMS: "database-migration-service";
  readonly EC2_LB: "load-balancer";
  readonly ECS: "elastic-container-service";
  readonly NAT_GATEWAY: "nat-gateway";
  readonly OTHER: "other";
  readonly RDS: "relational-database-service";
  readonly REDSHIFT: "redshift";
  readonly S2S_VPN: "site-to-site-vpn";
};
export type IpamPublicAddressAwsService =
  (typeof IpamPublicAddressAwsService)[keyof typeof IpamPublicAddressAwsService];
export interface IpamPublicAddressTag {
  Key?: string | undefined;
  Value?: string | undefined;
}
export interface IpamPublicAddressTags {
  EipTags?: IpamPublicAddressTag[] | undefined;
}
export interface IpamDiscoveredPublicAddress {
  IpamResourceDiscoveryId?: string | undefined;
  AddressRegion?: string | undefined;
  Address?: string | undefined;
  AddressOwnerId?: string | undefined;
  AddressAllocationId?: string | undefined;
  AssociationStatus?: IpamPublicAddressAssociationStatus | undefined;
  AddressType?: IpamPublicAddressType | undefined;
  Service?: IpamPublicAddressAwsService | undefined;
  ServiceResource?: string | undefined;
  VpcId?: string | undefined;
  SubnetId?: string | undefined;
  PublicIpv4PoolId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  NetworkInterfaceDescription?: string | undefined;
  InstanceId?: string | undefined;
  Tags?: IpamPublicAddressTags | undefined;
  NetworkBorderGroup?: string | undefined;
  SecurityGroups?: IpamPublicAddressSecurityGroup[] | undefined;
  SampleTime?: Date | undefined;
}
export interface GetIpamDiscoveredPublicAddressesResult {
  IpamDiscoveredPublicAddresses?: IpamDiscoveredPublicAddress[] | undefined;
  OldestSampleTime?: Date | undefined;
  NextToken?: string | undefined;
}
export interface GetIpamDiscoveredResourceCidrsRequest {
  DryRun?: boolean | undefined;
  IpamResourceDiscoveryId: string | undefined;
  ResourceRegion: string | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export declare const IpamResourceCidrIpSource: {
  readonly amazon: "amazon";
  readonly byoip: "byoip";
  readonly none: "none";
};
export type IpamResourceCidrIpSource =
  (typeof IpamResourceCidrIpSource)[keyof typeof IpamResourceCidrIpSource];
export declare const IpamNetworkInterfaceAttachmentStatus: {
  readonly available: "available";
  readonly in_use: "in-use";
};
export type IpamNetworkInterfaceAttachmentStatus =
  (typeof IpamNetworkInterfaceAttachmentStatus)[keyof typeof IpamNetworkInterfaceAttachmentStatus];
export declare const IpamResourceType: {
  readonly eip: "eip";
  readonly eni: "eni";
  readonly ipv6_pool: "ipv6-pool";
  readonly public_ipv4_pool: "public-ipv4-pool";
  readonly subnet: "subnet";
  readonly vpc: "vpc";
};
export type IpamResourceType =
  (typeof IpamResourceType)[keyof typeof IpamResourceType];
export interface IpamDiscoveredResourceCidr {
  IpamResourceDiscoveryId?: string | undefined;
  ResourceRegion?: string | undefined;
  ResourceId?: string | undefined;
  ResourceOwnerId?: string | undefined;
  ResourceCidr?: string | undefined;
  IpSource?: IpamResourceCidrIpSource | undefined;
  ResourceType?: IpamResourceType | undefined;
  ResourceTags?: IpamResourceTag[] | undefined;
  IpUsage?: number | undefined;
  VpcId?: string | undefined;
  SubnetId?: string | undefined;
  NetworkInterfaceAttachmentStatus?:
    | IpamNetworkInterfaceAttachmentStatus
    | undefined;
  SampleTime?: Date | undefined;
  AvailabilityZoneId?: string | undefined;
}
export interface GetIpamDiscoveredResourceCidrsResult {
  IpamDiscoveredResourceCidrs?: IpamDiscoveredResourceCidr[] | undefined;
  NextToken?: string | undefined;
}
export interface GetIpamPoolAllocationsRequest {
  DryRun?: boolean | undefined;
  IpamPoolId: string | undefined;
  IpamPoolAllocationId?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface GetIpamPoolAllocationsResult {
  IpamPoolAllocations?: IpamPoolAllocation[] | undefined;
  NextToken?: string | undefined;
}
export interface GetIpamPoolCidrsRequest {
  DryRun?: boolean | undefined;
  IpamPoolId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface GetIpamPoolCidrsResult {
  IpamPoolCidrs?: IpamPoolCidr[] | undefined;
  NextToken?: string | undefined;
}
export interface GetIpamResourceCidrsRequest {
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  IpamScopeId: string | undefined;
  IpamPoolId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: IpamResourceType | undefined;
  ResourceTag?: RequestIpamResourceTag | undefined;
  ResourceOwner?: string | undefined;
}
export declare const IpamManagementState: {
  readonly ignored: "ignored";
  readonly managed: "managed";
  readonly unmanaged: "unmanaged";
};
export type IpamManagementState =
  (typeof IpamManagementState)[keyof typeof IpamManagementState];
export interface IpamResourceCidr {
  IpamId?: string | undefined;
  IpamScopeId?: string | undefined;
  IpamPoolId?: string | undefined;
  ResourceRegion?: string | undefined;
  ResourceOwnerId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceName?: string | undefined;
  ResourceCidr?: string | undefined;
  ResourceType?: IpamResourceType | undefined;
  ResourceTags?: IpamResourceTag[] | undefined;
  IpUsage?: number | undefined;
  ComplianceStatus?: IpamComplianceStatus | undefined;
  ManagementState?: IpamManagementState | undefined;
  OverlapStatus?: IpamOverlapStatus | undefined;
  VpcId?: string | undefined;
  AvailabilityZoneId?: string | undefined;
}
export interface GetIpamResourceCidrsResult {
  NextToken?: string | undefined;
  IpamResourceCidrs?: IpamResourceCidr[] | undefined;
}
export interface GetLaunchTemplateDataRequest {
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
}
export interface GetLaunchTemplateDataResult {
  LaunchTemplateData?: ResponseLaunchTemplateData | undefined;
}
export interface GetManagedPrefixListAssociationsRequest {
  DryRun?: boolean | undefined;
  PrefixListId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface PrefixListAssociation {
  ResourceId?: string | undefined;
  ResourceOwner?: string | undefined;
}
export interface GetManagedPrefixListAssociationsResult {
  PrefixListAssociations?: PrefixListAssociation[] | undefined;
  NextToken?: string | undefined;
}
export interface GetManagedPrefixListEntriesRequest {
  DryRun?: boolean | undefined;
  PrefixListId: string | undefined;
  TargetVersion?: number | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface PrefixListEntry {
  Cidr?: string | undefined;
  Description?: string | undefined;
}
export interface GetManagedPrefixListEntriesResult {
  Entries?: PrefixListEntry[] | undefined;
  NextToken?: string | undefined;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
  NetworkInsightsAccessScopeAnalysisId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsResult {
  NetworkInsightsAccessScopeAnalysisId?: string | undefined;
  AnalysisStatus?: AnalysisStatus | undefined;
  AnalysisFindings?: AccessScopeAnalysisFinding[] | undefined;
  NextToken?: string | undefined;
}
export interface GetNetworkInsightsAccessScopeContentRequest {
  NetworkInsightsAccessScopeId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const DescribeVpnConnectionsResultFilterSensitiveLog: (
  obj: DescribeVpnConnectionsResult
) => any;
export declare const DetachVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: DetachVerifiedAccessTrustProviderResult
) => any;
export declare const VerifiedAccessInstanceUserTrustProviderClientConfigurationFilterSensitiveLog: (
  obj: VerifiedAccessInstanceUserTrustProviderClientConfiguration
) => any;
export declare const ExportVerifiedAccessInstanceClientConfigurationResultFilterSensitiveLog: (
  obj: ExportVerifiedAccessInstanceClientConfigurationResult
) => any;
export declare const GetInstanceTpmEkPubResultFilterSensitiveLog: (
  obj: GetInstanceTpmEkPubResult
) => any;
export declare const GetLaunchTemplateDataResultFilterSensitiveLog: (
  obj: GetLaunchTemplateDataResult
) => any;
