import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { KMSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../KMSClient";
import { VerifyRequest, VerifyResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link VerifyCommand}.
 */
export interface VerifyCommandInput extends VerifyRequest {
}
/**
 * @public
 *
 * The output of {@link VerifyCommand}.
 */
export interface VerifyCommandOutput extends VerifyResponse, __MetadataBearer {
}
declare const VerifyCommand_base: {
    new (input: VerifyCommandInput): import("@smithy/smithy-client").CommandImpl<VerifyCommandInput, VerifyCommandOutput, KMSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: VerifyCommandInput): import("@smithy/smithy-client").CommandImpl<VerifyCommandInput, VerifyCommandOutput, KMSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Verifies a digital signature that was generated by the <a>Sign</a> operation. </p>
 *          <p></p>
 *          <p>Verification confirms that an authorized user signed the message with the specified KMS
 *       key and signing algorithm, and the message hasn't changed since it was signed. If the
 *       signature is verified, the value of the <code>SignatureValid</code> field in the response is
 *         <code>True</code>. If the signature verification fails, the <code>Verify</code> operation
 *       fails with an <code>KMSInvalidSignatureException</code> exception.</p>
 *          <p>A digital signature is generated by using the private key in an asymmetric KMS key. The
 *       signature is verified by using the public key in the same asymmetric KMS key.
 *       For information about asymmetric KMS keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
 *          <p>To use the <code>Verify</code> operation, specify the same asymmetric KMS key, message,
 *       and signing algorithm that were used to produce the signature. The message type does not need
 *       to be the same as the one used for signing, but it must indicate whether the value of the
 *         <code>Message</code> parameter should be hashed as part of the verification process.</p>
 *          <p>You can also verify the digital signature by using the public key of the KMS key outside
 *       of KMS. Use the <a>GetPublicKey</a> operation to download the public key in the
 *       asymmetric KMS key and then use the public key to verify the signature outside of KMS. The
 *       advantage of using the <code>Verify</code> operation is that it is performed within KMS. As
 *       a result, it's easy to call, the operation is performed within the FIPS boundary, it is logged
 *       in CloudTrail, and you can use key policy and IAM policy to determine who is authorized to use
 *       the KMS key to verify signatures.</p>
 *          <p>To verify a signature outside of KMS with an SM2 public key (China Regions only), you
 *       must specify the distinguishing ID. By default, KMS uses <code>1234567812345678</code> as
 *       the distinguishing ID. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/offline-operations.html#key-spec-sm-offline-verification">Offline
 *         verification with SM2 key pairs</a>.</p>
 *          <p>The KMS key that you use for this operation must be in a compatible key state. For
 * details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
 *          <p>
 *             <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify
 *   the key ARN or alias ARN in the value of the <code>KeyId</code> parameter. </p>
 *          <p>
 *             <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:Verify</a> (key policy)</p>
 *          <p>
 *             <b>Related operations</b>: <a>Sign</a>
 *          </p>
 *          <p>
 *             <b>Eventual consistency</b>: The KMS API follows an eventual consistency model.
 *   For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/accessing-kms.html#programming-eventual-consistency">KMS eventual consistency</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { KMSClient, VerifyCommand } from "@aws-sdk/client-kms"; // ES Modules import
 * // const { KMSClient, VerifyCommand } = require("@aws-sdk/client-kms"); // CommonJS import
 * const client = new KMSClient(config);
 * const input = { // VerifyRequest
 *   KeyId: "STRING_VALUE", // required
 *   Message: new Uint8Array(), // e.g. Buffer.from("") or new TextEncoder().encode("")   // required
 *   MessageType: "RAW" || "DIGEST" || "EXTERNAL_MU",
 *   Signature: new Uint8Array(), // e.g. Buffer.from("") or new TextEncoder().encode("")   // required
 *   SigningAlgorithm: "RSASSA_PSS_SHA_256" || "RSASSA_PSS_SHA_384" || "RSASSA_PSS_SHA_512" || "RSASSA_PKCS1_V1_5_SHA_256" || "RSASSA_PKCS1_V1_5_SHA_384" || "RSASSA_PKCS1_V1_5_SHA_512" || "ECDSA_SHA_256" || "ECDSA_SHA_384" || "ECDSA_SHA_512" || "SM2DSA" || "ML_DSA_SHAKE_256", // required
 *   GrantTokens: [ // GrantTokenList
 *     "STRING_VALUE",
 *   ],
 *   DryRun: true || false,
 * };
 * const command = new VerifyCommand(input);
 * const response = await client.send(command);
 * // { // VerifyResponse
 * //   KeyId: "STRING_VALUE",
 * //   SignatureValid: true || false,
 * //   SigningAlgorithm: "RSASSA_PSS_SHA_256" || "RSASSA_PSS_SHA_384" || "RSASSA_PSS_SHA_512" || "RSASSA_PKCS1_V1_5_SHA_256" || "RSASSA_PKCS1_V1_5_SHA_384" || "RSASSA_PKCS1_V1_5_SHA_512" || "ECDSA_SHA_256" || "ECDSA_SHA_384" || "ECDSA_SHA_512" || "SM2DSA" || "ML_DSA_SHAKE_256",
 * // };
 *
 * ```
 *
 * @param VerifyCommandInput - {@link VerifyCommandInput}
 * @returns {@link VerifyCommandOutput}
 * @see {@link VerifyCommandInput} for command's `input` shape.
 * @see {@link VerifyCommandOutput} for command's `response` shape.
 * @see {@link KMSClientResolvedConfig | config} for KMSClient's `config` shape.
 *
 * @throws {@link DependencyTimeoutException} (server fault)
 *  <p>The system timed out while trying to fulfill the request. You can retry the
 *       request.</p>
 *
 * @throws {@link DisabledException} (client fault)
 *  <p>The request was rejected because the specified KMS key is not enabled.</p>
 *
 * @throws {@link DryRunOperationException} (client fault)
 *  <p> The request was rejected because the DryRun parameter was specified. </p>
 *
 * @throws {@link InvalidGrantTokenException} (client fault)
 *  <p>The request was rejected because the specified grant token is not valid.</p>
 *
 * @throws {@link InvalidKeyUsageException} (client fault)
 *  <p>The request was rejected for one of the following reasons: </p>
 *          <ul>
 *             <li>
 *                <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
 *           operation.</p>
 *             </li>
 *             <li>
 *                <p>The encryption algorithm or signing algorithm specified for the operation is
 *           incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
 *             </li>
 *          </ul>
 *          <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
 *         <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying
 *       messages, the <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. For generating and
 *       verifying message authentication codes (MACs), the <code>KeyUsage</code> must be
 *         <code>GENERATE_VERIFY_MAC</code>. For deriving key agreement secrets, the
 *         <code>KeyUsage</code> must be <code>KEY_AGREEMENT</code>. To find the <code>KeyUsage</code>
 *       of a KMS key, use the <a>DescribeKey</a> operation.</p>
 *          <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
 *         <a>DescribeKey</a> operation.</p>
 *
 * @throws {@link KeyUnavailableException} (server fault)
 *  <p>The request was rejected because the specified KMS key was not available. You can retry
 *       the request.</p>
 *
 * @throws {@link KMSInternalException} (server fault)
 *  <p>The request was rejected because an internal exception occurred. The request can be
 *       retried.</p>
 *
 * @throws {@link KMSInvalidSignatureException} (client fault)
 *  <p>The request was rejected because the signature verification failed. Signature verification
 *       fails when it cannot confirm that signature was produced by signing the specified message with
 *       the specified KMS key and signing algorithm.</p>
 *
 * @throws {@link KMSInvalidStateException} (client fault)
 *  <p>The request was rejected because the state of the specified resource is not valid for this
 *       request.</p>
 *          <p>This exceptions means one of the following:</p>
 *          <ul>
 *             <li>
 *                <p>The key state of the KMS key is not compatible with the operation. </p>
 *                <p>To find the key state, use the <a>DescribeKey</a> operation. For more
 *           information about which key states are compatible with each KMS operation, see
 *           <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of KMS keys</a> in the <i>
 *                      <i>Key Management Service Developer Guide</i>
 *                   </i>.</p>
 *             </li>
 *             <li>
 *                <p>For cryptographic operations on KMS keys in custom key stores, this exception
 *           represents a general failure with many possible causes. To identify the cause, see the
 *           error message that accompanies the exception.</p>
 *             </li>
 *          </ul>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>The request was rejected because the specified entity or resource could not be
 *       found.</p>
 *
 * @throws {@link KMSServiceException}
 * <p>Base exception class for all service exceptions from KMS service.</p>
 *
 *
 * @example To use an asymmetric KMS key to verify a digital signature
 * ```javascript
 * // This operation uses the public key in an elliptic curve (ECC) asymmetric key to verify a digital signature within AWS KMS.
 * const input = {
 *   KeyId: "alias/ECC_signing_key",
 *   Message: "<message to be verified>",
 *   MessageType: "RAW",
 *   Signature: "<binary data>",
 *   SigningAlgorithm: "ECDSA_SHA_384"
 * };
 * const command = new VerifyCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   KeyId: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
 *   SignatureValid: true,
 *   SigningAlgorithm: "ECDSA_SHA_384"
 * }
 * *\/
 * ```
 *
 * @example To use an asymmetric KMS key to verify a digital signature on a message digest
 * ```javascript
 * // This operation uses the public key in an RSA asymmetric signing key pair to verify the digital signature of a message digest. Hashing a message into a digest before sending it to KMS lets you verify messages that exceed the 4096-byte message size limit. To indicate that the value of Message is a digest, use the MessageType parameter
 * const input = {
 *   KeyId: "arn:aws:kms:us-east-2:111122223333:key/0987dcba-09fe-87dc-65ba-ab0987654321",
 *   Message: "<message digest to be verified>",
 *   MessageType: "DIGEST",
 *   Signature: "<binary data>",
 *   SigningAlgorithm: "RSASSA_PSS_SHA_512"
 * };
 * const command = new VerifyCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   KeyId: "arn:aws:kms:us-east-2:111122223333:key/0987dcba-09fe-87dc-65ba-ab0987654321",
 *   SignatureValid: true,
 *   SigningAlgorithm: "RSASSA_PSS_SHA_512"
 * }
 * *\/
 * ```
 *
 * @public
 */
export declare class VerifyCommand extends VerifyCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: VerifyRequest;
            output: VerifyResponse;
        };
        sdk: {
            input: VerifyCommandInput;
            output: VerifyCommandOutput;
        };
    };
}
