import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { DescribeStateMachineAliasInput, DescribeStateMachineAliasOutput } from "../models/models_0";
import { ServiceInputTypes, ServiceOutputTypes, SFNClientResolvedConfig } from "../SFNClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeStateMachineAliasCommand}.
 */
export interface DescribeStateMachineAliasCommandInput extends DescribeStateMachineAliasInput {
}
/**
 * @public
 *
 * The output of {@link DescribeStateMachineAliasCommand}.
 */
export interface DescribeStateMachineAliasCommandOutput extends DescribeStateMachineAliasOutput, __MetadataBearer {
}
declare const DescribeStateMachineAliasCommand_base: {
    new (input: DescribeStateMachineAliasCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeStateMachineAliasCommandInput, DescribeStateMachineAliasCommandOutput, SFNClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DescribeStateMachineAliasCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeStateMachineAliasCommandInput, DescribeStateMachineAliasCommandOutput, SFNClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns details about a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.</p>
 *          <p>
 *             <b>Related operations:</b>
 *          </p>
 *          <ul>
 *             <li>
 *                <p>
 *                   <a>CreateStateMachineAlias</a>
 *                </p>
 *             </li>
 *             <li>
 *                <p>
 *                   <a>ListStateMachineAliases</a>
 *                </p>
 *             </li>
 *             <li>
 *                <p>
 *                   <a>UpdateStateMachineAlias</a>
 *                </p>
 *             </li>
 *             <li>
 *                <p>
 *                   <a>DeleteStateMachineAlias</a>
 *                </p>
 *             </li>
 *          </ul>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { SFNClient, DescribeStateMachineAliasCommand } from "@aws-sdk/client-sfn"; // ES Modules import
 * // const { SFNClient, DescribeStateMachineAliasCommand } = require("@aws-sdk/client-sfn"); // CommonJS import
 * const client = new SFNClient(config);
 * const input = { // DescribeStateMachineAliasInput
 *   stateMachineAliasArn: "STRING_VALUE", // required
 * };
 * const command = new DescribeStateMachineAliasCommand(input);
 * const response = await client.send(command);
 * // { // DescribeStateMachineAliasOutput
 * //   stateMachineAliasArn: "STRING_VALUE",
 * //   name: "STRING_VALUE",
 * //   description: "STRING_VALUE",
 * //   routingConfiguration: [ // RoutingConfigurationList
 * //     { // RoutingConfigurationListItem
 * //       stateMachineVersionArn: "STRING_VALUE", // required
 * //       weight: Number("int"), // required
 * //     },
 * //   ],
 * //   creationDate: new Date("TIMESTAMP"),
 * //   updateDate: new Date("TIMESTAMP"),
 * // };
 *
 * ```
 *
 * @param DescribeStateMachineAliasCommandInput - {@link DescribeStateMachineAliasCommandInput}
 * @returns {@link DescribeStateMachineAliasCommandOutput}
 * @see {@link DescribeStateMachineAliasCommandInput} for command's `input` shape.
 * @see {@link DescribeStateMachineAliasCommandOutput} for command's `response` shape.
 * @see {@link SFNClientResolvedConfig | config} for SFNClient's `config` shape.
 *
 * @throws {@link InvalidArn} (client fault)
 *  <p>The provided Amazon Resource Name (ARN) is not valid.</p>
 *
 * @throws {@link ResourceNotFound} (client fault)
 *  <p>Could not find the referenced resource.</p>
 *
 * @throws {@link ValidationException} (client fault)
 *  <p>The input does not satisfy the constraints specified by an Amazon Web Services service.</p>
 *
 * @throws {@link SFNServiceException}
 * <p>Base exception class for all service exceptions from SFN service.</p>
 *
 *
 * @public
 */
export declare class DescribeStateMachineAliasCommand extends DescribeStateMachineAliasCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeStateMachineAliasInput;
            output: DescribeStateMachineAliasOutput;
        };
        sdk: {
            input: DescribeStateMachineAliasCommandInput;
            output: DescribeStateMachineAliasCommandOutput;
        };
    };
}
