import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog, } from "../models/models_1";
import { de_GetMaintenanceWindowExecutionTaskInvocationCommand, se_GetMaintenanceWindowExecutionTaskInvocationCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class GetMaintenanceWindowExecutionTaskInvocationCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "GetMaintenanceWindowExecutionTaskInvocation", {})
    .n("SSMClient", "GetMaintenanceWindowExecutionTaskInvocationCommand")
    .f(void 0, GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog)
    .ser(se_GetMaintenanceWindowExecutionTaskInvocationCommand)
    .de(de_GetMaintenanceWindowExecutionTaskInvocationCommand)
    .build() {
}
