import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetParameterHistoryResultFilterSensitiveLog, } from "../models/models_1";
import { de_GetParameterHistoryCommand, se_GetParameterHistoryCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetParameterHistoryCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "GetParameterHistory", {})
    .n("SSMClient", "GetParameterHistoryCommand")
    .f(void 0, GetParameterHistoryResultFilterSensitiveLog)
    .ser(se_GetParameterHistoryCommand)
    .de(de_GetParameterHistoryCommand)
    .build() {
}
