"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsManagedPolicy = void 0;
/** Provides names of all AWS managed policies. */
class AwsManagedPolicy {
}
exports.AwsManagedPolicy = AwsManagedPolicy;
/** Allow Access Analyzer to analyze resource metadata */
AwsManagedPolicy.AccessAnalyzerServiceRolePolicy = 'aws-service-role/AccessAnalyzerServiceRolePolicy';
/** Provides full access to AWS services and resources. */
AwsManagedPolicy.AdministratorAccess = 'AdministratorAccess';
/** Grants account administrative permissions while explicitly allowing direct access to resources needed by Amplify applications. */
AwsManagedPolicy.AdministratorAccessAmplify = 'AdministratorAccess-Amplify';
/** Grants account administrative permissions. Explicitly allows developers and administrators to gain direct access to resources they need to manage AWS Elastic Beanstalk applications */
AwsManagedPolicy.AdministratorAccessAWSElasticBeanstalk = 'AdministratorAccess-AWSElasticBeanstalk';
/** Provides ReadOnly permissions required by the Amazon AI Operations Assistant to do analysis on customer AWS resources during investigations. */
AwsManagedPolicy.AIOpsAssistantPolicy = 'AIOpsAssistantPolicy';
/** Grants full access to Amazon AI Operations service and its required permissions via AWS console. It also includes permissions to use identity-aware console sessions. */
AwsManagedPolicy.AIOpsConsoleAdminPolicy = 'AIOpsConsoleAdminPolicy';
/** Grants access to the Amazon AI Operations APIs for creating, updating, and deleting investigations, investigation events, and investigation resources. It also includes ReadOnly access to all AI Operations APIs and to use identity-aware sessions. */
AwsManagedPolicy.AIOpsOperatorAccess = 'AIOpsOperatorAccess';
/** Grants ReadOnly permissions to the Amazon AI Operations service and its required resources. */
AwsManagedPolicy.AIOpsReadOnlyAccess = 'AIOpsReadOnlyAccess';
/** Provide device setup access to AlexaForBusiness services */
AwsManagedPolicy.AlexaForBusinessDeviceSetup = 'AlexaForBusinessDeviceSetup';
/** Grants full access to AlexaForBusiness resources and access to related AWS Services */
AwsManagedPolicy.AlexaForBusinessFullAccess = 'AlexaForBusinessFullAccess';
/** Provide gateway execution access to AlexaForBusiness services */
AwsManagedPolicy.AlexaForBusinessGatewayExecution = 'AlexaForBusinessGatewayExecution';
/** Provide access to Lifesize AVS devices */
AwsManagedPolicy.AlexaForBusinessLifesizeDelegatedAccessPolicy = 'AlexaForBusinessLifesizeDelegatedAccessPolicy';
/** This policy enables Alexa for Business to perform automated tasks scheduled by your network profiles. */
AwsManagedPolicy.AlexaForBusinessNetworkProfileServicePolicy = 'aws-service-role/AlexaForBusinessNetworkProfileServicePolicy';
/** Provide access to Poly AVS devices */
AwsManagedPolicy.AlexaForBusinessPolyDelegatedAccessPolicy = 'AlexaForBusinessPolyDelegatedAccessPolicy';
/** Provide read only access to AlexaForBusiness services */
AwsManagedPolicy.AlexaForBusinessReadOnlyAccess = 'AlexaForBusinessReadOnlyAccess';
/** Provides full access to create/edit/delete APIs in Amazon API Gateway via the AWS Management Console. */
AwsManagedPolicy.AmazonAPIGatewayAdministrator = 'AmazonAPIGatewayAdministrator';
/** Provides full access to invoke APIs in Amazon API Gateway. */
AwsManagedPolicy.AmazonAPIGatewayInvokeFullAccess = 'AmazonAPIGatewayInvokeFullAccess';
/** Allows API Gateway to push logs to user's account. */
AwsManagedPolicy.AmazonAPIGatewayPushToCloudWatchLogs = 'service-role/AmazonAPIGatewayPushToCloudWatchLogs';
/** Provides full access to Amazon AppFlow and access to AWS services supported as flow source or destination (S3 and Redshift). Also provides access to KMS for encryption */
AwsManagedPolicy.AmazonAppFlowFullAccess = 'AmazonAppFlowFullAccess';
/** Provides read only access to Amazon Appflow flows */
AwsManagedPolicy.AmazonAppFlowReadOnlyAccess = 'AmazonAppFlowReadOnlyAccess';
/** Provides full access to Amazon AppStream via the AWS Management Console. */
AwsManagedPolicy.AmazonAppStreamFullAccess = 'AmazonAppStreamFullAccess';
/** Amazon AppStream 2.0 access to AWS Certificate Manager Private CA in customer accounts for certificate-based authentication */
AwsManagedPolicy.AmazonAppStreamPCAAccess = 'service-role/AmazonAppStreamPCAAccess';
/** Provides read only access to Amazon AppStream via the AWS Management Console. */
AwsManagedPolicy.AmazonAppStreamReadOnlyAccess = 'AmazonAppStreamReadOnlyAccess';
/** Default policy for Amazon AppStream service role. */
AwsManagedPolicy.AmazonAppStreamServiceAccess = 'service-role/AmazonAppStreamServiceAccess';
/** Provide full access to Amazon Athena and scoped access to the dependencies needed to enable querying, writing results, and data management. */
AwsManagedPolicy.AmazonAthenaFullAccess = 'AmazonAthenaFullAccess';
/** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Does not allow access for creating FlowDefinitions against the public-crowd Workteam. */
AwsManagedPolicy.AmazonAugmentedAIFullAccess = 'AmazonAugmentedAIFullAccess';
/** Provides access to perform all operations on HumanLoops. */
AwsManagedPolicy.AmazonAugmentedAIHumanLoopFullAccess = 'AmazonAugmentedAIHumanLoopFullAccess';
/** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Also provides access to those operations of services that are integrated with Amazon Augmented AI. */
AwsManagedPolicy.AmazonAugmentedAIIntegratedAPIAccess = 'AmazonAugmentedAIIntegratedAPIAccess';
/** Provides console full administrative access to Aurora DSQL */
AwsManagedPolicy.AmazonAuroraDSQLConsoleFullAccess = 'AmazonAuroraDSQLConsoleFullAccess';
/** Provides full administrative access to Aurora DSQL */
AwsManagedPolicy.AmazonAuroraDSQLFullAccess = 'AmazonAuroraDSQLFullAccess';
/** Provides read only access to Aurora DSQL */
AwsManagedPolicy.AmazonAuroraDSQLReadOnlyAccess = 'AmazonAuroraDSQLReadOnlyAccess';
/** Provides full access to Amazon Bedrock as well as limited access to related services that are required by it */
AwsManagedPolicy.AmazonBedrockFullAccess = 'AmazonBedrockFullAccess';
/** Provides read only access to Amazon Bedrock */
AwsManagedPolicy.AmazonBedrockReadOnly = 'AmazonBedrockReadOnly';
/** Defines the maximum permissions of IAM roles that Amazon Bedrock Studio creates for operating Amazon Bedrock Studio resources. */
AwsManagedPolicy.AmazonBedrockStudioPermissionsBoundary = 'AmazonBedrockStudioPermissionsBoundary';
/** Provides full access to Amazon Braket via the AWS Management Console and SDK. Also provides access to related services (e.g., S3, logs). */
AwsManagedPolicy.AmazonBraketFullAccess = 'AmazonBraketFullAccess';
/** Grants access to AWS Services and resources necessary for executing an Amazon Braket Job including S3, Cloudwatch, IAM and Braket */
AwsManagedPolicy.AmazonBraketJobsExecutionPolicy = 'AmazonBraketJobsExecutionPolicy';
/** Allows Amazon Braket to create and manage AWS resources on your behalf */
AwsManagedPolicy.AmazonBraketServiceRolePolicy = 'aws-service-role/AmazonBraketServiceRolePolicy';
/** Provides full access to Amazon Chime Admin Console via the AWS Management Console. */
AwsManagedPolicy.AmazonChimeFullAccess = 'AmazonChimeFullAccess';
/** Provides read only access to Amazon Chime Admin Console via the AWS Management Console. */
AwsManagedPolicy.AmazonChimeReadOnly = 'AmazonChimeReadOnly';
/** Provides access to Amazon Chime SDK operations */
AwsManagedPolicy.AmazonChimeSDK = 'AmazonChimeSDK';
/** Managed Policy For Amazon Chime SDK MediaPipelines Service Linked Role */
AwsManagedPolicy.AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy = 'aws-service-role/AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy';
/** Allows Amazon Chime SDK Messaging to access AWS resources and enable messaging functionality */
AwsManagedPolicy.AmazonChimeSDKMessagingServiceRolePolicy = 'aws-service-role/AmazonChimeSDKMessagingServiceRolePolicy';
/** Enables access to AWS Resources used or managed by Amazon Chime */
AwsManagedPolicy.AmazonChimeServiceRolePolicy = 'aws-service-role/AmazonChimeServiceRolePolicy';
/** Allows Amazon Chime to access Amazon Transcribe and Amazon Transcribe Medical on your behalf */
AwsManagedPolicy.AmazonChimeTranscriptionServiceLinkedRolePolicy = 'aws-service-role/AmazonChimeTranscriptionServiceLinkedRolePolicy';
/** Provides user management access to Amazon Chime Admin Console via the AWS Management Console. */
AwsManagedPolicy.AmazonChimeUserManagement = 'AmazonChimeUserManagement';
/** Managed policy for Service Linked Role for Amazon Chime VoiceConnector */
AwsManagedPolicy.AmazonChimeVoiceConnectorServiceLinkedRolePolicy = 'aws-service-role/AmazonChimeVoiceConnectorServiceLinkedRolePolicy';
/** Provides full access to Amazon Cloud Directory Service. */
AwsManagedPolicy.AmazonCloudDirectoryFullAccess = 'AmazonCloudDirectoryFullAccess';
/** Provides read only access to Amazon Cloud Directory Service. */
AwsManagedPolicy.AmazonCloudDirectoryReadOnlyAccess = 'AmazonCloudDirectoryReadOnlyAccess';
/** Provides full only access to Amazon CloudWatch Evidently. Also provides access to related Amazon S3, Amazon SNS, Amazon CloudWatch, and other related services. */
AwsManagedPolicy.AmazonCloudWatchEvidentlyFullAccess = 'AmazonCloudWatchEvidentlyFullAccess';
/** Provides read only access to Amazon CloudWatch Evidently */
AwsManagedPolicy.AmazonCloudWatchEvidentlyReadOnlyAccess = 'AmazonCloudWatchEvidentlyReadOnlyAccess';
/** Allows CloudWatch Evidently Service to manage associated AWS Resources on behalf of the customer */
AwsManagedPolicy.AmazonCloudWatchEvidentlyServiceRolePolicy = 'aws-service-role/AmazonCloudWatchEvidentlyServiceRolePolicy';
/** Grants full access permissions for the Amazon CloudWatch RUM service */
AwsManagedPolicy.AmazonCloudWatchRUMFullAccess = 'AmazonCloudWatchRUMFullAccess';
/** Grants read only permissions for the Amazon CloudWatch RUM service */
AwsManagedPolicy.AmazonCloudWatchRUMReadOnlyAccess = 'AmazonCloudWatchRUMReadOnlyAccess';
/** Grants permission to Amazon CloudWatch RUM Service to publish monitoring data to other relevant AWS services */
AwsManagedPolicy.AmazonCloudWatchRUMServiceRolePolicy = 'aws-service-role/AmazonCloudWatchRUMServiceRolePolicy';
/** Provides full access to Amazon CodeCatalyst */
AwsManagedPolicy.AmazonCodeCatalystFullAccess = 'AmazonCodeCatalystFullAccess';
/** Provides read only access to Amazon CodeCatalyst */
AwsManagedPolicy.AmazonCodeCatalystReadOnlyAccess = 'AmazonCodeCatalystReadOnlyAccess';
/** Allows Amazon CodeCatalyst to create, update, and resolve AWS Support cases on your behalf. */
AwsManagedPolicy.AmazonCodeCatalystSupportAccess = 'service-role/AmazonCodeCatalystSupportAccess';
/** Provides access required by Amazon CodeGuru Profiler agent. */
AwsManagedPolicy.AmazonCodeGuruProfilerAgentAccess = 'AmazonCodeGuruProfilerAgentAccess';
/** Provides full access to Amazon CodeGuru Profiler. */
AwsManagedPolicy.AmazonCodeGuruProfilerFullAccess = 'AmazonCodeGuruProfilerFullAccess';
/** Provides read only access to Amazon CodeGuru Profiler. */
AwsManagedPolicy.AmazonCodeGuruProfilerReadOnlyAccess = 'AmazonCodeGuruProfilerReadOnlyAccess';
/** Grants full access to Amazon CodeGuru Reviewer and scoped access to required dependencies. */
AwsManagedPolicy.AmazonCodeGuruReviewerFullAccess = 'AmazonCodeGuruReviewerFullAccess';
/** Provides read only access to Amazon CodeGuru Reviewer. */
AwsManagedPolicy.AmazonCodeGuruReviewerReadOnlyAccess = 'AmazonCodeGuruReviewerReadOnlyAccess';
/** A service-linked role required for Amazon CodeGuru Reviewer to access resources on your behalf. */
AwsManagedPolicy.AmazonCodeGuruReviewerServiceRolePolicy = 'aws-service-role/AmazonCodeGuruReviewerServiceRolePolicy';
/** Provides full access to Amazon CodeGuru Security. */
AwsManagedPolicy.AmazonCodeGuruSecurityFullAccess = 'AmazonCodeGuruSecurityFullAccess';
/** Provides access required for working with Amazon CodeGuru Security scans. */
AwsManagedPolicy.AmazonCodeGuruSecurityScanAccess = 'AmazonCodeGuruSecurityScanAccess';
/** Provides access to Amazon Cognito APIs to support developer authenticated identities from your authentication backend. */
AwsManagedPolicy.AmazonCognitoDeveloperAuthenticatedIdentities = 'AmazonCognitoDeveloperAuthenticatedIdentities';
/** Allows Amazon Cognito User Pools service to use your SES identities for email sending */
AwsManagedPolicy.AmazonCognitoIdpEmailServiceRolePolicy = 'aws-service-role/AmazonCognitoIdpEmailServiceRolePolicy';
/** Enables access to AWS Services and Resources used or managed by Amazon Cognito User Pools */
AwsManagedPolicy.AmazonCognitoIdpServiceRolePolicy = 'aws-service-role/AmazonCognitoIdpServiceRolePolicy';
/** Provides administrative access to existing Amazon Cognito resources. You will need AWS account admin privileges to create new Cognito resources. */
AwsManagedPolicy.AmazonCognitoPowerUser = 'AmazonCognitoPowerUser';
/** Provides read only access to Amazon Cognito resources. */
AwsManagedPolicy.AmazonCognitoReadOnly = 'AmazonCognitoReadOnly';
/** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This policy is not intended to be used as a stand alone permission policy. It is used as a guardrail against overly permissive policies attached for roles in an identity pool. Do not attach this policy to any roles, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
AwsManagedPolicy.AmazonCognitoUnAuthedIdentitiesSessionPolicy = 'AmazonCognitoUnAuthedIdentitiesSessionPolicy';
/** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This does not need to be attached to your unauth role, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
AwsManagedPolicy.AmazonCognitoUnauthenticatedIdentities = 'AmazonCognitoUnauthenticatedIdentities';
/** The purpose of this policy is to grant permissions to AWS Connect users required to use Connect resources. This policy provides full access to AWS Connect resources via the Connect Console and public APIs */
AwsManagedPolicy.AmazonConnectFullAccess = 'AmazonConnect_FullAccess';
/** Policy for Amazon Connect Campaigns service linked role */
AwsManagedPolicy.AmazonConnectCampaignsServiceLinkedRolePolicy = 'aws-service-role/AmazonConnectCampaignsServiceLinkedRolePolicy';
/** Grants permission to view the Amazon Connect instances in your AWS account. */
AwsManagedPolicy.AmazonConnectReadOnlyAccess = 'AmazonConnectReadOnlyAccess';
/** Allows Amazon Connect to create and manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonConnectServiceLinkedRolePolicy = 'aws-service-role/AmazonConnectServiceLinkedRolePolicy';
/** Allows Amazon Connect to synchronize AWS resources across regions on your behalf. */
AwsManagedPolicy.AmazonConnectSynchronizationServiceRolePolicy = 'aws-service-role/AmazonConnectSynchronizationServiceRolePolicy';
/** Provides full access to Amazon Connect Voice ID */
AwsManagedPolicy.AmazonConnectVoiceIDFullAccess = 'AmazonConnectVoiceIDFullAccess';
/** Provides permissions to consume Amazon Bedrock models, including invoking Amazon Bedrock application inference profile created for particular Amazon DataZone domain. */
AwsManagedPolicy.AmazonDataZoneBedrockModelConsumptionPolicy = 'service-role/AmazonDataZoneBedrockModelConsumptionPolicy';
/** Provides permissions to manage Amazon Bedrock model access, including creating, tagging and deleting application inference profiles. */
AwsManagedPolicy.AmazonDataZoneBedrockModelManagementPolicy = 'service-role/AmazonDataZoneBedrockModelManagementPolicy';
/** Default policy for the Amazon DataZone's DomainExecutionRole service role. This role is used by Amazon DataZone to catalog, discover, govern, share, and analyze data in the Amazon DataZone domain. */
AwsManagedPolicy.AmazonDataZoneDomainExecutionRolePolicy = 'service-role/AmazonDataZoneDomainExecutionRolePolicy';
/** Amazon DataZone creates IAM roles for Environments to perform data analytics actions, and uses this policy when creating these roles to define the boundary of their permissions. */
AwsManagedPolicy.AmazonDataZoneEnvironmentRolePermissionsBoundary = 'AmazonDataZoneEnvironmentRolePermissionsBoundary';
/** Provides full access to Amazon DataZone via the AWS Management Console as well as limited access to related services that are required by it. */
AwsManagedPolicy.AmazonDataZoneFullAccess = 'AmazonDataZoneFullAccess';
/** Provides full access to Amazon DataZone, but does not allow the management of domains, users, or associated accounts. */
AwsManagedPolicy.AmazonDataZoneFullUserAccess = 'AmazonDataZoneFullUserAccess';
/** The policy grants permissions to allow Amazon DataZone to enable publishing and access grants to data. */
AwsManagedPolicy.AmazonDataZoneGlueManageAccessRolePolicy = 'service-role/AmazonDataZoneGlueManageAccessRolePolicy';
/** Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone simplifies your experience across AWS services, including, but not limited to, Amazon Redshift, Amazon Athena, AWS Glue, and AWS Lake Formation. */
AwsManagedPolicy.AmazonDataZoneRedshiftGlueProvisioningPolicy = 'AmazonDataZoneRedshiftGlueProvisioningPolicy';
/** This policy gives Amazon DataZone permissions to publish Amazon Redshift data to the catalog. It also gives Amazon DataZone permissions to grant access or revoke access to Amazon Redshift or Amazon Redshift Serverless published assets in the catalog. */
AwsManagedPolicy.AmazonDataZoneRedshiftManageAccessRolePolicy = 'service-role/AmazonDataZoneRedshiftManageAccessRolePolicy';
/** The AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary policy is the list of permissions that are permitted on an execution role created in a SageMaker environment provisioned by Amazon DataZone. */
AwsManagedPolicy.AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary = 'AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary';
/** The AmazonDataZoneSageMakerManageAccessRolePolicy policy grants Amazon DataZone the permissions required to grant user access to various resources in the SageMaker environment. */
AwsManagedPolicy.AmazonDataZoneSageMakerManageAccessRolePolicy = 'AmazonDataZoneSageMakerManageAccessRolePolicy';
/** The AmazonDataZoneSageMakerProvisioningRolePolicy policy grants Amazon DataZone the permissions required to interoperate with Amazon SageMaker. */
AwsManagedPolicy.AmazonDataZoneSageMakerProvisioningRolePolicy = 'AmazonDataZoneSageMakerProvisioningRolePolicy';
/**  Provides full access to Amazon Detective service and scoped access to the console UI dependencies */
AwsManagedPolicy.AmazonDetectiveFullAccess = 'AmazonDetectiveFullAccess';
/** Provides investigator access to Amazon Detective service and scoped access to the console UI dependencies. This policy grants permission to dive into Detective for investigation purposes and limited write access to Guardduty. */
AwsManagedPolicy.AmazonDetectiveInvestigatorAccess = 'AmazonDetectiveInvestigatorAccess';
/** Provides member access to Amazon Detective service and scoped access to the console UI dependencies. */
AwsManagedPolicy.AmazonDetectiveMemberAccess = 'AmazonDetectiveMemberAccess';
/** Provides Organizations access to manage Delegated administrator for Amazon Detective and scoped access to the console UI dependencies. This also grants permission to create a service-linked role for Detective. */
AwsManagedPolicy.AmazonDetectiveOrganizationsAccess = 'AmazonDetectiveOrganizationsAccess';
/** Allows Amazon Detective to make service calls on your behalf */
AwsManagedPolicy.AmazonDetectiveServiceLinkedRolePolicy = 'aws-service-role/AmazonDetectiveServiceLinkedRolePolicy';
/** The policy grants full-access to the DevOps Guru console. */
AwsManagedPolicy.AmazonDevOpsGuruConsoleFullAccess = 'AmazonDevOpsGuruConsoleFullAccess';
/** Provides full access to Amazon DevOps Guru. */
AwsManagedPolicy.AmazonDevOpsGuruFullAccess = 'AmazonDevOpsGuruFullAccess';
/** Provide access to enable and manage Amazon DevOps Guru within an organization. */
AwsManagedPolicy.AmazonDevOpsGuruOrganizationsAccess = 'AmazonDevOpsGuruOrganizationsAccess';
/** Provides read only access to Amazon DevOps Guru Console. */
AwsManagedPolicy.AmazonDevOpsGuruReadOnlyAccess = 'AmazonDevOpsGuruReadOnlyAccess';
/** A service-linked role required for Amazon DevOpsGuru to access your resources. */
AwsManagedPolicy.AmazonDevOpsGuruServiceRolePolicy = 'aws-service-role/AmazonDevOpsGuruServiceRolePolicy';
/** Provides access to upload DMS replication logs to cloudwatch logs in customer account. */
AwsManagedPolicy.AmazonDMSCloudWatchLogsRole = 'service-role/AmazonDMSCloudWatchLogsRole';
/** Provides access to manage S3 settings for Redshift endpoints for DMS. */
AwsManagedPolicy.AmazonDMSRedshiftS3Role = 'service-role/AmazonDMSRedshiftS3Role';
/** Provides access to manage VPC settings for AWS managed customer configurations */
AwsManagedPolicy.AmazonDMSVPCManagementRole = 'service-role/AmazonDMSVPCManagementRole';
/** Allows Amazon DocumentDB-Elastic to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonDocDBElasticServiceRolePolicy = 'aws-service-role/AmazonDocDB-ElasticServiceRolePolicy';
/** Provides full access to manage Amazon DocumentDB with MongoDB compatibility using the AWS Management Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS and Amazon Neptune. */
AwsManagedPolicy.AmazonDocDBConsoleFullAccess = 'AmazonDocDBConsoleFullAccess';
/** Provides full access to Amazon DocumentDB Elastic Clusters and other required permissions for its dependencies including EC2, KMS, SecretsManager, CloudWatch and IAM. */
AwsManagedPolicy.AmazonDocDBElasticFullAccess = 'AmazonDocDBElasticFullAccess';
/** Provides read-only access to Amazon DocDB-Elastic and CloudWatch metrics. */
AwsManagedPolicy.AmazonDocDBElasticReadOnlyAccess = 'AmazonDocDBElasticReadOnlyAccess';
/** Provides full access to Amazon DocumentDB with MongoDB compatibility. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS and Amazon Neptune. */
AwsManagedPolicy.AmazonDocDBFullAccess = 'AmazonDocDBFullAccess';
/** Provides read-only access to Amazon DocumentDB with MongoDB compatibility. Note that this policy also grants access to Amazon RDS and Amazon Neptune resources. */
AwsManagedPolicy.AmazonDocDBReadOnlyAccess = 'AmazonDocDBReadOnlyAccess';
/** Provides access to manage VPC settings for Amazon managed customer configurations */
AwsManagedPolicy.AmazonDRSVPCManagement = 'AmazonDRSVPCManagement';
/** Provides full access to Amazon DynamoDB via the AWS Management Console. */
AwsManagedPolicy.AmazonDynamoDBFullAccess = 'AmazonDynamoDBFullAccess';
/** Provides full access to Amazon DynamoDB */
AwsManagedPolicy.AmazonDynamoDBFullAccessV2 = 'AmazonDynamoDBFullAccess_v2';
/** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DynamoDBPipeline.html. Provides full access to Amazon DynamoDB including Export/Import using AWS Data Pipeline via the AWS Management Console. */
AwsManagedPolicy.AmazonDynamoDBFullAccesswithDataPipeline = 'AmazonDynamoDBFullAccesswithDataPipeline';
/** Provides read only access to Amazon DynamoDB via the AWS Management Console. */
AwsManagedPolicy.AmazonDynamoDBReadOnlyAccess = 'AmazonDynamoDBReadOnlyAccess';
/** IAM Policy that allows the CSI driver service account to make calls to related services such as EC2 on your behalf. */
AwsManagedPolicy.AmazonEBSCSIDriverPolicy = 'service-role/AmazonEBSCSIDriverPolicy';
/** Provides administrative access to Amazon ECR resources */
AwsManagedPolicy.AmazonEC2ContainerRegistryFullAccess = 'AmazonEC2ContainerRegistryFullAccess';
/** Provides full access to Amazon EC2 Container Registry repositories, but does not allow repository deletion or policy changes. */
AwsManagedPolicy.AmazonEC2ContainerRegistryPowerUser = 'AmazonEC2ContainerRegistryPowerUser';
/** Provides access to pull images from Amazon EC2 Container Registry repositories. */
AwsManagedPolicy.AmazonEC2ContainerRegistryPullOnly = 'AmazonEC2ContainerRegistryPullOnly';
/** Provides read-only access to Amazon EC2 Container Registry repositories. */
AwsManagedPolicy.AmazonEC2ContainerRegistryReadOnly = 'AmazonEC2ContainerRegistryReadOnly';
/**   Policy to enable Task Autoscaling for Amazon EC2 Container Service */
AwsManagedPolicy.AmazonEC2ContainerServiceAutoscaleRole = 'service-role/AmazonEC2ContainerServiceAutoscaleRole';
/** Policy to enable CloudWatch Events for EC2 Container Service */
AwsManagedPolicy.AmazonEC2ContainerServiceEventsRole = 'service-role/AmazonEC2ContainerServiceEventsRole';
/** Default policy for the Amazon EC2 Role for Amazon EC2 Container Service. */
AwsManagedPolicy.AmazonEC2ContainerServiceforEC2Role = 'service-role/AmazonEC2ContainerServiceforEC2Role';
/** Default policy for Amazon ECS service role. */
AwsManagedPolicy.AmazonEC2ContainerServiceRole = 'service-role/AmazonEC2ContainerServiceRole';
/** Provides full access to Amazon EC2 via the AWS Management Console. */
AwsManagedPolicy.AmazonEC2FullAccess = 'AmazonEC2FullAccess';
/** Provides read only access to Amazon EC2 via the AWS Management Console. */
AwsManagedPolicy.AmazonEC2ReadOnlyAccess = 'AmazonEC2ReadOnlyAccess';
/** Provides EC2 access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
AwsManagedPolicy.AmazonEC2RoleforAWSCodeDeploy = 'service-role/AmazonEC2RoleforAWSCodeDeploy';
/** Provides EC2 limited access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
AwsManagedPolicy.AmazonEC2RoleforAWSCodeDeployLimited = 'service-role/AmazonEC2RoleforAWSCodeDeployLimited';
/** Default policy for the Amazon EC2 Role for Data Pipeline service role. */
AwsManagedPolicy.AmazonEC2RoleforDataPipelineRole = 'service-role/AmazonEC2RoleforDataPipelineRole';
/** This policy will soon be deprecated. Please use AmazonSSMManagedInstanceCore policy to enable AWS Systems Manager service core functionality on EC2 instances. For more information see https://docs.aws.amazon.com/systems-manager/latest/userguide/setup-instance-profile.html */
AwsManagedPolicy.AmazonEC2RoleforSSM = 'service-role/AmazonEC2RoleforSSM';
/** Managed policy for the Amazon LaunchWizard service role for EC2 */
AwsManagedPolicy.AmazonEC2RolePolicyForLaunchWizard = 'AmazonEC2RolePolicyForLaunchWizard';
/** Policy to enable Autoscaling for Amazon EC2 Spot Fleet */
AwsManagedPolicy.AmazonEC2SpotFleetAutoscaleRole = 'service-role/AmazonEC2SpotFleetAutoscaleRole';
/** Allows EC2 Spot Fleet to request, terminate and tag Spot Instances on your behalf. */
AwsManagedPolicy.AmazonEC2SpotFleetTaggingRole = 'service-role/AmazonEC2SpotFleetTaggingRole';
/** Provides administrative access to Amazon ECS resources and enables ECS features through access to other AWS service resources, including VPCs, Auto Scaling groups, and CloudFormation stacks. */
AwsManagedPolicy.AmazonECSFullAccess = 'AmazonECS_FullAccess';
/** Policy to enable Amazon ECS Compute to manage your EC2 instances and related resources as part of ECS managed instances */
AwsManagedPolicy.AmazonECSComputeServiceRolePolicy = 'aws-service-role/AmazonECSComputeServiceRolePolicy';
/** Provides administrative access to Private Certificate Authority, AWS Secrets Manager and other AWS Services required to manage ECS Service Connect TLS features on your behalf. */
AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity = 'service-role/AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity';
/** Provides access to other AWS service resources required to manage volumes associated with ECS workloads on your behalf. */
AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForVolumes = 'service-role/AmazonECSInfrastructureRolePolicyForVolumes';
/** Provides access to other AWS service resources required to manage VPC Lattice feature in ECS workloads on your behalf. */
AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForVpcLattice = 'AmazonECSInfrastructureRolePolicyForVpcLattice';
/** Policy to enable Amazon ECS to manage your cluster. */
AwsManagedPolicy.AmazonECSServiceRolePolicy = 'aws-service-role/AmazonECSServiceRolePolicy';
/** Provides access to other AWS service resources that are required to run Amazon ECS tasks */
AwsManagedPolicy.AmazonECSTaskExecutionRolePolicy = 'service-role/AmazonECSTaskExecutionRolePolicy';
/** Provides management access to EFS resources and read access to EC2 */
AwsManagedPolicy.AmazonEFSCSIDriverPolicy = 'service-role/AmazonEFSCSIDriverPolicy';
/** This policy provides the Amazon VPC CNI Plugin (amazon-vpc-cni-k8s) the permissions it requires to modify the IP address configuration on your EKS worker nodes. This permission set allows the CNI to list, describe, and modify Elastic Network Interfaces on your behalf. More information on the AWS VPC CNI Plugin is available here: https://github.com/aws/amazon-vpc-cni-k8s */
AwsManagedPolicy.AmazonEKSCNIPolicy = 'AmazonEKS_CNI_Policy';
/** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's block storage resources. */
AwsManagedPolicy.AmazonEKSBlockStoragePolicy = 'AmazonEKSBlockStoragePolicy';
/** This policy provides Kubernetes the permissions it requires to manage resources on your behalf. Kubernetes requires Ec2:CreateTags permissions to place identifying information on EC2 resources including but not limited to Instances, Security Groups, and Elastic Network Interfaces. */
AwsManagedPolicy.AmazonEKSClusterPolicy = 'AmazonEKSClusterPolicy';
/** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's compute resources. */
AwsManagedPolicy.AmazonEKSComputePolicy = 'AmazonEKSComputePolicy';
/** This policy allows Amazon EKS to manage AWS resources for EKS connector */
AwsManagedPolicy.AmazonEKSConnectorServiceRolePolicy = 'aws-service-role/AmazonEKSConnectorServiceRolePolicy';
/** Provides read only access to view the dashboard in the Amazon EKS console. The dashboard aggregates information about multiple clusters and related resources using AWS Organizations. */
AwsManagedPolicy.AmazonEKSDashboardConsoleReadOnly = 'AmazonEKSDashboardConsoleReadOnly';
/** This policy enables the Amazon EKS Dashboard to access and display organization-wide information. The policy allows the EKS Dashboard service to gather information about your AWS Organizations structure and accounts. */
AwsManagedPolicy.AmazonEKSDashboardServiceRolePolicy = 'aws-service-role/AmazonEKSDashboardServiceRolePolicy';
/** Provides access to other AWS service resources that are required to run Amazon EKS pods on AWS Fargate */
AwsManagedPolicy.AmazonEKSFargatePodExecutionRolePolicy = 'AmazonEKSFargatePodExecutionRolePolicy';
/** This policy grants necessary permissions to Amazon EKS to run fargate tasks */
AwsManagedPolicy.AmazonEKSForFargateServiceRolePolicy = 'aws-service-role/AmazonEKSForFargateServiceRolePolicy';
/** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's load balancing resources. */
AwsManagedPolicy.AmazonEKSLoadBalancingPolicy = 'AmazonEKSLoadBalancingPolicy';
/** This policy provides permissions to EKS local cluster's control-plane instances running in your account to manage resources on your behalf. */
AwsManagedPolicy.AmazonEKSLocalOutpostClusterPolicy = 'AmazonEKSLocalOutpostClusterPolicy';
/** Allows Amazon EKS Local to call AWS services on your behalf. */
AwsManagedPolicy.AmazonEKSLocalOutpostServiceRolePolicy = 'aws-service-role/AmazonEKSLocalOutpostServiceRolePolicy';
/** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's networking resources. */
AwsManagedPolicy.AmazonEKSNetworkingPolicy = 'AmazonEKSNetworkingPolicy';
/** This policy allows Amazon Elastic Container Service for Kubernetes to create and manage the necessary resources to operate EKS Clusters. */
AwsManagedPolicy.AmazonEKSServicePolicy = 'AmazonEKSServicePolicy';
/** A Service-Linked Role required for Amazon EKS to call AWS services on your behalf. */
AwsManagedPolicy.AmazonEKSServiceRolePolicy = 'aws-service-role/AmazonEKSServiceRolePolicy';
/** Policy used by VPC Resource Controller to manage ENI and IPs for worker nodes. */
AwsManagedPolicy.AmazonEKSVPCResourceController = 'AmazonEKSVPCResourceController';
/** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
AwsManagedPolicy.AmazonEKSWorkerNodeMinimalPolicy = 'AmazonEKSWorkerNodeMinimalPolicy';
/** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
AwsManagedPolicy.AmazonEKSWorkerNodePolicy = 'AmazonEKSWorkerNodePolicy';
/** Provides full access to Amazon ElastiCache via the AWS Management Console. */
AwsManagedPolicy.AmazonElastiCacheFullAccess = 'AmazonElastiCacheFullAccess';
/** Provides read only access to Amazon ElastiCache via the AWS Management Console. */
AwsManagedPolicy.AmazonElastiCacheReadOnlyAccess = 'AmazonElastiCacheReadOnlyAccess';
/** Provides administrative access to Amazon ECR Public resources */
AwsManagedPolicy.AmazonElasticContainerRegistryPublicFullAccess = 'AmazonElasticContainerRegistryPublicFullAccess';
/** Provides full access to Amazon ECR Public repositories, but does not allow repository deletion or policy changes. */
AwsManagedPolicy.AmazonElasticContainerRegistryPublicPowerUser = 'AmazonElasticContainerRegistryPublicPowerUser';
/** Provides read-only access to Amazon ECR Public repositories. */
AwsManagedPolicy.AmazonElasticContainerRegistryPublicReadOnly = 'AmazonElasticContainerRegistryPublicReadOnly';
/** Provides root client access to an Amazon EFS file system */
AwsManagedPolicy.AmazonElasticFileSystemClientFullAccess = 'AmazonElasticFileSystemClientFullAccess';
/** Provides read only client access to an Amazon EFS file system */
AwsManagedPolicy.AmazonElasticFileSystemClientReadOnlyAccess = 'AmazonElasticFileSystemClientReadOnlyAccess';
/** Provides read and write client access to an Amazon EFS file system */
AwsManagedPolicy.AmazonElasticFileSystemClientReadWriteAccess = 'AmazonElasticFileSystemClientReadWriteAccess';
/** Provides full access to Amazon EFS via the AWS Management Console. */
AwsManagedPolicy.AmazonElasticFileSystemFullAccess = 'AmazonElasticFileSystemFullAccess';
/** Provides read only access to Amazon EFS via the AWS Management Console. */
AwsManagedPolicy.AmazonElasticFileSystemReadOnlyAccess = 'AmazonElasticFileSystemReadOnlyAccess';
/** Allows Amazon Elastic File System to manage AWS resources on your behalf */
AwsManagedPolicy.AmazonElasticFileSystemServiceRolePolicy = 'aws-service-role/AmazonElasticFileSystemServiceRolePolicy';
/** Allows customers to use AWS Systems Manager to automatically manage Amazon EFS utilities (amazon-efs-utils) package on their EC2 instances, and use CloudWatchLog to get EFS file system mount success/failure notifications. */
AwsManagedPolicy.AmazonElasticFileSystemsUtils = 'AmazonElasticFileSystemsUtils';
/** Default policy for the Amazon Elastic MapReduce Editors service role. */
AwsManagedPolicy.AmazonElasticMapReduceEditorsRole = 'service-role/AmazonElasticMapReduceEditorsRole';
/** Amazon Elastic MapReduce for Auto Scaling. Role to allow Auto Scaling to add and remove instances from your EMR cluster. */
AwsManagedPolicy.AmazonElasticMapReduceforAutoScalingRole = 'service-role/AmazonElasticMapReduceforAutoScalingRole';
/** Default policy for the Amazon Elastic MapReduce for EC2 service role. */
AwsManagedPolicy.AmazonElasticMapReduceforEC2Role = 'service-role/AmazonElasticMapReduceforEC2Role';
/** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html. Provides full access to Amazon Elastic MapReduce and underlying services that it requires such as EC2 and S3 */
AwsManagedPolicy.AmazonElasticMapReduceFullAccess = 'AmazonElasticMapReduceFullAccess';
/** Policy to allow EMR to create, describe and delete EC2 placement groups. */
AwsManagedPolicy.AmazonElasticMapReducePlacementGroupPolicy = 'AmazonElasticMapReducePlacementGroupPolicy';
/** Provides read only access to Amazon Elastic MapReduce via the AWS Management Console. */
AwsManagedPolicy.AmazonElasticMapReduceReadOnlyAccess = 'AmazonElasticMapReduceReadOnlyAccess';
/** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html.  Default policy for the Amazon Elastic MapReduce service role. */
AwsManagedPolicy.AmazonElasticMapReduceRole = 'service-role/AmazonElasticMapReduceRole';
/** Allow Amazon Elasticsearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
AwsManagedPolicy.AmazonElasticsearchServiceRolePolicy = 'aws-service-role/AmazonElasticsearchServiceRolePolicy';
/** Grants users full access to Elastic Transcoder and the access to associated services that is required for full Elastic Transcoder functionality. */
AwsManagedPolicy.AmazonElasticTranscoderFullAccess = 'AmazonElasticTranscoder_FullAccess';
/** Grants users permission to change presets, submit jobs, and view Elastic Transcoder settings. This policy also grants some read-only access to some other services required to use the Elastic Transcode console, including S3, IAM, and SNS. */
AwsManagedPolicy.AmazonElasticTranscoderJobsSubmitter = 'AmazonElasticTranscoder_JobsSubmitter';
/** Grants users read-only access to Elastic Transcoder and list access to related services. */
AwsManagedPolicy.AmazonElasticTranscoderReadOnlyAccess = 'AmazonElasticTranscoder_ReadOnlyAccess';
/** Default policy for the Amazon Elastic Transcoder service role. */
AwsManagedPolicy.AmazonElasticTranscoderRole = 'service-role/AmazonElasticTranscoderRole';
/** Allows the actions that EMR requires to terminate and delete AWS EC2 resources if the EMR Service role has lost that ability. */
AwsManagedPolicy.AmazonEMRCleanupPolicy = 'aws-service-role/AmazonEMRCleanupPolicy';
/** Allows access to other AWS service resources that are required to run Amazon EMR */
AwsManagedPolicy.AmazonEMRContainersServiceRolePolicy = 'aws-service-role/AmazonEMRContainersServiceRolePolicy';
/** Provides full access to Amazon EMR */
AwsManagedPolicy.AmazonEMRFullAccessPolicyV2 = 'AmazonEMRFullAccessPolicy_v2';
/** Provides read only access to Amazon EMR and the associated CloudWatch Metrics. */
AwsManagedPolicy.AmazonEMRReadOnlyAccessPolicyV2 = 'AmazonEMRReadOnlyAccessPolicy_v2';
/** Allows access to other AWS service resources that are required to run Amazon EMRServerless */
AwsManagedPolicy.AmazonEMRServerlessServiceRolePolicy = 'aws-service-role/AmazonEMRServerlessServiceRolePolicy';
/** This policy is used for the Amazon EMR Service Role and should NOT be used for any other IAM users or roles in your account. The policy grants permissions to create and manage resources associated with EMR and related services necessary for the operation of your EMR cluster. */
AwsManagedPolicy.AmazonEMRServicePolicyV2 = 'service-role/AmazonEMRServicePolicy_v2';
/** Provides limited access to the Amazon Cognito configuration service. */
AwsManagedPolicy.AmazonESCognitoAccess = 'AmazonESCognitoAccess';
/** Provides full access to the Amazon ES configuration service. */
AwsManagedPolicy.AmazonESFullAccess = 'AmazonESFullAccess';
/** Provides read-only access to the Amazon ES configuration service. */
AwsManagedPolicy.AmazonESReadOnlyAccess = 'AmazonESReadOnlyAccess';
/** Allows EventBridge to access Secret Manager resources on your behalf. */
AwsManagedPolicy.AmazonEventBridgeApiDestinationsServiceRolePolicy = 'aws-service-role/AmazonEventBridgeApiDestinationsServiceRolePolicy';
/** Provides full access to Amazon EventBridge. */
AwsManagedPolicy.AmazonEventBridgeFullAccess = 'AmazonEventBridgeFullAccess';
/** Provides full access to Amazon EventBridge Pipes. */
AwsManagedPolicy.AmazonEventBridgePipesFullAccess = 'AmazonEventBridgePipesFullAccess';
/** Provides read-only and operator (ability to Stop and Start running Pipes) access to Amazon EventBridge Pipes. */
AwsManagedPolicy.AmazonEventBridgePipesOperatorAccess = 'AmazonEventBridgePipesOperatorAccess';
/** Provides read-only access to Amazon EventBridge Pipes. */
AwsManagedPolicy.AmazonEventBridgePipesReadOnlyAccess = 'AmazonEventBridgePipesReadOnlyAccess';
/** Provides read only access to Amazon EventBridge. */
AwsManagedPolicy.AmazonEventBridgeReadOnlyAccess = 'AmazonEventBridgeReadOnlyAccess';
/** The AmazonEventBridgeSchedulerFullAccess managed policy grants permissions to use all EventBridge Scheduler actions for schedules, and schedule groups. */
AwsManagedPolicy.AmazonEventBridgeSchedulerFullAccess = 'AmazonEventBridgeSchedulerFullAccess';
/** The AmazonEventBridgeSchedulerReadOnlyAccess managed policy grants read-only permissions to view details about your schedules and schedule groups */
AwsManagedPolicy.AmazonEventBridgeSchedulerReadOnlyAccess = 'AmazonEventBridgeSchedulerReadOnlyAccess';
/** Provides full access to Amazon EventBridge Schemas. */
AwsManagedPolicy.AmazonEventBridgeSchemasFullAccess = 'AmazonEventBridgeSchemasFullAccess';
/** Provides read only access to Amazon EventBridge Schemas. */
AwsManagedPolicy.AmazonEventBridgeSchemasReadOnlyAccess = 'AmazonEventBridgeSchemasReadOnlyAccess';
/** Grants permissions to Managed Rules created by Amazon EventBridge schemas. */
AwsManagedPolicy.AmazonEventBridgeSchemasServiceRolePolicy = 'aws-service-role/AmazonEventBridgeSchemasServiceRolePolicy';
/** Grants permissions to EVS to manage resources on your behalf */
AwsManagedPolicy.AmazonEVSServiceRolePolicy = 'aws-service-role/AmazonEVSServiceRolePolicy';
/** Policy to enable AWS FIS to manage monitoring and resource selection for experiments. */
AwsManagedPolicy.AmazonFISServiceRolePolicy = 'aws-service-role/AmazonFISServiceRolePolicy';
/** Gives access to all actions for Amazon Forecast */
AwsManagedPolicy.AmazonForecastFullAccess = 'AmazonForecastFullAccess';
/** Gives access to all actions for Amazon Fraud Detector */
AwsManagedPolicy.AmazonFraudDetectorFullAccessPolicy = 'AmazonFraudDetectorFullAccessPolicy';
/** Full Access Policy for Amazon FreeRTOS */
AwsManagedPolicy.AmazonFreeRTOSFullAccess = 'AmazonFreeRTOSFullAccess';
/** Allows user to access Amazon FreeRTOS OTA Update */
AwsManagedPolicy.AmazonFreeRTOSOTAUpdate = 'service-role/AmazonFreeRTOSOTAUpdate';
/** Provides full access to Amazon FSx and access to related AWS services via the AWS Management Console. */
AwsManagedPolicy.AmazonFSxConsoleFullAccess = 'AmazonFSxConsoleFullAccess';
/** Provides read only access to Amazon FSx and access to related AWS services via the AWS Management Console. */
AwsManagedPolicy.AmazonFSxConsoleReadOnlyAccess = 'AmazonFSxConsoleReadOnlyAccess';
/** Provides full access to Amazon FSx and access to related AWS services. */
AwsManagedPolicy.AmazonFSxFullAccess = 'AmazonFSxFullAccess';
/** Provides read only access to Amazon FSx. */
AwsManagedPolicy.AmazonFSxReadOnlyAccess = 'AmazonFSxReadOnlyAccess';
/** Allows Amazon FSx to manage AWS resources on your behalf */
AwsManagedPolicy.AmazonFSxServiceRolePolicy = 'aws-service-role/AmazonFSxServiceRolePolicy';
/** Provides full access to Amazon Glacier via the AWS Management Console. */
AwsManagedPolicy.AmazonGlacierFullAccess = 'AmazonGlacierFullAccess';
/** Provides read only access to Amazon Glacier via the AWS Management Console. */
AwsManagedPolicy.AmazonGlacierReadOnlyAccess = 'AmazonGlacierReadOnlyAccess';
/** This policy grants access to Amazon Athena and the dependencies needed to enable querying and writing results to s3 from the Amazon Athena plugin in Amazon Grafana. */
AwsManagedPolicy.AmazonGrafanaAthenaAccess = 'service-role/AmazonGrafanaAthenaAccess';
/** This policy grants access to Amazon CloudWatch and the dependencies needed to use CloudWatch as a datasource within Amazon Managed Grafana. */
AwsManagedPolicy.AmazonGrafanaCloudWatchAccess = 'service-role/AmazonGrafanaCloudWatchAccess';
/** This policy grants scoped access to Amazon Redshift and the dependencies needed to use the Amazon Redshift plugin in Amazon Grafana. */
AwsManagedPolicy.AmazonGrafanaRedshiftAccess = 'service-role/AmazonGrafanaRedshiftAccess';
/** Provides access to AWS Resources managed or used by Amazon Grafana. */
AwsManagedPolicy.AmazonGrafanaServiceLinkedRolePolicy = 'aws-service-role/AmazonGrafanaServiceLinkedRolePolicy';
/** Provides full access to use Amazon GuardDuty. */
AwsManagedPolicy.AmazonGuardDutyFullAccess = 'AmazonGuardDutyFullAccess';
/** Provides full access to use Amazon GuardDuty */
AwsManagedPolicy.AmazonGuardDutyFullAccessV2 = 'AmazonGuardDutyFullAccess_v2';
/** GuardDuty malware protection uses the service-linked role (SLR) named AWSServiceRoleForAmazonGuardDutyMalwareProtection. This service-linked role allows GuardDuty malware protection to perform agent-less scans to detect malware. It allows GuardDuty to create snapshots in your account, and share the snapshots with the GuardDuty service account to scan for malware. It evaluates these shared snapshots and includes the retrieved EC2 instance metadata in the GuardDuty Malware Protection findings. The AWSServiceRoleForAmazonGuardDutyMalwareProtection service-linked role trusts the malware-protection.guardduty.amazonaws.com service to assume the role. */
AwsManagedPolicy.AmazonGuardDutyMalwareProtectionServiceRolePolicy = 'aws-service-role/AmazonGuardDutyMalwareProtectionServiceRolePolicy';
/** Provides read only access to Amazon GuardDuty resources */
AwsManagedPolicy.AmazonGuardDutyReadOnlyAccess = 'AmazonGuardDutyReadOnlyAccess';
/** Enable access to AWS Resources used or managed by Amazon Guard Duty */
AwsManagedPolicy.AmazonGuardDutyServiceRolePolicy = 'aws-service-role/AmazonGuardDutyServiceRolePolicy';
/** Provides full access to Amazon HealthLake service. */
AwsManagedPolicy.AmazonHealthLakeFullAccess = 'AmazonHealthLakeFullAccess';
/** Provides read only access to Amazon HealthLake service. */
AwsManagedPolicy.AmazonHealthLakeReadOnlyAccess = 'AmazonHealthLakeReadOnlyAccess';
/** Provides full access to Honeycode via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeFullAccess = 'AmazonHoneycodeFullAccess';
/** Provides read only access to Honeycode via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeReadOnlyAccess = 'AmazonHoneycodeReadOnlyAccess';
/** A service-linked role required for Amazon Honeycode to access your resources. */
AwsManagedPolicy.AmazonHoneycodeServiceRolePolicy = 'aws-service-role/AmazonHoneycodeServiceRolePolicy';
/** Provides full access to Honeycode Team Association via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeTeamAssociationFullAccess = 'AmazonHoneycodeTeamAssociationFullAccess';
/** Provides read only access to Honeycode Team Association via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeTeamAssociationReadOnlyAccess = 'AmazonHoneycodeTeamAssociationReadOnlyAccess';
/** Provides full access to Honeycode Workbook via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeWorkbookFullAccess = 'AmazonHoneycodeWorkbookFullAccess';
/** Provides read only access to Honeycode Workbook via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeWorkbookReadOnlyAccess = 'AmazonHoneycodeWorkbookReadOnlyAccess';
/** Grants Amazon Inspector access to AWS Services needed to perform agent-less security assessments */
AwsManagedPolicy.AmazonInspector2AgentlessServiceRolePolicy = 'aws-service-role/AmazonInspector2AgentlessServiceRolePolicy';
/** Provides full access to Amazon Inspector and access to other related services such as organizations. */
AwsManagedPolicy.AmazonInspector2FullAccess = 'AmazonInspector2FullAccess';
/** This is a managed policy that customer should attach to their roles to communicate with inspector service for CIS scans */
AwsManagedPolicy.AmazonInspector2ManagedCisPolicy = 'AmazonInspector2ManagedCisPolicy';
/** Provides read only access to the Amazon inspector2 service and relevant support services */
AwsManagedPolicy.AmazonInspector2ReadOnlyAccess = 'AmazonInspector2ReadOnlyAccess';
/** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
AwsManagedPolicy.AmazonInspector2ServiceRolePolicy = 'aws-service-role/AmazonInspector2ServiceRolePolicy';
/** Provides full access to Amazon Inspector. */
AwsManagedPolicy.AmazonInspectorFullAccess = 'AmazonInspectorFullAccess';
/** Provides read only access to Amazon Inspector. */
AwsManagedPolicy.AmazonInspectorReadOnlyAccess = 'AmazonInspectorReadOnlyAccess';
/** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
AwsManagedPolicy.AmazonInspectorServiceRolePolicy = 'aws-service-role/AmazonInspectorServiceRolePolicy';
/** Provides full access to Amazon Kendra via the AWS Management Console. */
AwsManagedPolicy.AmazonKendraFullAccess = 'AmazonKendraFullAccess';
/** Provides read only access to Amazon Kendra via the AWS Management Console. */
AwsManagedPolicy.AmazonKendraReadOnlyAccess = 'AmazonKendraReadOnlyAccess';
/** Provide full access to Amazon Keyspaces */
AwsManagedPolicy.AmazonKeyspacesFullAccess = 'AmazonKeyspacesFullAccess';
/** Provide read only access to Amazon Keyspaces */
AwsManagedPolicy.AmazonKeyspacesReadOnlyAccess = 'AmazonKeyspacesReadOnlyAccess';
/** Provide read only access to Amazon Keyspaces and related AWS services. */
AwsManagedPolicy.AmazonKeyspacesReadOnlyAccessV2 = 'AmazonKeyspacesReadOnlyAccess_v2';
/** Provides full access to Amazon Kinesis Analytics via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisAnalyticsFullAccess = 'AmazonKinesisAnalyticsFullAccess';
/** Provides read-only access to Amazon Kinesis Analytics via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisAnalyticsReadOnly = 'AmazonKinesisAnalyticsReadOnly';
/** Provides full access to all Amazon Kinesis Firehose Delivery Streams. */
AwsManagedPolicy.AmazonKinesisFirehoseFullAccess = 'AmazonKinesisFirehoseFullAccess';
/** Provides read only access to all Amazon Kinesis Firehose Delivery Streams. */
AwsManagedPolicy.AmazonKinesisFirehoseReadOnlyAccess = 'AmazonKinesisFirehoseReadOnlyAccess';
/** Provides full access to all streams via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisFullAccess = 'AmazonKinesisFullAccess';
/** Provides read only access to all streams via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisReadOnlyAccess = 'AmazonKinesisReadOnlyAccess';
/** Provides full access to Amazon Kinesis Video Streams via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisVideoStreamsFullAccess = 'AmazonKinesisVideoStreamsFullAccess';
/** Provides read only access to AWS Kinesis Video Streams via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisVideoStreamsReadOnlyAccess = 'AmazonKinesisVideoStreamsReadOnlyAccess';
/** Full access to AWS Launch wizard and other required services. */
AwsManagedPolicy.AmazonLaunchWizardFullAccessV2 = 'AmazonLaunchWizardFullAccessV2';
/** This policy allows customers to call Lex runtime from channels */
AwsManagedPolicy.AmazonLexChannelsAccess = 'aws-service-role/AmazonLexChannelsAccess';
/** Provides full access to Amazon Lex via the AWS Management Console.  Also provides access to create Lex Service Linked Roles and grant Lex permissions to invoke a limited set of Lambda functions. */
AwsManagedPolicy.AmazonLexFullAccess = 'AmazonLexFullAccess';
/** Provides read-only access to Amazon Lex. */
AwsManagedPolicy.AmazonLexReadOnly = 'AmazonLexReadOnly';
/** Allows Amazon Lex to replicate Lex resources across regions on your behalf. */
AwsManagedPolicy.AmazonLexReplicationPolicy = 'aws-service-role/AmazonLexReplicationPolicy';
/** Provides access to Amazon Lex conversational APIs. */
AwsManagedPolicy.AmazonLexRunBotsOnly = 'AmazonLexRunBotsOnly';
/** Provides Lex V2 bots access to call other AWS services on your behalf. */
AwsManagedPolicy.AmazonLexV2BotPolicy = 'aws-service-role/AmazonLexV2BotPolicy';
/** Provides full access to Amazon Lookout for Equipment operations */
AwsManagedPolicy.AmazonLookoutEquipmentFullAccess = 'AmazonLookoutEquipmentFullAccess';
/** Provides read only access to Amazon Lookout for Equipments */
AwsManagedPolicy.AmazonLookoutEquipmentReadOnlyAccess = 'AmazonLookoutEquipmentReadOnlyAccess';
/** Gives access to all actions for Amazon Lookout for Metrics */
AwsManagedPolicy.AmazonLookoutMetricsFullAccess = 'AmazonLookoutMetricsFullAccess';
/** Gives access to all read-only actions for Amazon Lookout for Metrics */
AwsManagedPolicy.AmazonLookoutMetricsReadOnlyAccess = 'AmazonLookoutMetricsReadOnlyAccess';
/** Provides full access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
AwsManagedPolicy.AmazonLookoutVisionConsoleFullAccess = 'AmazonLookoutVisionConsoleFullAccess';
/** Provides read only access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
AwsManagedPolicy.AmazonLookoutVisionConsoleReadOnlyAccess = 'AmazonLookoutVisionConsoleReadOnlyAccess';
/** Provides full access to Amazon Lookout for Vision and scoped access to required dependencies. */
AwsManagedPolicy.AmazonLookoutVisionFullAccess = 'AmazonLookoutVisionFullAccess';
/** Provides read only access to Amazon Lookout for Vision and scoped access to required dependencies. */
AwsManagedPolicy.AmazonLookoutVisionReadOnlyAccess = 'AmazonLookoutVisionReadOnlyAccess';
/** Grants users permission to request Amazon Machine Learning batch predictions. */
AwsManagedPolicy.AmazonMachineLearningBatchPredictionsAccess = 'AmazonMachineLearningBatchPredictionsAccess';
/** Provides create access for non-prediction Amazon Machine Learning resources. */
AwsManagedPolicy.AmazonMachineLearningCreateOnlyAccess = 'AmazonMachineLearningCreateOnlyAccess';
/** Provides full access to Amazon Machine Learning resources. */
AwsManagedPolicy.AmazonMachineLearningFullAccess = 'AmazonMachineLearningFullAccess';
/** Grants users permission to create and delete the real-time endpoint for Amazon Machine Learning models. */
AwsManagedPolicy.AmazonMachineLearningManageRealTimeEndpointOnlyAccess = 'AmazonMachineLearningManageRealTimeEndpointOnlyAccess';
/** Provides read only access to Amazon Machine Learning resources. */
AwsManagedPolicy.AmazonMachineLearningReadOnlyAccess = 'AmazonMachineLearningReadOnlyAccess';
/** Grants users permission to request Amazon Machine Learning real-time predictions. */
AwsManagedPolicy.AmazonMachineLearningRealTimePredictionOnlyAccess = 'AmazonMachineLearningRealTimePredictionOnlyAccess';
/** Allows Machine Learning to configure and use your Redshift Clusters and S3 Staging Locations for Redshift Data Source. */
AwsManagedPolicy.AmazonMachineLearningRoleforRedshiftDataSourceV3 = 'service-role/AmazonMachineLearningRoleforRedshiftDataSourceV3';
/** Provides full access to Amazon Macie. */
AwsManagedPolicy.AmazonMacieFullAccess = 'AmazonMacieFullAccess';
/** Grants permission to create the service-linked role of Amazon Macie. */
AwsManagedPolicy.AmazonMacieHandshakeRole = 'service-role/AmazonMacieHandshakeRole';
/** Provides readonly access to Amazon Macie. */
AwsManagedPolicy.AmazonMacieReadOnlyAccess = 'AmazonMacieReadOnlyAccess';
/** Grants Macie read-only access to resource dependencies in your account in order to enable data analysis. */
AwsManagedPolicy.AmazonMacieServiceRole = 'service-role/AmazonMacieServiceRole';
/** Service linked role for Amazon Macie */
AwsManagedPolicy.AmazonMacieServiceRolePolicy = 'aws-service-role/AmazonMacieServiceRolePolicy';
/** Provides full access to Amazon Managed Blockchain via the AWS Management Console */
AwsManagedPolicy.AmazonManagedBlockchainConsoleFullAccess = 'AmazonManagedBlockchainConsoleFullAccess';
/** Provides full access to Amazon Managed Blockchain. */
AwsManagedPolicy.AmazonManagedBlockchainFullAccess = 'AmazonManagedBlockchainFullAccess';
/** Provides read-only access to Amazon Managed Blockchain. */
AwsManagedPolicy.AmazonManagedBlockchainReadOnlyAccess = 'AmazonManagedBlockchainReadOnlyAccess';
/** Enables access to AWS Services and Resources used or managed by Amazon Managed Blockchain */
AwsManagedPolicy.AmazonManagedBlockchainServiceRolePolicy = 'aws-service-role/AmazonManagedBlockchainServiceRolePolicy';
/** Provide full access to Amazon Managed Apache Cassandra Service */
AwsManagedPolicy.AmazonMCSFullAccess = 'AmazonMCSFullAccess';
/** Provide read only access to Amazon Managed Apache Cassandra Service */
AwsManagedPolicy.AmazonMCSReadOnlyAccess = 'AmazonMCSReadOnlyAccess';
/** Provides full access to all APIs in Amazon Mechanical Turk. */
AwsManagedPolicy.AmazonMechanicalTurkFullAccess = 'AmazonMechanicalTurkFullAccess';
/** Provides access to read only APIs in Amazon Mechanical Turk. */
AwsManagedPolicy.AmazonMechanicalTurkReadOnly = 'AmazonMechanicalTurkReadOnly';
/** Provides full access to Amazon MemoryDB via the AWS Management Console. */
AwsManagedPolicy.AmazonMemoryDBFullAccess = 'AmazonMemoryDBFullAccess';
/** Provides read only access to Amazon MemoryDB via the AWS Management Console. */
AwsManagedPolicy.AmazonMemoryDBReadOnlyAccess = 'AmazonMemoryDBReadOnlyAccess';
/** Provides read only access to all reports including financial data for all application resources. */
AwsManagedPolicy.AmazonMobileAnalyticsFinancialReportAccess = 'AmazonMobileAnalyticsFinancialReportAccess';
/** Provides full access to all application resources. */
AwsManagedPolicy.AmazonMobileAnalyticsFullAccess = 'AmazonMobileAnalyticsFullAccess';
/** Provides read only access to non financial reports for all application resources. */
AwsManagedPolicy.AmazonMobileAnalyticsNonFinancialReportAccess = 'AmazonMobileAnalyticsNon-financialReportAccess';
/** Provides write only access to put event data for all application resources. (Recommended for SDK integration) */
AwsManagedPolicy.AmazonMobileAnalyticsWriteOnlyAccess = 'AmazonMobileAnalyticsWriteOnlyAccess';
/** Provides full access to manage Amazon Monitron */
AwsManagedPolicy.AmazonMonitronFullAccess = 'AmazonMonitronFullAccess';
/** Provides full access to AmazonMQ via our API/SDK. */
AwsManagedPolicy.AmazonMQApiFullAccess = 'AmazonMQApiFullAccess';
/** Provides read only access to AmazonMQ via our API/SDK. */
AwsManagedPolicy.AmazonMQApiReadOnlyAccess = 'AmazonMQApiReadOnlyAccess';
/** Provides full access to AmazonMQ via the AWS Management Console. */
AwsManagedPolicy.AmazonMQFullAccess = 'AmazonMQFullAccess';
/** Provides read only access to AmazonMQ via the AWS Management Console. */
AwsManagedPolicy.AmazonMQReadOnlyAccess = 'AmazonMQReadOnlyAccess';
/** Service Linked Role Policy for AWS Amazon MQ */
AwsManagedPolicy.AmazonMQServiceRolePolicy = 'aws-service-role/AmazonMQServiceRolePolicy';
/** Provide readonly access to Amazon MSK Connect */
AwsManagedPolicy.AmazonMSKConnectReadOnlyAccess = 'AmazonMSKConnectReadOnlyAccess';
/** Provide full access to Amazon MSK and other required permissions for its dependencies. */
AwsManagedPolicy.AmazonMSKFullAccess = 'AmazonMSKFullAccess';
/** Provide readonly access to Amazon MSK */
AwsManagedPolicy.AmazonMSKReadOnlyAccess = 'AmazonMSKReadOnlyAccess';
/** The Service Linked Role used by Amazon Managed Workflows for Apache Airflow. */
AwsManagedPolicy.AmazonMWAAServiceRolePolicy = 'aws-service-role/AmazonMWAAServiceRolePolicy';
/** This policy grants access to resources needed by Nimble Studio Launch Profile workers. Attach this policy to EC2 instances created by Nimble Studio Builder. */
AwsManagedPolicy.AmazonNimbleStudioLaunchProfileWorker = 'AmazonNimbleStudio-LaunchProfileWorker';
/** This policy grants access to Amazon Nimble Studio resources associated with the studio admin and related studio resources in other services. Attach this policy to the Admin role associated with your studio. */
AwsManagedPolicy.AmazonNimbleStudioStudioAdmin = 'AmazonNimbleStudio-StudioAdmin';
/** This policy grants access to Amazon Nimble Studio resources associated with the studio user and related studio resources in other services. Attach this policy to the User role associated with your studio. */
AwsManagedPolicy.AmazonNimbleStudioStudioUser = 'AmazonNimbleStudio-StudioUser';
/** Allows Oracle Database@AWS to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonODBServiceRolePolicy = 'aws-service-role/AmazonODBServiceRolePolicy';
/** Provides full access to Amazon Omics and other required AWS Services. This policy allows the user to view and accept RAM share invitations to access resources outside of the user's AWS account. */
AwsManagedPolicy.AmazonOmicsFullAccess = 'AmazonOmicsFullAccess';
/** Provide read only access to Amazon Omics */
AwsManagedPolicy.AmazonOmicsReadOnlyAccess = 'AmazonOmicsReadOnlyAccess';
/** This policy grants administrative permissions that allow access to all Amazon One Enterprise resources and operations. */
AwsManagedPolicy.AmazonOneEnterpriseFullAccess = 'AmazonOneEnterpriseFullAccess';
/** This policy grants limited read and write permissions that allow device installation and activation. */
AwsManagedPolicy.AmazonOneEnterpriseInstallerAccess = 'AmazonOneEnterpriseInstallerAccess';
/** This policy grants read only permissions to all Amazon One Enterprise resources and operations. */
AwsManagedPolicy.AmazonOneEnterpriseReadOnlyAccess = 'AmazonOneEnterpriseReadOnlyAccess';
/** Provides access to Amazon OpenSearch Dashboards Service to access other AWS services such as CloudWatch on your behalf */
AwsManagedPolicy.AmazonOpenSearchDashboardsServiceRolePolicy = 'aws-service-role/AmazonOpenSearchDashboardsServiceRolePolicy';
/** Allows OpenSearch DirectQuery Service to access AWS Glue APIs for creating resources on your behalf. */
AwsManagedPolicy.AmazonOpenSearchDirectQueryGlueCreateAccess = 'AmazonOpenSearchDirectQueryGlueCreateAccess';
/** Allows Amazon OpenSearch Ingestion to access other AWS services on your behalf. */
AwsManagedPolicy.AmazonOpenSearchIngestionFullAccess = 'AmazonOpenSearchIngestionFullAccess';
/** Provides read only access to the Amazon OpenSearch Ingestion Service */
AwsManagedPolicy.AmazonOpenSearchIngestionReadOnlyAccess = 'AmazonOpenSearchIngestionReadOnlyAccess';
/** Allows Amazon OpenSearch Ingestion Service to access other AWS services on your behalf. */
AwsManagedPolicy.AmazonOpenSearchIngestionServiceRolePolicy = 'aws-service-role/AmazonOpenSearchIngestionServiceRolePolicy';
/** Allow Amazon OpenSearch Serverless to access other AWS services such as CloudWatch APIs on your behalf. */
AwsManagedPolicy.AmazonOpenSearchServerlessServiceRolePolicy = 'aws-service-role/AmazonOpenSearchServerlessServiceRolePolicy';
/** Provides access to the Amazon Cognito configuration service. */
AwsManagedPolicy.AmazonOpenSearchServiceCognitoAccess = 'AmazonOpenSearchServiceCognitoAccess';
/** Provides full access to the Amazon OpenSearch Service configuration service. */
AwsManagedPolicy.AmazonOpenSearchServiceFullAccess = 'AmazonOpenSearchServiceFullAccess';
/** Provides read-only access to the Amazon OpenSearch Service configuration service. */
AwsManagedPolicy.AmazonOpenSearchServiceReadOnlyAccess = 'AmazonOpenSearchServiceReadOnlyAccess';
/** Allow Amazon OpenSearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
AwsManagedPolicy.AmazonOpenSearchServiceRolePolicy = 'aws-service-role/AmazonOpenSearchServiceRolePolicy';
/** Provides full access to Amazon Personalize via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, CloudWatch). */
AwsManagedPolicy.AmazonPersonalizeFullAccess = 'service-role/AmazonPersonalizeFullAccess';
/** Grants full access to Amazon Polly service and resources. */
AwsManagedPolicy.AmazonPollyFullAccess = 'AmazonPollyFullAccess';
/** Grants read-only access to Amazon Polly resources. */
AwsManagedPolicy.AmazonPollyReadOnlyAccess = 'AmazonPollyReadOnlyAccess';
/** Grants full access to AWS Managed Prometheus resources in the AWS console */
AwsManagedPolicy.AmazonPrometheusConsoleFullAccess = 'AmazonPrometheusConsoleFullAccess';
/** Grants full access to AWS Managed Prometheus resources */
AwsManagedPolicy.AmazonPrometheusFullAccess = 'AmazonPrometheusFullAccess';
/** Grants access to run queries against AWS Managed Prometheus resources */
AwsManagedPolicy.AmazonPrometheusQueryAccess = 'AmazonPrometheusQueryAccess';
/** Grants write only access to AWS Managed Prometheus workspaces */
AwsManagedPolicy.AmazonPrometheusRemoteWriteAccess = 'AmazonPrometheusRemoteWriteAccess';
/** Provides access to AWS Resources managed or used by Amazon Managed Service for Prometheus Collector */
AwsManagedPolicy.AmazonPrometheusScraperServiceRolePolicy = 'aws-service-role/AmazonPrometheusScraperServiceRolePolicy';
/** Provides developer access to enable interactions with Amazon Q */
AwsManagedPolicy.AmazonQDeveloperAccess = 'AmazonQDeveloperAccess';
/** Provides full access to enable interactions with Amazon Q */
AwsManagedPolicy.AmazonQFullAccess = 'AmazonQFullAccess';
/** Provides full access to Amazon QLDB via the AWS Management Console. */
AwsManagedPolicy.AmazonQLDBConsoleFullAccess = 'AmazonQLDBConsoleFullAccess';
/** Provides full access to Amazon QLDB via the service API. */
AwsManagedPolicy.AmazonQLDBFullAccess = 'AmazonQLDBFullAccess';
/** Provides read only access to Amazon QLDB. */
AwsManagedPolicy.AmazonQLDBReadOnly = 'AmazonQLDBReadOnly';
/** Allows Amazon RDS to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonRDSBetaServiceRolePolicy = 'aws-service-role/AmazonRDSBetaServiceRolePolicy';
/** Allows Amazon RDS Custom to perform various automation actions and database management tasks through an EC2 instance profile. */
AwsManagedPolicy.AmazonRDSCustomInstanceProfileRolePolicy = 'AmazonRDSCustomInstanceProfileRolePolicy';
/** Amazon RDS Custom Preview Service Role Policy */
AwsManagedPolicy.AmazonRDSCustomPreviewServiceRolePolicy = 'aws-service-role/AmazonRDSCustomPreviewServiceRolePolicy';
/** Allows Amazon RDS Custom to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonRDSCustomServiceRolePolicy = 'aws-service-role/AmazonRDSCustomServiceRolePolicy';
/** Allows full access to use the RDS data APIs, secret store APIs for RDS database credentials, and DB console query management APIs to execute SQL statements on Aurora Serverless clusters in the AWS account. */
AwsManagedPolicy.AmazonRDSDataFullAccess = 'AmazonRDSDataFullAccess';
/** Allow RDS to access Directory Service Managed AD on behalf of the customer for domain-joined SQL Server DB instances. */
AwsManagedPolicy.AmazonRDSDirectoryServiceAccess = 'service-role/AmazonRDSDirectoryServiceAccess';
/** Provides access to Cloudwatch for RDS Enhanced Monitoring */
AwsManagedPolicy.AmazonRDSEnhancedMonitoringRole = 'service-role/AmazonRDSEnhancedMonitoringRole';
/** Provides full access to Amazon RDS via the AWS Management Console. */
AwsManagedPolicy.AmazonRDSFullAccess = 'AmazonRDSFullAccess';
/** Provides full access to RDS Performance Insights via the AWS Management Console */
AwsManagedPolicy.AmazonRDSPerformanceInsightsFullAccess = 'AmazonRDSPerformanceInsightsFullAccess';
/** Read-Only policy for RDS Performance Insights */
AwsManagedPolicy.AmazonRDSPerformanceInsightsReadOnly = 'AmazonRDSPerformanceInsightsReadOnly';
/** Amazon RDS Preview Service Role Policy */
AwsManagedPolicy.AmazonRDSPreviewServiceRolePolicy = 'aws-service-role/AmazonRDSPreviewServiceRolePolicy';
/** Provides read only access to Amazon RDS via the AWS Management Console. */
AwsManagedPolicy.AmazonRDSReadOnlyAccess = 'AmazonRDSReadOnlyAccess';
/** Allows Amazon RDS to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonRDSServiceRolePolicy = 'aws-service-role/AmazonRDSServiceRolePolicy';
/** This policy includes permissions to run SQL commands to copy, load, unload, query, and analyze data on Amazon Redshift. The policy also grants permissions to run select statements for related services, such as Amazon S3, Amazon CloudWatch logs, Amazon SageMaker, or AWS Glue. */
AwsManagedPolicy.AmazonRedshiftAllCommandsFullAccess = 'AmazonRedshiftAllCommandsFullAccess';
/** This policy provides full access to Amazon Redshift Data APIs. This policy also grants scoped access to other required services. */
AwsManagedPolicy.AmazonRedshiftDataFullAccess = 'AmazonRedshiftDataFullAccess';
/** Provides full access to Amazon Redshift via the AWS Management Console. */
AwsManagedPolicy.AmazonRedshiftFullAccess = 'AmazonRedshiftFullAccess';
/** Provides full access to the Amazon Redshift Query Editor and to saved queries via the AWS Management Console. */
AwsManagedPolicy.AmazonRedshiftQueryEditor = 'AmazonRedshiftQueryEditor';
/** Grants full access to the Amazon Redshift Query Editor V2 operations and resources. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters, read keys and aliases in AWS KMS and manage the Query Editor V2 secrets in AWS Secrets Manager. */
AwsManagedPolicy.AmazonRedshiftQueryEditorV2FullAccess = 'AmazonRedshiftQueryEditorV2FullAccess';
/** Grants the ability to work with Amazon Redshift Query Editor V2 without sharing resources. The granted principal can only read, update and delete its own resources but cannot share them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
AwsManagedPolicy.AmazonRedshiftQueryEditorV2NoSharing = 'AmazonRedshiftQueryEditorV2NoSharing';
/** Grants the ability to work with Amazon Redshift Query Editor V2 with limited sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read the resources shared with its team but cannot update them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
AwsManagedPolicy.AmazonRedshiftQueryEditorV2ReadSharing = 'AmazonRedshiftQueryEditorV2ReadSharing';
/** Grants the ability to work with Amazon Redshift Query Editor V2 with sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read and update the resources shared with its team. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
AwsManagedPolicy.AmazonRedshiftQueryEditorV2ReadWriteSharing = 'AmazonRedshiftQueryEditorV2ReadWriteSharing';
/** Provides read only access to Amazon Redshift via the AWS Management Console. */
AwsManagedPolicy.AmazonRedshiftReadOnlyAccess = 'AmazonRedshiftReadOnlyAccess';
/** Allows Amazon Redshift to call AWS services on your behalf */
AwsManagedPolicy.AmazonRedshiftServiceLinkedRolePolicy = 'aws-service-role/AmazonRedshiftServiceLinkedRolePolicy';
/** This policy specifies rekognition and s3 permissions required by Amazon Rekognition Custom Labels feature. */
AwsManagedPolicy.AmazonRekognitionCustomLabelsFullAccess = 'AmazonRekognitionCustomLabelsFullAccess';
/** Access to all Amazon Rekognition APIs */
AwsManagedPolicy.AmazonRekognitionFullAccess = 'AmazonRekognitionFullAccess';
/** Access to all Read rekognition APIs */
AwsManagedPolicy.AmazonRekognitionReadOnlyAccess = 'AmazonRekognitionReadOnlyAccess';
/** Allows Rekognition to call AWS services on your behalf. */
AwsManagedPolicy.AmazonRekognitionServiceRole = 'service-role/AmazonRekognitionServiceRole';
/** Provides full access to all Route 53 Auto Naming actions. */
AwsManagedPolicy.AmazonRoute53AutoNamingFullAccess = 'AmazonRoute53AutoNamingFullAccess';
/** Provides read-only access to all Route 53 Auto Naming actions. */
AwsManagedPolicy.AmazonRoute53AutoNamingReadOnlyAccess = 'AmazonRoute53AutoNamingReadOnlyAccess';
/** Provides registrant level access to Route 53 Auto Naming actions. */
AwsManagedPolicy.AmazonRoute53AutoNamingRegistrantAccess = 'AmazonRoute53AutoNamingRegistrantAccess';
/** Provides full access to all Route53 Domains actions and Create Hosted Zone to allow Hosted Zone creation as part of domain registrations. */
AwsManagedPolicy.AmazonRoute53DomainsFullAccess = 'AmazonRoute53DomainsFullAccess';
/** Provides access to Route53 Domains list and actions. */
AwsManagedPolicy.AmazonRoute53DomainsReadOnlyAccess = 'AmazonRoute53DomainsReadOnlyAccess';
/** Provides full access to all Amazon Route 53 via the AWS Management Console. */
AwsManagedPolicy.AmazonRoute53FullAccess = 'AmazonRoute53FullAccess';
/** This policy grants full access to Amazon Route 53 Profile resources. */
AwsManagedPolicy.AmazonRoute53ProfilesFullAccess = 'AmazonRoute53ProfilesFullAccess';
/** This policy grants read-only access to Amazon Route 53 Profile resources. */
AwsManagedPolicy.AmazonRoute53ProfilesReadOnlyAccess = 'AmazonRoute53ProfilesReadOnlyAccess';
/** Provides read only access to all Amazon Route 53 via the AWS Management Console. */
AwsManagedPolicy.AmazonRoute53ReadOnlyAccess = 'AmazonRoute53ReadOnlyAccess';
/** Provides full access to Amazon Route 53 Recovery Cluster */
AwsManagedPolicy.AmazonRoute53RecoveryClusterFullAccess = 'AmazonRoute53RecoveryClusterFullAccess';
/** Provides read only access to Amazon Route 53 Recovery Cluster */
AwsManagedPolicy.AmazonRoute53RecoveryClusterReadOnlyAccess = 'AmazonRoute53RecoveryClusterReadOnlyAccess';
/** Provides full access to Amazon Route 53 Recovery Control Config */
AwsManagedPolicy.AmazonRoute53RecoveryControlConfigFullAccess = 'AmazonRoute53RecoveryControlConfigFullAccess';
/** Provides read only access to Amazon Route 53 Recovery Control Config */
AwsManagedPolicy.AmazonRoute53RecoveryControlConfigReadOnlyAccess = 'AmazonRoute53RecoveryControlConfigReadOnlyAccess';
/** Provides full access to Amazon Route 53 Recovery Readiness */
AwsManagedPolicy.AmazonRoute53RecoveryReadinessFullAccess = 'AmazonRoute53RecoveryReadinessFullAccess';
/** Provides read only access to Amazon Route 53 Recovery Readiness */
AwsManagedPolicy.AmazonRoute53RecoveryReadinessReadOnlyAccess = 'AmazonRoute53RecoveryReadinessReadOnlyAccess';
/** Full access policy for Route 53 Resolver */
AwsManagedPolicy.AmazonRoute53ResolverFullAccess = 'AmazonRoute53ResolverFullAccess';
/** Read only policy for Route 53 Resolver */
AwsManagedPolicy.AmazonRoute53ResolverReadOnlyAccess = 'AmazonRoute53ResolverReadOnlyAccess';
/** Provides full access to all buckets via the AWS Management Console. */
AwsManagedPolicy.AmazonS3FullAccess = 'AmazonS3FullAccess';
/** Provides AWS Lambda functions permissions to interact with Amazon S3 Object Lambda. Also grants Lambda permissions to write to CloudWatch Logs. */
AwsManagedPolicy.AmazonS3ObjectLambdaExecutionRolePolicy = 'service-role/AmazonS3ObjectLambdaExecutionRolePolicy';
/** Provides full access to Amazon S3 on Outposts via the AWS Management Console. */
AwsManagedPolicy.AmazonS3OutpostsFullAccess = 'AmazonS3OutpostsFullAccess';
/** Provides read only access to Amazon S3 on Outposts via the AWS Management Console. */
AwsManagedPolicy.AmazonS3OutpostsReadOnlyAccess = 'AmazonS3OutpostsReadOnlyAccess';
/** Provides read only access to all buckets via the AWS Management Console. */
AwsManagedPolicy.AmazonS3ReadOnlyAccess = 'AmazonS3ReadOnlyAccess';
/** Provides full access to all S3 table buckets. */
AwsManagedPolicy.AmazonS3TablesFullAccess = 'AmazonS3TablesFullAccess';
/** This managed policy grants AWS Lake Formation permissions to act on all table buckets, namespaces, and tables within the account. */
AwsManagedPolicy.AmazonS3TablesLakeFormationServiceRole = 'service-role/AmazonS3TablesLakeFormationServiceRole';
/** Provides read only access to all S3 table buckets. */
AwsManagedPolicy.AmazonS3TablesReadOnlyAccess = 'AmazonS3TablesReadOnlyAccess';
/** Service role policy used by the AWS Service Catalog service to provision products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CodePipeline, CodeBuild, CodeCommit, Glue, CloudFormation, etc,. */
AwsManagedPolicy.AmazonSageMakerAdminServiceCatalogProductsServiceRolePolicy = 'AmazonSageMakerAdmin-ServiceCatalogProductsServiceRolePolicy';
/** Provides permissions for Amazon SageMaker Canvas to use AI services to support ready to use AI solutions. This policy will add more mutating permissions for services as Amazon SageMaker Canvas adds support. */
AwsManagedPolicy.AmazonSageMakerCanvasAIServicesAccess = 'AmazonSageMakerCanvasAIServicesAccess';
/** This policy grants permissions to use Amazon Bedrock in SageMaker Canvas by providing access to downstream services such as S3. */
AwsManagedPolicy.AmazonSageMakerCanvasBedrockAccess = 'AmazonSageMakerCanvasBedrockAccess';
/** Provides full access to Amazon SageMaker resources and operations for data preparation in Canvas. The policy also provides select access to related services (e.g., S3, IAM, KMS, RDS, CloudWatch Logs, Redshift, Athena, Glue, EventBridge, Secrets Manager). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
AwsManagedPolicy.AmazonSageMakerCanvasDataPrepFullAccess = 'AmazonSageMakerCanvasDataPrepFullAccess';
/** Allows Amazon SageMaker Canvas to create, manage and view endpoint details for endpoints created through Canvas. Allows Amazon SageMaker Canvas to retrieve endpoint invocation metrics from CloudWatch. */
AwsManagedPolicy.AmazonSageMakerCanvasDirectDeployAccess = 'service-role/AmazonSageMakerCanvasDirectDeployAccess';
/** This policy grants permissions to Amazon EMR Serverless for services such as S3, used by Amazon SageMaker Canvas for large data processing. */
AwsManagedPolicy.AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy = 'AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy';
/** This policy grants permissions commonly needed to use SageMaker Canvas with Amazon Forecast. */
AwsManagedPolicy.AmazonSageMakerCanvasForecastAccess = 'service-role/AmazonSageMakerCanvasForecastAccess';
/** Provides full access to Amazon SageMaker Canvas resources and operations. The policy also provides select access to related services (e.g., S3, IAM, VPC, ECR, CloudWatch Logs, Redshift, Secrets Manager, and Forecast). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
AwsManagedPolicy.AmazonSageMakerCanvasFullAccess = 'AmazonSageMakerCanvasFullAccess';
/** Provides permissions for Amazon SageMaker Canvas to use the SageMaker Data Science Assistant service. The Data Science Assistant currently uses both Amazon SageMaker and Amazon Q Developer to process user prompts. */
AwsManagedPolicy.AmazonSageMakerCanvasSMDataScienceAssistantAccess = 'AmazonSageMakerCanvasSMDataScienceAssistantAccess';
/** This policy grants permissions commonly needed to use Amazon SageMaker Cluster. */
AwsManagedPolicy.AmazonSageMakerClusterInstanceRolePolicy = 'AmazonSageMakerClusterInstanceRolePolicy';
/** Managed policy for Service Linked Role for Amazon SageMaker Core Services */
AwsManagedPolicy.AmazonSageMakerCoreServiceRolePolicy = 'aws-service-role/AmazonSageMakerCoreServiceRolePolicy';
/** Provides permissions necessary for SageMaker Edge to create and manage a device fleet for the customer using the default cloud connection. */
AwsManagedPolicy.AmazonSageMakerEdgeDeviceFleetPolicy = 'service-role/AmazonSageMakerEdgeDeviceFleetPolicy';
/** Provides permissions required to enable the offline store for an Amazon SageMaker FeatureStore feature group. */
AwsManagedPolicy.AmazonSageMakerFeatureStoreAccess = 'AmazonSageMakerFeatureStoreAccess';
/** Provides full access to Amazon SageMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, ECR, CloudWatch Logs). */
AwsManagedPolicy.AmazonSageMakerFullAccess = 'AmazonSageMakerFullAccess';
/** This policy provide access to services that are commonly needed to use SageMaker geospatial. */
AwsManagedPolicy.AmazonSageMakerGeospatialExecutionRole = 'service-role/AmazonSageMakerGeospatialExecutionRole';
/** This policy grants permissions that allow full access to Amazon SageMaker Geospatial through the AWS Management Console and SDK. */
AwsManagedPolicy.AmazonSageMakerGeospatialFullAccess = 'service-role/AmazonSageMakerGeospatialFullAccess';
/** Provides access to AWS services that are required to run SageMaker GroundTruth Labeling job */
AwsManagedPolicy.AmazonSageMakerGroundTruthExecution = 'AmazonSageMakerGroundTruthExecution';
/** This policy grants permissions to Amazon SageMaker HyperPod to related AWS services such as Amazon EKS, Amazon CloudWatch etc. */
AwsManagedPolicy.AmazonSageMakerHyperPodServiceRolePolicy = 'aws-service-role/AmazonSageMakerHyperPodServiceRolePolicy';
/** Provides access to create Amazon Augmented AI FlowDefinition resources against any Workteam. */
AwsManagedPolicy.AmazonSageMakerMechanicalTurkAccess = 'AmazonSageMakerMechanicalTurkAccess';
/** This AWS managed policy grants permissions needed to use all Amazon SageMaker Governance features. The policy also provides select access to related services (e.g., S3, KMS). */
AwsManagedPolicy.AmazonSageMakerModelGovernanceUseAccess = 'AmazonSageMakerModelGovernanceUseAccess';
/** This is a new managed policy for Model Registry in Sagemaker. This policy is a standalone policy that can be attached to the user role to access Model Registry related functionalities in Sagemaker. */
AwsManagedPolicy.AmazonSageMakerModelRegistryFullAccess = 'AmazonSageMakerModelRegistryFullAccess';
/** Managed policy for Service Linked Role for Amazon SageMaker Notebooks */
AwsManagedPolicy.AmazonSageMakerNotebooksServiceRolePolicy = 'aws-service-role/AmazonSageMakerNotebooksServiceRolePolicy';
/** Enables Amazon SageMaker partner app users to access applications, list available applications, launch application web UIs, and connect via the application SDK. */
AwsManagedPolicy.AmazonSageMakerPartnerAppsFullAccess = 'AmazonSageMakerPartnerAppsFullAccess';
/** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Lambda and others. */
AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy = 'service-role/AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy';
/** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including Lambda, APIGateway and others. */
AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy = 'service-role/AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy';
/** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Secrets Manager and others. */
AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy = 'service-role/AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy';
/** This Amazon Managed Policy grants permissions commonly needed for use with Callback steps and Lambda steps in SageMaker Model Building Pipelines. It is added to the AmazonSageMaker-ExecutionRole that can be created when setting up SageMaker Studio. It can also be attached to any other role that will be used for authoring or executing pipelines. */
AwsManagedPolicy.AmazonSageMakerPipelinesIntegrations = 'AmazonSageMakerPipelinesIntegrations';
/** This policy will be used By SageMaker Unified Studios to create VPC related resources for QuickSight */
AwsManagedPolicy.AmazonSageMakerQuickSightVPCPolicy = 'service-role/AmazonSageMakerQuickSightVPCPolicy';
/** Provides read only access to Amazon SageMaker via the AWS Management Console and SDK. */
AwsManagedPolicy.AmazonSageMakerReadOnly = 'AmazonSageMakerReadOnly';
/** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CloudWatch Logs and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy';
/** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including SageMaker and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy';
/** Service role policy used by the AWS CodeBuild within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy = 'AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy';
/** Service role policy used by the AWS CodePipeline within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy';
/** Service role policy used by the AWS CloudWatch Events within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy';
/** Service role policy used by the AWS Firehose within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Firehose and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy';
/** Service role policy used by the AWS Glue within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Glue, S3 and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy';
/** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including ECR, S3 and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy';
/** This Amazon Managed Policy provides the necessary permissions to create and manage SageMaker Training Plans. It allows users to create Training Plans and Reserved Capacities, describe existing Training Plans, and perform search and listing operations. */
AwsManagedPolicy.AmazonSageMakerTrainingPlanCreateAccess = 'AmazonSageMakerTrainingPlanCreateAccess';
/** Provides full access to Amazon Security Lake and related services needed to administer Security Lake. */
AwsManagedPolicy.AmazonSecurityLakeAdministrator = 'AmazonSecurityLakeAdministrator';
/** Policy for Amazon SecurityLake meta store manager lambda which allows the access to cloudwatch, S3, Glue and SQS. */
AwsManagedPolicy.AmazonSecurityLakeMetastoreManager = 'service-role/AmazonSecurityLakeMetastoreManager';
/** Amazon Security Lake creates IAM roles for third-party custom sources to write data to a data lake and for third-party subscribers to consume data from a data lake, and uses this policy when creating these roles to define the boundary of their permissions. */
AwsManagedPolicy.AmazonSecurityLakePermissionsBoundary = 'AmazonSecurityLakePermissionsBoundary';
/** Provides full access to Amazon SES via the AWS Management Console. */
AwsManagedPolicy.AmazonSESFullAccess = 'AmazonSESFullAccess';
/** Provides read only access to Amazon SES via the AWS Management Console. */
AwsManagedPolicy.AmazonSESReadOnlyAccess = 'AmazonSESReadOnlyAccess';
/** Allows SES to publish Amazon CloudWatch basic monitoring metrics on behalf of your SES resources */
AwsManagedPolicy.AmazonSESServiceRolePolicy = 'aws-service-role/AmazonSESServiceRolePolicy';
/** Provides full access to Amazon SNS via the AWS Management Console. */
AwsManagedPolicy.AmazonSNSFullAccess = 'AmazonSNSFullAccess';
/** Provides read only access to Amazon SNS via the AWS Management Console. */
AwsManagedPolicy.AmazonSNSReadOnlyAccess = 'AmazonSNSReadOnlyAccess';
/** Default policy for Amazon SNS service role. */
AwsManagedPolicy.AmazonSNSRole = 'service-role/AmazonSNSRole';
/** Provides full access to Amazon SQS via the AWS Management Console. */
AwsManagedPolicy.AmazonSQSFullAccess = 'AmazonSQSFullAccess';
/** Provides read only access to Amazon SQS via the AWS Management Console. */
AwsManagedPolicy.AmazonSQSReadOnlyAccess = 'AmazonSQSReadOnlyAccess';
/** Provides access to view automation executions and send approval decisions to automation waiting for approval */
AwsManagedPolicy.AmazonSSMAutomationApproverAccess = 'AmazonSSMAutomationApproverAccess';
/** Provides permissions for EC2 Automation service to execute activities defined within Automation documents */
AwsManagedPolicy.AmazonSSMAutomationRole = 'service-role/AmazonSSMAutomationRole';
/** This policy allows SSM Agent to access Directory Service on behalf of the customer for domain-join the managed instance. */
AwsManagedPolicy.AmazonSSMDirectoryServiceAccess = 'AmazonSSMDirectoryServiceAccess';
/** Provides full access to Amazon SSM. */
AwsManagedPolicy.AmazonSSMFullAccess = 'AmazonSSMFullAccess';
/**  Service Role to be used for EC2 Maintenance Window */
AwsManagedPolicy.AmazonSSMMaintenanceWindowRole = 'service-role/AmazonSSMMaintenanceWindowRole';
/** This policy enables AWS Systems Manager functionality on EC2 instances. */
AwsManagedPolicy.AmazonSSMManagedEC2InstanceDefaultPolicy = 'AmazonSSMManagedEC2InstanceDefaultPolicy';
/** The policy for Amazon EC2 Role to enable AWS Systems Manager service core functionality. */
AwsManagedPolicy.AmazonSSMManagedInstanceCore = 'AmazonSSMManagedInstanceCore';
/** Provide access to child instances for patch association operation. */
AwsManagedPolicy.AmazonSSMPatchAssociation = 'AmazonSSMPatchAssociation';
/** Provides read only access to Amazon SSM. */
AwsManagedPolicy.AmazonSSMReadOnlyAccess = 'AmazonSSMReadOnlyAccess';
/** Provides access to AWS Resources managed or used by Amazon SSM */
AwsManagedPolicy.AmazonSSMServiceRolePolicy = 'aws-service-role/AmazonSSMServiceRolePolicy';
/** Access to all Amazon Textract APIs */
AwsManagedPolicy.AmazonTextractFullAccess = 'AmazonTextractFullAccess';
/** Allows Textract to call AWS services on your behalf. */
AwsManagedPolicy.AmazonTextractServiceRole = 'service-role/AmazonTextractServiceRole';
/** Provides full access to manage Amazon Timestream using the AWS Management Console. Note that this policy also grants permissions for certain KMS operations, and operations to manage your saved queries. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamConsoleFullAccess = 'AmazonTimestreamConsoleFullAccess';
/** Provides full access to Amazon Timestream. Note that this policy also grants certain KMS operation access. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamFullAccess = 'AmazonTimestreamFullAccess';
/** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamInfluxDBFullAccess = 'AmazonTimestreamInfluxDBFullAccess';
/** Provides administrative access to manage Amazon Timestream InfluxDB instances and parameter groups except marketplace operations. */
AwsManagedPolicy.AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess = 'AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess';
/** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamInfluxDBServiceRolePolicy = 'aws-service-role/AmazonTimestreamInfluxDBServiceRolePolicy';
/** Provides read only access to Amazon Timestream. Policy also provides permission to cancel any running query. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamReadOnlyAccess = 'AmazonTimestreamReadOnlyAccess';
/** Provides full access to Amazon Transcribe operations */
AwsManagedPolicy.AmazonTranscribeFullAccess = 'AmazonTranscribeFullAccess';
/** Provides access to read only operation for Amazon Transcribe */
AwsManagedPolicy.AmazonTranscribeReadOnlyAccess = 'AmazonTranscribeReadOnlyAccess';
/** Provides full access to Verified Permissions */
AwsManagedPolicy.AmazonVerifiedPermissionsFullAccess = 'AmazonVerifiedPermissionsFullAccess';
/** Provides read-only access to the Verified Permissions service. */
AwsManagedPolicy.AmazonVerifiedPermissionsReadOnlyAccess = 'AmazonVerifiedPermissionsReadOnlyAccess';
/** Provides access to create network interfaces and attach them to cross-account resources */
AwsManagedPolicy.AmazonVPCCrossAccountNetworkInterfaceOperations = 'AmazonVPCCrossAccountNetworkInterfaceOperations';
/** Provides full access to Amazon VPC via the AWS Management Console. */
AwsManagedPolicy.AmazonVPCFullAccess = 'AmazonVPCFullAccess';
/** Provides permissions to describe AWS resources, run Network Access Analyzer, and create or delete tags on Network Insights Access Scope and Network Insights Access Scope Analysis. */
AwsManagedPolicy.AmazonVPCNetworkAccessAnalyzerFullAccessPolicy = 'AmazonVPCNetworkAccessAnalyzerFullAccessPolicy';
/** Provides permissions to describe AWS resources, run Reachability Analyzer, and create or delete tags on Network Insights Path and Network Insights Analysis. */
AwsManagedPolicy.AmazonVPCReachabilityAnalyzerFullAccessPolicy = 'AmazonVPCReachabilityAnalyzerFullAccessPolicy';
/** This policy is attached to the role IAMRoleForReachabilityAnalyzerCrossAccountResourceAccess. This role is deployed to the member accounts in an organization when the management account enables trusted access for Reachability Analyzer. It provides permissions to view resources from across your organization using the Reachability Analyzer console. */
AwsManagedPolicy.AmazonVPCReachabilityAnalyzerPathComponentReadPolicy = 'AmazonVPCReachabilityAnalyzerPathComponentReadPolicy';
/** Provides read only access to Amazon VPC via the AWS Management Console. */
AwsManagedPolicy.AmazonVPCReadOnlyAccess = 'AmazonVPCReadOnlyAccess';
/** Provides full access to Amazon WorkDocs via the AWS Management Console */
AwsManagedPolicy.AmazonWorkDocsFullAccess = 'AmazonWorkDocsFullAccess';
/** Provides read only access to Amazon WorkDocs via the AWS Management Console */
AwsManagedPolicy.AmazonWorkDocsReadOnlyAccess = 'AmazonWorkDocsReadOnlyAccess';
/** Enables access to AWS Services and Resources used or managed by Amazon WorkMail Events */
AwsManagedPolicy.AmazonWorkMailEventsServiceRolePolicy = 'aws-service-role/AmazonWorkMailEventsServiceRolePolicy';
/** Provides full access to WorkMail, Directory Service, SES, EC2 and read access to KMS metadata. */
AwsManagedPolicy.AmazonWorkMailFullAccess = 'AmazonWorkMailFullAccess';
/** Full access to the WorkMail Message Flow APIs */
AwsManagedPolicy.AmazonWorkMailMessageFlowFullAccess = 'AmazonWorkMailMessageFlowFullAccess';
/** Read only access to WorkMail messages for the GetRawMessageContent API */
AwsManagedPolicy.AmazonWorkMailMessageFlowReadOnlyAccess = 'AmazonWorkMailMessageFlowReadOnlyAccess';
/** Provides read only access to WorkMail and SES. */
AwsManagedPolicy.AmazonWorkMailReadOnlyAccess = 'AmazonWorkMailReadOnlyAccess';
/** Provides access to Amazon WorkSpaces administrative actions via AWS SDK and CLI. */
AwsManagedPolicy.AmazonWorkSpacesAdmin = 'AmazonWorkSpacesAdmin';
/** Provides administrator access for packaging an application in Amazon WorkSpaces Application Manager. */
AwsManagedPolicy.AmazonWorkSpacesApplicationManagerAdminAccess = 'AmazonWorkSpacesApplicationManagerAdminAccess';
/** This managed policy provides full administrative access to AWS Certificate Manager Private CA resources in your AWS account for certificate-based authentication. */
AwsManagedPolicy.AmazonWorkspacesPCAAccess = 'AmazonWorkspacesPCAAccess';
/** This policy provides AWS WorkSpaces service access to required customer account resources for launching Workspaces Pools */
AwsManagedPolicy.AmazonWorkSpacesPoolServiceAccess = 'AmazonWorkSpacesPoolServiceAccess';
/** Provides read-only access to Amazon WorkSpaces Secure Browser and its dependencies through the AWS Management Console, SDK, and CLI. */
AwsManagedPolicy.AmazonWorkSpacesSecureBrowserReadOnly = 'AmazonWorkSpacesSecureBrowserReadOnly';
/** Provides access to Amazon WorkSpaces backend service to perform Workspace Self Service actions */
AwsManagedPolicy.AmazonWorkSpacesSelfServiceAccess = 'AmazonWorkSpacesSelfServiceAccess';
/** Provides customer account access to AWS WorkSpaces service for launching a Workspace. */
AwsManagedPolicy.AmazonWorkSpacesServiceAccess = 'AmazonWorkSpacesServiceAccess';
/** Provides full access to Amazon WorkSpaces Thin Client as well as limited access to required related services */
AwsManagedPolicy.AmazonWorkSpacesThinClientFullAccess = 'AmazonWorkSpacesThinClientFullAccess';
/** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Thin Client Monitoring */
AwsManagedPolicy.AmazonWorkSpacesThinClientMonitoringServiceRolePolicy = 'aws-service-role/AmazonWorkSpacesThinClientMonitoringServiceRolePolicy';
/** Provides read-only access to Amazon WorkSpaces Thin Client and its dependencies */
AwsManagedPolicy.AmazonWorkSpacesThinClientReadOnlyAccess = 'AmazonWorkSpacesThinClientReadOnlyAccess';
/** Provides read-only access to Amazon WorkSpaces Web and its dependencies through the AWS Management Console, SDK, and CLI. */
AwsManagedPolicy.AmazonWorkSpacesWebReadOnly = 'AmazonWorkSpacesWebReadOnly';
/** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Web */
AwsManagedPolicy.AmazonWorkSpacesWebServiceRolePolicy = 'aws-service-role/AmazonWorkSpacesWebServiceRolePolicy';
/** Provides full access to Amazon Zocalo. */
AwsManagedPolicy.AmazonZocaloFullAccess = 'AmazonZocaloFullAccess';
/** Provides read only access to Amazon Zocalo */
AwsManagedPolicy.AmazonZocaloReadOnlyAccess = 'AmazonZocaloReadOnlyAccess';
/** Provides Amplify full access permissions to deploy Amplify backend resources (AWS AppSync, Amazon Cognito, Amazon S3 and other related services) via the AWS Cloud Development Kit (AWS CDK) */
AwsManagedPolicy.AmplifyBackendDeployFullAccess = 'service-role/AmplifyBackendDeployFullAccess';
/** Allows API Gateway to manage associated AWS Resources on behalf of the customer. */
AwsManagedPolicy.APIGatewayServiceRolePolicy = 'aws-service-role/APIGatewayServiceRolePolicy';
/** Allows AppIntegrations to manage AppFlow resources and publish CloudWatch metric data on your behalf. */
AwsManagedPolicy.AppIntegrationsServiceLinkedRolePolicy = 'aws-service-role/AppIntegrationsServiceLinkedRolePolicy';
/** Policy to enable Application Autoscaling for Amazon AppStream */
AwsManagedPolicy.ApplicationAutoScalingForAmazonAppStreamAccess = 'service-role/ApplicationAutoScalingForAmazonAppStreamAccess';
/** Enables access to AWS Services and Resources used or managed by Application Discovery Service Continuous Export feature */
AwsManagedPolicy.ApplicationDiscoveryServiceContinuousExportServiceRolePolicy = 'aws-service-role/ApplicationDiscoveryServiceContinuousExportServiceRolePolicy';
/** Allows AWS AppRunner Networking to manage related AWS resources on your behalf. */
AwsManagedPolicy.AppRunnerNetworkingServiceRolePolicy = 'aws-service-role/AppRunnerNetworkingServiceRolePolicy';
/** Allows AWS AppRunner to manage related AWS resources on your behalf. */
AwsManagedPolicy.AppRunnerServiceRolePolicy = 'aws-service-role/AppRunnerServiceRolePolicy';
/** Allows AppStudio to manage associated AWS resources on your behalf. */
AwsManagedPolicy.AppStudioServiceRolePolicy = 'aws-service-role/AppStudioServiceRolePolicy';
/** Policy for Amazon Aurora DSQL Service Linked Role */
AwsManagedPolicy.AuroraDsqlServiceLinkedRolePolicy = 'aws-service-role/AuroraDsqlServiceLinkedRolePolicy';
/** Provides full access to Auto Scaling via the AWS Management Console. */
AwsManagedPolicy.AutoScalingConsoleFullAccess = 'AutoScalingConsoleFullAccess';
/** Provides read-only access to Auto Scaling via the AWS Management Console. */
AwsManagedPolicy.AutoScalingConsoleReadOnlyAccess = 'AutoScalingConsoleReadOnlyAccess';
/** Provides full access to Auto Scaling. */
AwsManagedPolicy.AutoScalingFullAccess = 'AutoScalingFullAccess';
/** Default policy for the AutoScaling Notification Access service role. */
AwsManagedPolicy.AutoScalingNotificationAccessRole = 'service-role/AutoScalingNotificationAccessRole';
/** Provides read-only access to Auto Scaling. */
AwsManagedPolicy.AutoScalingReadOnlyAccess = 'AutoScalingReadOnlyAccess';
/** Enables access to AWS Services and Resources used or managed by Auto Scaling */
AwsManagedPolicy.AutoScalingServiceRolePolicy = 'aws-service-role/AutoScalingServiceRolePolicy';
/** Default policy for AWS Config service role. Provides permissions required for AWS Config to track changes to your AWS resources. */
AwsManagedPolicy.AWSConfigRole = 'service-role/AWS_ConfigRole';
/** Provides permissions to access the SSM Diagnosis S3 bucket for diagnosis and remediation of issues. */
AwsManagedPolicy.AWSSSMAutomationDiagnosisBucketPolicy = 'AWS-SSM-Automation-DiagnosisBucketPolicy';
/** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
AwsManagedPolicy.AWSSSMDiagnosisAutomationAdministrationRolePolicy = 'AWS-SSM-DiagnosisAutomation-AdministrationRolePolicy';
/** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by diagnosing SSM service health across all nodes. */
AwsManagedPolicy.AWSSSMDiagnosisAutomationExecutionRolePolicy = 'AWS-SSM-DiagnosisAutomation-ExecutionRolePolicy';
/** Provides permissions for operational accounts to diagnose unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
AwsManagedPolicy.AWSSSMDiagnosisAutomationOperationalAccountAdministrationRolePolicy = 'AWS-SSM-DiagnosisAutomation-OperationalAccountAdministrationRolePolicy';
/** Provide permission for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
AwsManagedPolicy.AWSSSMRemediationAutomationAdministrationRolePolicy = 'AWS-SSM-RemediationAutomation-AdministrationRolePolicy';
/** Provides permissions for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by remediating SSM services health across all nodes. */
AwsManagedPolicy.AWSSSMRemediationAutomationExecutionRolePolicy = 'AWS-SSM-RemediationAutomation-ExecutionRolePolicy';
/** Provides permissions for operational accounts to Remediate unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
AwsManagedPolicy.AWSSSMRemediationAutomationOperationalAccountAdministrationRolePolicy = 'AWS-SSM-RemediationAutomation-OperationalAccountAdministrationRolePolicy';
/** Allows users to access the Account Activity page. */
AwsManagedPolicy.AWSAccountActivityAccess = 'AWSAccountActivityAccess';
/** Provides full access to AWS Account Management. */
AwsManagedPolicy.AWSAccountManagementFullAccess = 'AWSAccountManagementFullAccess';
/** Provides read-only access to AWS Account Management */
AwsManagedPolicy.AWSAccountManagementReadOnlyAccess = 'AWSAccountManagementReadOnlyAccess';
/** Allows users to access the Account Usage Report page. */
AwsManagedPolicy.AWSAccountUsageReportAccess = 'AWSAccountUsageReportAccess';
/** Provides access for the Discovery Agentless Connector to register with AWS Application Discovery Service. */
AwsManagedPolicy.AWSAgentlessDiscoveryService = 'AWSAgentlessDiscoveryService';
/** Provides full access to the AWS AppFabric service and read only access to dependent services such as S3, Kinesis, KMS. */
AwsManagedPolicy.AWSAppFabricFullAccess = 'AWSAppFabricFullAccess';
/** Provides read only access to the AWS AppFabric */
AwsManagedPolicy.AWSAppFabricReadOnlyAccess = 'AWSAppFabricReadOnlyAccess';
/** Provides AppFabric access to AWS resources on your behalf */
AwsManagedPolicy.AWSAppFabricServiceRolePolicy = 'aws-service-role/AWSAppFabricServiceRolePolicy';
/** Policy granting permissions to Application Auto Scaling to access AppStream and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingAppStreamFleetPolicy = 'aws-service-role/AWSApplicationAutoscalingAppStreamFleetPolicy';
/** Policy granting permissions to Application Auto Scaling to access Cassandra and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingCassandraTablePolicy = 'aws-service-role/AWSApplicationAutoscalingCassandraTablePolicy';
/** Policy granting permissions to Application Auto Scaling to access Comprehend and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingComprehendEndpointPolicy = 'aws-service-role/AWSApplicationAutoscalingComprehendEndpointPolicy';
/** Policy granting permissions to Application Auto Scaling to access APIGateway and CloudWatch for custom resource scaling */
AwsManagedPolicy.AWSApplicationAutoScalingCustomResourcePolicy = 'aws-service-role/AWSApplicationAutoScalingCustomResourcePolicy';
/** Policy granting permissions to Application Auto Scaling to access DynamoDB and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingDynamoDBTablePolicy = 'aws-service-role/AWSApplicationAutoscalingDynamoDBTablePolicy';
/** Policy granting permissions to Application Auto Scaling to access EC2 Spot Fleet and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingEC2SpotFleetRequestPolicy = 'aws-service-role/AWSApplicationAutoscalingEC2SpotFleetRequestPolicy';
/** Policy granting permissions to Application Auto Scaling to access EC2 Container Service and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingECSServicePolicy = 'aws-service-role/AWSApplicationAutoscalingECSServicePolicy';
/** Policy granting permissions to Application Auto Scaling to access Amazon ElastiCache and Amazon CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingElastiCacheRGPolicy = 'aws-service-role/AWSApplicationAutoscalingElastiCacheRGPolicy';
/** Policy granting permissions to Application Auto Scaling to access Elastic Map Reduce and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingEMRInstanceGroupPolicy = 'aws-service-role/AWSApplicationAutoscalingEMRInstanceGroupPolicy';
/** Policy granting permissions to Application Auto Scaling to access Managed Streaming for Apache Kafka and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingKafkaClusterPolicy = 'aws-service-role/AWSApplicationAutoscalingKafkaClusterPolicy';
/** Policy granting permissions to Application Auto Scaling to access Lambda and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingLambdaConcurrencyPolicy = 'aws-service-role/AWSApplicationAutoscalingLambdaConcurrencyPolicy';
/** Policy granting permissions to Application Auto Scaling to access Amazon Neptune and Amazon CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingNeptuneClusterPolicy = 'aws-service-role/AWSApplicationAutoscalingNeptuneClusterPolicy';
/** Policy granting permissions to Application Auto Scaling to access RDS and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingRDSClusterPolicy = 'aws-service-role/AWSApplicationAutoscalingRDSClusterPolicy';
/** Policy granting permissions to Application Auto Scaling to access SageMaker and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingSageMakerEndpointPolicy = 'aws-service-role/AWSApplicationAutoscalingSageMakerEndpointPolicy';
/** Policy granting permissions to Application Auto Scaling to access Amazon WorkSpaces and Amazon CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingWorkSpacesPoolPolicy = 'aws-service-role/AWSApplicationAutoscalingWorkSpacesPoolPolicy';
/** Provides access for the Discovery Agent to register with AWS Application Discovery Service. */
AwsManagedPolicy.AWSApplicationDiscoveryAgentAccess = 'AWSApplicationDiscoveryAgentAccess';
/** Allows Application Discovery Service Agentless Collectors to auto update, register, and communicate with Application Discovery Service */
AwsManagedPolicy.AWSApplicationDiscoveryAgentlessCollectorAccess = 'AWSApplicationDiscoveryAgentlessCollectorAccess';
/** Provides full access to view and tag Configuration Items maintained by the AWS Application Discovery Service */
AwsManagedPolicy.AWSApplicationDiscoveryServiceFullAccess = 'AWSApplicationDiscoveryServiceFullAccess';
/** This policy allows installing the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
AwsManagedPolicy.AWSApplicationMigrationAgentInstallationPolicy = 'AWSApplicationMigrationAgentInstallationPolicy';
/** This policy allows installing and using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
AwsManagedPolicy.AWSApplicationMigrationAgentPolicy = 'AWSApplicationMigrationAgentPolicy';
/** This policy allows using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationAgentPolicyV2 = 'service-role/AWSApplicationMigrationAgentPolicy_v2';
/** This policy allows the Application Migration Service (MGN) Conversion Server, which are EC2 instances launched by Application Migration Service, to communicate with the MGN service. An IAM role with this policy is attached (as an EC2 Instance Profile) by MGN to the MGN Conversion Servers, which are automatically launched and terminated by MGN, when needed. We do not recommend that you attach this policy to your IAM users or roles. MGN Conversion Servers are used by Application Migration Service when users choose to launch Test or Cutover instances using the MGN console, CLI, or API. */
AwsManagedPolicy.AWSApplicationMigrationConversionServerPolicy = 'service-role/AWSApplicationMigrationConversionServerPolicy';
/** This policy provides Amazon EC2 operations required to use Application Migration Service (MGN) to launch the migrated servers as EC2 instances. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationEC2Access = 'AWSApplicationMigrationEC2Access';
/** This policy provides permissions to all public APIs of AWS Application Migration Service (MGN), as well as permissions to read KMS key information. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationFullAccess = 'AWSApplicationMigrationFullAccess';
/** This policy allows AWS Application Migration Service (MGN) to send meta-data about the progress of servers being migrated using MGN to AWS Migration Hub (MGH). MGN automatically creates an IAM role with this policy attached, and assumes this role. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationMGHAccess = 'service-role/AWSApplicationMigrationMGHAccess';
/** This policy provides permissions to all read-only public APIs of Application Migration Service (MGN), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the MGN console. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationReadOnlyAccess = 'AWSApplicationMigrationReadOnlyAccess';
/** This policy allows the Application Migration Service (MGN) Replication Servers, which are EC2 instances launched by Application Migration Service - to communicate with the MGN service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Application Migration Service to the MGN Replication Servers which are automatically launched and terminated by MGN, as needed. MGN Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the migration process managed using MGN. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationReplicationServerPolicy = 'service-role/AWSApplicationMigrationReplicationServerPolicy';
/** This policy allows installing and using the AWS Replication Agent, which is used by AWS Application Migration Service (AWS MGN) to migrate source servers that run on EC2 (cross-Region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
AwsManagedPolicy.AWSApplicationMigrationServiceEc2InstancePolicy = 'AWSApplicationMigrationServiceEc2InstancePolicy';
/** Allows AWS application Migration Service to create and manage AWS resources on your behalf. */
AwsManagedPolicy.AWSApplicationMigrationServiceRolePolicy = 'aws-service-role/AWSApplicationMigrationServiceRolePolicy';
/** This policy provides access to Amazon SSM operations required to use Application Migration Service (MGN) to execute custom post migration command SSM documents. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationSSMAccess = 'AWSApplicationMigrationSSMAccess';
/** This policy allows installing and using the AWS VCenter Client, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS VCenter Client. */
AwsManagedPolicy.AWSApplicationMigrationVCenterClientPolicy = 'AWSApplicationMigrationVCenterClientPolicy';
/** App Mesh Envoy policy for accessing Virtual Node configuration. */
AwsManagedPolicy.AWSAppMeshEnvoyAccess = 'AWSAppMeshEnvoyAccess';
/** Provides full access to the AWS App Mesh APIs and Management Console. */
AwsManagedPolicy.AWSAppMeshFullAccess = 'AWSAppMeshFullAccess';
/** App Mesh Preview Envoy policy for accessing Virtual Node configuration. */
AwsManagedPolicy.AWSAppMeshPreviewEnvoyAccess = 'AWSAppMeshPreviewEnvoyAccess';
/** Enables access to AWS Services and Resources used or managed by AWS App Mesh */
AwsManagedPolicy.AWSAppMeshPreviewServiceRolePolicy = 'aws-service-role/AWSAppMeshPreviewServiceRolePolicy';
/** Provides read-only access to the AWS App Mesh APIs and Management Console. */
AwsManagedPolicy.AWSAppMeshReadOnly = 'AWSAppMeshReadOnly';
/** Enables access to AWS Services and Resources used or managed by AWS AppMesh */
AwsManagedPolicy.AWSAppMeshServiceRolePolicy = 'aws-service-role/AWSAppMeshServiceRolePolicy';
/** Grants permissions to all App Runner actions. */
AwsManagedPolicy.AWSAppRunnerFullAccess = 'AWSAppRunnerFullAccess';
/** Grants permissions to list and view details about App Runner resources. */
AwsManagedPolicy.AWSAppRunnerReadOnlyAccess = 'AWSAppRunnerReadOnlyAccess';
/** AWS App Runner service policy that grants read permissions to Amazon ECR resources in the customer's account. Use it in a role that is passed to App Runner when creating or updating an App Runner service. */
AwsManagedPolicy.AWSAppRunnerServicePolicyForECRAccess = 'service-role/AWSAppRunnerServicePolicyForECRAccess';
/** Provides administrative access to the AppSync service, though not enough to access via the console. */
AwsManagedPolicy.AWSAppSyncAdministrator = 'AWSAppSyncAdministrator';
/** Provides full invoking access to the AppSync service - both through the console and independently */
AwsManagedPolicy.AWSAppSyncInvokeFullAccess = 'AWSAppSyncInvokeFullAccess';
/** Allows AppSync to push logs to user's CloudWatch account. */
AwsManagedPolicy.AWSAppSyncPushToCloudWatchLogs = 'service-role/AWSAppSyncPushToCloudWatchLogs';
/** Provides access to create, update, and query the schema. */
AwsManagedPolicy.AWSAppSyncSchemaAuthor = 'AWSAppSyncSchemaAuthor';
/** Enables access to AWS services and resources used or managed by AppSync */
AwsManagedPolicy.AWSAppSyncServiceRolePolicy = 'aws-service-role/AWSAppSyncServiceRolePolicy';
/** Allows AWS Artifact read-only access to operations in AWS Organizations. */
AwsManagedPolicy.AWSArtifactAccountSync = 'service-role/AWSArtifactAccountSync';
/** This policy grants full permissions to list, download, accept, and terminate AWS Artifact agreements. It also includes permissions to list and enable AWS service access in the Organization service, as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists and creates one if it doesn't */
AwsManagedPolicy.AWSArtifactAgreementsFullAccess = 'AWSArtifactAgreementsFullAccess';
/** This policy grants read-only access to list the AWS Artifact service agreements and to download the accepted agreements.. It also includes permissions to list as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists. */
AwsManagedPolicy.AWSArtifactAgreementsReadOnlyAccess = 'AWSArtifactAgreementsReadOnlyAccess';
/** Provides read-only access to the AWS Artifact service reports. */
AwsManagedPolicy.AWSArtifactReportsReadOnlyAccess = 'AWSArtifactReportsReadOnlyAccess';
/** Allows AWS Artifact to gather information about an organization via AWS Organizations service. */
AwsManagedPolicy.AWSArtifactServiceRolePolicy = 'aws-service-role/AWSArtifactServiceRolePolicy';
/** Provides administrative access to enable or disable AWS Audit Manager, update settings, and manage assessments, controls, and frameworks */
AwsManagedPolicy.AWSAuditManagerAdministratorAccess = 'AWSAuditManagerAdministratorAccess';
/** Enables access to AWS Services and Resources used or managed by AWS Audit Manager */
AwsManagedPolicy.AWSAuditManagerServiceRolePolicy = 'aws-service-role/AWSAuditManagerServiceRolePolicy';
/** Policy granting permissions to AWS Auto Scaling to periodically forecast capacity and generate scheduled scaling actions for Auto Scaling groups in a scaling plan */
AwsManagedPolicy.AWSAutoScalingPlansEC2AutoScalingPolicy = 'aws-service-role/AWSAutoScalingPlansEC2AutoScalingPolicy';
/** This policy grants permissions for users to create controls and frameworks that define their expectations for AWS Backup resources and activities, and to audit AWS Backup resources and activities against their defined controls and frameworks. This policy grants permissions to AWS Config and similar services to describe user expectations perform the audits. This policy also grants permissions to deliver audit reports to S3 and similar services, and enables users to find and open their audit reports. */
AwsManagedPolicy.AWSBackupAuditAccess = 'AWSBackupAuditAccess';
/** This policy allows the AWS Backint agent to complete backup data transfer with AWS Backup Storage plane. Attach this policy to roles assumed by EC2 Instances running SAP HANA with the Backint agent. */
AwsManagedPolicy.AWSBackupDataTransferAccess = 'AWSBackupDataTransferAccess';
/** This policy is for backup administrators, granting full access to AWS Backup operations, including creating or editing backup plans, assigning AWS resources to backup plans, deleting backups, and restoring backups. */
AwsManagedPolicy.AWSBackupFullAccess = 'AWSBackupFullAccess';
/** Provides AWS BackupGateway permission to sync the metadata of Virtual Machines on your behalf */
AwsManagedPolicy.AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync = 'service-role/AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync';
/** This policy grants users permissions to assign AWS resources to backup plans, create on-demand backups, and restore backups. This policy does not allow the user to create or edit backup plans or to delete scheduled backups after they are created. */
AwsManagedPolicy.AWSBackupOperatorAccess = 'AWSBackupOperatorAccess';
/** This policy is for backup administators who use cross-account backup management to manage backups for the organization. */
AwsManagedPolicy.AWSBackupOrganizationAdminAccess = 'AWSBackupOrganizationAdminAccess';
/** Provides AWS Backup permission to restore a backup of SAP HANA on Amazon EC2 */
AwsManagedPolicy.AWSBackupRestoreAccessForSAPHANA = 'AWSBackupRestoreAccessForSAPHANA';
/** The search operator role has access to create backup indexes, create searches of backup metadata that has been indexed. This policy contains the necessary permissions for these search operator functions. */
AwsManagedPolicy.AWSBackupSearchOperatorAccess = 'AWSBackupSearchOperatorAccess';
/** Provides AWS Backup permission to create backups on your behalf across AWS services */
AwsManagedPolicy.AWSBackupServiceLinkedRolePolicyForBackup = 'aws-service-role/AWSBackupServiceLinkedRolePolicyForBackup';
/** Provides AWS Backup permission to create backups on your behalf across AWS services */
AwsManagedPolicy.AWSBackupServiceLinkedRolePolicyForBackupTest = 'aws-service-role/AWSBackupServiceLinkedRolePolicyForBackupTest';
/** Provides AWS Backup permission to create backups on your behalf across AWS services */
AwsManagedPolicy.AWSBackupServiceRolePolicyForBackup = 'service-role/AWSBackupServiceRolePolicyForBackup';
/** Policy containing permissions necessary for AWS Backup to index recovery points. */
AwsManagedPolicy.AWSBackupServiceRolePolicyForIndexing = 'AWSBackupServiceRolePolicyForIndexing';
/** Policy containing permissions necessary for AWS Backup to restore individual items in a recovery point */
AwsManagedPolicy.AWSBackupServiceRolePolicyForItemRestores = 'AWSBackupServiceRolePolicyForItemRestores';
/** Provides AWS Backup permission to perform restores on your behalf across AWS services. This policy includes permissions to create and delete AWS resources, such as EBS volumes, RDS instances, and EFS file systems, which are part of the restore process. */
AwsManagedPolicy.AWSBackupServiceRolePolicyForRestores = 'service-role/AWSBackupServiceRolePolicyForRestores';
/** Policy containing permissions necessary for AWS Backup to backup data in any S3 bucket. This includes read access to all S3 objects and any decrypt access for all KMS keys. */
AwsManagedPolicy.AWSBackupServiceRolePolicyForS3Backup = 'AWSBackupServiceRolePolicyForS3Backup';
/** Policy containing permissions necessary for AWS Backup to restore a S3 backup to a bucket. This includes read/write permissions to all S3 buckets, and permissions to GenerateDataKey and DescribeKey for all KMS keys. */
AwsManagedPolicy.AWSBackupServiceRolePolicyForS3Restore = 'AWSBackupServiceRolePolicyForS3Restore';
/** Provides full access for AWS Batch resources. */
AwsManagedPolicy.AWSBatchFullAccess = 'AWSBatchFullAccess';
/** Policy to enable CloudWatch Event Target for AWS Batch Job Submission */
AwsManagedPolicy.AWSBatchServiceEventTargetRole = 'service-role/AWSBatchServiceEventTargetRole';
/** Policy for AWS Batch service role which allows access to related services including EC2, Autoscaling, EC2 Container service and Cloudwatch Logs. */
AwsManagedPolicy.AWSBatchServiceRole = 'service-role/AWSBatchServiceRole';
/** A service linked role to provide Billing and Cost Management Data Exports access to AWS service data for exporting the data to a target location, such as Amazon S3, on behalf of a customer. */
AwsManagedPolicy.AWSBCMDataExportsServiceRolePolicy = 'aws-service-role/AWSBCMDataExportsServiceRolePolicy';
/** Use the AWSBillingConductorFullAccess managed policy to allow complete access to AWS Billing Conductor (ABC) console and APIs. This policy allows users to list, create and delete ABC resources. */
AwsManagedPolicy.AWSBillingConductorFullAccess = 'AWSBillingConductorFullAccess';
/** Use the AWSBillingConductorReadOnlyAccess managed policy to allow read only access to AWS Billing Conductor (ABC) console and APIs. This policy grants permission to view and list all ABC resources. It does not include the ability to create or delete resources. */
AwsManagedPolicy.AWSBillingConductorReadOnlyAccess = 'AWSBillingConductorReadOnlyAccess';
/** Allows users to view bills on the Billing Console. */
AwsManagedPolicy.AWSBillingReadOnlyAccess = 'AWSBillingReadOnlyAccess';
/** This policy gives permissions to control AWS resources. For example, to start and stop EC2 or RDS instances by executing AWS Systems Manager (SSM) scripts. */
AwsManagedPolicy.AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM = 'AWSBudgetsActions_RolePolicyForResourceAdministrationWithSSM';
/** Provides full access to AWS Budgets Actions including using Budgets Actions to control states of running AWS resources via AWS Management Console */
AwsManagedPolicy.AWSBudgetsActionsWithAWSResourceControlAccess = 'AWSBudgetsActionsWithAWSResourceControlAccess';
/** Provides read only access to AWS Budgets Console via the AWS Management Console. */
AwsManagedPolicy.AWSBudgetsReadOnlyAccess = 'AWSBudgetsReadOnlyAccess';
/** This IAM policy grants users full access to the AWS BugBust console */
AwsManagedPolicy.AWSBugBustFullAccess = 'AWSBugBustFullAccess';
/** This IAM policy grants users access to participate in AWS BugBust events */
AwsManagedPolicy.AWSBugBustPlayerAccess = 'AWSBugBustPlayerAccess';
/** Grants permissions to AWS BugBust to access resources on your behalf */
AwsManagedPolicy.AWSBugBustServiceRolePolicy = 'aws-service-role/AWSBugBustServiceRolePolicy';
/** Provides full access to AWS Certificate Manager (ACM) */
AwsManagedPolicy.AWSCertificateManagerFullAccess = 'AWSCertificateManagerFullAccess';
/** Provides auditor access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAAuditor = 'AWSCertificateManagerPrivateCAAuditor';
/** Provides full access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAFullAccess = 'AWSCertificateManagerPrivateCAFullAccess';
/** Provides privileged certificate user access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAPrivilegedUser = 'AWSCertificateManagerPrivateCAPrivilegedUser';
/** Provides read only access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAReadOnly = 'AWSCertificateManagerPrivateCAReadOnly';
/** Provides certificate user access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAUser = 'AWSCertificateManagerPrivateCAUser';
/** Provides read only access to AWS Certificate Manager (ACM). */
AwsManagedPolicy.AWSCertificateManagerReadOnly = 'AWSCertificateManagerReadOnly';
/** The Service Linked Role used by AWS Chatbot. */
AwsManagedPolicy.AWSChatbotServiceLinkedRolePolicy = 'aws-service-role/AWSChatbotServiceLinkedRolePolicy';
/** Allows full access to AWS Clean Rooms resources and access to related AWS Services. */
AwsManagedPolicy.AWSCleanRoomsFullAccess = 'AWSCleanRoomsFullAccess';
/** Allows full access to AWS Clean Rooms resources except for querying in a collaboration and access to related AWS Services. */
AwsManagedPolicy.AWSCleanRoomsFullAccessNoQuerying = 'AWSCleanRoomsFullAccessNoQuerying';
/** Allows full access to AWS Clean Rooms ML resources and access to related AWS Services. */
AwsManagedPolicy.AWSCleanRoomsMLFullAccess = 'AWSCleanRoomsMLFullAccess';
/** Allows read-only access to AWS Clean Rooms ML resources and read-only access to related AWS Clean Rooms resources */
AwsManagedPolicy.AWSCleanRoomsMLReadOnlyAccess = 'AWSCleanRoomsMLReadOnlyAccess';
/** Allows read-only access to AWS Clean Rooms resources and read-only access to related AWS Glue and Amazon CloudWatch Logs resources. */
AwsManagedPolicy.AWSCleanRoomsReadOnlyAccess = 'AWSCleanRoomsReadOnlyAccess';
/** Provides administrator access to AWS Cloud9. */
AwsManagedPolicy.AWSCloud9Administrator = 'AWSCloud9Administrator';
/** Provides the ability to be invited into AWS Cloud9 shared development environments. */
AwsManagedPolicy.AWSCloud9EnvironmentMember = 'AWSCloud9EnvironmentMember';
/** Service Linked Role Policy for AWS Cloud9 */
AwsManagedPolicy.AWSCloud9ServiceRolePolicy = 'aws-service-role/AWSCloud9ServiceRolePolicy';
/** This policy will be used to attach a role on a InstanceProfile which will allow Cloud9 to use the SSM Session Manager to connect to the instance */
AwsManagedPolicy.AWSCloud9SSMInstanceProfile = 'AWSCloud9SSMInstanceProfile';
/** Provides permission to create AWS Cloud9 development environments and to manage owned environments. */
AwsManagedPolicy.AWSCloud9User = 'AWSCloud9User';
/** Provides full access to AWS CloudFormation. */
AwsManagedPolicy.AWSCloudFormationFullAccess = 'AWSCloudFormationFullAccess';
/** Provides access to AWS CloudFormation via the AWS Management Console. */
AwsManagedPolicy.AWSCloudFormationReadOnlyAccess = 'AWSCloudFormationReadOnlyAccess';
/** Grants CloudFront Logger write permissions to CloudWatch Logs. */
AwsManagedPolicy.AWSCloudFrontLogger = 'aws-service-role/AWSCloudFrontLogger';
/** Allows CloudFront to manage EC2 Elastic Network Interfaces and Security Groups on your behalf. */
AwsManagedPolicy.AWSCloudFrontVPCOriginServiceRolePolicy = 'aws-service-role/AWSCloudFrontVPCOriginServiceRolePolicy';
/** Provides full access to all CloudHSM resources. */
AwsManagedPolicy.AWSCloudHSMFullAccess = 'AWSCloudHSMFullAccess';
/** Provides read only access to all CloudHSM resources. */
AwsManagedPolicy.AWSCloudHSMReadOnlyAccess = 'AWSCloudHSMReadOnlyAccess';
/** Default policy for the AWS CloudHSM service role. */
AwsManagedPolicy.AWSCloudHSMRole = 'service-role/AWSCloudHSMRole';
/** Provides access to AWS Cloud Map discovery API. */
AwsManagedPolicy.AWSCloudMapDiscoverInstanceAccess = 'AWSCloudMapDiscoverInstanceAccess';
/** Provides full access to all AWS Cloud Map actions. */
AwsManagedPolicy.AWSCloudMapFullAccess = 'AWSCloudMapFullAccess';
/** Provides read-only access to all AWS Cloud Map actions. */
AwsManagedPolicy.AWSCloudMapReadOnlyAccess = 'AWSCloudMapReadOnlyAccess';
/** Provides registrant level access to AWS Cloud Map actions. */
AwsManagedPolicy.AWSCloudMapRegisterInstanceAccess = 'AWSCloudMapRegisterInstanceAccess';
/** Grants using AWS CloudShell with all features */
AwsManagedPolicy.AWSCloudShellFullAccess = 'AWSCloudShellFullAccess';
/** Provides full access to AWS CloudTrail. */
AwsManagedPolicy.AWSCloudTrailFullAccess = 'AWSCloudTrail_FullAccess';
/** Provides read only access to AWS CloudTrail. */
AwsManagedPolicy.AWSCloudTrailReadOnlyAccess = 'AWSCloudTrail_ReadOnlyAccess';
/** This policy is used by the service-linked role named AWSServiceRoleForCloudWatchAlarms_ActionSSMIncidents. CloudWatch uses this service-linked role to perform AWS System Manager Incident Manager actions when a CloudWatch alarm goes in to ALARM state. This policy grants permission to start incidents on your behalf. */
AwsManagedPolicy.AWSCloudWatchAlarmsActionSSMIncidentsServiceRolePolicy = 'aws-service-role/AWSCloudWatchAlarms_ActionSSMIncidentsServiceRolePolicy';
/** Provides full access to AWS CodeArtifact via the AWS Management Console. */
AwsManagedPolicy.AWSCodeArtifactAdminAccess = 'AWSCodeArtifactAdminAccess';
/** Provides read only access to AWS CodeArtifact via the AWS Management Console. */
AwsManagedPolicy.AWSCodeArtifactReadOnlyAccess = 'AWSCodeArtifactReadOnlyAccess';
/** Provides full access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts, and attach IAMFullAccess to create and manage the service role for CodeBuild. */
AwsManagedPolicy.AWSCodeBuildAdminAccess = 'AWSCodeBuildAdminAccess';
/** Provides access to AWS CodeBuild via the AWS Management Console, but does not allow CodeBuild project administration. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
AwsManagedPolicy.AWSCodeBuildDeveloperAccess = 'AWSCodeBuildDeveloperAccess';
/** Provides read only access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
AwsManagedPolicy.AWSCodeBuildReadOnlyAccess = 'AWSCodeBuildReadOnlyAccess';
/** Provides full access to AWS CodeCommit via the AWS Management Console. */
AwsManagedPolicy.AWSCodeCommitFullAccess = 'AWSCodeCommitFullAccess';
/** Provides full access to AWS CodeCommit repositories, but does not allow repository deletion. */
AwsManagedPolicy.AWSCodeCommitPowerUser = 'AWSCodeCommitPowerUser';
/** Provides read only access to AWS CodeCommit via the AWS Management Console. */
AwsManagedPolicy.AWSCodeCommitReadOnly = 'AWSCodeCommitReadOnly';
/** Provides access to register and deploy a revision. */
AwsManagedPolicy.AWSCodeDeployDeployerAccess = 'AWSCodeDeployDeployerAccess';
/** Provides full access to CodeDeploy resources. */
AwsManagedPolicy.AWSCodeDeployFullAccess = 'AWSCodeDeployFullAccess';
/** Provides read only access to CodeDeploy resources. */
AwsManagedPolicy.AWSCodeDeployReadOnlyAccess = 'AWSCodeDeployReadOnlyAccess';
/** Provides CodeDeploy service access to expand tags and interact with Auto Scaling on your behalf. */
AwsManagedPolicy.AWSCodeDeployRole = 'service-role/AWSCodeDeployRole';
/** Provides CodeDeploy service access to invoke Lambda function on your behalf to perform blue/green deployment through CloudFormation. */
AwsManagedPolicy.AWSCodeDeployRoleForCloudFormation = 'service-role/AWSCodeDeployRoleForCloudFormation';
/** Provides CodeDeploy service wide access to perform an ECS blue/green deployment on your behalf. Grants full access to support services, such as  full access to read all S3 objects, invoke all Lambda functions, publish to all SNS topics within the account and update all ECS services. */
AwsManagedPolicy.AWSCodeDeployRoleForECS = 'AWSCodeDeployRoleForECS';
/**  Provides CodeDeploy service limited access to perform an ECS blue/green deployment on your behalf. */
AwsManagedPolicy.AWSCodeDeployRoleForECSLimited = 'AWSCodeDeployRoleForECSLimited';
/** Provides CodeDeploy service access to perform a Lambda deployment on your behalf. */
AwsManagedPolicy.AWSCodeDeployRoleForLambda = 'service-role/AWSCodeDeployRoleForLambda';
/** Provides CodeDeploy service limited access to perform a Lambda deployment on your behalf. */
AwsManagedPolicy.AWSCodeDeployRoleForLambdaLimited = 'service-role/AWSCodeDeployRoleForLambdaLimited';
/** Provides full access to AWS CodePipeline via the AWS Management Console. */
AwsManagedPolicy.AWSCodePipelineFullAccess = 'AWSCodePipeline_FullAccess';
/** Provides read only access to AWS CodePipeline via the AWS Management Console. */
AwsManagedPolicy.AWSCodePipelineReadOnlyAccess = 'AWSCodePipeline_ReadOnlyAccess';
/** Provides access to view and approve manual changes for all pipelines */
AwsManagedPolicy.AWSCodePipelineApproverAccess = 'AWSCodePipelineApproverAccess';
/** Provides access for custom actions to poll for jobs details (including temporary credentials) and report status updates to AWS CodePipeline. */
AwsManagedPolicy.AWSCodePipelineCustomActionAccess = 'AWSCodePipelineCustomActionAccess';
/** Provides full access to AWS CodeStar via the AWS Management Console. */
AwsManagedPolicy.AWSCodeStarFullAccess = 'AWSCodeStarFullAccess';
/** Allows AWS CodeStar Notifications to access Amazon CloudWatch Events on your behalf */
AwsManagedPolicy.AWSCodeStarNotificationsServiceRolePolicy = 'aws-service-role/AWSCodeStarNotificationsServiceRolePolicy';
/** DO NOT USE -  AWS CodeStar Service Role Policy which grants administrative privileges in order for CodeStar to manage IAM and other service resources on behalf of the customer. */
AwsManagedPolicy.AWSCodeStarServiceRole = 'service-role/AWSCodeStarServiceRole';
/** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly.  Do NOT remove this policy.  Instead, please follow the instructions specified in the email sent to you regarding this event. */
AwsManagedPolicy.AWSCompromisedKeyQuarantine = 'AWSCompromisedKeyQuarantine';
/** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
AwsManagedPolicy.AWSCompromisedKeyQuarantineV2 = 'AWSCompromisedKeyQuarantineV2';
/** Denies access to certain actions, applied by AWS in the event that an IAM user's credentials have been compromised or exposed publicly. The policy aims to limit the potential damage that may be caused by fraud-related activity leading to unauthorized charges, while not impacting the existing resources. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
AwsManagedPolicy.AWSCompromisedKeyQuarantineV3 = 'AWSCompromisedKeyQuarantineV3';
/** Allows Config to call AWS services and deploy config resources across organization */
AwsManagedPolicy.AWSConfigMultiAccountSetupPolicy = 'aws-service-role/AWSConfigMultiAccountSetupPolicy';
/** Allows AWS Config to remediate noncompliant resources on your behalf. */
AwsManagedPolicy.AWSConfigRemediationServiceRolePolicy = 'aws-service-role/AWSConfigRemediationServiceRolePolicy';
/** Allows AWS Config to call read-only AWS Organizations APIs */
AwsManagedPolicy.AWSConfigRoleForOrganizations = 'service-role/AWSConfigRoleForOrganizations';
/** Allows an AWS Lambda function to access the AWS Config API and the configuration snapshots that AWS Config delivers periodically to Amazon S3. This access is required by functions that evaluate configuration changes for custom Config rules. */
AwsManagedPolicy.AWSConfigRulesExecutionRole = 'service-role/AWSConfigRulesExecutionRole';
/** Allows Config to call AWS services and collect resource configurations on your behalf. */
AwsManagedPolicy.AWSConfigServiceRolePolicy = 'aws-service-role/AWSConfigServiceRolePolicy';
/** Provides access to use AWS Config, including searching by tags on resources, and reading all tags. This does not provide permission to configure AWS Config, which requires administrative privileges. */
AwsManagedPolicy.AWSConfigUserAccess = 'AWSConfigUserAccess';
/** Enables broad read/write access to ALL EC2 objects, read/write access to S3 buckets starting with 'import-to-ec2-', and the ability to list all S3 buckets, for the AWS Connector to import VMs on your behalf. */
AwsManagedPolicy.AWSConnector = 'AWSConnector';
/** Allows AWS Control Tower to call AWS services that provide automated account configuration and centralized governance on your behalf. */
AwsManagedPolicy.AWSControlTowerAccountServiceRolePolicy = 'aws-service-role/AWSControlTowerAccountServiceRolePolicy';
/** Provides access to AWS Resources managed or used by AWS Control Tower */
AwsManagedPolicy.AWSControlTowerServiceRolePolicy = 'service-role/AWSControlTowerServiceRolePolicy';
/** Grants permissions to to describe the organization of the account, create S3 buckets for the MAP program and apply tags to it, create a Cost and Usage Report, and describe Cost and Usage Report definitions. */
AwsManagedPolicy.AWSCostAndUsageReportAutomationPolicy = 'service-role/AWSCostAndUsageReportAutomationPolicy';
/** Gives Data Grant owners access to AWS Data Exchange actions using the AWS Management Console and SDK. */
AwsManagedPolicy.AWSDataExchangeDataGrantOwnerFullAccess = 'AWSDataExchangeDataGrantOwnerFullAccess';
/** Gives Data Grant receiver access to AWS Data Exchange actions using the AWS Management Console and SDK. */
AwsManagedPolicy.AWSDataExchangeDataGrantReceiverFullAccess = 'AWSDataExchangeDataGrantReceiverFullAccess';
/** Grants full access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
AwsManagedPolicy.AWSDataExchangeFullAccess = 'AWSDataExchangeFullAccess';
/** Grants data provider access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
AwsManagedPolicy.AWSDataExchangeProviderFullAccess = 'AWSDataExchangeProviderFullAccess';
/** Grants read-only access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. */
AwsManagedPolicy.AWSDataExchangeReadOnly = 'AWSDataExchangeReadOnly';
/** Allows AWS Data Exchange to access AWS Services and Resources used or managed by AWS Data Exchange for license management. */
AwsManagedPolicy.AWSDataExchangeServiceRolePolicyForLicenseManagement = 'aws-service-role/AWSDataExchangeServiceRolePolicyForLicenseManagement';
/** Allows AWS Data Exchange to read data about your AWS Organization to determine eligibility for AWS Data Exchange data grants license distribution. */
AwsManagedPolicy.AWSDataExchangeServiceRolePolicyForOrganizationDiscovery = 'aws-service-role/AWSDataExchangeServiceRolePolicyForOrganizationDiscovery';
/** Grants data subscriber access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
AwsManagedPolicy.AWSDataExchangeSubscriberFullAccess = 'AWSDataExchangeSubscriberFullAccess';
/** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources */
AwsManagedPolicy.AWSDataLifecycleManagerServiceRole = 'service-role/AWSDataLifecycleManagerServiceRole';
/** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources for AMI Management */
AwsManagedPolicy.AWSDataLifecycleManagerServiceRoleForAMIManagement = 'service-role/AWSDataLifecycleManagerServiceRoleForAMIManagement';
/** Provides Amazon Data Lifecycle Manager permission to perform the Systems Manager actions required to run pre and post scripts on all Amazon EC2 instances. */
AwsManagedPolicy.AWSDataLifecycleManagerSSMFullAccess = 'service-role/AWSDataLifecycleManagerSSMFullAccess';
/** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
AwsManagedPolicy.AWSDataPipelineFullAccess = 'AWSDataPipeline_FullAccess';
/** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
AwsManagedPolicy.AWSDataPipelinePowerUser = 'AWSDataPipeline_PowerUser';
/** Allows DataSync Discovery to integrate with other AWS services on your behalf. */
AwsManagedPolicy.AWSDataSyncDiscoveryServiceRolePolicy = 'aws-service-role/AWSDataSyncDiscoveryServiceRolePolicy';
/** Provides full access to AWS DataSync and minimal access to its dependencies */
AwsManagedPolicy.AWSDataSyncFullAccess = 'AWSDataSyncFullAccess';
/** Provides read-only access to AWS DataSync */
AwsManagedPolicy.AWSDataSyncReadOnlyAccess = 'AWSDataSyncReadOnlyAccess';
/** Allows DataSync to integrate with other AWS services on your behalf */
AwsManagedPolicy.AWSDataSyncServiceRolePolicy = 'aws-service-role/AWSDataSyncServiceRolePolicy';
/** Provides AWS Deadline Cloud workers with access to run tasks on a farm. */
AwsManagedPolicy.AWSDeadlineCloudFleetWorker = 'AWSDeadlineCloud-FleetWorker';
/** Provides user workstation access to AWS Deadline Cloud farms with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
AwsManagedPolicy.AWSDeadlineCloudUserAccessFarms = 'AWSDeadlineCloud-UserAccessFarms';
/** Provides user workstation access to AWS Deadline Cloud fleets with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
AwsManagedPolicy.AWSDeadlineCloudUserAccessFleets = 'AWSDeadlineCloud-UserAccessFleets';
/** Provides user workstation access to AWS Deadline Cloud jobs with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
AwsManagedPolicy.AWSDeadlineCloudUserAccessJobs = 'AWSDeadlineCloud-UserAccessJobs';
/** Provides user workstation access to AWS Deadline Cloud queues with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
AwsManagedPolicy.AWSDeadlineCloudUserAccessQueues = 'AWSDeadlineCloud-UserAccessQueues';
/** Provides access for AWS Deadline Cloud worker hosts to join a fleet in a farm. */
AwsManagedPolicy.AWSDeadlineCloudWorkerHost = 'AWSDeadlineCloud-WorkerHost';
/** This policy specifies permissions required by DeepLens Administrative lambda functions that run on a DeepLens device */
AwsManagedPolicy.AWSDeepLensLambdaFunctionAccessPolicy = 'AWSDeepLensLambdaFunctionAccessPolicy';
/** Grants AWS DeepLens access to AWS Services, resources and roles needed by DeepLens and its dependencies including IoT, S3, GreenGrass and AWS Lambda. */
AwsManagedPolicy.AWSDeepLensServiceRolePolicy = 'service-role/AWSDeepLensServiceRolePolicy';
/** DeepRacer admin access to all actions including toggling between multiuser and single user mode. */
AwsManagedPolicy.AWSDeepRacerAccountAdminAccess = 'AWSDeepRacerAccountAdminAccess';
/** Allows CloudFormation to create and manage AWS stacks and resources on your behalf. */
AwsManagedPolicy.AWSDeepRacerCloudFormationAccessPolicy = 'AWSDeepRacerCloudFormationAccessPolicy';
/** DeepRacer MultiUser Default user access to use deepracer in multi-user mode */
AwsManagedPolicy.AWSDeepRacerDefaultMultiUserAccess = 'AWSDeepRacerDefaultMultiUserAccess';
/** Provides full access to AWS DeepRacer. Also provides select access to related services (e.g., S3). */
AwsManagedPolicy.AWSDeepRacerFullAccess = 'AWSDeepRacerFullAccess';
/** Allows RoboMaker to create required resources and call AWS services on your behalf. */
AwsManagedPolicy.AWSDeepRacerRoboMakerAccessPolicy = 'AWSDeepRacerRoboMakerAccessPolicy';
/** Allows DeepRacer to create required resources and call AWS services on your behalf. */
AwsManagedPolicy.AWSDeepRacerServiceRolePolicy = 'service-role/AWSDeepRacerServiceRolePolicy';
/** Deny all access. */
AwsManagedPolicy.AWSDenyAll = 'AWSDenyAll';
/** Provides full access to all AWS Device Farm operations. */
AwsManagedPolicy.AWSDeviceFarmFullAccess = 'AWSDeviceFarmFullAccess';
/** Grant permissions to AWS Device Farm to call EC2 Network APIs on your behalf. */
AwsManagedPolicy.AWSDeviceFarmServiceRolePolicy = 'aws-service-role/AWSDeviceFarmServiceRolePolicy';
/** Grant permissions to AWS Device Farm to call EC2 APIs on your behalf. */
AwsManagedPolicy.AWSDeviceFarmTestGridServiceRolePolicy = 'aws-service-role/AWSDeviceFarmTestGridServiceRolePolicy';
/** Provides full access to AWS Direct Connect via the AWS Management Console. */
AwsManagedPolicy.AWSDirectConnectFullAccess = 'AWSDirectConnectFullAccess';
/** Provides read only access to AWS Direct Connect via the AWS Management Console. */
AwsManagedPolicy.AWSDirectConnectReadOnlyAccess = 'AWSDirectConnectReadOnlyAccess';
/** Provides AWS Direct Connect permission to create and manage AWS resources on your behalf. */
AwsManagedPolicy.AWSDirectConnectServiceRolePolicy = 'aws-service-role/AWSDirectConnectServiceRolePolicy';
/** Provides full access to AWS Directory Service Data. */
AwsManagedPolicy.AWSDirectoryServiceDataFullAccess = 'AWSDirectoryServiceDataFullAccess';
/** Provides read-only access to AWS Directory Service Data */
AwsManagedPolicy.AWSDirectoryServiceDataReadOnlyAccess = 'AWSDirectoryServiceDataReadOnlyAccess';
/** Provides full access to AWS Directory Service. */
AwsManagedPolicy.AWSDirectoryServiceFullAccess = 'AWSDirectoryServiceFullAccess';
/** Provides read only access to AWS Directory Service. */
AwsManagedPolicy.AWSDirectoryServiceReadOnlyAccess = 'AWSDirectoryServiceReadOnlyAccess';
/** Provides write access to AWS resources required for AWS Discovery Continuous Export */
AwsManagedPolicy.AWSDiscoveryContinuousExportFirehosePolicy = 'AWSDiscoveryContinuousExportFirehosePolicy';
/** Allows DMS Fleet Advisor to manage CloudWatch metrics on your behalf. */
AwsManagedPolicy.AWSDMSFleetAdvisorServiceRolePolicy = 'aws-service-role/AWSDMSFleetAdvisorServiceRolePolicy';
/** Grants AWS DMS Serverless permissions to create and manage DMS resources in your account on your behalf */
AwsManagedPolicy.AWSDMSServerlessServiceRolePolicy = 'aws-service-role/AWSDMSServerlessServiceRolePolicy';
/** Allows EC2 CapacityReservation Fleet service to manage Capacity Reservations */
AwsManagedPolicy.AWSEC2CapacityReservationFleetRolePolicy = 'aws-service-role/AWSEC2CapacityReservationFleetRolePolicy';
/** Allows EC2 Fleet to launch and manage instances. */
AwsManagedPolicy.AWSEC2FleetServiceRolePolicy = 'aws-service-role/AWSEC2FleetServiceRolePolicy';
/** Allows EC2 Spot Fleet to launch and manage spot fleet instances */
AwsManagedPolicy.AWSEC2SpotFleetServiceRolePolicy = 'aws-service-role/AWSEC2SpotFleetServiceRolePolicy';
/** Allows EC2 Spot to launch and manage spot instances */
AwsManagedPolicy.AWSEC2SpotServiceRolePolicy = 'aws-service-role/AWSEC2SpotServiceRolePolicy';
/** This policy is attached to the IAM role that's attached to your Amazon EC2 Windows Instances to enable the Amazon EC2 VSS solution to create and add tags to Amazon Machine Images (AMI) and EBS Snapshots. */
AwsManagedPolicy.AWSEC2VssSnapshotPolicy = 'AWSEC2VssSnapshotPolicy';
/** Enables access to AWS services and resources used or managed by AWS ECR pull through cache */
AwsManagedPolicy.AWSECRPullThroughCacheServiceRolePolicy = 'aws-service-role/AWSECRPullThroughCache_ServiceRolePolicy';
/** Provide the instance in your custom platform builder environment permission to launch EC2 instance, create EBS snapshot and AMI, stream logs to Amazon CloudWatch Logs, and store artifacts in Amazon S3. */
AwsManagedPolicy.AWSElasticBeanstalkCustomPlatformforEC2Role = 'AWSElasticBeanstalkCustomPlatformforEC2Role';
/** AWS Elastic Beanstalk Service policy for Health Monitoring system */
AwsManagedPolicy.AWSElasticBeanstalkEnhancedHealth = 'service-role/AWSElasticBeanstalkEnhancedHealth';
/** AWS Elastic Beanstalk Service Role policy that grants limited permissions to update your resources on your behalf for maintenance purposes. */
AwsManagedPolicy.AWSElasticBeanstalkMaintenance = 'aws-service-role/AWSElasticBeanstalkMaintenance';
/** This policy is for the AWS Elastic Beanstalk service role used to perform managed updates of Elastic Beanstalk environments. This policy should not be attached to other users or roles. The policy grants broad permissions to create and manage resources across a number of AWS services including AutoScaling, EC2, ECS, Elastic Load Balancing and CloudFormation.  This policy also allows passing of any IAM role usable with those services. */
AwsManagedPolicy.AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy = 'AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy';
/** AWS Elastic Beanstalk Service Role policy that grants limited permissions to managed updates. */
AwsManagedPolicy.AWSElasticBeanstalkManagedUpdatesServiceRolePolicy = 'aws-service-role/AWSElasticBeanstalkManagedUpdatesServiceRolePolicy';
/** Provide the instances in your multicontainer Docker environment access to use the Amazon EC2 Container Service to manage container deployment tasks. */
AwsManagedPolicy.AWSElasticBeanstalkMulticontainerDocker = 'AWSElasticBeanstalkMulticontainerDocker';
/** Grants read-only permissions. Explicitly allows operators to gain direct access to retrieve information about resources related to AWS Elastic Beanstalk applications. */
AwsManagedPolicy.AWSElasticBeanstalkReadOnly = 'AWSElasticBeanstalkReadOnly';
/** AWSElasticBeanstalkRoleCore (Elastic Beanstalk operations role) Allows core operation of a web service environment. */
AwsManagedPolicy.AWSElasticBeanstalkRoleCore = 'service-role/AWSElasticBeanstalkRoleCore';
/** (Elastic Beanstalk operations role) Allows an environment to manage Amazon CloudWatch Logs log groups. */
AwsManagedPolicy.AWSElasticBeanstalkRoleCWL = 'service-role/AWSElasticBeanstalkRoleCWL';
/** (Elastic Beanstalk operations role) Allows a multicontainer Docker environment to manage Amazon ECS clusters. */
AwsManagedPolicy.AWSElasticBeanstalkRoleECS = 'service-role/AWSElasticBeanstalkRoleECS';
/** (Elastic Beanstalk operations role) Allows an environment to integrate an Amazon RDS instance. */
AwsManagedPolicy.AWSElasticBeanstalkRoleRDS = 'service-role/AWSElasticBeanstalkRoleRDS';
/** (Elastic Beanstalk operations role) Allows an environment to enable Amazon SNS topic integration. */
AwsManagedPolicy.AWSElasticBeanstalkRoleSNS = 'service-role/AWSElasticBeanstalkRoleSNS';
/** (Elastic Beanstalk operations role) Allows a worker environment tier to create an Amazon DynamoDB table and an Amazon SQS queue. */
AwsManagedPolicy.AWSElasticBeanstalkRoleWorkerTier = 'service-role/AWSElasticBeanstalkRoleWorkerTier';
/** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-servicerole.html. AWS Elastic Beanstalk Service role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
AwsManagedPolicy.AWSElasticBeanstalkService = 'service-role/AWSElasticBeanstalkService';
/** AWS Elastic Beanstalk Service Linked Role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
AwsManagedPolicy.AWSElasticBeanstalkServiceRolePolicy = 'aws-service-role/AWSElasticBeanstalkServiceRolePolicy';
/** Provide the instances in your web server environment access to upload log files to Amazon S3. */
AwsManagedPolicy.AWSElasticBeanstalkWebTier = 'AWSElasticBeanstalkWebTier';
/** Provide the instances in your worker environment access to upload log files to Amazon S3, to use Amazon SQS to monitor your application's job queue, to use Amazon DynamoDB to perform leader election, and to Amazon CloudWatch to publish metrics for health monitoring. */
AwsManagedPolicy.AWSElasticBeanstalkWorkerTier = 'AWSElasticBeanstalkWorkerTier';
/** This policy allows installing the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide during the installation step of the AWS Replication Agent. */
AwsManagedPolicy.AWSElasticDisasterRecoveryAgentInstallationPolicy = 'AWSElasticDisasterRecoveryAgentInstallationPolicy';
/** This policy allows using the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover source servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryAgentPolicy = 'service-role/AWSElasticDisasterRecoveryAgentPolicy';
/** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (DRS), as well as permissions to read KMS key, License Manager, Resource Groups, Elastic Load Balancing, IAM, and EC2 information. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryConsoleFullAccess = 'AWSElasticDisasterRecoveryConsoleFullAccess';
/** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (AWS DRS), as well as all public APIs in other AWS services used by AWS DRS Console. Attach this policy to your users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryConsoleFullAccessV2 = 'AWSElasticDisasterRecoveryConsoleFullAccess_v2';
/** This policy is attached to the AWS Elastic Disaster Recovery Conversion server's instance role. This policy allows Elastic Disaster Recovery (DRS) Conversion Servers, which are EC2 instances launched by Elastic Disaster Recovery, to communicate with the DRS service. An IAM role with this policy is attached (as an EC2 Instance Profile) by DRS to the DRS Conversion Servers, which are automatically launched and terminated by DRS, when needed. We do not recommend that you attach this policy to your IAM users or roles. DRS Conversion Servers are used by Elastic Disaster Recovery when users choose to recover source servers using the DRS console, CLI, or API. */
AwsManagedPolicy.AWSElasticDisasterRecoveryConversionServerPolicy = 'service-role/AWSElasticDisasterRecoveryConversionServerPolicy';
/** This policy allows AWS Elastic Disaster Recovery (DRS) to support cross-account replication and cross-account failback. */
AwsManagedPolicy.AWSElasticDisasterRecoveryCrossAccountReplicationPolicy = 'service-role/AWSElasticDisasterRecoveryCrossAccountReplicationPolicy';
/** This policy allows installing and using the AWS Replication Agent, which is used by AWS Elastic Disaster Recovery (DRS) to recover source servers that run on EC2 (cross-region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
AwsManagedPolicy.AWSElasticDisasterRecoveryEc2InstancePolicy = 'service-role/AWSElasticDisasterRecoveryEc2InstancePolicy';
/** You can attach the AWSElasticDisasterRecoveryFailbackInstallationPolicy policy to your IAM identities.  This policy allows installing the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. Attach this policy to your IAM users or roles whose credentials you provide when running the Elastic Disaster Recovery Failback Client. */
AwsManagedPolicy.AWSElasticDisasterRecoveryFailbackInstallationPolicy = 'AWSElasticDisasterRecoveryFailbackInstallationPolicy';
/** This policy allows using the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryFailbackPolicy = 'service-role/AWSElasticDisasterRecoveryFailbackPolicy';
/** This policy allows you to use Amazon SSM and additional services required permissions to run post-launch actions in AWS Elastic Disaster Recovery (AWS DRS). Attach this policy to your IAM roles or users. */
AwsManagedPolicy.AWSElasticDisasterRecoveryLaunchActionsPolicy = 'AWSElasticDisasterRecoveryLaunchActionsPolicy';
/** This policy allows AWS Elastic Disaster Recovery (DRS) to support network replication. */
AwsManagedPolicy.AWSElasticDisasterRecoveryNetworkReplicationPolicy = 'service-role/AWSElasticDisasterRecoveryNetworkReplicationPolicy';
/** You can attach the AWSElasticDisasterRecoveryReadOnlyAccess policy to your IAM identities.  This policy provides permissions to all read-only public APIs of Elastic Disaster Recovery (DRS), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the DRS console. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryReadOnlyAccess = 'AWSElasticDisasterRecoveryReadOnlyAccess';
/** This policy is attached to the instance role of Elastic Disaster Recovery's Recovery Instance.  This policy allows the Elastic Disaster Recovery (DRS) Recovery Instance, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to be able to failback to their original source infrastructure. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Recovery Instances. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryRecoveryInstancePolicy = 'service-role/AWSElasticDisasterRecoveryRecoveryInstancePolicy';
/** This policy is attached to the Elastic Disaster Recovery Replication server's instance role. This policy allows the Elastic Disaster Recovery (DRS) Replication Servers, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Replication Servers which are automatically launched and terminated by DRS, as needed. DRS Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the recovery process managed by DRS. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryReplicationServerPolicy = 'service-role/AWSElasticDisasterRecoveryReplicationServerPolicy';
/** This policy allows Elastic Disaster Recovery to manage AWS resources on your behalf. */
AwsManagedPolicy.AWSElasticDisasterRecoveryServiceRolePolicy = 'aws-service-role/AWSElasticDisasterRecoveryServiceRolePolicy';
/** This policy allows read-only access to AWS Elastic Disaster Recovery (DRS) resources such as source servers and jobs. It also allows creating a converted snapshot and sharing that EBS snapshot with a specific account. */
AwsManagedPolicy.AWSElasticDisasterRecoveryStagingAccountPolicy = 'service-role/AWSElasticDisasterRecoveryStagingAccountPolicy';
/** This policy is used by AWS Elastic Disaster Recovery (DRS) to recover source servers into a separate target account and to allow failing back. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryStagingAccountPolicyV2 = 'service-role/AWSElasticDisasterRecoveryStagingAccountPolicy_v2';
/** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane - Classic */
AwsManagedPolicy.AWSElasticLoadBalancingClassicServiceRolePolicy = 'aws-service-role/AWSElasticLoadBalancingClassicServiceRolePolicy';
/** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane */
AwsManagedPolicy.AWSElasticLoadBalancingServiceRolePolicy = 'aws-service-role/AWSElasticLoadBalancingServiceRolePolicy';
/** Provides full access to AWS Elemental MediaConnect resources. */
AwsManagedPolicy.AWSElementalMediaConnectFullAccess = 'AWSElementalMediaConnectFullAccess';
/** Provides read-only access to AWS Elemental MediaConnect resources. */
AwsManagedPolicy.AWSElementalMediaConnectReadOnlyAccess = 'AWSElementalMediaConnectReadOnlyAccess';
/** Provides full access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
AwsManagedPolicy.AWSElementalMediaConvertFullAccess = 'AWSElementalMediaConvertFullAccess';
/** Provides read only access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
AwsManagedPolicy.AWSElementalMediaConvertReadOnly = 'AWSElementalMediaConvertReadOnly';
/** Provides full access to AWS Elemental MediaLive resources */
AwsManagedPolicy.AWSElementalMediaLiveFullAccess = 'AWSElementalMediaLiveFullAccess';
/** Provides read only access to AWS Elemental MediaLive resources */
AwsManagedPolicy.AWSElementalMediaLiveReadOnly = 'AWSElementalMediaLiveReadOnly';
/** Provides full access to AWS Elemental MediaPackage resources */
AwsManagedPolicy.AWSElementalMediaPackageFullAccess = 'AWSElementalMediaPackageFullAccess';
/** Provides read only access to AWS Elemental MediaPackage resources */
AwsManagedPolicy.AWSElementalMediaPackageReadOnly = 'AWSElementalMediaPackageReadOnly';
/** Provides full access to AWS Elemental MediaPackageV2 resources. */
AwsManagedPolicy.AWSElementalMediaPackageV2FullAccess = 'AWSElementalMediaPackageV2FullAccess';
/** Provides read-only access to AWS Elemental MediaPackageV2 resources. */
AwsManagedPolicy.AWSElementalMediaPackageV2ReadOnly = 'AWSElementalMediaPackageV2ReadOnly';
/** Provides full read and write access to all MediaStore APIs */
AwsManagedPolicy.AWSElementalMediaStoreFullAccess = 'AWSElementalMediaStoreFullAccess';
/** Provides read-only permissions for MediaStore APIs */
AwsManagedPolicy.AWSElementalMediaStoreReadOnly = 'AWSElementalMediaStoreReadOnly';
/** Provides full access to AWS Elemental MediaTailor resources */
AwsManagedPolicy.AWSElementalMediaTailorFullAccess = 'AWSElementalMediaTailorFullAccess';
/** Provides read only access to AWS Elemental MediaTailor resources */
AwsManagedPolicy.AWSElementalMediaTailorReadOnly = 'AWSElementalMediaTailorReadOnly';
/** Policy to enable enhanced classic networking management feature. */
AwsManagedPolicy.AWSEnhancedClassicNetworkingMangementPolicy = 'aws-service-role/AWSEnhancedClassicNetworkingMangementPolicy';
/** Provides console full access to AWS Entity Resolution and related services. */
AwsManagedPolicy.AWSEntityResolutionConsoleFullAccess = 'AWSEntityResolutionConsoleFullAccess';
/** Provides read-only access to AWS Entity Resolution via the AWS Management Console. */
AwsManagedPolicy.AWSEntityResolutionConsoleReadOnlyAccess = 'AWSEntityResolutionConsoleReadOnlyAccess';
/** This policy grants the Fault Injection Simulator Service permission in EC2 and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorEC2Access = 'service-role/AWSFaultInjectionSimulatorEC2Access';
/** This policy grants the Fault Injection Simulator Service permission in ECS and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorECSAccess = 'service-role/AWSFaultInjectionSimulatorECSAccess';
/** This policy grants the Fault Injection Simulator Service permission in EKS and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorEKSAccess = 'service-role/AWSFaultInjectionSimulatorEKSAccess';
/** This policy grants the Fault Injection Simulator Service permission in EC2 networking and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorNetworkAccess = 'service-role/AWSFaultInjectionSimulatorNetworkAccess';
/** This policy grants the Fault Injection Simulator Service permission in RDS and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorRDSAccess = 'service-role/AWSFaultInjectionSimulatorRDSAccess';
/** This policy grants the Fault Injection Simulator Service permission in SSM and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorSSMAccess = 'service-role/AWSFaultInjectionSimulatorSSMAccess';
/** Policy to enable access to AWS Service and Resources used or managed by Amazon FinSpace */
AwsManagedPolicy.AWSFinSpaceServiceRolePolicy = 'aws-service-role/AWSFinSpaceServiceRolePolicy';
/** Full access for AWS FM Administrator */
AwsManagedPolicy.AWSFMAdminFullAccess = 'AWSFMAdminFullAccess';
/** Read only access for AWS FM Administrator that allows monitoring AWS FM operations */
AwsManagedPolicy.AWSFMAdminReadOnlyAccess = 'AWSFMAdminReadOnlyAccess';
/** Provides read only access to AWS WAF actions for AWS Firewall Manager member accounts */
AwsManagedPolicy.AWSFMMemberReadOnlyAccess = 'AWSFMMemberReadOnlyAccess';
/** Managed policy for AWS For Wordpress Plugin */
AwsManagedPolicy.AWSForWordPressPluginPolicy = 'AWSForWordPressPluginPolicy';
/** Policy which allows AWS Code Connections to sync content from your git repository */
AwsManagedPolicy.AWSGitSyncServiceRolePolicy = 'aws-service-role/AWSGitSyncServiceRolePolicy';
/** Policy granting permissions to AWS Global Accelerator to manage EC2 Elastic Network Interfaces and Security Groups. */
AwsManagedPolicy.AWSGlobalAcceleratorSLRPolicy = 'aws-service-role/AWSGlobalAcceleratorSLRPolicy';
/** Provides full access to AWS Glue via the AWS Management Console */
AwsManagedPolicy.AWSGlueConsoleFullAccess = 'AWSGlueConsoleFullAccess';
/** Provides full access to AWS Glue via the AWS Management Console and access to sagemaker notebook instances. */
AwsManagedPolicy.AWSGlueConsoleSageMakerNotebookFullAccess = 'AWSGlueConsoleSageMakerNotebookFullAccess';
/** Provides full access to AWS Glue DataBrew via the AWS Management Console. Also provides select access to related services (e.g., S3, KMS, Glue). */
AwsManagedPolicy.AwsGlueDataBrewFullAccessPolicy = 'AwsGlueDataBrewFullAccessPolicy';
/** This policy grants permission to glue to perform action on user's glue data catalog, this policy also provides permission to ec2 actions to allow glue to create ENI to connect to resources in the VPC, also allow glue to access registered data in lakeformation and permission to access user's cloudwatch */
AwsManagedPolicy.AWSGlueDataBrewServiceRole = 'service-role/AWSGlueDataBrewServiceRole';
/** Provides full access to the AWS Glue Schema Registry Service */
AwsManagedPolicy.AWSGlueSchemaRegistryFullAccess = 'AWSGlueSchemaRegistryFullAccess';
/** Provides readonly access to the AWS Glue Schema Registry Service */
AwsManagedPolicy.AWSGlueSchemaRegistryReadonlyAccess = 'AWSGlueSchemaRegistryReadonlyAccess';
/** Policy for AWS Glue service role which allows customer to manage notebook server */
AwsManagedPolicy.AWSGlueServiceNotebookRole = 'service-role/AWSGlueServiceNotebookRole';
/** Policy for AWS Glue service role which allows access to related services including EC2, S3, and Cloudwatch Logs */
AwsManagedPolicy.AWSGlueServiceRole = 'service-role/AWSGlueServiceRole';
/** Provides permissions that allows users to create and use only the notebook sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
AwsManagedPolicy.AwsGlueSessionUserRestrictedNotebookPolicy = 'AwsGlueSessionUserRestrictedNotebookPolicy';
/** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the notebook sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services. */
AwsManagedPolicy.AwsGlueSessionUserRestrictedNotebookServiceRole = 'service-role/AwsGlueSessionUserRestrictedNotebookServiceRole';
/** Provides permissions that allows users to create and use only the interactive sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
AwsManagedPolicy.AwsGlueSessionUserRestrictedPolicy = 'AwsGlueSessionUserRestrictedPolicy';
/** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the interactive sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services */
AwsManagedPolicy.AwsGlueSessionUserRestrictedServiceRole = 'service-role/AwsGlueSessionUserRestrictedServiceRole';
/** Provides access within Amazon Grafana to create and manage workspaces for the entire organization. */
AwsManagedPolicy.AWSGrafanaAccountAdministrator = 'AWSGrafanaAccountAdministrator';
/** Access to read only operations in Amazon Grafana. */
AwsManagedPolicy.AWSGrafanaConsoleReadOnlyAccess = 'AWSGrafanaConsoleReadOnlyAccess';
/** Provides only the ability to update user and group permissions for AWS Grafana workspaces. */
AwsManagedPolicy.AWSGrafanaWorkspacePermissionManagement = 'AWSGrafanaWorkspacePermissionManagement';
/** Provides ability to update IAM Identity Center (IdC) user and group permissions for Amazon Managed Grafana workspaces. */
AwsManagedPolicy.AWSGrafanaWorkspacePermissionManagementV2 = 'AWSGrafanaWorkspacePermissionManagementV2';
/** This policy gives full access to the AWS Greengrass configuration, management and deployment actions */
AwsManagedPolicy.AWSGreengrassFullAccess = 'AWSGreengrassFullAccess';
/** This policy gives read only access to the AWS Greengrass configuration, management and deployment actions */
AwsManagedPolicy.AWSGreengrassReadOnlyAccess = 'AWSGreengrassReadOnlyAccess';
/** Policy for AWS Greengrass service role which allows access to related services including AWS Lambda and AWS IoT thing shadows. */
AwsManagedPolicy.AWSGreengrassResourceAccessRolePolicy = 'service-role/AWSGreengrassResourceAccessRolePolicy';
/** Provides the Dataflow Endpoint Instance permissions to use the AWS Ground Station Agent */
AwsManagedPolicy.AWSGroundStationAgentInstancePolicy = 'AWSGroundStationAgentInstancePolicy';
/** Allows AWS Health to enable the Health event processor feature. */
AwsManagedPolicy.AWSHealthEventProcessorServiceRolePolicy = 'aws-service-role/AWSHealth_EventProcessorServiceRolePolicy';
/** Allows full access to the AWS Health Apis and Notifications and the Personal Health Dashboard */
AwsManagedPolicy.AWSHealthFullAccess = 'AWSHealthFullAccess';
/** Provides full access to AWS Health Imaging service. */
AwsManagedPolicy.AWSHealthImagingFullAccess = 'AWSHealthImagingFullAccess';
/** Provides read only access to AWS Health Imaging service. */
AwsManagedPolicy.AWSHealthImagingReadOnlyAccess = 'AWSHealthImagingReadOnlyAccess';
/** Provides the list of actions that are allowed for roles assumed with the IAM Identity Center identity context. AWS Security Token Service (AWS STS) automatically attaches this policy to assumed roles. The identity context is passed as ProvidedContext. */
AwsManagedPolicy.AWSIAMIdentityCenterAllowListForIdentityContext = 'AWSIAMIdentityCenterAllowListForIdentityContext';
/** Grants full access to the Identity Sync service */
AwsManagedPolicy.AWSIdentitySyncFullAccess = 'AWSIdentitySyncFullAccess';
/** Read only access to the Identity Sync service */
AwsManagedPolicy.AWSIdentitySyncReadOnlyAccess = 'AWSIdentitySyncReadOnlyAccess';
/** Provides full access to all AWS Image Builder actions and resource scoped access to related AWS services. */
AwsManagedPolicy.AWSImageBuilderFullAccess = 'AWSImageBuilderFullAccess';
/** Provides read only access to all AWS Image Builder actions. */
AwsManagedPolicy.AWSImageBuilderReadOnlyAccess = 'AWSImageBuilderReadOnlyAccess';
/** Provides read and write access to the jobs created under the AWS account. */
AwsManagedPolicy.AWSImportExportFullAccess = 'AWSImportExportFullAccess';
/** Provides read only access to the jobs created under the AWS account. */
AwsManagedPolicy.AWSImportExportReadOnlyAccess = 'AWSImportExportReadOnlyAccess';
/** Grants Incident Manager permissions to call other AWS services as a part of managing an incident. */
AwsManagedPolicy.AWSIncidentManagerIncidentAccessServiceRolePolicy = 'AWSIncidentManagerIncidentAccessServiceRolePolicy';
/** This policy grants permissions to start, view, and update incidents with full access to custom timeline events & related items. Assign this policy to users who will create and resolve incidents. */
AwsManagedPolicy.AWSIncidentManagerResolverAccess = 'AWSIncidentManagerResolverAccess';
/** This policy grants Incident Manager permission to manage incident records and related resources on your behalf. */
AwsManagedPolicy.AWSIncidentManagerServiceRolePolicy = 'aws-service-role/AWSIncidentManagerServiceRolePolicy';
/** Provides full access to AWS IoT 1-Click. */
AwsManagedPolicy.AWSIoT1ClickFullAccess = 'AWSIoT1ClickFullAccess';
/** Provides read only access to AWS IoT 1-Click. */
AwsManagedPolicy.AWSIoT1ClickReadOnlyAccess = 'AWSIoT1ClickReadOnlyAccess';
/** Provides full access to IoT Analytics. */
AwsManagedPolicy.AWSIoTAnalyticsFullAccess = 'AWSIoTAnalyticsFullAccess';
/** Provides read only access to IoT Analytics. */
AwsManagedPolicy.AWSIoTAnalyticsReadOnlyAccess = 'AWSIoTAnalyticsReadOnlyAccess';
/** This policy gives full access to the AWS IoT configuration actions */
AwsManagedPolicy.AWSIoTConfigAccess = 'AWSIoTConfigAccess';
/** This policy gives read only access to the AWS IoT configuration actions */
AwsManagedPolicy.AWSIoTConfigReadOnlyAccess = 'AWSIoTConfigReadOnlyAccess';
/** This policy gives full access to the AWS IoT messaging actions */
AwsManagedPolicy.AWSIoTDataAccess = 'AWSIoTDataAccess';
/** Provides write access to IoT thing groups and read access to IoT Certificates for execution of ADD_THINGS_TO_THING_GROUP mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction = 'service-role/AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction';
/** Provides read access for IoT and related resources */
AwsManagedPolicy.AWSIoTDeviceDefenderAudit = 'service-role/AWSIoTDeviceDefenderAudit';
/** Provides access for enabling IoT logging for execution of ENABLE_IOT_LOGGING mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction = 'service-role/AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction';
/** Provides messages publish access to SNS topic for execution of PUBLISH_FINDING_TO_SNS mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction = 'service-role/AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction';
/** Provides write access to IoT policies for execution of REPLACE_DEFAULT_POLICY_VERSION mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction = 'service-role/AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction';
/** Provides write access to IoT CA certificates for execution of  UPDATE_CA_CERTIFICATE mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderUpdateCACertMitigationAction = 'service-role/AWSIoTDeviceDefenderUpdateCACertMitigationAction';
/** Provides write access to IoT certificates for execution of UPDATE_DEVICE_CERTIFICATE mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction = 'service-role/AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction';
/** Allows AWS IoT Device Tester to run the FreeRTOS qualification suite by allowing access to services including IoT, S3, and IAM */
AwsManagedPolicy.AWSIoTDeviceTesterForFreeRTOSFullAccess = 'AWSIoTDeviceTesterForFreeRTOSFullAccess';
/** Allows AWS IoT Device Tester to run the AWS Greengrass qualification suite by allowing access to related services including Lambda, IoT, API Gateway, IAM */
AwsManagedPolicy.AWSIoTDeviceTesterForGreengrassFullAccess = 'AWSIoTDeviceTesterForGreengrassFullAccess';
/** Provides full access to IoT Events. */
AwsManagedPolicy.AWSIoTEventsFullAccess = 'AWSIoTEventsFullAccess';
/** Provides read only access to IoT Events. */
AwsManagedPolicy.AWSIoTEventsReadOnlyAccess = 'AWSIoTEventsReadOnlyAccess';
/** Federation access for IoT Fleet Hub applications */
AwsManagedPolicy.AWSIoTFleetHubFederationAccess = 'service-role/AWSIoTFleetHubFederationAccess';
/** Grants permissions to AWS Resources and metaData used or managed by AWSIoTFleetwise for auxiliary features */
AwsManagedPolicy.AWSIoTFleetwiseServiceRolePolicy = 'aws-service-role/AWSIoTFleetwiseServiceRolePolicy';
/** This policy gives full access to the AWS IoT configuration and messaging actions */
AwsManagedPolicy.AWSIoTFullAccess = 'AWSIoTFullAccess';
/** Allows creation of Amazon CloudWatch Log groups and streaming logs to the groups */
AwsManagedPolicy.AWSIoTLogging = 'service-role/AWSIoTLogging';
/** Provides full access to managed integrations for AWS IoT Device Management and related services. */
AwsManagedPolicy.AWSIoTManagedIntegrationsFullAccess = 'AWSIoTManagedIntegrationsFullAccess';
/** Provides managed integrations for AWS IoT Device Management permission to publish logs and metrics on your behalf. */
AwsManagedPolicy.AWSIoTManagedIntegrationsRolePolicy = 'aws-service-role/AWSIoTManagedIntegrationsRolePolicy';
/** Allows access to create AWS IoT Job and describe the AWS code signer job */
AwsManagedPolicy.AWSIoTOTAUpdate = 'service-role/AWSIoTOTAUpdate';
/** Allows access to all AWS services supported in AWS IoT Rule Actions */
AwsManagedPolicy.AWSIoTRuleActions = 'service-role/AWSIoTRuleActions';
/** Provides full access to manage AWS IoT SiteWise using the AWS Management Console. Note this policy also grants access to create and list data stores used with AWS IoT SiteWise (e.g. AWS IoT Analytics), access to list and view AWS IoT Greengrass resources, list and modify AWS Secrets Manager secrets, retrieve AWS IoT thing shadows, list resources with specific tags, and create and use a service-linked role for AWS IoT SiteWise. */
AwsManagedPolicy.AWSIoTSiteWiseConsoleFullAccess = 'AWSIoTSiteWiseConsoleFullAccess';
/** Provides full access to IoT SiteWise. */
AwsManagedPolicy.AWSIoTSiteWiseFullAccess = 'AWSIoTSiteWiseFullAccess';
/** This policy grants permissions to access AWS IoT SiteWise assets and asset data, create AWS IoT SiteWise Monitor resources, and list AWS SSO users. */
AwsManagedPolicy.AWSIoTSiteWiseMonitorPortalAccess = 'service-role/AWSIoTSiteWiseMonitorPortalAccess';
/** This role grants AWS IoT SiteWise monitor permissions to access your AWS IoT SiteWise assets & asset properties, and create AWS IoT Sitewise projects, dashboards & access policies through AWS IoT SiteWise portals. */
AwsManagedPolicy.AWSIoTSiteWiseMonitorServiceRolePolicy = 'aws-service-role/AWSIoTSiteWiseMonitorServiceRolePolicy';
/** Provides read only access to IoT SiteWise. */
AwsManagedPolicy.AWSIoTSiteWiseReadOnlyAccess = 'AWSIoTSiteWiseReadOnlyAccess';
/** This policy allows users to register things at bulk using AWS IoT StartThingRegistrationTask API */
AwsManagedPolicy.AWSIoTThingsRegistration = 'service-role/AWSIoTThingsRegistration';
/** Allows AWS IoT TwinMaker to call other AWS services and to sync their resources on your behalf. */
AwsManagedPolicy.AWSIoTTwinMakerServiceRolePolicy = 'aws-service-role/AWSIoTTwinMakerServiceRolePolicy';
/** Allows the associated identity data access to AWS IoT Wireless devices. */
AwsManagedPolicy.AWSIoTWirelessDataAccess = 'AWSIoTWirelessDataAccess';
/** Allows the associated identity full access to all AWS IoT Wireless operations. */
AwsManagedPolicy.AWSIoTWirelessFullAccess = 'AWSIoTWirelessFullAccess';
/** Provides IoT Wireless full access to publish to IoT Rules Engine on your behalf. */
AwsManagedPolicy.AWSIoTWirelessFullPublishAccess = 'AWSIoTWirelessFullPublishAccess';
/** Allows the associated identity access to create, list and describe IoT Certificates */
AwsManagedPolicy.AWSIoTWirelessGatewayCertManager = 'AWSIoTWirelessGatewayCertManager';
/** Allows the associated identity to create Amazon CloudWatch Logs groups and stream logs to the groups. */
AwsManagedPolicy.AWSIoTWirelessLogging = 'AWSIoTWirelessLogging';
/** Allows the associated identity read only access to AWS IoT wireless. */
AwsManagedPolicy.AWSIoTWirelessReadOnlyAccess = 'AWSIoTWirelessReadOnlyAccess';
/** Allows VPC IP Address Manager to access VPC resources and integrate with AWS Organizations on your behalf. */
AwsManagedPolicy.AWSIPAMServiceRolePolicy = 'aws-service-role/AWSIPAMServiceRolePolicy';
/** Used by AWS IQ to execute payment requests on behalf of a customer */
AwsManagedPolicy.AWSIQContractServiceRolePolicy = 'aws-service-role/AWSIQContractServiceRolePolicy';
/** Provides full access to AWS IQ */
AwsManagedPolicy.AWSIQFullAccess = 'AWSIQFullAccess';
/** Allows AWS IQ to manage the role assumed by AWS IQ experts. */
AwsManagedPolicy.AWSIQPermissionServiceRolePolicy = 'aws-service-role/AWSIQPermissionServiceRolePolicy';
/** Enables access to AWS services and resources required for AWS KMS custom key stores */
AwsManagedPolicy.AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy = 'aws-service-role/AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy';
/** Enables AWS KMS to synchronize the shared properties of multi-Region keys. */
AwsManagedPolicy.AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy = 'aws-service-role/AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy';
/** Provides access to AWS Key Management Service (KMS). */
AwsManagedPolicy.AWSKeyManagementServicePowerUser = 'AWSKeyManagementServicePowerUser';
/** Provides cross account access to Glue resources via Lake Formation. Also grants read access to other required services such as organizations and resource access manager */
AwsManagedPolicy.AWSLakeFormationCrossAccountManager = 'AWSLakeFormationCrossAccountManager';
/** Grants administrative access to AWS Lake Formation and related services, such as AWS Glue, to manage data lakes */
AwsManagedPolicy.AWSLakeFormationDataAdmin = 'AWSLakeFormationDataAdmin';
/** Grants full access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
AwsManagedPolicy.AWSLambdaFullAccess = 'AWSLambda_FullAccess';
/** Grants read-only access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
AwsManagedPolicy.AWSLambdaReadOnlyAccess = 'AWSLambda_ReadOnlyAccess';
/** Provides write permissions to CloudWatch Logs. */
AwsManagedPolicy.AWSLambdaBasicExecutionRole = 'service-role/AWSLambdaBasicExecutionRole';
/** Provides list and read access to DynamoDB streams and write permissions to CloudWatch logs. */
AwsManagedPolicy.AWSLambdaDynamoDBExecutionRole = 'service-role/AWSLambdaDynamoDBExecutionRole';
/** Provides minimum permissions for a Lambda function to manage ENIs (create, describe, delete) used by a VPC-enabled Lambda Function. */
AwsManagedPolicy.AWSLambdaENIManagementAccess = 'service-role/AWSLambdaENIManagementAccess';
/** Provides Put, Get access to S3 and full access to CloudWatch Logs. */
AwsManagedPolicy.AWSLambdaExecute = 'AWSLambdaExecute';
/** Provides read access to DynamoDB Streams. */
AwsManagedPolicy.AWSLambdaInvocationDynamoDB = 'AWSLambdaInvocation-DynamoDB';
/** Provides list and read access to Kinesis streams and write permissions to CloudWatch logs. */
AwsManagedPolicy.AWSLambdaKinesisExecutionRole = 'service-role/AWSLambdaKinesisExecutionRole';
/** Provides permissions required to access MSK Cluster within a VPC, manage ENIs (create, describe, delete) in the VPC and write permissions to CloudWatch Logs. */
AwsManagedPolicy.AWSLambdaMSKExecutionRole = 'service-role/AWSLambdaMSKExecutionRole';
/** Grants Lambda Replicator necessary permissions to replicate functions across regions */
AwsManagedPolicy.AWSLambdaReplicator = 'aws-service-role/AWSLambdaReplicator';
/** Default policy for AWS Lambda service role. */
AwsManagedPolicy.AWSLambdaRole = 'service-role/AWSLambdaRole';
/** Provides receive message, delete message, and read attribute access to SQS queues, and write permissions to CloudWatch logs. */
AwsManagedPolicy.AWSLambdaSQSQueueExecutionRole = 'service-role/AWSLambdaSQSQueueExecutionRole';
/** Provides minimum permissions for a Lambda function to execute while accessing a resource within a VPC - create, describe, delete network interfaces and write permissions to CloudWatch Logs. */
AwsManagedPolicy.AWSLambdaVPCAccessExecutionRole = 'service-role/AWSLambdaVPCAccessExecutionRole';
/** Provides permissions to allow access to the AWS License Manager API actions required to consume upon licenses that the user has entitlements. */
AwsManagedPolicy.AWSLicenseManagerConsumptionPolicy = 'service-role/AWSLicenseManagerConsumptionPolicy';
/** Allows AWS License Manager Linux Subscriptions Service to manage resources on your behalf. */
AwsManagedPolicy.AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy = 'aws-service-role/AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy';
/** AWS License Manager service master account role policy */
AwsManagedPolicy.AWSLicenseManagerMasterAccountRolePolicy = 'aws-service-role/AWSLicenseManagerMasterAccountRolePolicy';
/** AWS License Manager service member account role policy */
AwsManagedPolicy.AWSLicenseManagerMemberAccountRolePolicy = 'aws-service-role/AWSLicenseManagerMemberAccountRolePolicy';
/** AWS License Manager service default role policy */
AwsManagedPolicy.AWSLicenseManagerServiceRolePolicy = 'aws-service-role/AWSLicenseManagerServiceRolePolicy';
/** Allows AWS License Manager User Subscriptions Service to manage resources on your behalf. */
AwsManagedPolicy.AWSLicenseManagerUserSubscriptionsServiceRolePolicy = 'aws-service-role/AWSLicenseManagerUserSubscriptionsServiceRolePolicy';
/** Allows AWS M2 to manage AWS resources on your behalf. */
AwsManagedPolicy.AWSM2ServicePolicy = 'aws-service-role/AWSM2ServicePolicy';
/** Allows AWS Managed Services to read the values of the tags on AWS resources */
AwsManagedPolicy.AWSManagedServicesContactsServiceRolePolicy = 'aws-service-role/AWSManagedServices_ContactsServiceRolePolicy';
/** AWS Managed Services - policy to manage detective controls infrastructure */
AwsManagedPolicy.AWSManagedServicesDetectiveControlsConfigServiceRolePolicy = 'aws-service-role/AWSManagedServices_DetectiveControlsConfig_ServiceRolePolicy';
/** AWS Managed Services policy to enable AMS event processor feature. */
AwsManagedPolicy.AWSManagedServicesEventsServiceRolePolicy = 'aws-service-role/AWSManagedServices_EventsServiceRolePolicy';
/** Allows Amazon's AWS Managed Service's Self Service Reporting feature to read AWS Organization data on your behalf to enable organization level aggregated reporting */
AwsManagedPolicy.AWSManagedServicesSelfServiceReportingServiceRolePolicy = 'aws-service-role/AWSManagedServices_SelfServiceReporting_ServiceRolePolicy';
/** Allows AWS Managed Services to manage deployment toolkit on your behalf. */
AwsManagedPolicy.AWSManagedServicesDeploymentToolkitPolicy = 'aws-service-role/AWSManagedServicesDeploymentToolkitPolicy';
/** Allows AWS Marketplace to copy your Amazon Machine Images (AMIs) in order to list them on AWS Marketplace */
AwsManagedPolicy.AWSMarketplaceAmiIngestion = 'AWSMarketplaceAmiIngestion';
/** Allows AWS Marketplace to create and manage seller deployment parameters for the products that you subscribe to on AWS Marketplace. */
AwsManagedPolicy.AWSMarketplaceDeploymentServiceRolePolicy = 'aws-service-role/AWSMarketplaceDeploymentServiceRolePolicy';
/** Provides the ability to subscribe and unsubscribe to AWS Marketplace software, allows users to manage Marketplace software instances from the Marketplace 'Your Software' page, and provides administrative access to EC2. */
AwsManagedPolicy.AWSMarketplaceFullAccess = 'AWSMarketplaceFullAccess';
/** Provides read access to AWS Marketplace Entitlements */
AwsManagedPolicy.AWSMarketplaceGetEntitlements = 'AWSMarketplaceGetEntitlements';
/** Enables access to AWS Services and Resources used or managed by AWS Marketplace for license management. */
AwsManagedPolicy.AWSMarketplaceLicenseManagementServiceRolePolicy = 'aws-service-role/AWSMarketplaceLicenseManagementServiceRolePolicy';
/** Provides the ability to subscribe and unsubscribe to AWS Marketplace software */
AwsManagedPolicy.AWSMarketplaceManageSubscriptions = 'AWSMarketplaceManageSubscriptions';
/** Provides full access to AWS Marketplace Metering. */
AwsManagedPolicy.AWSMarketplaceMeteringFullAccess = 'AWSMarketplaceMeteringFullAccess';
/** Provides permissions to register a resource and track usage through AWS Marketplace Metering Service. */
AwsManagedPolicy.AWSMarketplaceMeteringRegisterUsage = 'AWSMarketplaceMeteringRegisterUsage';
/** Provides full access to all administrative actions for an AWS Marketplace eProcurement integration. */
AwsManagedPolicy.AWSMarketplaceProcurementSystemAdminFullAccess = 'AWSMarketplaceProcurementSystemAdminFullAccess';
/** Enables access for AWS Marketplace services to purchase order management. */
AwsManagedPolicy.AWSMarketplacePurchaseOrdersServiceRolePolicy = 'aws-service-role/AWSMarketplacePurchaseOrdersServiceRolePolicy';
/** Provides the ability to review AWS Marketplace subscriptions */
AwsManagedPolicy.AWSMarketplaceReadOnly = 'AWSMarketplaceRead-only';
/** Enables access to AWS Services and Resources used or managed by AWS Marketplace for Resale Authorization. */
AwsManagedPolicy.AWSMarketplaceResaleAuthorizationServiceRolePolicy = 'aws-service-role/AWSMarketplaceResaleAuthorizationServiceRolePolicy';
/** Provides full access to all seller operations on the AWS Marketplace and other AWS services such as AMI management. */
AwsManagedPolicy.AWSMarketplaceSellerFullAccess = 'AWSMarketplaceSellerFullAccess';
/** Provides sellers access to Offers and Agreements management activities. */
AwsManagedPolicy.AWSMarketplaceSellerOfferManagement = 'AWSMarketplaceSellerOfferManagement';
/** Provides sellers full access to AWS Marketplace Management Products page and other AWS services such as AMI management. */
AwsManagedPolicy.AWSMarketplaceSellerProductsFullAccess = 'AWSMarketplaceSellerProductsFullAccess';
/** Provide sellers read-only access to AWS Marketplace Management Products page. */
AwsManagedPolicy.AWSMarketplaceSellerProductsReadOnly = 'AWSMarketplaceSellerProductsReadOnly';
/** The default policy that enables access to AWS Services and Resources used or managed by MediaConnect. */
AwsManagedPolicy.AWSMediaConnectServicePolicy = 'aws-service-role/AWSMediaConnectServicePolicy';
/** Allows MediaLive Anywhere to create and manage AWS resources on your behalf. */
AwsManagedPolicy.AWSMediaLiveAnywhereServiceRolePolicy = 'aws-service-role/AWSMediaLiveAnywhereServiceRolePolicy';
/** Enable access to AWS Resources used or managed by MediaTailor */
AwsManagedPolicy.AWSMediaTailorServiceRolePolicy = 'aws-service-role/AWSMediaTailorServiceRolePolicy';
/** Policy allows AWSMigrationHubService to call AWSApplicationDiscoveryService on behalf of the customer. */
AwsManagedPolicy.AWSMigrationHubDiscoveryAccess = 'service-role/AWSMigrationHubDiscoveryAccess';
/** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
AwsManagedPolicy.AWSMigrationHubDMSAccess = 'service-role/AWSMigrationHubDMSAccess';
/** Managed policy to provide the customer access to the Migration Hub Service */
AwsManagedPolicy.AWSMigrationHubFullAccess = 'AWSMigrationHubFullAccess';
/** Provides limited access to AWS Migration Hub, AWS Application Discovery Service, Amazon Simple Storage Service and AWS Secrets Manager. This policy also grants full access to AWS Migration Hub Orchestrator service. */
AwsManagedPolicy.AWSMigrationHubOrchestratorConsoleFullAccess = 'AWSMigrationHubOrchestratorConsoleFullAccess';
/** This policy needs to be attached for SAP and MGN migrated instance for our service to orchestrate instances by downloading scripts from S3 and to fetch secret values inside EC2 instance. */
AwsManagedPolicy.AWSMigrationHubOrchestratorInstanceRolePolicy = 'AWSMigrationHubOrchestratorInstanceRolePolicy';
/** Provides limited access to Amazon Simple Storage Service, AWS Secrets Manager and Plugin related actions for AWS Migration Hub Orchestrator. */
AwsManagedPolicy.AWSMigrationHubOrchestratorPlugin = 'AWSMigrationHubOrchestratorPlugin';
/** Provides permissions necessary for Migration Hub Orchestrator to migrate and modernize your on-premises workloads */
AwsManagedPolicy.AWSMigrationHubOrchestratorServiceRolePolicy = 'aws-service-role/AWSMigrationHubOrchestratorServiceRolePolicy';
/** Grants full access to AWS Migration Hub Refactor Spaces and other AWS related services except AWS Transit Gateway and EC2 security groups not required when using environments without a network bridge. This policy also excludes permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
AwsManagedPolicy.AWSMigrationHubRefactorSpacesEnvironmentsWithoutBridgesFullAccess = 'AWSMigrationHubRefactorSpaces-EnvironmentsWithoutBridgesFullAccess';
/** Use in the IAM service role passed to the SSM Automation document AWSRefactorSpaces-CreateResources to grant permissions required to run the automation. The policy grants read/write access to EC2 tags in order to track automation progress. When the Refactor Spaces environment's network bridge is enabled, the automation also adds the environment's security group to the EC2 instance to permit traffic from other Refactor Spaces services in the environment. The policy also grants access to the Application Migration Service's post launch actions SSM parameters. */
AwsManagedPolicy.AWSMigrationHubRefactorSpacesSSMAutomationPolicy = 'service-role/AWSMigrationHubRefactorSpaces-SSMAutomationPolicy';
/** Grants full access to AWS MigrationHub Refactor Spaces, AWS MigrationHub Refactor Spaces console features and other related AWS services except permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
AwsManagedPolicy.AWSMigrationHubRefactorSpacesFullAccess = 'AWSMigrationHubRefactorSpacesFullAccess';
/** Provides access to AWS Resources managed or used by AWS Migration Hub Refactor Spaces. */
AwsManagedPolicy.AWSMigrationHubRefactorSpacesServiceRolePolicy = 'aws-service-role/AWSMigrationHubRefactorSpacesServiceRolePolicy';
/** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
AwsManagedPolicy.AWSMigrationHubSMSAccess = 'service-role/AWSMigrationHubSMSAccess';
/** Grants permissions to allow communication with the AWS Migration Hub Strategy Recommendations service, read/write access to S3 buckets related to the service, Amazon API Gateway access to upload logs and metrics to AWS, AWS Secrets Manager access to fetch credentials, and any related services. */
AwsManagedPolicy.AWSMigrationHubStrategyCollector = 'AWSMigrationHubStrategyCollector';
/** Grants full access to the AWS Migration Hub Strategy Recommendations service and access to related AWS services through the AWS Management Console. */
AwsManagedPolicy.AWSMigrationHubStrategyConsoleFullAccess = 'AWSMigrationHubStrategyConsoleFullAccess';
/** Enable access to AWS Resources used or managed by AWS Migration Hub Strategy Recommendations service. */
AwsManagedPolicy.AWSMigrationHubStrategyServiceRolePolicy = 'aws-service-role/AWSMigrationHubStrategyServiceRolePolicy';
/** Grants permissions to Amazon MSK Replicator to replicate data between MSK Clusters. */
AwsManagedPolicy.AWSMSKReplicatorExecutionRole = 'service-role/AWSMSKReplicatorExecutionRole';
/** Grants full access to AWS Network Firewall service, including permissions to create, configure, manage, and delete firewall resources, policies, and rule groups. Additionally includes permissions to modify VPC endpoints, S3 bucket policies, CloudWatch Logs configurations, and create service-linked roles for Network Firewall and log delivery services */
AwsManagedPolicy.AWSNetworkFirewallFullAccess = 'AWSNetworkFirewallFullAccess';
/** Provides read-only access to AWS Network Firewall resources via the AWS Management Console, CLI, and SDKs. This policy allows users to view and monitor firewall configurations, policies, rule groups, and associated resources, without the ability to make changes. */
AwsManagedPolicy.AWSNetworkFirewallReadOnlyAccess = 'AWSNetworkFirewallReadOnlyAccess';
/** Allow AWSNetworkFirewall to create and manage necessary resources for your Firewalls. */
AwsManagedPolicy.AWSNetworkFirewallServiceRolePolicy = 'aws-service-role/AWSNetworkFirewallServiceRolePolicy';
/** Allow NetworkManager to access resources associated with your Core Network */
AwsManagedPolicy.AWSNetworkManagerCloudWANServiceRolePolicy = 'aws-service-role/AWSNetworkManagerCloudWANServiceRolePolicy';
/** Provides full access to Amazon NetworkManager via the AWS Management Console. */
AwsManagedPolicy.AWSNetworkManagerFullAccess = 'AWSNetworkManagerFullAccess';
/** Provides read only access to Amazon NetworkManager via the AWS Management Console. */
AwsManagedPolicy.AWSNetworkManagerReadOnlyAccess = 'AWSNetworkManagerReadOnlyAccess';
/** Allow NetworkManager to access resources associated with your Global Networks */
AwsManagedPolicy.AWSNetworkManagerServiceRolePolicy = 'aws-service-role/AWSNetworkManagerServiceRolePolicy';
/** Provides access to manage AWS Config Configuration Recorder, manage AWS Config Configuration Aggregator, create AWS Config Service Linked Role for Configuration Recorder functionality, consume recorder configuration data, and read AWS Organizations data for organizational features. */
AwsManagedPolicy.AWSObservabilityAdminServiceRolePolicy = 'aws-service-role/AWSObservabilityAdminServiceRolePolicy';
/** Provides full access to AWS OpsWorks. */
AwsManagedPolicy.AWSOpsWorksFullAccess = 'AWSOpsWorks_FullAccess';
/** Enables OpsWorks instances with the CWLogs integration enabled to ship logs and create required log groups */
AwsManagedPolicy.AWSOpsWorksCloudWatchLogs = 'AWSOpsWorksCloudWatchLogs';
/** Provides S3 access for instances launched by OpsWorks CM. */
AwsManagedPolicy.AWSOpsWorksCMInstanceProfileRole = 'AWSOpsWorksCMInstanceProfileRole';
/** Service Role Policy to be used for Creating OpsWorks CM servers. */
AwsManagedPolicy.AWSOpsWorksCMServiceRole = 'service-role/AWSOpsWorksCMServiceRole';
/** Provides access for an Amazon EC2 instance to register with an AWS OpsWorks stack. */
AwsManagedPolicy.AWSOpsWorksInstanceRegistration = 'AWSOpsWorksInstanceRegistration';
/** Policy to enable registration of EC2 instances via the OpsWorks CLI */
AwsManagedPolicy.AWSOpsWorksRegisterCLIEC2 = 'AWSOpsWorksRegisterCLI_EC2';
/** Policy to enable registration of On-Premises instances via the OpsWorks CLI */
AwsManagedPolicy.AWSOpsWorksRegisterCLIOnPremises = 'AWSOpsWorksRegisterCLI_OnPremises';
/** Provides full access to AWS Organizations. */
AwsManagedPolicy.AWSOrganizationsFullAccess = 'AWSOrganizationsFullAccess';
/** Provides read-only access to AWS Organizations. */
AwsManagedPolicy.AWSOrganizationsReadOnlyAccess = 'AWSOrganizationsReadOnlyAccess';
/** A policy to allow AWS Organizations to share trust with other approved AWS Services for the purpose of simplifying customer configuration. */
AwsManagedPolicy.AWSOrganizationsServiceTrustPolicy = 'aws-service-role/AWSOrganizationsServiceTrustPolicy';
/** This policy grants permissions that allow you to install an Outpost server on your on-premises network. */
AwsManagedPolicy.AWSOutpostsAuthorizeServerPolicy = 'AWSOutpostsAuthorizeServerPolicy';
/** Service Linked Role policy to enable access to AWS resources managed by AWS Outposts */
AwsManagedPolicy.AWSOutpostsServiceRolePolicy = 'aws-service-role/AWSOutpostsServiceRolePolicy';
/** Allows AWS IoT software on an AWS Panorama Appliance to upload logs to Amazon CloudWatch. */
AwsManagedPolicy.AWSPanoramaApplianceRolePolicy = 'service-role/AWSPanoramaApplianceRolePolicy';
/** Allows an AWS Panorama Appliance to upload logs to Amazon CloudWatch, and to get objects from Amazon S3 access points created for use with AWS Panorama. */
AwsManagedPolicy.AWSPanoramaApplianceServiceRolePolicy = 'service-role/AWSPanoramaApplianceServiceRolePolicy';
/** Provides full access to AWS Panorama */
AwsManagedPolicy.AWSPanoramaFullAccess = 'AWSPanoramaFullAccess';
/** Allows an AWS Lambda function on an AWS Panorama Appliance to manage resources in Panorama, upload logs and metrics to Amazon CloudWatch, and to manage objects in buckets created for use with Panorama. */
AwsManagedPolicy.AWSPanoramaGreengrassGroupRolePolicy = 'service-role/AWSPanoramaGreengrassGroupRolePolicy';
/** Allows Amazon SageMaker to manage objects in buckets created for use with AWS Panorama. */
AwsManagedPolicy.AWSPanoramaSageMakerRolePolicy = 'service-role/AWSPanoramaSageMakerRolePolicy';
/** Allows AWS Panorama to manage resources in AWS IoT, AWS Secrets Manager and AWS Panorama. */
AwsManagedPolicy.AWSPanoramaServiceLinkedRolePolicy = 'aws-service-role/AWSPanoramaServiceLinkedRolePolicy';
/** Allows AWS Panorama to manage resources in Amazon S3, AWS IoT, AWS IoT GreenGrass, AWS Lambda, Amazon SageMaker, and Amazon CloudWatch Logs, and to pass service roles to AWS IoT, AWS IoT GreenGrass, and Amazon SageMaker. */
AwsManagedPolicy.AWSPanoramaServiceRolePolicy = 'service-role/AWSPanoramaServiceRolePolicy';
/** Provides full access to AWS Partner Central and related AWS Services. */
AwsManagedPolicy.AWSPartnerCentralFullAccess = 'AWSPartnerCentralFullAccess';
/** Provides necessary access for opportunity management activities. */
AwsManagedPolicy.AWSPartnerCentralOpportunityManagement = 'AWSPartnerCentralOpportunityManagement';
/** Provides necessary access for developer testing in the Sandbox catalog. */
AwsManagedPolicy.AWSPartnerCentralSandboxFullAccess = 'AWSPartnerCentralSandboxFullAccess';
/** Provides access to the ResourceSnapshotJob to read a resource and snapshot it in the target engagement. */
AwsManagedPolicy.AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy = 'AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy';
/** This policy can be used to grant read-only access to APIs that can read service metadata for services in your AWS account. You can use this policy to provide your partners in the Partner-Led Support Program with access to the services specified in the permissions details section below. */
AwsManagedPolicy.AWSPartnerLedSupportReadOnlyAccess = 'AWSPartnerLedSupportReadOnlyAccess';
/** Grants permission to AWS PCS compute nodes to connect to AWS PCS clusters. */
AwsManagedPolicy.AWSPCSComputeNodePolicy = 'AWSPCSComputeNodePolicy';
/** Grants permissions to PCS to manage resources on your behalf. */
AwsManagedPolicy.AWSPCSServiceRolePolicy = 'aws-service-role/AWSPCSServiceRolePolicy';
/** Provides full access to AWS Price List Service. */
AwsManagedPolicy.AWSPriceListServiceFullAccess = 'AWSPriceListServiceFullAccess';
/** Provides auditor access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAAuditor = 'AWSPrivateCAAuditor';
/** Grants essential permissions for the AWS Private CA Connector for Kubernetes. */
AwsManagedPolicy.AWSPrivateCAConnectorForKubernetesPolicy = 'AWSPrivateCAConnectorForKubernetesPolicy';
/** Provides full access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAFullAccess = 'AWSPrivateCAFullAccess';
/** Provides privileged certificate user access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAPrivilegedUser = 'AWSPrivateCAPrivilegedUser';
/** Provides read only access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAReadOnly = 'AWSPrivateCAReadOnly';
/** Provides certificate user access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAUser = 'AWSPrivateCAUser';
/** Provides full access to all administrative actions for an AWS Private Marketplace. */
AwsManagedPolicy.AWSPrivateMarketplaceAdminFullAccess = 'AWSPrivateMarketplaceAdminFullAccess';
/** Provides access to creating requests in an AWS Private Marketplace. */
AwsManagedPolicy.AWSPrivateMarketplaceRequests = 'AWSPrivateMarketplaceRequests';
/** Allows AWS Private Networks Service to manage resources on behalf of the customer. */
AwsManagedPolicy.AWSPrivateNetworksServiceRolePolicy = 'aws-service-role/AWSPrivateNetworksServiceRolePolicy';
/** Permissions CodeBuild needs to run a build for AWS Proton CodeBuild Provisioning. */
AwsManagedPolicy.AWSProtonCodeBuildProvisioningBasicAccess = 'AWSProtonCodeBuildProvisioningBasicAccess';
/** Allows AWS Proton to manage Proton resource provisioning using CodeBuild and other AWS services on your behalf. */
AwsManagedPolicy.AWSProtonCodeBuildProvisioningServiceRolePolicy = 'aws-service-role/AWSProtonCodeBuildProvisioningServiceRolePolicy';
/** Provides access to the AWS Proton APIs and Management Console, but does not allow administration of Proton templates or environments. */
AwsManagedPolicy.AWSProtonDeveloperAccess = 'AWSProtonDeveloperAccess';
/** Provides full access to the AWS Proton APIs and Management Console. In addition to these permissions, access to Amazon S3 is also needed to register template bundles from your S3 buckets, as well as access to Amazon IAM to create and manage the service roles for Proton. */
AwsManagedPolicy.AWSProtonFullAccess = 'AWSProtonFullAccess';
/** Provides read only access to the AWS Proton APIs and Management Console. */
AwsManagedPolicy.AWSProtonReadOnlyAccess = 'AWSProtonReadOnlyAccess';
/** Policy which allows AWS Proton to sync your service, environment and component definitions from your git repository to AWS Proton. */
AwsManagedPolicy.AWSProtonServiceGitSyncServiceRolePolicy = 'aws-service-role/AWSProtonServiceGitSyncServiceRolePolicy';
/** Policy which allows AWS Proton to sync your git repository contents to Proton or sync Proton contents to your git repositories. */
AwsManagedPolicy.AWSProtonSyncServiceRolePolicy = 'aws-service-role/AWSProtonSyncServiceRolePolicy';
/** Grants permissions to view and modify purchase orders on billing console */
AwsManagedPolicy.AWSPurchaseOrdersServiceRolePolicy = 'AWSPurchaseOrdersServiceRolePolicy';
/** The AWSQuickSetupCFGCPacksPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to deploy AWS Config conformance packs. */
AwsManagedPolicy.AWSQuickSetupCFGCPacksPermissionsBoundary = 'AWSQuickSetupCFGCPacksPermissionsBoundary';
/** Provides permissions for AWS Systems Manager Quick Setup to deploy multiple configuration types. These configuration types create IAM roles and automations that configure frequently used Amazon Web Services services and features with recommended best practices. */
AwsManagedPolicy.AWSQuickSetupDeploymentRolePolicy = 'AWSQuickSetupDeploymentRolePolicy';
/** The AWSQuickSetupDevOpsGuruPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure Amazon DevOps Guru. This policy also provides permissions to enable Systems Manager Explorer. */
AwsManagedPolicy.AWSQuickSetupDevOpsGuruPermissionsBoundary = 'AWSQuickSetupDevOpsGuruPermissionsBoundary';
/** QuickSetup creates IAM roles which enable it to configure the Systems Manager Distributor feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
AwsManagedPolicy.AWSQuickSetupDistributorPermissionsBoundary = 'AWSQuickSetupDistributorPermissionsBoundary';
/** This policy grants permissions that allow Systems Manager to run the AWSQuickSetupType-EnableAREX Automation runbook, which enables AWS Resource Explorer for use with Systems Manager. */
AwsManagedPolicy.AWSQuickSetupEnableAREXExecutionPolicy = 'AWSQuickSetupEnableAREXExecutionPolicy';
/** This policy grants permissions that allow principals to run the AWSQuickSetupType-EnableDHMC Automation runbook, which enables Default Host Management Configuration. */
AwsManagedPolicy.AWSQuickSetupEnableDHMCExecutionPolicy = 'AWSQuickSetupEnableDHMCExecutionPolicy';
/** This policy allows Quick Setup to deploy the configuration type required to set up just-in-time node access. */
AwsManagedPolicy.AWSQuickSetupJITNADeploymentRolePolicy = 'AWSQuickSetupJITNADeploymentRolePolicy';
/** This policy grants administrative permissions that allow Systems Manager to create a default IAM instance profile for the Quick Setup capability and attach it to Amazon EC2 instances that don't already have an instance. profile attached. */
AwsManagedPolicy.AWSQuickSetupManagedInstanceProfileExecutionPolicy = 'AWSQuickSetupManagedInstanceProfileExecutionPolicy';
/** This policy provides permissions to enable just-in-time node access for Systems Manager. */
AwsManagedPolicy.AWSQuickSetupManageJITNAResourcesExecutionPolicy = 'AWSQuickSetupManageJITNAResourcesExecutionPolicy';
/** Provides read-only permissions to access patch baselines that have been configured by an administrator in the current AWS account or organization using Quick Setup. */
AwsManagedPolicy.AWSQuickSetupPatchPolicyBaselineAccess = 'AWSQuickSetupPatchPolicyBaselineAccess';
/** Provides permissions that allow Quick Setup to create resources associated with a patch policy configuration. */
AwsManagedPolicy.AWSQuickSetupPatchPolicyDeploymentRolePolicy = 'AWSQuickSetupPatchPolicyDeploymentRolePolicy';
/** QuickSetup creates IAM roles which enable it to configure the Systems Manager Patch Manager feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
AwsManagedPolicy.AWSQuickSetupPatchPolicyPermissionsBoundary = 'AWSQuickSetupPatchPolicyPermissionsBoundary';
/** The AWSQuickSetupSchedulerPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure scheduled operations on Amazon EC2 instances and other resources. */
AwsManagedPolicy.AWSQuickSetupSchedulerPermissionsBoundary = 'AWSQuickSetupSchedulerPermissionsBoundary';
/** This policy grants administrative permssions that allow Quick Setup to create resources that are used during the Systems Manager onboarding process. */
AwsManagedPolicy.AWSQuickSetupSSMDeploymentRolePolicy = 'AWSQuickSetupSSMDeploymentRolePolicy';
/** This policy grants permissions for listing all S3 buckets in an account; and for managing and retrieving information about specific buckets in the principal account that are managed through AWS CloudFormation templates. */
AwsManagedPolicy.AWSQuickSetupSSMDeploymentS3BucketRolePolicy = 'AWSQuickSetupSSMDeploymentS3BucketRolePolicy';
/** Quick Setup creates IAM roles which enable it to configure the Host Manager Quick Setup type on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
AwsManagedPolicy.AWSQuickSetupSSMHostMgmtPermissionsBoundary = 'AWSQuickSetupSSMHostMgmtPermissionsBoundary';
/** The policy grants administrative permissions that allow Quick Setup to run the a AWS CloudFormation custom resource on lifecycle events during Quick Setup deployment in Systems Manager. */
AwsManagedPolicy.AWSQuickSetupSSMLifecycleManagementExecutionPolicy = 'AWSQuickSetupSSMLifecycleManagementExecutionPolicy';
/** This policy grants permissions that allow Systems Manager to create prerequisites such as IAM roles required for Systems Manager onboarding. */
AwsManagedPolicy.AWSQuickSetupSSMManageResourcesExecutionPolicy = 'AWSQuickSetupSSMManageResourcesExecutionPolicy';
/** Provides the set of permissions required to perform QuickSight Asset Bundle Export Operations */
AwsManagedPolicy.AWSQuickSightAssetBundleExportPolicy = 'AWSQuickSightAssetBundleExportPolicy';
/** Provides the set of permissions required to perform QuickSight Asset Bundle Import Operations */
AwsManagedPolicy.AWSQuickSightAssetBundleImportPolicy = 'AWSQuickSightAssetBundleImportPolicy';
/** Quicksight access to Athena API and S3 buckets used for Athena query results */
AwsManagedPolicy.AWSQuicksightAthenaAccess = 'service-role/AWSQuicksightAthenaAccess';
/** Allow QuickSight to describe the RDS resources */
AwsManagedPolicy.AWSQuickSightDescribeRDS = 'service-role/AWSQuickSightDescribeRDS';
/** Allow QuickSight to describe Redshift resources */
AwsManagedPolicy.AWSQuickSightDescribeRedshift = 'service-role/AWSQuickSightDescribeRedshift';
/** Provides access to Amazon Elasticsearch resources from Amazon QuickSight */
AwsManagedPolicy.AWSQuickSightElasticsearchPolicy = 'service-role/AWSQuickSightElasticsearchPolicy';
/** Give QuickSight read-only access to IoT Analytics datasets */
AwsManagedPolicy.AWSQuickSightIoTAnalyticsAccess = 'AWSQuickSightIoTAnalyticsAccess';
/** Allow QuickSight to list IAM entities */
AwsManagedPolicy.AWSQuickSightListIAM = 'service-role/AWSQuickSightListIAM';
/** Provides access to Amazon OpenSearch resources from Amazon QuickSight */
AwsManagedPolicy.AWSQuicksightOpenSearchPolicy = 'service-role/AWSQuicksightOpenSearchPolicy';
/** Provides access to Amazon SageMaker resources from Amazon QuickSight */
AwsManagedPolicy.AWSQuickSightSageMakerPolicy = 'service-role/AWSQuickSightSageMakerPolicy';
/** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
AwsManagedPolicy.AWSQuickSightSecretsManagerWriteAccess = 'service-role/AWSQuickSightSecretsManagerWriteAccess';
/** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
AwsManagedPolicy.AWSQuickSightSecretsManagerWritePolicy = 'AWSQuickSightSecretsManagerWritePolicy';
/** AWS QuickSight access to AWS Timestream APIs. Customers can attach this policy to AWS QuickSight role to allow retrieval of data and metadata. */
AwsManagedPolicy.AWSQuickSightTimestreamPolicy = 'service-role/AWSQuickSightTimestreamPolicy';
/** Allows VPC Reachability Analyzer to access AWS resources and integrate with AWS Organizations on your behalf. */
AwsManagedPolicy.AWSReachabilityAnalyzerServiceRolePolicy = 'aws-service-role/AWSReachabilityAnalyzerServiceRolePolicy';
/** This policy grants permission to use AWS services with the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. It is intended to be attached to a local AWS profile. The policy allows uploading application artifacts and downloading the resulting artifacts from Amazon S3. It allows building applications into a container image using AWS CodeBuild and storing and retrieving the images from Amazon Elastic Container Registry (Amazon ECR). And it allows deployment of the application to container services on AWS such as Amazon Elastic Container Service (Amazon ECS), optional creation of VPC resources, optional connection to existing infrastructure such as AWS Directory Service, and other related services. */
AwsManagedPolicy.AWSRefactoringToolkitFullAccess = 'AWSRefactoringToolkitFullAccess';
/** This policy is intended to be used by Amazon ECS Tasks created for testing applications in AWS using the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. The policy grants access to download application artifacts from Amazon S3, communicate the status of the Task using AWS Systems Manager, and other required services. */
AwsManagedPolicy.AWSRefactoringToolkitSidecarPolicy = 'AWSRefactoringToolkitSidecarPolicy';
/** Provides re:Post Private access to publish CloudWatch metrics data */
AwsManagedPolicy.AWSrePostPrivateCloudWatchAccess = 'aws-service-role/AWSrePostPrivateCloudWatchAccess';
/** This policy allows the re:Post Space service to create, manage, and resolve Support cases that are created through the Space application. */
AwsManagedPolicy.AWSRepostSpaceSupportOperationsPolicy = 'AWSRepostSpaceSupportOperationsPolicy';
/** Policy for AWS Resilience Hub service role which allows access to other AWS services in order to execute assessment. */
AwsManagedPolicy.AWSResilienceHubAsssessmentExecutionPolicy = 'AWSResilienceHubAsssessmentExecutionPolicy';
/** Provides full access to AWS Resource Access Manager */
AwsManagedPolicy.AWSResourceAccessManagerFullAccess = 'AWSResourceAccessManagerFullAccess';
/** Provides read only access to AWS Resource Access Manager. */
AwsManagedPolicy.AWSResourceAccessManagerReadOnlyAccess = 'AWSResourceAccessManagerReadOnlyAccess';
/** Provides access to AWS Resource Access Manager APIs needed by a resource share participant. */
AwsManagedPolicy.AWSResourceAccessManagerResourceShareParticipantAccess = 'AWSResourceAccessManagerResourceShareParticipantAccess';
/** Policy containing Read-only AWS Resource Access Manager access to customers' Organizations structure. It also contains IAM permissions to self-delete the role. */
AwsManagedPolicy.AWSResourceAccessManagerServiceRolePolicy = 'aws-service-role/AWSResourceAccessManagerServiceRolePolicy';
/** This policy grants administrative permissions to access Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
AwsManagedPolicy.AWSResourceExplorerFullAccess = 'AWSResourceExplorerFullAccess';
/** This policy grants administrative permissions to Resource Explorer and grants read-only permissions to other AWS services to support this access. The AWS Organizations administrator needs these permissions to setup and manage multi-account search in the console. */
AwsManagedPolicy.AWSResourceExplorerOrganizationsAccess = 'AWSResourceExplorerOrganizationsAccess';
/** This policy grants read-only permissions to search for and view Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
AwsManagedPolicy.AWSResourceExplorerReadOnlyAccess = 'AWSResourceExplorerReadOnlyAccess';
/** Allows Resource Explorer to view resources and CloudTrail events on your behalf to index your resources for search. */
AwsManagedPolicy.AWSResourceExplorerServiceRolePolicy = 'aws-service-role/AWSResourceExplorerServiceRolePolicy';
/** This is the read only policy for AWS Resource Groups */
AwsManagedPolicy.AWSResourceGroupsReadOnlyAccess = 'AWSResourceGroupsReadOnlyAccess';
/** Provides full access to AWS RoboMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, IAM). */
AwsManagedPolicy.AWSRoboMakerFullAccess = 'AWSRoboMaker_FullAccess';
/** Provides read only access to AWS RoboMaker via the AWS Management Console and SDK */
AwsManagedPolicy.AWSRoboMakerReadOnlyAccess = 'AWSRoboMakerReadOnlyAccess';
/** RoboMaker service policy */
AwsManagedPolicy.AWSRoboMakerServicePolicy = 'aws-service-role/AWSRoboMakerServicePolicy';
/** RoboMaker service policy */
AwsManagedPolicy.AWSRoboMakerServiceRolePolicy = 'AWSRoboMakerServiceRolePolicy';
/** Allows IAM Roles Anywhere to publish service/usage metrics to CloudWatch and check the status of Private Certificate Authorities on your behalf. */
AwsManagedPolicy.AWSRolesAnywhereServicePolicy = 'aws-service-role/AWSRolesAnywhereServicePolicy';
/** Allow Amazon S3 on Outposts service to manage EC2 network resources on your behalf. */
AwsManagedPolicy.AWSS3OnOutpostsServiceRolePolicy = 'aws-service-role/AWSS3OnOutpostsServiceRolePolicy';
/** Provides full access to Savings Plans service */
AwsManagedPolicy.AWSSavingsPlansFullAccess = 'AWSSavingsPlansFullAccess';
/** Provides read only access to Savings Plans service */
AwsManagedPolicy.AWSSavingsPlansReadOnlyAccess = 'AWSSavingsPlansReadOnlyAccess';
/** Provides full access to use AWS Security Hub. */
AwsManagedPolicy.AWSSecurityHubFullAccess = 'AWSSecurityHubFullAccess';
/** Grants permission to enable and manage AWS Security Hub within an organization. Includes enabling the service across the organization, and determining the delegated administrator account for the service. */
AwsManagedPolicy.AWSSecurityHubOrganizationsAccess = 'AWSSecurityHubOrganizationsAccess';
/** Provides read only access to AWS Security Hub resources */
AwsManagedPolicy.AWSSecurityHubReadOnlyAccess = 'AWSSecurityHubReadOnlyAccess';
/** A service-linked role required for AWS Security Hub to access your resources. */
AwsManagedPolicy.AWSSecurityHubServiceRolePolicy = 'aws-service-role/AWSSecurityHubServiceRolePolicy';
/** This policy allows Security Hub to manage AWS Config rules and Security Hub resources in your organization and on your behalf. */
AwsManagedPolicy.AWSSecurityHubV2ServiceRolePolicy = 'aws-service-role/AWSSecurityHubV2ServiceRolePolicy';
/** Policy provides customers with Read and Write permissions to case resources that are created through the Security Incident Response service. */
AwsManagedPolicy.AWSSecurityIncidentResponseCaseFullAccess = 'AWSSecurityIncidentResponseCaseFullAccess';
/** Policy provides customers with Read and Write permissions to all resources associated to the Security Incident Response service. */
AwsManagedPolicy.AWSSecurityIncidentResponseFullAccess = 'AWSSecurityIncidentResponseFullAccess';
/** Policy provides customers with Read-only permissions to all resources associated to the Security Incident Response service. Permission includes access to GetCaseAttachmentDownloadUrl as well for the ability to get case attachment download URLs. */
AwsManagedPolicy.AWSSecurityIncidentResponseReadOnlyAccess = 'AWSSecurityIncidentResponseReadOnlyAccess';
/** Provides access to AWS Resources managed or used by Security Incident Response */
AwsManagedPolicy.AWSSecurityIncidentResponseServiceRolePolicy = 'aws-service-role/AWSSecurityIncidentResponseServiceRolePolicy';
/** Provides access to AWS Security Incident Response to continuously monitor your environment for security threats, tune security services to reduce alert noise, and gather information to investigate potential incidents. */
AwsManagedPolicy.AWSSecurityIncidentResponseTriageServiceRolePolicy = 'aws-service-role/AWSSecurityIncidentResponseTriageServiceRolePolicy';
/** Provides full access to service catalog admin capabilities */
AwsManagedPolicy.AWSServiceCatalogAdminFullAccess = 'AWSServiceCatalogAdminFullAccess';
/** Provides read-only access to Service Catalog admin capabilities */
AwsManagedPolicy.AWSServiceCatalogAdminReadOnlyAccess = 'AWSServiceCatalogAdminReadOnlyAccess';
/** Provides full access to Service Catalog App Registry capabilities */
AwsManagedPolicy.AWSServiceCatalogAppRegistryFullAccess = 'AWSServiceCatalogAppRegistryFullAccess';
/** Provides read-only access to Service Catalog App Registry capabilites */
AwsManagedPolicy.AWSServiceCatalogAppRegistryReadOnlyAccess = 'AWSServiceCatalogAppRegistryReadOnlyAccess';
/** Allows Service Catalog AppRegistry to manage Resource Groups on your behalf */
AwsManagedPolicy.AWSServiceCatalogAppRegistryServiceRolePolicy = 'aws-service-role/AWSServiceCatalogAppRegistryServiceRolePolicy';
/** Provides full access to service catalog enduser capabilities */
AwsManagedPolicy.AWSServiceCatalogEndUserFullAccess = 'AWSServiceCatalogEndUserFullAccess';
/** Provides read-only access to Service Catalog end-user capabilities */
AwsManagedPolicy.AWSServiceCatalogEndUserReadOnlyAccess = 'AWSServiceCatalogEndUserReadOnlyAccess';
/** A Service Linked Role Policy for AWS ServiceCatalog to sync with AWS Organizations organization structure */
AwsManagedPolicy.AWSServiceCatalogOrgsDataSyncServiceRolePolicy = 'aws-service-role/AWSServiceCatalogOrgsDataSyncServiceRolePolicy';
/** A Service Linked Role for AWS ServiceCatalog to sync Provisioning Artifacts from source repositories */
AwsManagedPolicy.AWSServiceCatalogSyncServiceRolePolicy = 'aws-service-role/AWSServiceCatalogSyncServiceRolePolicy';
/** Permissions required for managing nodegroups in the customer's account. These policies related to management of the following resources: AutoscalingGroups, SecurityGroups, LaunchTemplates and InstanceProfiles. */
AwsManagedPolicy.AWSServiceRoleForAmazonEKSNodegroup = 'aws-service-role/AWSServiceRoleForAmazonEKSNodegroup';
/** This Service Linked Role provides Amazon Q Developer ability to provide usage information. */
AwsManagedPolicy.AWSServiceRoleForAmazonQDeveloper = 'aws-service-role/AWSServiceRoleForAmazonQDeveloper';
/** This Service-Linked Role provides AWS Transform with the ability to provide usage information. */
AwsManagedPolicy.AWSServiceRoleForAWSTransform = 'aws-service-role/AWSServiceRoleForAWSTransform';
/** Provides access to Systems Manager resources used by CloudWatch Alarms */
AwsManagedPolicy.AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy = 'aws-service-role/AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy';
/** Allows CloudWatch to access RDS Performance Insights metrics on your behalf */
AwsManagedPolicy.AWSServiceRoleForCloudWatchMetricsDbPerfInsightsServiceRolePolicy = 'aws-service-role/AWSServiceRoleForCloudWatchMetrics_DbPerfInsightsServiceRolePolicy';
/** A service-linked role required for Amazon CodeGuru Profiler to send notifications on your behalf. */
AwsManagedPolicy.AWSServiceRoleForCodeGuruProfiler = 'aws-service-role/AWSServiceRoleForCodeGuru-Profiler';
/** This role grants permissions to CodeWhisperer to access data in your account to calculate billing, provides access to create and access security reports in Amazon CodeGuru, and emit data to CloudWatch. */
AwsManagedPolicy.AWSServiceRoleForCodeWhispererPolicy = 'aws-service-role/AWSServiceRoleForCodeWhispererPolicy';
/** Allows EC2 Scheduled Instances to launch and manage spot instances. */
AwsManagedPolicy.AWSServiceRoleForEC2ScheduledInstances = 'aws-service-role/AWSServiceRoleForEC2ScheduledInstances';
/** AWS GroundStation uses this service-linked role to invoke EC2 to find public IPv4 addresses */
AwsManagedPolicy.AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy = 'aws-service-role/AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy';
/** Allows EC2ImageBuilder to call AWS services on your behalf. */
AwsManagedPolicy.AWSServiceRoleForImageBuilder = 'aws-service-role/AWSServiceRoleForImageBuilder';
/** Allows AWS IoT SiteWise to provision and manage gateways as well as query data. The policy includes required AWS Greengrass permissions for deploying to groups, AWS Lambda permissions for creating and updating service-prefixed functions, and AWS IoT Analytics permissions for querying data from datastores. */
AwsManagedPolicy.AWSServiceRoleForIoTSiteWise = 'aws-service-role/AWSServiceRoleForIoTSiteWise';
/** Allows Log Delivery service to deliver logs by calling log destination on your behalf. */
AwsManagedPolicy.AWSServiceRoleForLogDeliveryPolicy = 'aws-service-role/AWSServiceRoleForLogDeliveryPolicy';
/** Grants Amazon Monitron permissions to manage AWS resources, including AWS SSO user assignment on your behalf. */
AwsManagedPolicy.AWSServiceRoleForMonitronPolicy = 'aws-service-role/AWSServiceRoleForMonitronPolicy';
/** Provides Cloudwatch access to publish operational and usage metrics and logs for Amazon Neptune */
AwsManagedPolicy.AWSServiceRoleForNeptuneGraphPolicy = 'aws-service-role/AWSServiceRoleForNeptuneGraphPolicy';
/** Provides permissions to describe and update Private Marketplace resources and describe AWS Organizations */
AwsManagedPolicy.AWSServiceRoleForPrivateMarketplaceAdminPolicy = 'aws-service-role/AWSServiceRoleForPrivateMarketplaceAdminPolicy';
/** Policy for Procurement Insights to obtain Organization Account details */
AwsManagedPolicy.AWSServiceRoleForProcurementInsightsPolicy = 'aws-service-role/AWSServiceRoleForProcurementInsightsPolicy';
/** Provides access to AWS services and resources necessary to migrate service instances into AWS including EC2, S3 and Cloudformation. */
AwsManagedPolicy.AWSServiceRoleForSMS = 'aws-service-role/AWSServiceRoleForSMS';
/** Provides access to the User Subscriptions service to your Identity Center resources to automatically update your subscriptions. */
AwsManagedPolicy.AWSServiceRoleForUserSubscriptions = 'aws-service-role/AWSServiceRoleForUserSubscriptions';
/** Provides AWS Backup permissions to create compliance reports on your behalf */
AwsManagedPolicy.AWSServiceRolePolicyForBackupReports = 'aws-service-role/AWSServiceRolePolicyForBackupReports';
/** This policy contains permissions for testing restores and for cleaning up resources created during tests. */
AwsManagedPolicy.AWSServiceRolePolicyForBackupRestoreTesting = 'aws-service-role/AWSServiceRolePolicyForBackupRestoreTesting';
/** This managed policy provides administrative access to Amazon WorkSpaces to manage EC2 instances in your AWS account */
AwsManagedPolicy.AWSServiceRolePolicyForWorkspacesInstances = 'aws-service-role/AWSServiceRolePolicyForWorkspacesInstances';
/** Provides the AWS DDoS Response Team with limited access to your AWS account to assist with DDoS attack mitigation during a high-severity event. */
AwsManagedPolicy.AWSShieldDRTAccessPolicy = 'service-role/AWSShieldDRTAccessPolicy';
/** Allows AWS Shield to access AWS resources on your behalf to provide DDoS protection. */
AwsManagedPolicy.AWSShieldServiceRolePolicy = 'aws-service-role/AWSShieldServiceRolePolicy';
/** Provides access to publish metrics and provide insights for your social message sending. */
AwsManagedPolicy.AWSSocialMessagingServiceRolePolicy = 'aws-service-role/AWSSocialMessagingServiceRolePolicy';
/** Provides AWS Systems Manager for SAP with the permissions needed to manage and integrate SAP software with AWS. */
AwsManagedPolicy.AWSSSMForSAPServiceLinkedRolePolicy = 'aws-service-role/AWSSSMForSAPServiceLinkedRolePolicy';
/** Policy for Service Linked Role AWSServiceRoleForAmazonSSM_OpsInsights */
AwsManagedPolicy.AWSSSMOpsInsightsServiceRolePolicy = 'aws-service-role/AWSSSMOpsInsightsServiceRolePolicy';
/** Administrator access for SSO Directory */
AwsManagedPolicy.AWSSSODirectoryAdministrator = 'AWSSSODirectoryAdministrator';
/** ReadOnly access for SSO Directory */
AwsManagedPolicy.AWSSSODirectoryReadOnly = 'AWSSSODirectoryReadOnly';
/** Provides access within AWS SSO to manage AWS Organizations master and member accounts and cloud application */
AwsManagedPolicy.AWSSSOMasterAccountAdministrator = 'AWSSSOMasterAccountAdministrator';
/** Provides access within AWS SSO to manage AWS Organizations member accounts and cloud application */
AwsManagedPolicy.AWSSSOMemberAccountAdministrator = 'AWSSSOMemberAccountAdministrator';
/** Provides read only access to AWS SSO configurations. */
AwsManagedPolicy.AWSSSOReadOnly = 'AWSSSOReadOnly';
/** Grants AWS SSO permissions to manage AWS resources, including IAM roles, policies and SAML IdP on your behalf. */
AwsManagedPolicy.AWSSSOServiceRolePolicy = 'aws-service-role/AWSSSOServiceRolePolicy';
/** An access policy for providing a user/role/etc access to the AWS StepFunctions console. For a full console experience, in addition to this policy, a user may need iam:PassRole permission on other IAM roles that can be assumed by the service. */
AwsManagedPolicy.AWSStepFunctionsConsoleFullAccess = 'AWSStepFunctionsConsoleFullAccess';
/** An access policy for providing a user/role/etc access to the AWS StepFunctions API. For full access, in addition to this policy, a user MUST have iam:PassRole permission on at least one IAM role that can be assumed by the service. */
AwsManagedPolicy.AWSStepFunctionsFullAccess = 'AWSStepFunctionsFullAccess';
/** An access policy for providing a user/role/etc read only access to the AWS StepFunctions service. */
AwsManagedPolicy.AWSStepFunctionsReadOnlyAccess = 'AWSStepFunctionsReadOnlyAccess';
/** Provides full access to AWS Storage Gateway via the AWS Management Console. */
AwsManagedPolicy.AWSStorageGatewayFullAccess = 'AWSStorageGatewayFullAccess';
/** Provides access to AWS Storage Gateway via the AWS Management Console. */
AwsManagedPolicy.AWSStorageGatewayReadOnlyAccess = 'AWSStorageGatewayReadOnlyAccess';
/** Service-linked role used by AWS Storage Gateway to enable integration of other AWS services with Storage Gateway. */
AwsManagedPolicy.AWSStorageGatewayServiceRolePolicy = 'aws-service-role/AWSStorageGatewayServiceRolePolicy';
/** AWSSupplyChainFederationAdminAccess provides AWS Supply Chain federated users access to the AWS Supply Chain application, including the required permissions to perform actions within the AWS Supply Chain application. The policy provides administrative permissions over IAM Identity Center users and groups and is attached to a role created by AWS Supply Chain on your behalf. You shouldn't attach AWSSupplyChainFederationAdminAccess policy to any other IAM entities. */
AwsManagedPolicy.AWSSupplyChainFederationAdminAccess = 'service-role/AWSSupplyChainFederationAdminAccess';
/** Allows users to access the AWS Support Center. */
AwsManagedPolicy.AWSSupportAccess = 'AWSSupportAccess';
/** Provides full access to the AWS Support App and other required services, such as AWS Support and Service Quotas. This policy includes permissions to use the supporting services so that the user can contact AWS Support for support cases, change service quotas, and create the relevant service-linked roles. */
AwsManagedPolicy.AWSSupportAppFullAccess = 'AWSSupportAppFullAccess';
/** Provides read-only access to the AWS Support App. */
AwsManagedPolicy.AWSSupportAppReadOnlyAccess = 'AWSSupportAppReadOnlyAccess';
/** Provides full access to supportplans. */
AwsManagedPolicy.AWSSupportPlansFullAccess = 'AWSSupportPlansFullAccess';
/** Provides read-only access to supportplans. */
AwsManagedPolicy.AWSSupportPlansReadOnlyAccess = 'AWSSupportPlansReadOnlyAccess';
/** Allows AWS Support to access AWS resources to provide billing, administrative, and support services. */
AwsManagedPolicy.AWSSupportServiceRolePolicy = 'aws-service-role/AWSSupportServiceRolePolicy';
/** Grants AWS Systems Manager (SSM) permission to discover AWS account information. */
AwsManagedPolicy.AWSSystemsManagerAccountDiscoveryServicePolicy = 'aws-service-role/AWSSystemsManagerAccountDiscoveryServicePolicy';
/** Provides access to AWS resources managed or used by the AWS Systems Manager change management framework. */
AwsManagedPolicy.AWSSystemsManagerChangeManagementServicePolicy = 'aws-service-role/AWSSystemsManagerChangeManagementServicePolicy';
/** Provides permissions for AWS Systems Manager Quick Setup to enable and configure AWS Config configuration recording. */
AwsManagedPolicy.AWSSystemsManagerEnableConfigRecordingExecutionPolicy = 'AWSSystemsManagerEnableConfigRecordingExecutionPolicy';
/** This policy grants administrative permissions for enabling Explorer, a capability of AWS Systems Manager. This includes permissions to update related Systems Manager service settings, and to create a service-linked role for Systems Manager. */
AwsManagedPolicy.AWSSystemsManagerEnableExplorerExecutionPolicy = 'AWSSystemsManagerEnableExplorerExecutionPolicy';
/** Provides full access to AWS Systems Manager for SAP service */
AwsManagedPolicy.AWSSystemsManagerForSAPFullAccess = 'AWSSystemsManagerForSAPFullAccess';
/** Provides read only access to AWS Systems Manager for SAP service */
AwsManagedPolicy.AWSSystemsManagerForSAPReadOnlyAccess = 'AWSSystemsManagerForSAPReadOnlyAccess';
/** Provides access to AWS resources managed or used by the AWS Systems Manager just in time access framework. */
AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessServicePolicy = 'aws-service-role/AWSSystemsManagerJustInTimeAccessServicePolicy';
/** The managed policy AWSSystemsManagerJustInTimeAccessTokenPolicy allows Systems Manager to generate access tokens used for just-in-time node access. */
AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessTokenPolicy = 'AWSSystemsManagerJustInTimeAccessTokenPolicy';
/** The managed policy AWSSystemsManagerJustInTimeAccessTokenSessionPolicy allows Systems Manager to apply scoped down permissions to a just-in-time node access session once it is started. */
AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessTokenSessionPolicy = 'AWSSystemsManagerJustInTimeAccessTokenSessionPolicy';
/** This policy allows Systems Manager to share a deny-access policy for just-in-time node access from the delegated administrator account to member accounts, and replicate the policy to multiple Regions. */
AwsManagedPolicy.AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy = 'AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy';
/** Permissions required to collect information about a user for Just-In-Time-Node-Access notifications. */
AwsManagedPolicy.AWSSystemsManagerNotificationsServicePolicy = 'aws-service-role/AWSSystemsManagerNotificationsServicePolicy';
/** IAM role for SSM Explorer to manage OpsData related operations */
AwsManagedPolicy.AWSSystemsManagerOpsDataSyncServiceRolePolicy = 'aws-service-role/AWSSystemsManagerOpsDataSyncServiceRolePolicy';
/** This policy grants the AWS Portal Asset Server the necessary permissions required for normal operation. */
AwsManagedPolicy.AWSThinkboxAssetServerPolicy = 'AWSThinkboxAssetServerPolicy';
/** This policy grants AWS Thinkbox's Deadline software full access to multiple AWS services as required for AWS Portal administration. This includes access to create arbitrary tags on several EC2 resource types. */
AwsManagedPolicy.AWSThinkboxAWSPortalAdminPolicy = 'AWSThinkboxAWSPortalAdminPolicy';
/** This policy grants the AWS Portal Gateway machine the necessary permissions required for normal operation. */
AwsManagedPolicy.AWSThinkboxAWSPortalGatewayPolicy = 'AWSThinkboxAWSPortalGatewayPolicy';
/** This policy grants the Deadline Workers in AWS Portal the necessary permissions required for normal operation. */
AwsManagedPolicy.AWSThinkboxAWSPortalWorkerPolicy = 'AWSThinkboxAWSPortalWorkerPolicy';
/** Grants permissions required for the operation of AWS Thinkbox's Deadline Resource Tracker.  This includes full access to some EC2 actions, including DeleteFleets and CancelSpotFleetRequests. */
AwsManagedPolicy.AWSThinkboxDeadlineResourceTrackerAccessPolicy = 'AWSThinkboxDeadlineResourceTrackerAccessPolicy';
/** Grants permissions required to create, destroy, and administer AWS Thinkbox's Deadline Resource Tracker. */
AwsManagedPolicy.AWSThinkboxDeadlineResourceTrackerAdminPolicy = 'AWSThinkboxDeadlineResourceTrackerAdminPolicy';
/** Grants permissions required for AWS Thinkbox's Deadline Spot Event Plugin.  This includes permission to request, modify, and cancel a spot fleet, as well as limited PassRole permission. */
AwsManagedPolicy.AWSThinkboxDeadlineSpotEventPluginAdminPolicy = 'AWSThinkboxDeadlineSpotEventPluginAdminPolicy';
/** Grant permissions required for an EC2 instance running AWS Thinkbox Deadline Spot Event Plugin Worker software. */
AwsManagedPolicy.AWSThinkboxDeadlineSpotEventPluginWorkerPolicy = 'AWSThinkboxDeadlineSpotEventPluginWorkerPolicy';
/** Provides full access to AWS Transfer via the AWS Management Console */
AwsManagedPolicy.AWSTransferConsoleFullAccess = 'AWSTransferConsoleFullAccess';
/** Provides full access to AWS Transfer Service. */
AwsManagedPolicy.AWSTransferFullAccess = 'AWSTransferFullAccess';
/** Allows AWS Transfer full access to create log streams and groups and put log events to your account */
AwsManagedPolicy.AWSTransferLoggingAccess = 'service-role/AWSTransferLoggingAccess';
/** Provide readonly access to AWS Transfer services. */
AwsManagedPolicy.AWSTransferReadOnlyAccess = 'AWSTransferReadOnlyAccess';
/** Provides full access to AWS Trusted Advisor Priority. This policy also enables the user to add Trusted Advisor as a trusted service with AWS Organizations and to specify delegated administrator accounts for Trusted Advisor Priority. */
AwsManagedPolicy.AWSTrustedAdvisorPriorityFullAccess = 'AWSTrustedAdvisorPriorityFullAccess';
/** Provides read-only access to AWS Trusted Advisor Priority. This includes permission to view the delegated administrator accounts. */
AwsManagedPolicy.AWSTrustedAdvisorPriorityReadOnlyAccess = 'AWSTrustedAdvisorPriorityReadOnlyAccess';
/** Service Policy for Trusted Advisor Multi-account Reporting */
AwsManagedPolicy.AWSTrustedAdvisorReportingServiceRolePolicy = 'aws-service-role/AWSTrustedAdvisorReportingServiceRolePolicy';
/** Access for the AWS Trusted Advisor Service to help reduce cost, increase performance, and improve security of your AWS environment. */
AwsManagedPolicy.AWSTrustedAdvisorServiceRolePolicy = 'aws-service-role/AWSTrustedAdvisorServiceRolePolicy';
/** Allows AWS User Notifications to call AWS services on your behalf. */
AwsManagedPolicy.AWSUserNotificationsServiceLinkedRolePolicy = 'aws-service-role/AWSUserNotificationsServiceLinkedRolePolicy';
/** Provides full access for viewing entitled Vendor Insights resources and managing Vendor Insights subscriptions */
AwsManagedPolicy.AWSVendorInsightsAssessorFullAccess = 'AWSVendorInsightsAssessorFullAccess';
/** Provides read-only access for viewing entitled Vendor Insights resources */
AwsManagedPolicy.AWSVendorInsightsAssessorReadOnly = 'AWSVendorInsightsAssessorReadOnly';
/** Provides full access for creating and managing the Vendor Insights resources */
AwsManagedPolicy.AWSVendorInsightsVendorFullAccess = 'AWSVendorInsightsVendorFullAccess';
/** Provides read-only access for viewing the Vendor Insights resources */
AwsManagedPolicy.AWSVendorInsightsVendorReadOnly = 'AWSVendorInsightsVendorReadOnly';
/** Allows VPC Lattice to access AWS resources on your behalf. */
AwsManagedPolicy.AWSVpcLatticeServiceRolePolicy = 'aws-service-role/AWSVpcLatticeServiceRolePolicy';
/** Allow Site-to-Site VPN to create and manage resources related to your VPN Connections. */
AwsManagedPolicy.AWSVPCS2SVpnServiceRolePolicy = 'aws-service-role/AWSVPCS2SVpnServiceRolePolicy';
/** Allow VPC Transit Gateway to create and manage necessary resources for your Transit Gateway VPC Attachments. */
AwsManagedPolicy.AWSVPCTransitGatewayServiceRolePolicy = 'aws-service-role/AWSVPCTransitGatewayServiceRolePolicy';
/** Policy to enable AWS Verified Access service to provision endpoints on your behalf */
AwsManagedPolicy.AWSVPCVerifiedAccessServiceRolePolicy = 'aws-service-role/AWSVPCVerifiedAccessServiceRolePolicy';
/** Provides full access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list and update Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
AwsManagedPolicy.AWSWAFConsoleFullAccess = 'AWSWAFConsoleFullAccess';
/** Provides read-only access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
AwsManagedPolicy.AWSWAFConsoleReadOnlyAccess = 'AWSWAFConsoleReadOnlyAccess';
/** Provides full access to AWS WAF actions. */
AwsManagedPolicy.AWSWAFFullAccess = 'AWSWAFFullAccess';
/** Provides read only access to AWS WAF actions. */
AwsManagedPolicy.AWSWAFReadOnlyAccess = 'AWSWAFReadOnlyAccess';
/** Allows WellArchitected to access AWS services and resources that relate to WellArchitected resources on behalf of customers. */
AwsManagedPolicy.AWSWellArchitectedDiscoveryServiceRolePolicy = 'aws-service-role/AWSWellArchitectedDiscoveryServiceRolePolicy';
/** Allows Well-Architected to access Organizations on your behalf. */
AwsManagedPolicy.AWSWellArchitectedOrganizationsServiceRolePolicy = 'aws-service-role/AWSWellArchitectedOrganizationsServiceRolePolicy';
/** This policy grants full administrative permissions to the Wickr service, including the Wickr administrative functions under the AWS Management Console. */
AwsManagedPolicy.AWSWickrFullAccess = 'AWSWickrFullAccess';
/** Provides capabilities to manage Observability Access Manager links and establish sharing of X-Ray traces */
AwsManagedPolicy.AWSXrayCrossAccountSharingConfiguration = 'AWSXrayCrossAccountSharingConfiguration';
/** Allow the AWS X-Ray Daemon to relay raw trace segments data to the service's API and retrieve sampling data (rules, targets, etc.) to be used by the X-Ray SDK. */
AwsManagedPolicy.AWSXRayDaemonWriteAccess = 'AWSXRayDaemonWriteAccess';
/** AWS X-Ray full access managed policy */
AwsManagedPolicy.AWSXrayFullAccess = 'AWSXrayFullAccess';
/** AWS X-Ray read only managed policy */
AwsManagedPolicy.AWSXrayReadOnlyAccess = 'AWSXrayReadOnlyAccess';
/** AWS X-Ray write only managed policy */
AwsManagedPolicy.AWSXrayWriteOnlyAccess = 'AWSXrayWriteOnlyAccess';
/** Provides administrative access for ARC zonal shift practice runs, and access to CloudWatch alarm statuses to monitor practice runs. */
AwsManagedPolicy.AWSZonalAutoshiftPracticeRunSLRPolicy = 'aws-service-role/AWSZonalAutoshiftPracticeRunSLRPolicy';
/** Provides access for the AWS Batch service to manage the required resources, including Amazon EC2 and Amazon ECS resources. */
AwsManagedPolicy.BatchServiceRolePolicy = 'aws-service-role/BatchServiceRolePolicy';
/** Grants permissions for billing and cost management. This includes viewing account usage and viewing and modifying budgets and payment methods. */
AwsManagedPolicy.Billing = 'job-function/Billing';
/** Amazon Certificate Manager Service Role Policy */
AwsManagedPolicy.CertificateManagerServiceRolePolicy = 'aws-service-role/CertificateManagerServiceRolePolicy';
/** Policy to enable AWS Client VPN to manage your Client VPN endpoint connections. */
AwsManagedPolicy.ClientVPNServiceConnectionsRolePolicy = 'aws-service-role/ClientVPNServiceConnectionsRolePolicy';
/** Policy to enable AWS Client VPN to manage your Client VPN endpoints. */
AwsManagedPolicy.ClientVPNServiceRolePolicy = 'aws-service-role/ClientVPNServiceRolePolicy';
/** Service Role for CloudFormation StackSets (Organization Master Account) */
AwsManagedPolicy.CloudFormationStackSetsOrgAdminServiceRolePolicy = 'aws-service-role/CloudFormationStackSetsOrgAdminServiceRolePolicy';
/** Service Role for CloudFormation StackSets (Organization Member Account) */
AwsManagedPolicy.CloudFormationStackSetsOrgMemberServiceRolePolicy = 'aws-service-role/CloudFormationStackSetsOrgMemberServiceRolePolicy';
/** Provides full access to the CloudFront console plus the ability to list Amazon S3 buckets via the AWS Management Console. */
AwsManagedPolicy.CloudFrontFullAccess = 'CloudFrontFullAccess';
/** Provides access to CloudFront distribution configuration information and list distributions via the AWS Management Console. */
AwsManagedPolicy.CloudFrontReadOnlyAccess = 'CloudFrontReadOnlyAccess';
/** Enables access to AWS resources used or managed by CloudHSM */
AwsManagedPolicy.CloudHSMServiceRolePolicy = 'aws-service-role/CloudHSMServiceRolePolicy';
/** Provides full access to the Amazon CloudSearch configuration service. */
AwsManagedPolicy.CloudSearchFullAccess = 'CloudSearchFullAccess';
/** Provides read only access to the Amazon CloudSearch configuration service. */
AwsManagedPolicy.CloudSearchReadOnlyAccess = 'CloudSearchReadOnlyAccess';
/** This service linked role allows CloudTrail to get and add resource tags to the resource owner's CloudTrail events. */
AwsManagedPolicy.CloudTrailEventContext = 'aws-service-role/CloudTrailEventContext';
/** Permission policy for CloudTrail ServiceLinkedRole */
AwsManagedPolicy.CloudTrailServiceRolePolicy = 'aws-service-role/CloudTrailServiceRolePolicy';
/** Allows CloudWatch to assume CloudWatch-CrossAccountSharing roles in remote accounts on behalf of the current account in order to display data cross-account, cross-region */
AwsManagedPolicy.CloudWatchCrossAccountAccess = 'aws-service-role/CloudWatch-CrossAccountAccess';
/** Provides read-only access to CloudWatch alarms and metrics as well as EC2 metadata. Provides access to Stop, Terminate and Reboot EC2 instances. */
AwsManagedPolicy.CloudWatchActionsEC2Access = 'CloudWatchActionsEC2Access';
/** Full permissions required to use AmazonCloudWatchAgent. */
AwsManagedPolicy.CloudWatchAgentAdminPolicy = 'CloudWatchAgentAdminPolicy';
/** Permissions required to use AmazonCloudWatchAgent on servers */
AwsManagedPolicy.CloudWatchAgentServerPolicy = 'CloudWatchAgentServerPolicy';
/** Provides full access to CloudWatch Application Insights and required dependencies. */
AwsManagedPolicy.CloudWatchApplicationInsightsFullAccess = 'CloudWatchApplicationInsightsFullAccess';
/** Provides read only access to CloudWatch Application Insights. */
AwsManagedPolicy.CloudWatchApplicationInsightsReadOnlyAccess = 'CloudWatchApplicationInsightsReadOnlyAccess';
/** Cloudwatch Application Insights Service Linked Role Policy */
AwsManagedPolicy.CloudwatchApplicationInsightsServiceLinkedRolePolicy = 'aws-service-role/CloudwatchApplicationInsightsServiceLinkedRolePolicy';
/** Provide full access to CloudWatch Application Signals service and scoped access to the dependencies needed to use and operate this service. */
AwsManagedPolicy.CloudWatchApplicationSignalsFullAccess = 'CloudWatchApplicationSignalsFullAccess';
/** Provides read only access to CloudWatch Application Signals service and scoped access to the dependencies needed to use this service */
AwsManagedPolicy.CloudWatchApplicationSignalsReadOnlyAccess = 'CloudWatchApplicationSignalsReadOnlyAccess';
/** Policy grants permission to CloudWatch Application Signals to collect monitoring and tagging data from other relevant AWS services. */
AwsManagedPolicy.CloudWatchApplicationSignalsServiceRolePolicy = 'aws-service-role/CloudWatchApplicationSignalsServiceRolePolicy';
/** Provides access to the non-CloudWatch APIs used to display CloudWatch Automatic Dashboards, including the contents of objects such as Lambda functions */
AwsManagedPolicy.CloudWatchAutomaticDashboardsAccess = 'CloudWatchAutomaticDashboardsAccess';
/** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch resources */
AwsManagedPolicy.CloudWatchCrossAccountSharingConfiguration = 'CloudWatchCrossAccountSharingConfiguration';
/** Allows built-in targets in Amazon CloudWatch Events to perform EC2 actions on your behalf. */
AwsManagedPolicy.CloudWatchEventsBuiltInTargetExecutionAccess = 'service-role/CloudWatchEventsBuiltInTargetExecutionAccess';
/** Provides full access to Amazon CloudWatch Events. */
AwsManagedPolicy.CloudWatchEventsFullAccess = 'CloudWatchEventsFullAccess';
/** Allows Amazon CloudWatch Events to relay events to the streams in AWS Kinesis Streams in your account. */
AwsManagedPolicy.CloudWatchEventsInvocationAccess = 'service-role/CloudWatchEventsInvocationAccess';
/** Provides read only access to Amazon CloudWatch Events. */
AwsManagedPolicy.CloudWatchEventsReadOnlyAccess = 'CloudWatchEventsReadOnlyAccess';
/** Allow AWS CloudWatch to execute actions on your behalf configured through alarms and events. */
AwsManagedPolicy.CloudWatchEventsServiceRolePolicy = 'aws-service-role/CloudWatchEventsServiceRolePolicy';
/** Provides full access to CloudWatch. */
AwsManagedPolicy.CloudWatchFullAccess = 'CloudWatchFullAccess';
/** Provides full access to CloudWatch. */
AwsManagedPolicy.CloudWatchFullAccessV2 = 'CloudWatchFullAccessV2';
/** Provides full access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services, such as Amazon CloudWatch, Amazon EC2, Amazon CloudFront, Amazon WorkSpaces, and Elastic Load Balancing, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
AwsManagedPolicy.CloudWatchInternetMonitorFullAccess = 'CloudWatchInternetMonitorFullAccess';
/** Provides read only access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services in Amazon CloudWatch, including policies to retrieve information on CloudWatch metrics and to manage log queries, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
AwsManagedPolicy.CloudWatchInternetMonitorReadOnlyAccess = 'CloudWatchInternetMonitorReadOnlyAccess';
/** Allows Internet Monitor to access EC2, Workspaces, and CloudFront resources, and other required services on your behalf. */
AwsManagedPolicy.CloudWatchInternetMonitorServiceRolePolicy = 'aws-service-role/CloudWatchInternetMonitorServiceRolePolicy';
/** Provides write access to X-Ray and CloudWatch Application Signals log group. */
AwsManagedPolicy.CloudWatchLambdaApplicationSignalsExecutionRolePolicy = 'CloudWatchLambdaApplicationSignalsExecutionRolePolicy';
/** Policy required for the Lambda Insights Extension */
AwsManagedPolicy.CloudWatchLambdaInsightsExecutionRolePolicy = 'CloudWatchLambdaInsightsExecutionRolePolicy';
/** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch Logs resources */
AwsManagedPolicy.CloudWatchLogsCrossAccountSharingConfiguration = 'CloudWatchLogsCrossAccountSharingConfiguration';
/** Provides full access to CloudWatch Logs */
AwsManagedPolicy.CloudWatchLogsFullAccess = 'CloudWatchLogsFullAccess';
/** Provides read only access to CloudWatch Logs */
AwsManagedPolicy.CloudWatchLogsReadOnlyAccess = 'CloudWatchLogsReadOnlyAccess';
/** You can use this policy in IAM roles that are attached to Amazon EC2 and Amazon EKS instance resources to send telemetry reports (metrics) to a Network Flow Monitor endpoint. */
AwsManagedPolicy.CloudWatchNetworkFlowMonitorAgentPublishPolicy = 'CloudWatchNetworkFlowMonitorAgentPublishPolicy';
/** You can't attach CloudWatchNetworkFlowMonitorServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor, which publishes network telemetry aggregation results, collected by Network Flow Monitor agents, to CloudWatch. It also allows the service to use AWS Organizations to get information for multi-account scenarios. */
AwsManagedPolicy.CloudWatchNetworkFlowMonitorServiceRolePolicy = 'aws-service-role/CloudWatchNetworkFlowMonitorServiceRolePolicy';
/** You can't attach CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor_Topology, which generates topology snapshots of resources used by Network Flow Monitor in your account. */
AwsManagedPolicy.CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy = 'aws-service-role/CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy';
/** Allows CloudWatch Network Monitor to access and manage EC2 and VPC resources, publish data to CloudWatch and access other required services on your behalf. */
AwsManagedPolicy.CloudWatchNetworkMonitorServiceRolePolicy = 'aws-service-role/CloudWatchNetworkMonitorServiceRolePolicy';
/** This policy provides user access to view OpenSearch dashboards on the CloudWatch Logs console. */
AwsManagedPolicy.CloudWatchOpenSearchDashboardAccess = 'CloudWatchOpenSearchDashboardAccess';
/** This policy provides user access to create integration with OpenSearch to create, update, delete or view dashboards on the CloudWatch Logs console. */
AwsManagedPolicy.CloudWatchOpenSearchDashboardsFullAccess = 'CloudWatchOpenSearchDashboardsFullAccess';
/** Provides read only access to CloudWatch. */
AwsManagedPolicy.CloudWatchReadOnlyAccess = 'CloudWatchReadOnlyAccess';
/** Provides full access to CloudWatch Synthetics. */
AwsManagedPolicy.CloudWatchSyntheticsFullAccess = 'CloudWatchSyntheticsFullAccess';
/** Provides read only access to CloudWatch Synthetics. */
AwsManagedPolicy.CloudWatchSyntheticsReadOnlyAccess = 'CloudWatchSyntheticsReadOnlyAccess';
/** Policy for AWS Comprehend service role which allows access to S3 resources for data access */
AwsManagedPolicy.ComprehendDataAccessRolePolicy = 'service-role/ComprehendDataAccessRolePolicy';
/** Provides full access to Amazon Comprehend. */
AwsManagedPolicy.ComprehendFullAccess = 'ComprehendFullAccess';
/** Provides full access to Amazon Comprehend Medical */
AwsManagedPolicy.ComprehendMedicalFullAccess = 'ComprehendMedicalFullAccess';
/** Provides read-only access to Amazon Comprehend. */
AwsManagedPolicy.ComprehendReadOnly = 'ComprehendReadOnly';
/** Provides read only access to ComputeOptimizer. */
AwsManagedPolicy.ComputeOptimizerReadOnlyAccess = 'ComputeOptimizerReadOnlyAccess';
/** Allows ComputeOptimizer to call AWS services and collect workload details on your behalf. */
AwsManagedPolicy.ComputeOptimizerServiceRolePolicy = 'aws-service-role/ComputeOptimizerServiceRolePolicy';
/** Policy needed for AWSConfig to create conformance packs */
AwsManagedPolicy.ConfigConformsServiceRolePolicy = 'aws-service-role/ConfigConformsServiceRolePolicy';
/** This managed policy provides admin access to Cost Optimization Hub. */
AwsManagedPolicy.CostOptimizationHubAdminAccess = 'CostOptimizationHubAdminAccess';
/** This managed policy provides read-only access to Cost Optimization Hub. */
AwsManagedPolicy.CostOptimizationHubReadOnlyAccess = 'CostOptimizationHubReadOnlyAccess';
/** Allows Cost Optimization Hub to retrieve organization information and collect optimization-related data and metadata. */
AwsManagedPolicy.CostOptimizationHubServiceRolePolicy = 'aws-service-role/CostOptimizationHubServiceRolePolicy';
/** Allows Amazon Connect Customer Profiles to access AWS services and resources on your behalf. */
AwsManagedPolicy.CustomerProfilesServiceLinkedRolePolicy = 'aws-service-role/CustomerProfilesServiceLinkedRolePolicy';
/** Grants full access permissions to AWS services and actions required to set up and configure AWS database services. */
AwsManagedPolicy.DatabaseAdministrator = 'job-function/DatabaseAdministrator';
/** Grants permissions to AWS data analytics services. */
AwsManagedPolicy.DataScientist = 'job-function/DataScientist';
/** This policy allows DAX to create and manage Network interface, Security group, Subnet and Vpc on behalf of customer */
AwsManagedPolicy.DAXServiceRolePolicy = 'aws-service-role/DAXServiceRolePolicy';
/** Provides access to read-only APIs needed to run EC2 Declarative Policies Account Status Report. */
AwsManagedPolicy.DeclarativePoliciesEC2Report = 'aws-service-role/DeclarativePoliciesEC2Report';
/** Permissions required to support Amazon CloudWatch Contributor Insights for Amazon DynamoDB. */
AwsManagedPolicy.DynamoDBCloudWatchContributorInsightsServiceRolePolicy = 'aws-service-role/DynamoDBCloudWatchContributorInsightsServiceRolePolicy';
/** Provide AWS DynamoDB access to KinesisDataStreams */
AwsManagedPolicy.DynamoDBKinesisReplicationServiceRolePolicy = 'aws-service-role/DynamoDBKinesisReplicationServiceRolePolicy';
/** Permissions required by DynamoDB for cross-region data replication */
AwsManagedPolicy.DynamoDBReplicationServiceRolePolicy = 'aws-service-role/DynamoDBReplicationServiceRolePolicy';
/** This policy grants full access to EC2 Fast Launch actions */
AwsManagedPolicy.EC2FastLaunchFullAccess = 'EC2FastLaunchFullAccess';
/** Policy grants ec2fastlaunch to prepare and manage preprovisioned snapshots in customer's account & publish related metrics. */
AwsManagedPolicy.EC2FastLaunchServiceRolePolicy = 'aws-service-role/EC2FastLaunchServiceRolePolicy';
/** Policy granting permissions to EC2 Fleet to launch instances in the future. */
AwsManagedPolicy.EC2FleetTimeShiftableServiceRolePolicy = 'aws-service-role/EC2FleetTimeShiftableServiceRolePolicy';
/** Permissions need by EC2 Image Builder to perform a cross account distribution. */
AwsManagedPolicy.Ec2ImageBuilderCrossAccountDistributionAccess = 'Ec2ImageBuilderCrossAccountDistributionAccess';
/** The EC2ImageBuilderLifecycleExecutionPolicy policy grants permissions for Image Builder to perform actions such as deprecate or delete Image Builder image resources and their underlying resources (AMIs, snapshots) to support automated rules for image lifecycle management tasks. */
AwsManagedPolicy.EC2ImageBuilderLifecycleExecutionPolicy = 'service-role/EC2ImageBuilderLifecycleExecutionPolicy';
/** Allows customers to call EC2 Instance Connect to publish ephemeral keys to their EC2 instances and connect via ssh or the EC2 Instance Connect CLI. */
AwsManagedPolicy.EC2InstanceConnect = 'EC2InstanceConnect';
/** EC2 Instance Connect endpoint policy to manage EC2 Instance Connect endpoints created by the customer */
AwsManagedPolicy.Ec2InstanceConnectEndpoint = 'aws-service-role/Ec2InstanceConnectEndpoint';
/** EC2 Instance profile for Image Builder service. */
AwsManagedPolicy.EC2InstanceProfileForImageBuilder = 'EC2InstanceProfileForImageBuilder';
/** EC2 Instance profile for building container images with EC2 Image Builder. This policy grants the user broad permissions to upload ECR images. */
AwsManagedPolicy.EC2InstanceProfileForImageBuilderECRContainerBuilds = 'EC2InstanceProfileForImageBuilderECRContainerBuilds';
/** Enables access to AWS Services and Resources used or managed by ECR Replication */
AwsManagedPolicy.ECRReplicationServiceRolePolicy = 'aws-service-role/ECRReplicationServiceRolePolicy';
/** Allows actions to be performed when using AWS ECR repository creation templates */
AwsManagedPolicy.ECRTemplateServiceRolePolicy = 'aws-service-role/ECRTemplateServiceRolePolicy';
/** This policy allows ElastiCache to manage AWS resources on your behalf as necessary for managing your cache */
AwsManagedPolicy.ElastiCacheServiceRolePolicy = 'aws-service-role/ElastiCacheServiceRolePolicy';
/** Provides full access to Amazon ElasticLoadBalancing, and limited access to other services necessary to provide ElasticLoadBalancing features. */
AwsManagedPolicy.ElasticLoadBalancingFullAccess = 'ElasticLoadBalancingFullAccess';
/** Provides read only access to Amazon ElasticLoadBalancing and dependent services */
AwsManagedPolicy.ElasticLoadBalancingReadOnly = 'ElasticLoadBalancingReadOnly';
/** Access to view purchased assets and download related software and kickstart files */
AwsManagedPolicy.ElementalActivationsDownloadSoftwareAccess = 'ElementalActivationsDownloadSoftwareAccess';
/** Full access to view and take action on Elemental Appliances and Software purchased assets */
AwsManagedPolicy.ElementalActivationsFullAccess = 'ElementalActivationsFullAccess';
/** Access to view purchased assets and generate software licenses for pending activations */
AwsManagedPolicy.ElementalActivationsGenerateLicenses = 'ElementalActivationsGenerateLicenses';
/** Read-only access to the detailed list of purchased assets associated to the AWS account of the user */
AwsManagedPolicy.ElementalActivationsReadOnlyAccess = 'ElementalActivationsReadOnlyAccess';
/** Full access to view and take action on Elemental Appliances and Software quotes and orders */
AwsManagedPolicy.ElementalAppliancesSoftwareFullAccess = 'ElementalAppliancesSoftwareFullAccess';
/** Read-only access to view Elemental Appliances and Software quotes and orders */
AwsManagedPolicy.ElementalAppliancesSoftwareReadOnlyAccess = 'ElementalAppliancesSoftwareReadOnlyAccess';
/** Full access to view and take action on Elemental Appliance and Software support cases and product support content */
AwsManagedPolicy.ElementalSupportCenterFullAccess = 'ElementalSupportCenterFullAccess';
/** This policy grants read-only permissions that allow the WAL service for Amazon EMR to find and return the status of a cluster */
AwsManagedPolicy.EMRDescribeClusterPolicyForEMRWAL = 'aws-service-role/EMRDescribeClusterPolicyForEMRWAL';
/** Access policy to allow FM service linked role to perform FM-related actions on FM-managed resources within a customer AWS Organization account. */
AwsManagedPolicy.FMSServiceRolePolicy = 'aws-service-role/FMSServiceRolePolicy';
/** Allows Amazon FSx to delete its Service Linked Roles for Amazon S3 access */
AwsManagedPolicy.FSxDeleteServiceLinkedRoleAccess = 'aws-service-role/FSxDeleteServiceLinkedRoleAccess';
/** Grants the required permissions for compute actions in an Amazon GameLift container fleet, including access to dependencies such as Amazon S3. */
AwsManagedPolicy.GameLiftContainerFleetPolicy = 'GameLiftContainerFleetPolicy';
/** Policy to allow Gamelift GameServerGroups to manage customer resources */
AwsManagedPolicy.GameLiftGameServerGroupPolicy = 'GameLiftGameServerGroupPolicy';
/** This managed policy grants permission to connect with Amazon Q and utilize the features in the GitLab Duo with Amazon Q integration. */
AwsManagedPolicy.GitLabDuoWithAmazonQPermissionsPolicy = 'GitLabDuoWithAmazonQPermissionsPolicy';
/** Allow GlobalAccelerator Users full Access to all APIs */
AwsManagedPolicy.GlobalAcceleratorFullAccess = 'GlobalAcceleratorFullAccess';
/** Allow GlobalAccelerator Users Access to Read Only APIs */
AwsManagedPolicy.GlobalAcceleratorReadOnlyAccess = 'GlobalAcceleratorReadOnlyAccess';
/** Provides read access to the Greengrass OTA Update artifacts in all Greengrass regions */
AwsManagedPolicy.GreengrassOTAUpdateArtifactAccess = 'service-role/GreengrassOTAUpdateArtifactAccess';
/** AWS Health policy to enable Organizational View feature */
AwsManagedPolicy.HealthOrganizationsServiceRolePolicy = 'aws-service-role/Health_OrganizationsServiceRolePolicy';
/** This policy grants access to read all access information provided by IAM access advisor such as service last accessed information. */
AwsManagedPolicy.IAMAccessAdvisorReadOnly = 'IAMAccessAdvisorReadOnly';
/** Provides full access to IAM Access Analyzer */
AwsManagedPolicy.IAMAccessAnalyzerFullAccess = 'IAMAccessAnalyzerFullAccess';
/** Provides read only access to IAM Access Analyzer resources */
AwsManagedPolicy.IAMAccessAnalyzerReadOnlyAccess = 'IAMAccessAnalyzerReadOnlyAccess';
/** Provides access required to check the presence of root user credentials such as root user password and root user access keys using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.IAMAuditRootUserCredentials = 'root-task/IAMAuditRootUserCredentials';
/** Provides access required to create a root user password using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.IAMCreateRootUserPassword = 'root-task/IAMCreateRootUserPassword';
/** Provides access required to delete all root user credentials such as root password and root access keys using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.IAMDeleteRootUserCredentials = 'root-task/IAMDeleteRootUserCredentials';
/** Provides full access to IAM via the AWS Management Console. */
AwsManagedPolicy.IAMFullAccess = 'IAMFullAccess';
/** Provides read only access to IAM via the AWS Management Console. */
AwsManagedPolicy.IAMReadOnlyAccess = 'IAMReadOnlyAccess';
/** Allows an IAM user to manage their own Service Specific Credentials. */
AwsManagedPolicy.IAMSelfManageServiceSpecificCredentials = 'IAMSelfManageServiceSpecificCredentials';
/** Provides the ability for an IAM user to change their own password. */
AwsManagedPolicy.IAMUserChangePassword = 'IAMUserChangePassword';
/** Provides the ability for an IAM user to manage their own SSH keys. */
AwsManagedPolicy.IAMUserSSHKeys = 'IAMUserSSHKeys';
/** Provides full access to Interactive Video Service (IVS), Also included permissions for dependent services, needed for full access to the ivs console. */
AwsManagedPolicy.IVSFullAccess = 'IVSFullAccess';
/** Provides read-only access to IVS Low-Latency and Real-Time streaming APIs */
AwsManagedPolicy.IVSReadOnlyAccess = 'IVSReadOnlyAccess';
/** Service Linked Role to perform S3 PutObject to recording IVS live streams */
AwsManagedPolicy.IVSRecordToS3 = 'aws-service-role/IVSRecordToS3';
/** This policy grants Kafka Connect permission to manage AWS resources on your behalf. */
AwsManagedPolicy.KafkaConnectServiceRolePolicy = 'aws-service-role/KafkaConnectServiceRolePolicy';
/** IAM service linked role policy for Kafka. */
AwsManagedPolicy.KafkaServiceRolePolicy = 'aws-service-role/KafkaServiceRolePolicy';
/** Grants the required permissions to Amazon Keyspaces for Change Data Capture */
AwsManagedPolicy.KeyspacesCDCServiceRolePolicy = 'aws-service-role/KeyspacesCDCServiceRolePolicy';
/** Permissions required by Keyspaces for cross-region data replication */
AwsManagedPolicy.KeyspacesReplicationServiceRolePolicy = 'aws-service-role/KeyspacesReplicationServiceRolePolicy';
/** Policy to grant temporary data access to Lake Formation resources */
AwsManagedPolicy.LakeFormationDataAccessServiceRolePolicy = 'aws-service-role/LakeFormationDataAccessServiceRolePolicy';
/** Policy for AWS Lex Bot use case */
AwsManagedPolicy.LexBotPolicy = 'aws-service-role/LexBotPolicy';
/** Policy for AWS Lex Channel use case */
AwsManagedPolicy.LexChannelPolicy = 'aws-service-role/LexChannelPolicy';
/** AWS Lightsail service linked role policy which grants permissions to export resources */
AwsManagedPolicy.LightsailExportAccess = 'aws-service-role/LightsailExportAccess';
/** This policy grants permission to register MediaConnect Gateway Instances to a MediaConnect Gateway. */
AwsManagedPolicy.MediaConnectGatewayInstanceRolePolicy = 'MediaConnectGatewayInstanceRolePolicy';
/** Allows MediaPackage to publish logs to CloudWatch */
AwsManagedPolicy.MediaPackageServiceRolePolicy = 'aws-service-role/MediaPackageServiceRolePolicy';
/** This policy allows MemoryDB to manage AWS resources on your behalf as necessary for managing your resources. */
AwsManagedPolicy.MemoryDBServiceRolePolicy = 'aws-service-role/MemoryDBServiceRolePolicy';
/** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
AwsManagedPolicy.MigrationHubDMSAccessServiceRolePolicy = 'aws-service-role/MigrationHubDMSAccessServiceRolePolicy';
/** Allows Migration Hub to call Application Discovery Service on your behalf */
AwsManagedPolicy.MigrationHubServiceRolePolicy = 'aws-service-role/MigrationHubServiceRolePolicy';
/** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
AwsManagedPolicy.MigrationHubSMSAccessServiceRolePolicy = 'aws-service-role/MigrationHubSMSAccessServiceRolePolicy';
/** Policy for AWS Monitron service linked role granting access to required customer resources. */
AwsManagedPolicy.MonitronServiceRolePolicy = 'aws-service-role/MonitronServiceRolePolicy';
/** Provides full access to Multi-party approval. This policy also includes related permissions to AWS Organizations and AWS IAM Identity for managing approval teams and identity sources. */
AwsManagedPolicy.MultiPartyApprovalFullAccess = 'MultiPartyApprovalFullAccess';
/** Provides read-only access to Multi-party approval. This policy also includes related read permission to AWS Organizations and AWS IAM Identity for approval teams and identity sources. */
AwsManagedPolicy.MultiPartyApprovalReadOnlyAccess = 'MultiPartyApprovalReadOnlyAccess';
/** Provides full access to manage Amazon Neptune using the AWS Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
AwsManagedPolicy.NeptuneConsoleFullAccess = 'NeptuneConsoleFullAccess';
/** Provides full access to Amazon Neptune. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
AwsManagedPolicy.NeptuneFullAccess = 'NeptuneFullAccess';
/** Provides read only access to all Amazon Neptune Analytics resources along with read only permissions for dependent services. */
AwsManagedPolicy.NeptuneGraphReadOnlyAccess = 'NeptuneGraphReadOnlyAccess';
/** Provides read only access to Amazon Neptune. Note that this policy also grants access to Amazon RDS resources. For more information, see https://aws.amazon.com/neptune/faqs/. */
AwsManagedPolicy.NeptuneReadOnlyAccess = 'NeptuneReadOnlyAccess';
/** Grants full access permissions to AWS services and actions required to set up and configure AWS network resources. */
AwsManagedPolicy.NetworkAdministrator = 'job-function/NetworkAdministrator';
/** Provides permissions for the AWS Shield network security director service linked role to assess specified environments. */
AwsManagedPolicy.NetworkSecurityDirectorServiceLinkedRolePolicy = 'aws-service-role/NetworkSecurityDirectorServiceLinkedRolePolicy';
/** Provides full access to CloudWatch Observability Access Manager */
AwsManagedPolicy.OAMFullAccess = 'OAMFullAccess';
/** Provides Read Only access to CloudWatch Observability Access Manager */
AwsManagedPolicy.OAMReadOnlyAccess = 'OAMReadOnlyAccess';
/** Allows Amazon OpenSearch Ingestion to describe network resources and write service metrics to cloudwatch */
AwsManagedPolicy.OpensearchIngestionSelfManagedVpcePolicy = 'aws-service-role/OpensearchIngestionSelfManagedVpcePolicy';
/** Provides access to associate and dissociate partner central users with IAM roles */
AwsManagedPolicy.PartnerCentralAccountManagementUserRoleAssociation = 'PartnerCentralAccountManagementUserRoleAssociation';
/** Provides full access to AWS services and resources, but does not allow management of Users and groups. */
AwsManagedPolicy.PowerUserAccess = 'PowerUserAccess';
/** Grants permissions to AWS Services and Resources used or managed by Amazon Q Apps. */
AwsManagedPolicy.QAppsServiceRolePolicy = 'aws-service-role/QAppsServiceRolePolicy';
/** Grants permissions to QBusiness to call QuickSight APIs for the QuickSight plugin */
AwsManagedPolicy.QBusinessQuicksightPluginPolicy = 'QBusinessQuicksightPluginPolicy';
/** Grants permissions to AWS Services and Resources used or managed by Amazon Q */
AwsManagedPolicy.QBusinessServiceRolePolicy = 'aws-service-role/QBusinessServiceRolePolicy';
/** Policy used by QuickSight team to access customer data produced by S3 Storage Management Analytics. */
AwsManagedPolicy.QuickSightAccessForS3StorageManagementAnalyticsReadOnly = 'service-role/QuickSightAccessForS3StorageManagementAnalyticsReadOnly';
/** Default policy for the Amazon RDS service role. */
AwsManagedPolicy.RDSCloudHsmAuthorizationRole = 'service-role/RDSCloudHsmAuthorizationRole';
/** Provides read-only access to AWS services and resources. */
AwsManagedPolicy.ReadOnlyAccess = 'ReadOnlyAccess';
/** Provides full access to Resource Groups and Tag Editor. */
AwsManagedPolicy.ResourceGroupsandTagEditorFullAccess = 'ResourceGroupsandTagEditorFullAccess';
/** Provides access to use Resource Groups and Tag Editor, but does not allow editing of tags via the Tag Editor. */
AwsManagedPolicy.ResourceGroupsandTagEditorReadOnlyAccess = 'ResourceGroupsandTagEditorReadOnlyAccess';
/** Allows AWS Resource Groups to query the AWS services that own your resources to keep the group up-to-date */
AwsManagedPolicy.ResourceGroupsServiceRolePolicy = 'aws-service-role/ResourceGroupsServiceRolePolicy';
/** Provides permissions to tag and untag all the resources supported by Resource Groups Tagging API. This policy also grants the permissions required to retrieve all tagged, or previously tagged, resources through the Resource Groups Tagging API. */
AwsManagedPolicy.ResourceGroupsTaggingAPITagUntagSupportedResources = 'ResourceGroupsTaggingAPITagUntagSupportedResources';
/** Allows the OpenShift Amazon EBS Container Storage Interface (CSI) Driver Operator to install and maintain the Amazon EBS CSI driver on a Red Hat OpenShift Service on AWS (ROSA) cluster. The Amazon EBS CSI driver allows ROSA clusters to manage the lifecycle of Amazon EBS volumes for persistent volumes. */
AwsManagedPolicy.ROSAAmazonEBSCSIDriverOperatorPolicy = 'service-role/ROSAAmazonEBSCSIDriverOperatorPolicy';
/** Allows the OpenShift Cloud Network Config Controller Operator to provision and manage networking resources for use by the Red Hat OpenShift Service on AWS (ROSA) cluster networking overlay. The OpenShift Cloud Network Operator interfaces with AWS APIs on behalf of the network plugins via CustomResourceDefinitions. The operator uses these policy permissions to manage private IP addresses for Amazon EC2 instances as part of the ROSA cluster. */
AwsManagedPolicy.ROSACloudNetworkConfigOperatorPolicy = 'service-role/ROSACloudNetworkConfigOperatorPolicy';
/** Allows Red Hat OpenShift Service on AWS (ROSA) control plane to manage ROSA cluster Amazon EC2 and Amazon Route 53 resources. */
AwsManagedPolicy.ROSAControlPlaneOperatorPolicy = 'service-role/ROSAControlPlaneOperatorPolicy';
/** Allows the OpenShift Image Registry Operator to provision and manage Amazon S3 buckets and objects for use by the Red Hat OpenShift Service on AWS (ROSA) in-cluster image registry to satisfy ROSA storage requirements. The OpenShift Image Registry Operator installs and maintains the internal registry of a Red Hat OpenShift cluster. */
AwsManagedPolicy.ROSAImageRegistryOperatorPolicy = 'service-role/ROSAImageRegistryOperatorPolicy';
/** Allows the OpenShift Ingress Operator to provision and manage load balancers and domain name system (DNS) configurations for Red Hat OpenShift Service on AWS (ROSA) clusters. The policy allows read access to tag values, which the operator filters for Route 53 resources to discover hosted zones. */
AwsManagedPolicy.ROSAIngressOperatorPolicy = 'service-role/ROSAIngressOperatorPolicy';
/** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to manage AWS resources that support ROSA cluster installation. This includes managing instance profiles for ROSA worker nodes. */
AwsManagedPolicy.ROSAInstallerPolicy = 'service-role/ROSAInstallerPolicy';
/** Allows the built-in ROSA AWS Encryption Provider to manage AWS Key Management Service (KMS) keys to support etcd data encryption using a customer provided AWS KMS key. The policy allows encryption and decryption of data using KMS keys. */
AwsManagedPolicy.ROSAKMSProviderPolicy = 'service-role/ROSAKMSProviderPolicy';
/** Allows the ROSA Kubernetes controller to manage Amazon EC2, Elastic Load Balancing (ELB), and AWS Key Management Service (KMS) resources for a ROSA cluster. */
AwsManagedPolicy.ROSAKubeControllerPolicy = 'service-role/ROSAKubeControllerPolicy';
/** This policy provides the permissions required to manage the Red Hat OpenShift Service on AWS (ROSA) subscription. */
AwsManagedPolicy.ROSAManageSubscription = 'ROSAManageSubscription';
/** Allows Red Hat OpenShift Service on AWS (ROSA) to manage cluster EC2 instances as worker nodes, including permission to configure security groups and tag instances and volumes. This policy also allows for the use of EC2 instances with disk encryption provided by AWS Key Management Service (KMS) keys. */
AwsManagedPolicy.ROSANodePoolManagementPolicy = 'service-role/ROSANodePoolManagementPolicy';
/** Provides ROSA site reliability engineering (SRE) the permissions needed to initially observe, diagnose, and support AWS resources associated with Red Hat OpenShift Service on AWS (ROSA) clusters, including the ability to change ROSA cluster node state. */
AwsManagedPolicy.ROSASRESupportPolicy = 'service-role/ROSASRESupportPolicy';
/** Allows Red Hat OpenShift Service on AWS (ROSA) worker nodes in your account read-only access to Amazon EC2 instances and AWS Regions for compute node lifecycle management. */
AwsManagedPolicy.ROSAWorkerInstancePolicy = 'service-role/ROSAWorkerInstancePolicy';
/** Service Linked Role Policy for Route 53 Recovery Readiness */
AwsManagedPolicy.Route53RecoveryReadinessServiceRolePolicy = 'aws-service-role/Route53RecoveryReadinessServiceRolePolicy';
/** Enables access to AWS Services and Resources used or managed by Route53 Resolver */
AwsManagedPolicy.Route53ResolverServiceRolePolicy = 'aws-service-role/Route53ResolverServiceRolePolicy';
/** Enables access to AWS Services and Resources used or managed by S3 Storage Lens */
AwsManagedPolicy.S3StorageLensServiceRolePolicy = 'aws-service-role/S3StorageLensServiceRolePolicy';
/** Provides access required to unlock a S3 bucket policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.S3UnlockBucketPolicy = 'root-task/S3UnlockBucketPolicy';
/** Allows Amazon Bedrock Agents to access Amazon Bedrock models and other resources attached to an agent in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockAgentServiceRolePolicy = 'service-role/SageMakerStudioBedrockAgentServiceRolePolicy';
/** Provides access to an Amazon Bedrock chat agent app's configuration and Amazon Bedrock agent in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockChatAgentUserRolePolicy = 'service-role/SageMakerStudioBedrockChatAgentUserRolePolicy';
/** Allows Amazon Bedrock to access Amazon Bedrock models and datasets for evaluation jobs in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockEvaluationJobServiceRolePolicy = 'service-role/SageMakerStudioBedrockEvaluationJobServiceRolePolicy';
/** Allows Amazon Bedrock Flows to access Amazon Bedrock models and other resources attached to a flow in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockFlowServiceRolePolicy = 'service-role/SageMakerStudioBedrockFlowServiceRolePolicy';
/** Allows AWS Lambda to access an Amazon Bedrock function component's configuration in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockFunctionExecutionRolePolicy = 'service-role/SageMakerStudioBedrockFunctionExecutionRolePolicy';
/** Provides access to configure vector stores and Amazon Bedrock knowledge bases in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy = 'service-role/SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy';
/** Allows Amazon Bedrock Knowledge Bases to access Amazon Bedrock models and data sources in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy = 'service-role/SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy';
/** Provides access to an Amazon Bedrock prompt and its configuration in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockPromptUserRolePolicy = 'service-role/SageMakerStudioBedrockPromptUserRolePolicy';
/** This policy is used by Amazon SageMaker Studio to catalog, discover, govern, share, and analyze data in the Amazon SageMaker Studio domain. */
AwsManagedPolicy.SageMakerStudioDomainExecutionRolePolicy = 'service-role/SageMakerStudioDomainExecutionRolePolicy';
/** Service role for domain level actions in the portal that are performed by Amazon SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioDomainServiceRolePolicy = 'service-role/SageMakerStudioDomainServiceRolePolicy';
/** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
AwsManagedPolicy.SageMakerStudioEMRInstanceRolePolicy = 'service-role/SageMakerStudioEMRInstanceRolePolicy';
/** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
AwsManagedPolicy.SageMakerStudioEMRServiceRolePolicy = 'service-role/SageMakerStudioEMRServiceRolePolicy';
/** This policy provides full access to Amazon SageMaker Unified Studio via the Amazon SageMaker management console. */
AwsManagedPolicy.SageMakerStudioFullAccess = 'SageMakerStudioFullAccess';
/** Amazon SageMaker Studio uses this policy to provision and manage resources in your account. */
AwsManagedPolicy.SageMakerStudioProjectProvisioningRolePolicy = 'service-role/SageMakerStudioProjectProvisioningRolePolicy';
/** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to SageMaker. */
AwsManagedPolicy.SageMakerStudioProjectRoleMachineLearningPolicy = 'SageMakerStudioProjectRoleMachineLearningPolicy';
/** Amazon SageMaker creates IAM roles for Projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the boundary of their permissions. */
AwsManagedPolicy.SageMakerStudioProjectUserRolePermissionsBoundary = 'SageMakerStudioProjectUserRolePermissionsBoundary';
/** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions. */
AwsManagedPolicy.SageMakerStudioProjectUserRolePolicy = 'SageMakerStudioProjectUserRolePolicy';
/** Amazon SageMaker Studio uses this policy when running query executions on federated connections. */
AwsManagedPolicy.SageMakerStudioQueryExecutionRolePolicy = 'service-role/SageMakerStudioQueryExecutionRolePolicy';
/** Provides read/write access to AWS Secrets Manager via the AWS Management Console. Note: this exludes IAM actions, so combine with IAMFullAccess if rotation configuration is required. */
AwsManagedPolicy.SecretsManagerReadWrite = 'SecretsManagerReadWrite';
/** The security audit template grants access to read security configuration metadata. It is useful for software that audits the configuration of an AWS account. */
AwsManagedPolicy.SecurityAudit = 'SecurityAudit';
/** Provides access to manage resources created by Security Lake. */
AwsManagedPolicy.SecurityLakeResourceManagementServiceRolePolicy = 'aws-service-role/SecurityLakeResourceManagementServiceRolePolicy';
/** This policy grants permissions to operate the Amazon Security Lake service on your behalf */
AwsManagedPolicy.SecurityLakeServiceLinkedRole = 'aws-service-role/SecurityLakeServiceLinkedRole';
/** Permissions to allow the AWS Server Migration Connector to migrate VMs to EC2. Allows communication with the AWS Server Migration Service, read/write access to S3 buckets starting with 'sms-b-' and 'import-to-ec2-' as well as the buckets used for AWS Server Migration Connector upgrade, AWS Server Migration Connector registration with AWS, and metrics upload to AWS. */
AwsManagedPolicy.ServerMigrationConnector = 'ServerMigrationConnector';
/** Required permissions to use all features of the Server Migration Service Console */
AwsManagedPolicy.ServerMigrationServiceConsoleFullAccess = 'ServerMigrationServiceConsoleFullAccess';
/** Permissions to allow the AWS Server Migration Service to create and update relevant AWS resources into the customer's AWS account for launching migrated servers and applications. */
AwsManagedPolicy.ServerMigrationServiceLaunchRole = 'service-role/ServerMigrationServiceLaunchRole';
/** Permissions to allow the AWS SMS to run used data validation script and send script success/failure back to SMS */
AwsManagedPolicy.ServerMigrationServiceRoleForInstanceValidation = 'service-role/ServerMigrationServiceRoleForInstanceValidation';
/** Provides full access to Service Quotas */
AwsManagedPolicy.ServiceQuotasFullAccess = 'ServiceQuotasFullAccess';
/** Provides read only access to Service Quotas */
AwsManagedPolicy.ServiceQuotasReadOnlyAccess = 'ServiceQuotasReadOnlyAccess';
/** Allows Service Quotas to create support cases on your behalf */
AwsManagedPolicy.ServiceQuotasServiceRolePolicy = 'aws-service-role/ServiceQuotasServiceRolePolicy';
/** Provides full access to the Simple Workflow configuration service. */
AwsManagedPolicy.SimpleWorkflowFullAccess = 'SimpleWorkflowFullAccess';
/** Allows SMSVoice to publish metrics to CloudWatch on your behalf */
AwsManagedPolicy.SMSVoiceServiceRolePolicy = 'aws-service-role/SMSVoiceServiceRolePolicy';
/** Allows split cost allocation data to retrieve AWS Organizations information, if applicable, and collect telemetry data for the split cost allocation data services that the customer has opted in to. */
AwsManagedPolicy.SplitCostAllocationDataServiceRolePolicy = 'aws-service-role/SplitCostAllocationDataServiceRolePolicy';
/** Provides access required to unlock a SQS queue policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.SQSUnlockQueuePolicy = 'root-task/SQSUnlockQueuePolicy';
/** Provides permissions to check Quick Setup configuration health, ensure consistent use of parameters and provisioned resources, and remediate resources when drift is detected. */
AwsManagedPolicy.SSMQuickSetupRolePolicy = 'aws-service-role/SSMQuickSetupRolePolicy';
/** This policy grants permissions to troubleshoot and resolve issues in an AWS account. This policy also enables the user to contact AWS support to create and manage cases. */
AwsManagedPolicy.SupportUser = 'job-function/SupportUser';
/** Grants full access permissions necessary for resources required for application and development operations. */
AwsManagedPolicy.SystemAdministrator = 'job-function/SystemAdministrator';
/** Provides full access to Amazon Translate. */
AwsManagedPolicy.TranslateFullAccess = 'TranslateFullAccess';
/** Provides read-only access to Amazon Translate. */
AwsManagedPolicy.TranslateReadOnly = 'TranslateReadOnly';
/** This policy grants permissions to view resources and basic metadata across all AWS services. */
AwsManagedPolicy.ViewOnlyAccess = 'job-function/ViewOnlyAccess';
/** Default policy for the VM Import/Export service role, for customers using the AWS Connector. The VM Import/Export service assumes a role with this policy to fulfill virtual machine migration requests from the AWS Connector virtual appliance. (Note that the AWS Connector uses the "AWSConnector" managed policy to issue requests on the customer's behalf to the VM Import/Export service.) Provides the ability to create AMIs and EBS snapshots, modify EBS snapshot attributes, make "Describe*" calls on EC2 objects, and read from S3 buckets starting with 'import-to-ec2-'. */
AwsManagedPolicy.VMImportExportRoleForAWSConnector = 'service-role/VMImportExportRoleForAWSConnector';
/** Provides full access to Amazon VPC Lattice and access to dependency services. */
AwsManagedPolicy.VPCLatticeFullAccess = 'VPCLatticeFullAccess';
/** Provides read-only access to Amazon VPC Lattice via the AWS Management Console, and limited access to dependency services. */
AwsManagedPolicy.VPCLatticeReadOnlyAccess = 'VPCLatticeReadOnlyAccess';
/** Provides access to invoking Amazon VPC Lattice services. */
AwsManagedPolicy.VPCLatticeServicesInvokeAccess = 'VPCLatticeServicesInvokeAccess';
/** Creating SLR to write customer's logs to a firehose stream */
AwsManagedPolicy.WAFLoggingServiceRolePolicy = 'aws-service-role/WAFLoggingServiceRolePolicy';
/** Creating SLR to write customer's logs to a firehose stream */
AwsManagedPolicy.WAFRegionalLoggingServiceRolePolicy = 'aws-service-role/WAFRegionalLoggingServiceRolePolicy';
/** This policy creates a service-linked role that allows AWS WAF to write logs to Amazon Kinesis Data Firehose. */
AwsManagedPolicy.WAFV2LoggingServiceRolePolicy = 'aws-service-role/WAFV2LoggingServiceRolePolicy';
/** Provides full access to AWS Well-Architected Tool via the AWS Management Console */
AwsManagedPolicy.WellArchitectedConsoleFullAccess = 'WellArchitectedConsoleFullAccess';
/** Provides read-only access to AWS Well-Architected Tool via the AWS Management Console */
AwsManagedPolicy.WellArchitectedConsoleReadOnlyAccess = 'WellArchitectedConsoleReadOnlyAccess';
/** Enables access to AWS Services and Resources used or managed by Amazon WorkLink */
AwsManagedPolicy.WorkLinkServiceRolePolicy = 'WorkLinkServiceRolePolicy';
//# sourceMappingURL=data:application/json;base64,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