"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mgn = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mgn extends shared_1.PolicyStatement {
    /**
     * Grants permission to archive an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ArchiveApplication.html
     */
    toArchiveApplication() {
        return this.to('ArchiveApplication');
    }
    /**
     * Grants permission to archive a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ArchiveWave.html
     */
    toArchiveWave() {
        return this.to('ArchiveWave');
    }
    /**
     * Grants permission to associate applications to a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_AssociateApplications.html
     */
    toAssociateApplications() {
        return this.to('AssociateApplications');
    }
    /**
     * Grants permission to associate source servers to an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_AssociateSourceServers.html
     */
    toAssociateSourceServers() {
        return this.to('AssociateSourceServers');
    }
    /**
     * Grants permission to create volume snapshot group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toBatchCreateVolumeSnapshotGroupForMgn() {
        return this.to('BatchCreateVolumeSnapshotGroupForMgn');
    }
    /**
     * Grants permission to batch delete snapshot request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toBatchDeleteSnapshotRequestForMgn() {
        return this.to('BatchDeleteSnapshotRequestForMgn');
    }
    /**
     * Grants permission to change source server life cycle state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ChangeServerLifeCycleState.html
     */
    toChangeServerLifeCycleState() {
        return this.to('ChangeServerLifeCycleState');
    }
    /**
     * Grants permission to create an application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication() {
        return this.to('CreateApplication');
    }
    /**
     * Grants permission to create connector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateConnector.html
     */
    toCreateConnector() {
        return this.to('CreateConnector');
    }
    /**
     * Grants permission to create launch configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateLaunchConfigurationTemplate.html
     */
    toCreateLaunchConfigurationTemplate() {
        return this.to('CreateLaunchConfigurationTemplate');
    }
    /**
     * Grants permission to create a network migration definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateNetworkMigrationDefinition.html
     */
    toCreateNetworkMigrationDefinition() {
        return this.to('CreateNetworkMigrationDefinition');
    }
    /**
     * Grants permission to create replication configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     */
    toCreateReplicationConfigurationTemplate() {
        return this.to('CreateReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to create vcenter client
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toCreateVcenterClientForMgn() {
        return this.to('CreateVcenterClientForMgn');
    }
    /**
     * Grants permission to create a wave
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateWave.html
     */
    toCreateWave() {
        return this.to('CreateWave');
    }
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication() {
        return this.to('DeleteApplication');
    }
    /**
     * Grants permission to delete connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteConnector.html
     */
    toDeleteConnector() {
        return this.to('DeleteConnector');
    }
    /**
     * Grants permission to delete job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteJob.html
     */
    toDeleteJob() {
        return this.to('DeleteJob');
    }
    /**
     * Grants permission to delete launch configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteLaunchConfigurationTemplate.html
     */
    toDeleteLaunchConfigurationTemplate() {
        return this.to('DeleteLaunchConfigurationTemplate');
    }
    /**
     * Grants permission to delete a network migration definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteNetworkMigrationDefinition.html
     */
    toDeleteNetworkMigrationDefinition() {
        return this.to('DeleteNetworkMigrationDefinition');
    }
    /**
     * Grants permission to delete replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     */
    toDeleteReplicationConfigurationTemplate() {
        return this.to('DeleteReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to delete source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteSourceServer.html
     */
    toDeleteSourceServer() {
        return this.to('DeleteSourceServer');
    }
    /**
     * Grants permission to delete vcenter client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteVcenterClient.html
     */
    toDeleteVcenterClient() {
        return this.to('DeleteVcenterClient');
    }
    /**
     * Grants permission to delete a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteWave.html
     */
    toDeleteWave() {
        return this.to('DeleteWave');
    }
    /**
     * Grants permission to describe job log items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobLogItems.html
     */
    toDescribeJobLogItems() {
        return this.to('DescribeJobLogItems');
    }
    /**
     * Grants permission to describe jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs() {
        return this.to('DescribeJobs');
    }
    /**
     * Grants permission to describe launch configuration template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeLaunchConfigurationTemplates.html
     */
    toDescribeLaunchConfigurationTemplates() {
        return this.to('DescribeLaunchConfigurationTemplates');
    }
    /**
     * Grants permission to describe replication configuration template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     */
    toDescribeReplicationConfigurationTemplates() {
        return this.to('DescribeReplicationConfigurationTemplates');
    }
    /**
     * Grants permission to describe replication server associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toDescribeReplicationServerAssociationsForMgn() {
        return this.to('DescribeReplicationServerAssociationsForMgn');
    }
    /**
     * Grants permission to describe snapshots requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toDescribeSnapshotRequestsForMgn() {
        return this.to('DescribeSnapshotRequestsForMgn');
    }
    /**
     * Grants permission to describe source servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeSourceServers.html
     */
    toDescribeSourceServers() {
        return this.to('DescribeSourceServers');
    }
    /**
     * Grants permission to describe vcenter clients
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeVcenterClients.html
     */
    toDescribeVcenterClients() {
        return this.to('DescribeVcenterClients');
    }
    /**
     * Grants permission to disassociate applications from a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisassociateApplications.html
     */
    toDisassociateApplications() {
        return this.to('DisassociateApplications');
    }
    /**
     * Grants permission to disassociate source servers from an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisassociateSourceServers.html
     */
    toDisassociateSourceServers() {
        return this.to('DisassociateSourceServers');
    }
    /**
     * Grants permission to disconnect source server from service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisconnectFromService.html
     */
    toDisconnectFromService() {
        return this.to('DisconnectFromService');
    }
    /**
     * Grants permission to finalize cutover
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_FinalizeCutover.html
     */
    toFinalizeCutover() {
        return this.to('FinalizeCutover');
    }
    /**
     * Grants permission to get agent command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentCommandForMgn() {
        return this.to('GetAgentCommandForMgn');
    }
    /**
     * Grants permission to get agent confirmed resume info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentConfirmedResumeInfoForMgn() {
        return this.to('GetAgentConfirmedResumeInfoForMgn');
    }
    /**
     * Grants permission to get agent installation assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentInstallationAssetsForMgn() {
        return this.to('GetAgentInstallationAssetsForMgn');
    }
    /**
     * Grants permission to get agent replication info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentReplicationInfoForMgn() {
        return this.to('GetAgentReplicationInfoForMgn');
    }
    /**
     * Grants permission to get agent runtime configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentRuntimeConfigurationForMgn() {
        return this.to('GetAgentRuntimeConfigurationForMgn');
    }
    /**
     * Grants permission to get agent snapshots credits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentSnapshotCreditsForMgn() {
        return this.to('GetAgentSnapshotCreditsForMgn');
    }
    /**
     * Grants permission to get channel commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetChannelCommandsForMgn() {
        return this.to('GetChannelCommandsForMgn');
    }
    /**
     * Grants permission to get launch configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetLaunchConfiguration.html
     */
    toGetLaunchConfiguration() {
        return this.to('GetLaunchConfiguration');
    }
    /**
     * Grants permission to get a network migration definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetNetworkMigrationDefinition.html
     */
    toGetNetworkMigrationDefinition() {
        return this.to('GetNetworkMigrationDefinition');
    }
    /**
     * Grants permission to get a network migration mapper segment construct
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetNetworkMigrationMapperSegmentConstruct.html
     */
    toGetNetworkMigrationMapperSegmentConstruct() {
        return this.to('GetNetworkMigrationMapperSegmentConstruct');
    }
    /**
     * Grants permission to get replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetReplicationConfiguration.html
     */
    toGetReplicationConfiguration() {
        return this.to('GetReplicationConfiguration');
    }
    /**
     * Grants permission to get vcenter client commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetVcenterClientCommandsForMgn() {
        return this.to('GetVcenterClientCommandsForMgn');
    }
    /**
     * Grants permission to initialize service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_InitializeService.html
     */
    toInitializeService() {
        return this.to('InitializeService');
    }
    /**
     * Grants permission to issue a client certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toIssueClientCertificateForMgn() {
        return this.to('IssueClientCertificateForMgn');
    }
    /**
     * Grants permission to list application summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListApplications.html
     */
    toListApplications() {
        return this.to('ListApplications');
    }
    /**
     * Grants permission to list connectors
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListConnectors.html
     */
    toListConnectors() {
        return this.to('ListConnectors');
    }
    /**
     * Grants permission to list the errors of an export task
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListExportErrors.html
     */
    toListExportErrors() {
        return this.to('ListExportErrors');
    }
    /**
     * Grants permission to list export tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListExports.html
     */
    toListExports() {
        return this.to('ListExports');
    }
    /**
     * Grants permission to list the errors of an import task
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListImportErrors.html
     */
    toListImportErrors() {
        return this.to('ListImportErrors');
    }
    /**
     * Grants permission to list the import tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListImports.html
     */
    toListImports() {
        return this.to('ListImports');
    }
    /**
     * Grants permission to list managed accounts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListManagedAccounts.html
     */
    toListManagedAccounts() {
        return this.to('ListManagedAccounts');
    }
    /**
     * Grants permission to list network migration analyses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationAnalyses.html
     */
    toListNetworkMigrationAnalyses() {
        return this.to('ListNetworkMigrationAnalyses');
    }
    /**
     * Grants permission to list network migration analysis results
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationAnalysisResults.html
     */
    toListNetworkMigrationAnalysisResults() {
        return this.to('ListNetworkMigrationAnalysisResults');
    }
    /**
     * Grants permission to list network migration code generation segments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationCodeGenerationSegments.html
     */
    toListNetworkMigrationCodeGenerationSegments() {
        return this.to('ListNetworkMigrationCodeGenerationSegments');
    }
    /**
     * Grants permission to list network migration code generations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationCodeGenerations.html
     */
    toListNetworkMigrationCodeGenerations() {
        return this.to('ListNetworkMigrationCodeGenerations');
    }
    /**
     * Grants permission to list network migration definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDefinitions.html
     */
    toListNetworkMigrationDefinitions() {
        return this.to('ListNetworkMigrationDefinitions');
    }
    /**
     * Grants permission to list network migration deployed stacks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployedStacks.html
     */
    toListNetworkMigrationDeployedStacks() {
        return this.to('ListNetworkMigrationDeployedStacks');
    }
    /**
     * Grants permission to list network migration deployed stacks deletions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployedStacksDeletions.html
     */
    toListNetworkMigrationDeployedStacksDeletions() {
        return this.to('ListNetworkMigrationDeployedStacksDeletions');
    }
    /**
     * Grants permission to list network migration deployments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployments.html
     */
    toListNetworkMigrationDeployments() {
        return this.to('ListNetworkMigrationDeployments');
    }
    /**
     * Grants permission to list network migration executions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationExecutions.html
     */
    toListNetworkMigrationExecutions() {
        return this.to('ListNetworkMigrationExecutions');
    }
    /**
     * Grants permission to list network migration mapper segment constructs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMapperSegmentConstructs.html
     */
    toListNetworkMigrationMapperSegmentConstructs() {
        return this.to('ListNetworkMigrationMapperSegmentConstructs');
    }
    /**
     * Grants permission to list network migration mapper segments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMapperSegments.html
     */
    toListNetworkMigrationMapperSegments() {
        return this.to('ListNetworkMigrationMapperSegments');
    }
    /**
     * Grants permission to list network migration mappings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMappings.html
     */
    toListNetworkMigrationMappings() {
        return this.to('ListNetworkMigrationMappings');
    }
    /**
     * Grants permission to list source server action documents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListSourceServerActions.html
     */
    toListSourceServerActions() {
        return this.to('ListSourceServerActions');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list launch configuration template action documents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListTemplateActions.html
     */
    toListTemplateActions() {
        return this.to('ListTemplateActions');
    }
    /**
     * Grants permission to list wave summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListWaves.html
     */
    toListWaves() {
        return this.to('ListWaves');
    }
    /**
     * Grants permission to mark source server as archived
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_MarkAsArchived.html
     */
    toMarkAsArchived() {
        return this.to('MarkAsArchived');
    }
    /**
     * Grants permission to notify agent authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentAuthenticationForMgn() {
        return this.to('NotifyAgentAuthenticationForMgn');
    }
    /**
     * Grants permission to notify agent is connected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentConnectedForMgn() {
        return this.to('NotifyAgentConnectedForMgn');
    }
    /**
     * Grants permission to notify agent is disconnected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentDisconnectedForMgn() {
        return this.to('NotifyAgentDisconnectedForMgn');
    }
    /**
     * Grants permission to notify agent replication progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentReplicationProgressForMgn() {
        return this.to('NotifyAgentReplicationProgressForMgn');
    }
    /**
     * Grants permission to notify vcenter client started
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyVcenterClientStartedForMgn() {
        return this.to('NotifyVcenterClientStartedForMgn');
    }
    /**
     * Grants permission to pause replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PauseReplication.html
     */
    toPauseReplication() {
        return this.to('PauseReplication');
    }
    /**
     * Grants permission to put source server action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PutSourceServerAction.html
     */
    toPutSourceServerAction() {
        return this.to('PutSourceServerAction');
    }
    /**
     * Grants permission to put launch configuration template action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PutTemplateAction.html
     */
    toPutTemplateAction() {
        return this.to('PutTemplateAction');
    }
    /**
     * Grants permission to register agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toRegisterAgentForMgn() {
        return this.to('RegisterAgentForMgn');
    }
    /**
     * Grants permission to remove source server action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RemoveSourceServerAction.html
     */
    toRemoveSourceServerAction() {
        return this.to('RemoveSourceServerAction');
    }
    /**
     * Grants permission to remove launch configuration template action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RemoveTemplateAction.html
     */
    toRemoveTemplateAction() {
        return this.to('RemoveTemplateAction');
    }
    /**
     * Grants permission to resume replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ResumeReplication.html
     */
    toResumeReplication() {
        return this.to('ResumeReplication');
    }
    /**
     * Grants permission to retry replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RetryDataReplication.html
     */
    toRetryDataReplication() {
        return this.to('RetryDataReplication');
    }
    /**
     * Grants permission to send agent logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendAgentLogsForMgn() {
        return this.to('SendAgentLogsForMgn');
    }
    /**
     * Grants permission to send agent metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendAgentMetricsForMgn() {
        return this.to('SendAgentMetricsForMgn');
    }
    /**
     * Grants permission to send channel command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendChannelCommandResultForMgn() {
        return this.to('SendChannelCommandResultForMgn');
    }
    /**
     * Grants permission to send client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendClientLogsForMgn() {
        return this.to('SendClientLogsForMgn');
    }
    /**
     * Grants permission to send client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendClientMetricsForMgn() {
        return this.to('SendClientMetricsForMgn');
    }
    /**
     * Grants permission to send vcenter client command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientCommandResultForMgn() {
        return this.to('SendVcenterClientCommandResultForMgn');
    }
    /**
     * Grants permission to send vcenter client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientLogsForMgn() {
        return this.to('SendVcenterClientLogsForMgn');
    }
    /**
     * Grants permission to send vcenter client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientMetricsForMgn() {
        return this.to('SendVcenterClientMetricsForMgn');
    }
    /**
     * Grants permission to start cutover
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartCutover.html
     */
    toStartCutover() {
        return this.to('StartCutover');
    }
    /**
     * Grants permission to start an export task
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeLaunchTemplateVersions
     * - mgn:DescribeSourceServers
     * - mgn:GetLaunchConfiguration
     * - mgn:ListApplications
     * - mgn:ListWaves
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartExport.html
     */
    toStartExport() {
        return this.to('StartExport');
    }
    /**
     * Grants permission to create an import task
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:ModifyLaunchTemplate
     * - mgn:DescribeSourceServers
     * - mgn:GetLaunchConfiguration
     * - mgn:ListApplications
     * - mgn:ListWaves
     * - mgn:TagResource
     * - mgn:UpdateLaunchConfiguration
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartImport.html
     */
    toStartImport() {
        return this.to('StartImport');
    }
    /**
     * Grants permission to start a network migration analysis
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - directconnect:DescribeConnections
     * - directconnect:DescribeDirectConnectGatewayAssociations
     * - directconnect:DescribeDirectConnectGatewayAttachments
     * - directconnect:DescribeDirectConnectGateways
     * - directconnect:DescribeVirtualGateways
     * - directconnect:DescribeVirtualInterfaces
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNetworkInsightsPath
     * - ec2:CreateNetworkInterface
     * - ec2:CreateSecurityGroup
     * - ec2:CreateTags
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteTags
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeCustomerGateways
     * - ec2:DescribeInstances
     * - ec2:DescribeInternetGateways
     * - ec2:DescribeManagedPrefixLists
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeNetworkInsightsAnalyses
     * - ec2:DescribeNetworkInsightsPaths
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribePrefixLists
     * - ec2:DescribeRegions
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeTransitGatewayAttachments
     * - ec2:DescribeTransitGatewayConnects
     * - ec2:DescribeTransitGatewayPeeringAttachments
     * - ec2:DescribeTransitGatewayRouteTables
     * - ec2:DescribeTransitGatewayVpcAttachments
     * - ec2:DescribeTransitGateways
     * - ec2:DescribeVpcEndpointServiceConfigurations
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcPeeringConnections
     * - ec2:DescribeVpcs
     * - ec2:DescribeVpnConnections
     * - ec2:DescribeVpnGateways
     * - ec2:GetManagedPrefixListEntries
     * - ec2:GetTransitGatewayRouteTablePropagations
     * - ec2:SearchTransitGatewayRoutes
     * - ec2:StartNetworkInsightsAnalysis
     * - elasticloadbalancing:DescribeListeners
     * - elasticloadbalancing:DescribeLoadBalancerAttributes
     * - elasticloadbalancing:DescribeLoadBalancers
     * - elasticloadbalancing:DescribeRules
     * - elasticloadbalancing:DescribeTags
     * - elasticloadbalancing:DescribeTargetGroupAttributes
     * - elasticloadbalancing:DescribeTargetGroups
     * - elasticloadbalancing:DescribeTargetHealth
     * - globalaccelerator:ListAccelerators
     * - globalaccelerator:ListCustomRoutingAccelerators
     * - globalaccelerator:ListCustomRoutingEndpointGroups
     * - globalaccelerator:ListCustomRoutingListeners
     * - globalaccelerator:ListCustomRoutingPortMappings
     * - globalaccelerator:ListEndpointGroups
     * - globalaccelerator:ListListeners
     * - network-firewall:DescribeFirewall
     * - network-firewall:DescribeFirewallPolicy
     * - network-firewall:DescribeResourcePolicy
     * - network-firewall:DescribeRuleGroup
     * - network-firewall:ListFirewallPolicies
     * - network-firewall:ListFirewalls
     * - network-firewall:ListRuleGroups
     * - tiros:CreateQuery
     * - tiros:ExtendQuery
     * - tiros:GetQueryAnswer
     * - tiros:GetQueryExplanation
     * - tiros:GetQueryExtensionAccounts
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationAnalysis.html
     */
    toStartNetworkMigrationAnalysis() {
        return this.to('StartNetworkMigrationAnalysis');
    }
    /**
     * Grants permission to start network migration code generation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationCodeGeneration.html
     */
    toStartNetworkMigrationCodeGeneration() {
        return this.to('StartNetworkMigrationCodeGeneration');
    }
    /**
     * Grants permission to start deletion of network migration deployed stacks
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:AcceptTransitGatewayVpcAttachment
     * - ec2:AssociateNatGatewayAddress
     * - ec2:AssociateRouteTable
     * - ec2:AssociateSubnetCidrBlock
     * - ec2:AssociateTransitGatewayRouteTable
     * - ec2:AssociateVpcCidrBlock
     * - ec2:AttachInternetGateway
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:DeleteInternetGateway
     * - ec2:DeleteLaunchTemplate
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteNatGateway
     * - ec2:DeleteNetworkAcl
     * - ec2:DeleteNetworkAclEntry
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteRoute
     * - ec2:DeleteRouteTable
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteSnapshot
     * - ec2:DeleteSubnet
     * - ec2:DeleteTransitGateway
     * - ec2:DeleteTransitGatewayRoute
     * - ec2:DeleteTransitGatewayRouteTable
     * - ec2:DeleteTransitGatewayVpcAttachment
     * - ec2:DeleteVolume
     * - ec2:DeleteVpc
     * - ec2:DetachInternetGateway
     * - ec2:DetachVolume
     * - ec2:DisableTransitGatewayRouteTablePropagation
     * - ec2:DisassociateNatGatewayAddress
     * - ec2:DisassociateRouteTable
     * - ec2:DisassociateTransitGatewayRouteTable
     * - ec2:EnableTransitGatewayRouteTablePropagation
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ModifySubnetAttribute
     * - ec2:ModifyTransitGateway
     * - ec2:ModifyTransitGatewayVpcAttachment
     * - ec2:ModifyVolume
     * - ec2:ModifyVpcAttribute
     * - ec2:RejectTransitGatewayVpcAttachment
     * - ec2:ReleaseAddress
     * - ec2:ReplaceNetworkAclAssociation
     * - ec2:ReplaceNetworkAclEntry
     * - ec2:ReplaceRoute
     * - ec2:ReplaceTransitGatewayRoute
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RevokeSecurityGroupIngress
     * - ec2:SearchTransitGatewayRoutes
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationDeployedStacksDeletion.html
     */
    toStartNetworkMigrationDeployedStacksDeletion() {
        return this.to('StartNetworkMigrationDeployedStacksDeletion');
    }
    /**
     * Grants permission to start a network migration deployment
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:AcceptTransitGatewayVpcAttachment
     * - ec2:AssociateNatGatewayAddress
     * - ec2:AssociateRouteTable
     * - ec2:AssociateSubnetCidrBlock
     * - ec2:AssociateTransitGatewayRouteTable
     * - ec2:AssociateVpcCidrBlock
     * - ec2:AttachInternetGateway
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNatGateway
     * - ec2:CreateNetworkAcl
     * - ec2:CreateNetworkAclEntry
     * - ec2:CreateNetworkInsightsPath
     * - ec2:CreateNetworkInterface
     * - ec2:CreateRoute
     * - ec2:CreateRouteTable
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSubnet
     * - ec2:CreateTags
     * - ec2:CreateTransitGatewayRoute
     * - ec2:CreateTransitGatewayRouteTable
     * - ec2:CreateTransitGatewayVpcAttachment
     * - ec2:DeleteInternetGateway
     * - ec2:DeleteLaunchTemplate
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteNatGateway
     * - ec2:DeleteNetworkAcl
     * - ec2:DeleteNetworkAclEntry
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteRoute
     * - ec2:DeleteRouteTable
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteSnapshot
     * - ec2:DeleteSubnet
     * - ec2:DeleteTransitGateway
     * - ec2:DeleteTransitGatewayRoute
     * - ec2:DeleteTransitGatewayRouteTable
     * - ec2:DeleteTransitGatewayVpcAttachment
     * - ec2:DeleteVolume
     * - ec2:DeleteVpc
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAddresses
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeCustomerGateways
     * - ec2:DescribeEgressOnlyInternetGateways
     * - ec2:DescribeHosts
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeInternetGateways
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeManagedPrefixLists
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeNetworkInsightsAnalyses
     * - ec2:DescribeNetworkInsightsPaths
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribePrefixLists
     * - ec2:DescribeRegions
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSecurityGroupRules
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeTransitGatewayAttachments
     * - ec2:DescribeTransitGatewayConnects
     * - ec2:DescribeTransitGatewayPeeringAttachments
     * - ec2:DescribeTransitGatewayRouteTables
     * - ec2:DescribeTransitGatewayVpcAttachments
     * - ec2:DescribeTransitGateways
     * - ec2:DescribeVolumes
     * - ec2:DescribeVpcEndpointServiceConfigurations
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcPeeringConnections
     * - ec2:DescribeVpcs
     * - ec2:DescribeVpnConnections
     * - ec2:DescribeVpnGateways
     * - ec2:DetachInternetGateway
     * - ec2:DetachVolume
     * - ec2:DisableTransitGatewayRouteTablePropagation
     * - ec2:DisassociateNatGatewayAddress
     * - ec2:DisassociateRouteTable
     * - ec2:DisassociateTransitGatewayRouteTable
     * - ec2:EnableTransitGatewayRouteTablePropagation
     * - ec2:GetEbsDefaultKmsKeyId
     * - ec2:GetEbsEncryptionByDefault
     * - ec2:GetManagedPrefixListEntries
     * - ec2:GetTransitGatewayRouteTableAssociations
     * - ec2:GetTransitGatewayRouteTablePropagations
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ModifySubnetAttribute
     * - ec2:ModifyTransitGateway
     * - ec2:ModifyTransitGatewayVpcAttachment
     * - ec2:ModifyVolume
     * - ec2:ModifyVpcAttribute
     * - ec2:RejectTransitGatewayVpcAttachment
     * - ec2:ReleaseAddress
     * - ec2:ReplaceNetworkAclAssociation
     * - ec2:ReplaceNetworkAclEntry
     * - ec2:ReplaceRoute
     * - ec2:ReplaceTransitGatewayRoute
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RevokeSecurityGroupIngress
     * - ec2:SearchTransitGatewayRoutes
     * - ec2:StartNetworkInsightsAnalysis
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationDeployment.html
     */
    toStartNetworkMigrationDeployment() {
        return this.to('StartNetworkMigrationDeployment');
    }
    /**
     * Grants permission to start a network migration mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationMapping.html
     */
    toStartNetworkMigrationMapping() {
        return this.to('StartNetworkMigrationMapping');
    }
    /**
     * Grants permission to start replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartReplication.html
     */
    toStartReplication() {
        return this.to('StartReplication');
    }
    /**
     * Grants permission to start test
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartTest.html
     */
    toStartTest() {
        return this.to('StartTest');
    }
    /**
     * Grants permission to stop replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StopReplication.html
     */
    toStopReplication() {
        return this.to('StopReplication');
    }
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifCreateAction()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to terminate target instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TerminateTargetInstances.html
     */
    toTerminateTargetInstances() {
        return this.to('TerminateTargetInstances');
    }
    /**
     * Grants permission to unarchive an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UnarchiveApplication.html
     */
    toUnarchiveApplication() {
        return this.to('UnarchiveApplication');
    }
    /**
     * Grants permission to unarchive a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UnarchiveWave.html
     */
    toUnarchiveWave() {
        return this.to('UnarchiveWave');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update agent backlog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentBacklogForMgn() {
        return this.to('UpdateAgentBacklogForMgn');
    }
    /**
     * Grants permission to update agent conversion info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentConversionInfoForMgn() {
        return this.to('UpdateAgentConversionInfoForMgn');
    }
    /**
     * Grants permission to update agent replication info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentReplicationInfoForMgn() {
        return this.to('UpdateAgentReplicationInfoForMgn');
    }
    /**
     * Grants permission to update agent replication process state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentReplicationProcessStateForMgn() {
        return this.to('UpdateAgentReplicationProcessStateForMgn');
    }
    /**
     * Grants permission to update agent source properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentSourcePropertiesForMgn() {
        return this.to('UpdateAgentSourcePropertiesForMgn');
    }
    /**
     * Grants permission to update an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication() {
        return this.to('UpdateApplication');
    }
    /**
     * Grants permission to update connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateConnector.html
     */
    toUpdateConnector() {
        return this.to('UpdateConnector');
    }
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfiguration.html
     */
    toUpdateLaunchConfiguration() {
        return this.to('UpdateLaunchConfiguration');
    }
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfigurationTemplate.html
     */
    toUpdateLaunchConfigurationTemplate() {
        return this.to('UpdateLaunchConfigurationTemplate');
    }
    /**
     * Grants permission to update a network migration definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationDefinition.html
     */
    toUpdateNetworkMigrationDefinition() {
        return this.to('UpdateNetworkMigrationDefinition');
    }
    /**
     * Grants permission to update a network migration mapper segment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationMapperSegment.html
     */
    toUpdateNetworkMigrationMapperSegment() {
        return this.to('UpdateNetworkMigrationMapperSegment');
    }
    /**
     * Grants permission to update a network migration mapper segment construct
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationMapperSegmentConstruct.html
     */
    toUpdateNetworkMigrationMapperSegmentConstruct() {
        return this.to('UpdateNetworkMigrationMapperSegmentConstruct');
    }
    /**
     * Grants permission to update replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfiguration.html
     */
    toUpdateReplicationConfiguration() {
        return this.to('UpdateReplicationConfiguration');
    }
    /**
     * Grants permission to update replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     */
    toUpdateReplicationConfigurationTemplate() {
        return this.to('UpdateReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to update source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateSourceServer.html
     */
    toUpdateSourceServer() {
        return this.to('UpdateSourceServer');
    }
    /**
     * Grants permission to update source server replication type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateSourceServerReplicationType.html
     */
    toUpdateSourceServerReplicationType() {
        return this.to('UpdateSourceServerReplicationType');
    }
    /**
     * Grants permission to update a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateWave.html
     */
    toUpdateWave() {
        return this.to('UpdateWave');
    }
    /**
     * Grants permission to verify client role
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toVerifyClientRoleForMgn() {
        return this.to('VerifyClientRoleForMgn');
    }
    /**
     * Adds a resource of type JobResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/launching-target-servers.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobResource(jobID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:job/${jobID}`);
    }
    /**
     * Adds a resource of type ReplicationConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:replication-configuration-template/${replicationConfigurationTemplateID}`);
    }
    /**
     * Adds a resource of type LaunchConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/post-launch-settings.html
     *
     * @param launchConfigurationTemplateID - Identifier for the launchConfigurationTemplateID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLaunchConfigurationTemplateResource(launchConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:launch-configuration-template/${launchConfigurationTemplateID}`);
    }
    /**
     * Adds a resource of type VcenterClientResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/agentless-mgn.html
     *
     * @param vcenterClientID - Identifier for the vcenterClientID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVcenterClientResource(vcenterClientID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:vcenter-client/${vcenterClientID}`);
    }
    /**
     * Adds a resource of type SourceServerResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceServerResource(sourceServerID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:source-server/${sourceServerID}`);
    }
    /**
     * Adds a resource of type ApplicationResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/applications.html
     *
     * @param applicationID - Identifier for the applicationID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationResource(applicationID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:application/${applicationID}`);
    }
    /**
     * Adds a resource of type WaveResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/waves.html
     *
     * @param waveID - Identifier for the waveID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWaveResource(waveID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:wave/${waveID}`);
    }
    /**
     * Adds a resource of type ImportResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/imports.html
     *
     * @param importID - Identifier for the importID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onImportResource(importID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:import/${importID}`);
    }
    /**
     * Adds a resource of type ExportResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/exports.html
     *
     * @param exportID - Identifier for the exportID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExportResource(exportID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:export/${exportID}`);
    }
    /**
     * Adds a resource of type ConnectorResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/connectors.html
     *
     * @param connectorID - Identifier for the connectorID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnectorResource(connectorID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:connector/${connectorID}`);
    }
    /**
     * Adds a resource of type NetworkMigrationDefinitionResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/network-migration-definition.html
     *
     * @param networkMigrationDefinitionID - Identifier for the networkMigrationDefinitionID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkMigrationDefinitionResource(networkMigrationDefinitionID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:network-migration-definition/${networkMigrationDefinitionID}`);
    }
    /**
     * Filters access by presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateConnector()
     * - .toCreateLaunchConfigurationTemplate()
     * - .toCreateReplicationConfigurationTemplate()
     * - .toCreateVcenterClientForMgn()
     * - .toCreateWave()
     * - .toRegisterAgentForMgn()
     * - .toStartCutover()
     * - .toStartTest()
     * - .toTagResource()
     * - .toTerminateTargetInstances()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - JobResource
     * - ReplicationConfigurationTemplateResource
     * - LaunchConfigurationTemplateResource
     * - VcenterClientResource
     * - SourceServerResource
     * - ApplicationResource
     * - WaveResource
     * - ImportResource
     * - ExportResource
     * - ConnectorResource
     * - NetworkMigrationDefinitionResource
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateConnector()
     * - .toCreateLaunchConfigurationTemplate()
     * - .toCreateReplicationConfigurationTemplate()
     * - .toCreateVcenterClientForMgn()
     * - .toCreateWave()
     * - .toRegisterAgentForMgn()
     * - .toStartCutover()
     * - .toStartTest()
     * - .toTagResource()
     * - .toTerminateTargetInstances()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the name of a resource-creating API action
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value, operator) {
        return this.if(`CreateAction`, value, operator ?? 'StringLike');
    }
    /**
     * Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'mgn';
        this.accessLevelList = {
            Write: [
                'ArchiveApplication',
                'ArchiveWave',
                'AssociateApplications',
                'AssociateSourceServers',
                'BatchCreateVolumeSnapshotGroupForMgn',
                'BatchDeleteSnapshotRequestForMgn',
                'ChangeServerLifeCycleState',
                'CreateApplication',
                'CreateConnector',
                'CreateLaunchConfigurationTemplate',
                'CreateNetworkMigrationDefinition',
                'CreateReplicationConfigurationTemplate',
                'CreateVcenterClientForMgn',
                'CreateWave',
                'DeleteApplication',
                'DeleteConnector',
                'DeleteJob',
                'DeleteLaunchConfigurationTemplate',
                'DeleteNetworkMigrationDefinition',
                'DeleteReplicationConfigurationTemplate',
                'DeleteSourceServer',
                'DeleteVcenterClient',
                'DeleteWave',
                'DisassociateApplications',
                'DisassociateSourceServers',
                'DisconnectFromService',
                'FinalizeCutover',
                'InitializeService',
                'IssueClientCertificateForMgn',
                'MarkAsArchived',
                'NotifyAgentAuthenticationForMgn',
                'NotifyAgentConnectedForMgn',
                'NotifyAgentDisconnectedForMgn',
                'NotifyAgentReplicationProgressForMgn',
                'NotifyVcenterClientStartedForMgn',
                'PauseReplication',
                'PutSourceServerAction',
                'PutTemplateAction',
                'RegisterAgentForMgn',
                'RemoveSourceServerAction',
                'RemoveTemplateAction',
                'ResumeReplication',
                'RetryDataReplication',
                'SendAgentLogsForMgn',
                'SendAgentMetricsForMgn',
                'SendChannelCommandResultForMgn',
                'SendClientLogsForMgn',
                'SendClientMetricsForMgn',
                'SendVcenterClientCommandResultForMgn',
                'SendVcenterClientLogsForMgn',
                'SendVcenterClientMetricsForMgn',
                'StartCutover',
                'StartExport',
                'StartImport',
                'StartNetworkMigrationAnalysis',
                'StartNetworkMigrationCodeGeneration',
                'StartNetworkMigrationDeployedStacksDeletion',
                'StartNetworkMigrationDeployment',
                'StartNetworkMigrationMapping',
                'StartReplication',
                'StartTest',
                'StopReplication',
                'TerminateTargetInstances',
                'UnarchiveApplication',
                'UnarchiveWave',
                'UpdateAgentBacklogForMgn',
                'UpdateAgentConversionInfoForMgn',
                'UpdateAgentReplicationInfoForMgn',
                'UpdateAgentReplicationProcessStateForMgn',
                'UpdateAgentSourcePropertiesForMgn',
                'UpdateApplication',
                'UpdateConnector',
                'UpdateLaunchConfiguration',
                'UpdateLaunchConfigurationTemplate',
                'UpdateNetworkMigrationDefinition',
                'UpdateNetworkMigrationMapperSegment',
                'UpdateNetworkMigrationMapperSegmentConstruct',
                'UpdateReplicationConfiguration',
                'UpdateReplicationConfigurationTemplate',
                'UpdateSourceServer',
                'UpdateSourceServerReplicationType',
                'UpdateWave'
            ],
            Read: [
                'DescribeJobLogItems',
                'DescribeReplicationServerAssociationsForMgn',
                'DescribeSnapshotRequestsForMgn',
                'GetAgentCommandForMgn',
                'GetAgentConfirmedResumeInfoForMgn',
                'GetAgentInstallationAssetsForMgn',
                'GetAgentReplicationInfoForMgn',
                'GetAgentRuntimeConfigurationForMgn',
                'GetAgentSnapshotCreditsForMgn',
                'GetChannelCommandsForMgn',
                'GetLaunchConfiguration',
                'GetNetworkMigrationDefinition',
                'GetNetworkMigrationMapperSegmentConstruct',
                'GetReplicationConfiguration',
                'GetVcenterClientCommandsForMgn',
                'ListConnectors',
                'ListTagsForResource',
                'VerifyClientRoleForMgn'
            ],
            List: [
                'DescribeJobs',
                'DescribeLaunchConfigurationTemplates',
                'DescribeReplicationConfigurationTemplates',
                'DescribeSourceServers',
                'DescribeVcenterClients',
                'ListApplications',
                'ListExportErrors',
                'ListExports',
                'ListImportErrors',
                'ListImports',
                'ListManagedAccounts',
                'ListNetworkMigrationAnalyses',
                'ListNetworkMigrationAnalysisResults',
                'ListNetworkMigrationCodeGenerationSegments',
                'ListNetworkMigrationCodeGenerations',
                'ListNetworkMigrationDefinitions',
                'ListNetworkMigrationDeployedStacks',
                'ListNetworkMigrationDeployedStacksDeletions',
                'ListNetworkMigrationDeployments',
                'ListNetworkMigrationExecutions',
                'ListNetworkMigrationMapperSegmentConstructs',
                'ListNetworkMigrationMapperSegments',
                'ListNetworkMigrationMappings',
                'ListSourceServerActions',
                'ListTemplateActions',
                'ListWaves'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
}
exports.Mgn = Mgn;
//# sourceMappingURL=data:application/json;base64,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