import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [arc-zonal-shift](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonapplicationrecoverycontroller-zonalshift.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ArcZonalShift extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to cancel an active zonal shift
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_CancelZonalShift.html
     */
    toCancelZonalShift(): this;
    /**
     * Grants permission to create a practice run configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * Dependent actions:
     * - cloudwatch:DescribeAlarms
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_CreatePracticeRunConfiguration.html
     */
    toCreatePracticeRunConfiguration(): this;
    /**
     * Grants permission to delete a practice run configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_DeletePracticeRunConfiguration.html
     */
    toDeletePracticeRunConfiguration(): this;
    /**
     * Grants permission to get autoshift observer notification status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_GetAutoshiftObserverNotificationStatus.html
     */
    toGetAutoshiftObserverNotificationStatus(): this;
    /**
     * Grants permission to get information about a managed resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_GetManagedResource.html
     */
    toGetManagedResource(): this;
    /**
     * Grants permission to list active and completed autoshifts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListAutoshifts.html
     */
    toListAutoshifts(): this;
    /**
     * Grants permission to list managed resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListManagedResources.html
     */
    toListManagedResources(): this;
    /**
     * Grants permission to list zonal shifts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListZonalShifts.html
     */
    toListZonalShifts(): this;
    /**
     * Grants permission to start a zonal shift
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_StartZonalShift.html
     */
    toStartZonalShift(): this;
    /**
     * Grants permission to update autoshift observer notification status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_UpdateAutoshiftObserverNotificationStatus.html
     */
    toUpdateAutoshiftObserverNotificationStatus(): this;
    /**
     * Grants permission to update a practice run configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * Dependent actions:
     * - cloudwatch:DescribeAlarms
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_UpdatePracticeRunConfiguration.html
     */
    toUpdatePracticeRunConfiguration(): this;
    /**
     * Grants permission to update a zonal autoshift status
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_UpdateZonalAutoshiftConfiguration.html
     */
    toUpdateZonalAutoshiftConfiguration(): this;
    /**
     * Grants permission to update an existing zonal shift
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_UpdateZonalShift.html
     */
    toUpdateZonalShift(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ALB to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     */
    onALB(loadBalancerName: string, loadBalancerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type NLB to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifResourceIdentifier()
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     */
    onNLB(loadBalancerName: string, loadBalancerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the resource identifier of the managed resource
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53applicationrecoverycontroller-zonalshift.html#amazonroute53applicationrecoverycontroller-zonalshift-policy-keys
     *
     * Applies to actions:
     * - .toCancelZonalShift()
     * - .toCreatePracticeRunConfiguration()
     * - .toDeletePracticeRunConfiguration()
     * - .toGetManagedResource()
     * - .toStartZonalShift()
     * - .toUpdatePracticeRunConfiguration()
     * - .toUpdateZonalAutoshiftConfiguration()
     * - .toUpdateZonalShift()
     *
     * Applies to resource types:
     * - ALB
     * - NLB
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceIdentifier(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the managed resource
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/load-balancer-authentication-access-control.html#elb-condition-keys
     *
     * Applies to actions:
     * - .toCancelZonalShift()
     * - .toCreatePracticeRunConfiguration()
     * - .toDeletePracticeRunConfiguration()
     * - .toGetManagedResource()
     * - .toStartZonalShift()
     * - .toUpdatePracticeRunConfiguration()
     * - .toUpdateZonalAutoshiftConfiguration()
     * - .toUpdateZonalShift()
     *
     * Applies to resource types:
     * - ALB
     * - NLB
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the managed resource
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/load-balancer-authentication-access-control.html#elb-condition-keys
     *
     * Applies to actions:
     * - .toCancelZonalShift()
     * - .toCreatePracticeRunConfiguration()
     * - .toDeletePracticeRunConfiguration()
     * - .toGetManagedResource()
     * - .toStartZonalShift()
     * - .toUpdatePracticeRunConfiguration()
     * - .toUpdateZonalAutoshiftConfiguration()
     * - .toUpdateZonalShift()
     *
     * Applies to resource types:
     * - ALB
     * - NLB
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifElasticloadbalancingResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [arc-zonal-shift](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonapplicationrecoverycontroller-zonalshift.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
