"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationTransformation = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [application-transformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationtransformationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ApplicationTransformation extends shared_1.PolicyStatement {
    /**
     * Grants permission to get the details of all Containerization jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetContainerization() {
        return this.to('GetContainerization');
    }
    /**
     * Grants permission to get the details of all Deployment jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetDeployment() {
        return this.to('GetDeployment');
    }
    /**
     * Grants permission to Get the details of a Grouping Assessment Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toGetGroupingAssessment() {
        return this.to('GetGroupingAssessment');
    }
    /**
     * Grants permission to Get Porting Compatibility Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toGetPortingCompatibilityAssessment() {
        return this.to('GetPortingCompatibilityAssessment');
    }
    /**
     * Grants permission to Get the details of a Porting Recommendation Assessment Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toGetPortingRecommendationAssessment() {
        return this.to('GetPortingRecommendationAssessment');
    }
    /**
     * Grants permission to Get the details of a Runtime Assessment Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toGetRuntimeAssessment() {
        return this.to('GetRuntimeAssessment');
    }
    /**
     * Grants permission to Push Logs (Intended for Clients Only)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toPutLogData() {
        return this.to('PutLogData');
    }
    /**
     * Grants permission to Push Metrics Data (Intended for Clients Only)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toPutMetricData() {
        return this.to('PutMetricData');
    }
    /**
     * Grants permission to start a Containerization job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartContainerization() {
        return this.to('StartContainerization');
    }
    /**
     * Grants permission to start a Deployment job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartDeployment() {
        return this.to('StartDeployment');
    }
    /**
     * Grants permission to Start a Grouping Assessment Operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toStartGroupingAssessment() {
        return this.to('StartGroupingAssessment');
    }
    /**
     * Grants permission to Start Porting Compatibility Operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toStartPortingCompatibilityAssessment() {
        return this.to('StartPortingCompatibilityAssessment');
    }
    /**
     * Grants permission to Start the Porting Recommendation Assessment Operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toStartPortingRecommendationAssessment() {
        return this.to('StartPortingRecommendationAssessment');
    }
    /**
     * Grants permission to Start a Runtime Assessment Operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toStartRuntimeAssessment() {
        return this.to('StartRuntimeAssessment');
    }
    /**
     * Statement provider for service [application-transformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationtransformationservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'application-transformation';
        this.accessLevelList = {
            Read: [
                'GetContainerization',
                'GetDeployment',
                'GetGroupingAssessment',
                'GetPortingCompatibilityAssessment',
                'GetPortingRecommendationAssessment',
                'GetRuntimeAssessment'
            ],
            Write: [
                'PutLogData',
                'PutMetricData',
                'StartContainerization',
                'StartDeployment',
                'StartGroupingAssessment',
                'StartPortingCompatibilityAssessment',
                'StartPortingRecommendationAssessment',
                'StartRuntimeAssessment'
            ]
        };
    }
}
exports.ApplicationTransformation = ApplicationTransformation;
//# sourceMappingURL=data:application/json;base64,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