"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bedrock = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [bedrock](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Bedrock extends shared_1.PolicyStatement {
    /**
     * Grants permission to configure vended log delivery for a knowledge base
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toAllowVendedLogDeliveryForResource() {
        return this.to('AllowVendedLogDeliveryForResource');
    }
    /**
     * Grants permission to apply a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toApplyGuardrail() {
        return this.to('ApplyGuardrail');
    }
    /**
     * Grants permission to associate another existing agent as a collaborator to an existing agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_AssociateAgentCollaborator.html
     */
    toAssociateAgentCollaborator() {
        return this.to('AssociateAgentCollaborator');
    }
    /**
     * Grants permission to associate a knowledge base with an agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_AssociateAgentKnowledgeBase.html
     */
    toAssociateAgentKnowledgeBase() {
        return this.to('AssociateAgentKnowledgeBase');
    }
    /**
     * Grants permission to use 3rd party platform to store knowledge data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifThirdPartyKnowledgeBaseCredentialsSecretArn()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toAssociateThirdPartyKnowledgeBase() {
        return this.to('AssociateThirdPartyKnowledgeBase');
    }
    /**
     * Grants permission to batch delete list of bedrock evaluation jobs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_BatchDeleteEvaluationJob.html
     */
    toBatchDeleteEvaluationJob() {
        return this.to('BatchDeleteEvaluationJob');
    }
    /**
     * Grants permission to create a new agent and a test agent alias pointing to the DRAFT agent version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgent.html
     */
    toCreateAgent() {
        return this.to('CreateAgent');
    }
    /**
     * Grants permission to create a new action group in an existing agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html
     */
    toCreateAgentActionGroup() {
        return this.to('CreateAgentActionGroup');
    }
    /**
     * Grants permission to create a new alias for an agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentAlias.html
     */
    toCreateAgentAlias() {
        return this.to('CreateAgentAlias');
    }
    /**
     * Grants permission to create a blueprint for custom output from data automation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_CreateBlueprint.html
     */
    toCreateBlueprint() {
        return this.to('CreateBlueprint');
    }
    /**
     * Grants permission to create a new version for an existing blueprint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_CreateBlueprintVersion.html
     */
    toCreateBlueprintVersion() {
        return this.to('CreateBlueprintVersion');
    }
    /**
     * Grants permission to create a data automation project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_CreateDataAutomationProject.html
     */
    toCreateDataAutomationProject() {
        return this.to('CreateDataAutomationProject');
    }
    /**
     * Grants permission to create a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateDataSource.html
     */
    toCreateDataSource() {
        return this.to('CreateDataSource');
    }
    /**
     * Grants permission to create a job for evaluation foundation models or custom models
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateEvaluationJob.html
     */
    toCreateEvaluationJob() {
        return this.to('CreateEvaluationJob');
    }
    /**
     * Grants permission to create a prompt flow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateFlow.html
     */
    toCreateFlow() {
        return this.to('CreateFlow');
    }
    /**
     * Grants permission to create an alias of a prompt flow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateFlowAlias.html
     */
    toCreateFlowAlias() {
        return this.to('CreateFlowAlias');
    }
    /**
     * Grants permission to create an immutable version of a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateFlowVersion.html
     */
    toCreateFlowVersion() {
        return this.to('CreateFlowVersion');
    }
    /**
     * Grants permission to create a new foundation model agreement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toCreateFoundationModelAgreement() {
        return this.to('CreateFoundationModelAgreement');
    }
    /**
     * Grants permission to create a new guardrail
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCreateGuardrail() {
        return this.to('CreateGuardrail');
    }
    /**
     * Grants permission to create a new guardrail version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCreateGuardrailVersion() {
        return this.to('CreateGuardrailVersion');
    }
    /**
     * Grants permission to create inference profiles
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateInferenceProfile.html
     */
    toCreateInferenceProfile() {
        return this.to('CreateInferenceProfile');
    }
    /**
     * Grants permission to create a new invocation in an existing session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_CreateInvocation.html
     */
    toCreateInvocation() {
        return this.to('CreateInvocation');
    }
    /**
     * Grants permission to create a knowledge base
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateKnowledgeBase.html
     */
    toCreateKnowledgeBase() {
        return this.to('CreateKnowledgeBase');
    }
    /**
     * Grants permission to create a marketplace model endpoint
     *
     * Access Level: Write
     */
    toCreateMarketplaceModelEndpoint() {
        return this.to('CreateMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to create a job for copying a custom model across region or across account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelCopyJob.html
     */
    toCreateModelCopyJob() {
        return this.to('CreateModelCopyJob');
    }
    /**
     * Grants permission to create a job for customizing the model with your custom training data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelCustomizationJob.html
     */
    toCreateModelCustomizationJob() {
        return this.to('CreateModelCustomizationJob');
    }
    /**
     * Grants permission to create a job for evaluation foundation models or custom models
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelEvaluationJob.html
     */
    toCreateModelEvaluationJob() {
        return this.to('CreateModelEvaluationJob');
    }
    /**
     * Grants permission to create a job for importing model into Bedrock
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html
     */
    toCreateModelImportJob() {
        return this.to('CreateModelImportJob');
    }
    /**
     * Grants permission to create a new model invocation job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelInvocationJob.html
     */
    toCreateModelInvocationJob() {
        return this.to('CreateModelInvocationJob');
    }
    /**
     * Grants permission to create a prompt
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreatePrompt.html
     */
    toCreatePrompt() {
        return this.to('CreatePrompt');
    }
    /**
     * Grants permission to create a custom prompt router
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreatePromptRouter.html
     */
    toCreatePromptRouter() {
        return this.to('CreatePromptRouter');
    }
    /**
     * Grants permission to create a version of a prompt
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreatePromptVersion.html
     */
    toCreatePromptVersion() {
        return this.to('CreatePromptVersion');
    }
    /**
     * Grants permission to create a new provisioned model throughput
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateProvisionedModelThroughput.html
     */
    toCreateProvisionedModelThroughput() {
        return this.to('CreateProvisionedModelThroughput');
    }
    /**
     * Grants permission to create a new session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_CreateSession.html
     */
    toCreateSession() {
        return this.to('CreateSession');
    }
    /**
     * Grants permission to delete an Agent that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteAgent.html
     */
    toDeleteAgent() {
        return this.to('DeleteAgent');
    }
    /**
     * Grants permission to delete an actionGroup that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteAgentActionGroup.html
     */
    toDeleteAgentActionGroup() {
        return this.to('DeleteAgentActionGroup');
    }
    /**
     * Grants permission to delete an AgentAlias that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteAgentAlias.html
     */
    toDeleteAgentAlias() {
        return this.to('DeleteAgentAlias');
    }
    /**
     * Grants permission to delete existing memory for an alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_DeleteAgentMemory.html
     */
    toDeleteAgentMemory() {
        return this.to('DeleteAgentMemory');
    }
    /**
     * Grants permission to delete an Agent Version that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteAgentVersion.html
     */
    toDeleteAgentVersion() {
        return this.to('DeleteAgentVersion');
    }
    /**
     * Grants permission to delete a blueprint for data automation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_DeleteBlueprint.html
     */
    toDeleteBlueprint() {
        return this.to('DeleteBlueprint');
    }
    /**
     * Grants permission to delete a custom model that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModel.html
     */
    toDeleteCustomModel() {
        return this.to('DeleteCustomModel');
    }
    /**
     * Grants permission to delete a data automation project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_DeleteDataAutomationProject.html
     */
    toDeleteDataAutomationProject() {
        return this.to('DeleteDataAutomationProject');
    }
    /**
     * Grants permission to delete a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteDataSource.html
     */
    toDeleteDataSource() {
        return this.to('DeleteDataSource');
    }
    /**
     * Grants permission to delete a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteFlow.html
     */
    toDeleteFlow() {
        return this.to('DeleteFlow');
    }
    /**
     * Grants permission to delete an alias of a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteFlowAlias.html
     */
    toDeleteFlowAlias() {
        return this.to('DeleteFlowAlias');
    }
    /**
     * Grants permission to delete a version of a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteFlowVersion.html
     */
    toDeleteFlowVersion() {
        return this.to('DeleteFlowVersion');
    }
    /**
     * Grants permission to delete a foundation model agreement that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toDeleteFoundationModelAgreement() {
        return this.to('DeleteFoundationModelAgreement');
    }
    /**
     * Grants permission to delete a guardrail or its version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toDeleteGuardrail() {
        return this.to('DeleteGuardrail');
    }
    /**
     * Grants permission to delete previously created Bedrock imported model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteImportedModel.html
     */
    toDeleteImportedModel() {
        return this.to('DeleteImportedModel');
    }
    /**
     * Grants permission to delete inference profiles
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteInferenceProfile.html
     */
    toDeleteInferenceProfile() {
        return this.to('DeleteInferenceProfile');
    }
    /**
     * Grants permission to delete a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteKnowledgeBase.html
     */
    toDeleteKnowledgeBase() {
        return this.to('DeleteKnowledgeBase');
    }
    /**
     * Grants permission to delete documents from a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteKnowledgeBaseDocuments.html
     */
    toDeleteKnowledgeBaseDocuments() {
        return this.to('DeleteKnowledgeBaseDocuments');
    }
    /**
     * Grants permission to unsubscribe from a bedrock marketplace enabled AWS marketplace model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toDeleteMarketplaceModelAgreement() {
        return this.to('DeleteMarketplaceModelAgreement');
    }
    /**
     * Grants permission to delete a marketplace model endpoint
     *
     * Access Level: Write
     */
    toDeleteMarketplaceModelEndpoint() {
        return this.to('DeleteMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to delete an existing Invocation logging configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteModelInvocationLoggingConfiguration.html
     */
    toDeleteModelInvocationLoggingConfiguration() {
        return this.to('DeleteModelInvocationLoggingConfiguration');
    }
    /**
     * Grants permission to delete a prompt or its version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeletePrompt.html
     */
    toDeletePrompt() {
        return this.to('DeletePrompt');
    }
    /**
     * Grants permission to delete a custom prompt router
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeletePromptRouter.html
     */
    toDeletePromptRouter() {
        return this.to('DeletePromptRouter');
    }
    /**
     * Grants permission to delete a provisioned model throughput that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteProvisionedModelThroughput.html
     */
    toDeleteProvisionedModelThroughput() {
        return this.to('DeleteProvisionedModelThroughput');
    }
    /**
     * Deletes a previously created Bedrock resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * Grants permission to delete a Session that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_DeleteSession.html
     */
    toDeleteSession() {
        return this.to('DeleteSession');
    }
    /**
     * Grants permission to deregister a marketplace model endpoint to make it unusable in Bedrock Marketplace
     *
     * Access Level: Write
     */
    toDeregisterMarketplaceModelEndpoint() {
        return this.to('DeregisterMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to detect if the provided content is generated using Amazon Bedrock
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toDetectGeneratedContent() {
        return this.to('DetectGeneratedContent');
    }
    /**
     * Grants permission to diassociate a collaborator that you associated earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DisassociateAgentCollaborator.html
     */
    toDisassociateAgentCollaborator() {
        return this.to('DisassociateAgentCollaborator');
    }
    /**
     * Grants permission to disassociate a knowledge base from the agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DisassociateAgentKnowledgeBase.html
     */
    toDisassociateAgentKnowledgeBase() {
        return this.to('DisassociateAgentKnowledgeBase');
    }
    /**
     * Grants permission to end a Session that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html
     */
    toEndSession() {
        return this.to('EndSession');
    }
    /**
     * Grants permission to generate queries associated with user input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGenerateQuery() {
        return this.to('GenerateQuery');
    }
    /**
     * Grants permission to retrieve an existing agent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgent.html
     */
    toGetAgent() {
        return this.to('GetAgent');
    }
    /**
     * Grants permission to retrieve an existing action group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html
     */
    toGetAgentActionGroup() {
        return this.to('GetAgentActionGroup');
    }
    /**
     * Grants permission to retrieve an existing alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentAlias.html
     */
    toGetAgentAlias() {
        return this.to('GetAgentAlias');
    }
    /**
     * Grants permission to retrieve an existing collaborator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentCollaborator.html
     */
    toGetAgentCollaborator() {
        return this.to('GetAgentCollaborator');
    }
    /**
     * Grants permission to describe a knowledge base associated with an agent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentKnowledgeBase.html
     */
    toGetAgentKnowledgeBase() {
        return this.to('GetAgentKnowledgeBase');
    }
    /**
     * Grants permission to retrieve existing memory for an alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetAgentMemory.html
     */
    toGetAgentMemory() {
        return this.to('GetAgentMemory');
    }
    /**
     * Grants permission to retrieve an existing version of an agent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentVersion.html
     */
    toGetAgentVersion() {
        return this.to('GetAgentVersion');
    }
    /**
     * Grants permission to get the properties associated with an asynchronous invocation that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetAsyncInvoke.html
     */
    toGetAsyncInvoke() {
        return this.to('GetAsyncInvoke');
    }
    /**
     * Grants permission to retrieve an existing blueprint for data automation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_GetBlueprint.html
     */
    toGetBlueprint() {
        return this.to('GetBlueprint');
    }
    /**
     * Grants permission to retrieve blueprint recommendation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetBlueprintRecommendation() {
        return this.to('GetBlueprintRecommendation');
    }
    /**
     * Grants permission to get the properties associated with a Bedrock custom model that you have created
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModel.html
     */
    toGetCustomModel() {
        return this.to('GetCustomModel');
    }
    /**
     * Grants permission to retrieve an existing data automation project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_GetDataAutomationProject.html
     */
    toGetDataAutomationProject() {
        return this.to('GetDataAutomationProject');
    }
    /**
     * Grants permission to retrieve the status of a data automation invocation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation-runtime_GetDataAutomationStatus.html
     */
    toGetDataAutomationStatus() {
        return this.to('GetDataAutomationStatus');
    }
    /**
     * Grants permission to retrieve an existing data source
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetDataSource.html
     */
    toGetDataSource() {
        return this.to('GetDataSource');
    }
    /**
     * Grants permission to get the properties associated with a evaluation job. Use this operation to get the status of a evaluation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetEvaluationJob.html
     */
    toGetEvaluationJob() {
        return this.to('GetEvaluationJob');
    }
    /**
     * Grants permission to retrieve an existing prompt flow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html
     */
    toGetFlow() {
        return this.to('GetFlow');
    }
    /**
     * Grants permission to retrieve an existing alias of a prompt flow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowAlias.html
     */
    toGetFlowAlias() {
        return this.to('GetFlowAlias');
    }
    /**
     * Grants permission to retrieve an existing version of a prompt flow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowVersion.html
     */
    toGetFlowVersion() {
        return this.to('GetFlowVersion');
    }
    /**
     * Grants permission to get the properties associated with a Bedrock foundation model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html
     */
    toGetFoundationModel() {
        return this.to('GetFoundationModel');
    }
    /**
     * Grants permission to get the availability of a foundation model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toGetFoundationModelAvailability() {
        return this.to('GetFoundationModelAvailability');
    }
    /**
     * Grants permission to retrieve a guardrail or its version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetGuardrail() {
        return this.to('GetGuardrail');
    }
    /**
     * Grants permission to get the properties associated with Bedrock imported model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetImportedModel.html
     */
    toGetImportedModel() {
        return this.to('GetImportedModel');
    }
    /**
     * Grants permission to get the properties associated with an inference profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetInferenceProfile.html
     */
    toGetInferenceProfile() {
        return this.to('GetInferenceProfile');
    }
    /**
     * Grants permission to retrieve an existing ingestion job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetIngestionJob.html
     */
    toGetIngestionJob() {
        return this.to('GetIngestionJob');
    }
    /**
     * Grants permission to get an invocation step from a session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetInvocationStep.html
     */
    toGetInvocationStep() {
        return this.to('GetInvocationStep');
    }
    /**
     * Grants permission to retrieve an existing knowledge base
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetKnowledgeBase.html
     */
    toGetKnowledgeBase() {
        return this.to('GetKnowledgeBase');
    }
    /**
     * Grants permission to get details for documents in a knowledge base
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetKnowledgeBaseDocuments.html
     */
    toGetKnowledgeBaseDocuments() {
        return this.to('GetKnowledgeBaseDocuments');
    }
    /**
     * Grants permission to get the properties of a marketplace model endpoint
     *
     * Access Level: Read
     */
    toGetMarketplaceModelEndpoint() {
        return this.to('GetMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to get the properties associated with a model-copy job. Use this operation to get the status of a model-copy job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelCopyJob.html
     */
    toGetModelCopyJob() {
        return this.to('GetModelCopyJob');
    }
    /**
     * Grants permission to get the properties associated with a model-customization job. Use this operation to get the status of a model-customization job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelCustomizationJob.html
     */
    toGetModelCustomizationJob() {
        return this.to('GetModelCustomizationJob');
    }
    /**
     * Grants permission to get the properties associated with a model-evaluation job. Use this operation to get the status of a model-evaluation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelEvaluationJob.html
     */
    toGetModelEvaluationJob() {
        return this.to('GetModelEvaluationJob');
    }
    /**
     * Grants permission to get the properties associated with a model import job and is used to get the status of a model import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelImportJob.html
     */
    toGetModelImportJob() {
        return this.to('GetModelImportJob');
    }
    /**
     * Grants permission to retrieve a model invocation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelInvocationJob.html
     */
    toGetModelInvocationJob() {
        return this.to('GetModelInvocationJob');
    }
    /**
     * Grants permission to retrieve an existing Invocation logging configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelInvocationLoggingConfiguration.html
     */
    toGetModelInvocationLoggingConfiguration() {
        return this.to('GetModelInvocationLoggingConfiguration');
    }
    /**
     * Grants permission to retrieve an existing prompt or its version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetPrompt.html
     */
    toGetPrompt() {
        return this.to('GetPrompt');
    }
    /**
     * Grants permission to get the properties associated with a prompt router
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetPromptRouter.html
     */
    toGetPromptRouter() {
        return this.to('GetPromptRouter');
    }
    /**
     * Grants permission to retrieve a provisioned model throughput
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetProvisionedModelThroughput.html
     */
    toGetProvisionedModelThroughput() {
        return this.to('GetProvisionedModelThroughput');
    }
    /**
     * Gets the resource policy document for a Bedrock resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetResourePolicy.html
     */
    toGetResourcePolicy() {
        return this.to('GetResourcePolicy');
    }
    /**
     * Grants permission to retrieve an existing session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html
     */
    toGetSession() {
        return this.to('GetSession');
    }
    /**
     * Grants permission to retrieve a use case for model access
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toGetUseCaseForModelAccess() {
        return this.to('GetUseCaseForModelAccess');
    }
    /**
     * Grants permission to directly ingest documents into a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_IngestKnowledgeBaseDocuments.html
     */
    toIngestKnowledgeBaseDocuments() {
        return this.to('IngestKnowledgeBaseDocuments');
    }
    /**
     * Grants permission to send user input (text-only) to the alias of an agent for Bedrock
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html
     */
    toInvokeAgent() {
        return this.to('InvokeAgent');
    }
    /**
     * Grants permission to invoke blueprint recommendations asynchronously
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toInvokeBlueprintRecommendationAsync() {
        return this.to('InvokeBlueprintRecommendationAsync');
    }
    /**
     * Grants permission to use the conversational builder which aids in building supported bedrock resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/userguide/agents-create-cb.html
     */
    toInvokeBuilder() {
        return this.to('InvokeBuilder');
    }
    /**
     * Grants permission to invoke a Bedrock data automation job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation-runtime_InvokeDataAutomationAsync.html
     */
    toInvokeDataAutomationAsync() {
        return this.to('InvokeDataAutomationAsync');
    }
    /**
     * Grants permission to invoke a prompt flow with user input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html
     */
    toInvokeFlow() {
        return this.to('InvokeFlow');
    }
    /**
     * Grants permission to send user input (text-only) to the inline agent for Bedrock
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html
     */
    toInvokeInlineAgent() {
        return this.to('InvokeInlineAgent');
    }
    /**
     * Grants permission to invoke the specified Bedrock model to run inference using the input provided in the request body
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInferenceProfileArn()
     * - .ifPromptRouterArn()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifGuardrailIdentifier()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModel.html
     */
    toInvokeModel() {
        return this.to('InvokeModel');
    }
    /**
     * Grants permission to invoke the specified Bedrock model to run inference using the input provided in the request body with streaming response
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInferenceProfileArn()
     * - .ifPromptRouterArn()
     * - .ifGuardrailIdentifier()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModelWithResponseStream.html
     */
    toInvokeModelWithResponseStream() {
        return this.to('InvokeModelWithResponseStream');
    }
    /**
     * Grants permission to list action groups in an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentActionGroups.html
     */
    toListAgentActionGroups() {
        return this.to('ListAgentActionGroups');
    }
    /**
     * Grants permission to list aliases for an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentAliases.html
     */
    toListAgentAliases() {
        return this.to('ListAgentAliases');
    }
    /**
     * Grants permission to list collaborators for an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentCollaborators.html
     */
    toListAgentCollaborators() {
        return this.to('ListAgentCollaborators');
    }
    /**
     * Grants permission to list knowledge bases associated with an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentKnowledgeBases.html
     */
    toListAgentKnowledgeBases() {
        return this.to('ListAgentKnowledgeBases');
    }
    /**
     * Grants permission to list existing versions of an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentVersions.html
     */
    toListAgentVersions() {
        return this.to('ListAgentVersions');
    }
    /**
     * Grants permission to list existing agents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgents.html
     */
    toListAgents() {
        return this.to('ListAgents');
    }
    /**
     * Grants permission to get a list of asynchronous invocations that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListAsyncInvokes.html
     */
    toListAsyncInvokes() {
        return this.to('ListAsyncInvokes');
    }
    /**
     * Grants permission to list existing blueprints for data automation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_ListBlueprints.html
     */
    toListBlueprints() {
        return this.to('ListBlueprints');
    }
    /**
     * Grants permission to get a list of Bedrock custom models that you have created
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModels.html
     */
    toListCustomModels() {
        return this.to('ListCustomModels');
    }
    /**
     * Grants permission to list existing data automation projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_ListDataAutomationProjects.html
     */
    toListDataAutomationProjects() {
        return this.to('ListDataAutomationProjects');
    }
    /**
     * Grants permission to list existing data sources in an knowledge base
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListDataSources.html
     */
    toListDataSources() {
        return this.to('ListDataSources');
    }
    /**
     * Grants permission to get the list of evaluation jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListEvaluationJobs.html
     */
    toListEvaluationJobs() {
        return this.to('ListEvaluationJobs');
    }
    /**
     * Grants permission to list existing aliases of a prompt flow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowAliases.html
     */
    toListFlowAliases() {
        return this.to('ListFlowAliases');
    }
    /**
     * Grants permission to list existing versions of a prompt flow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowVersions.html
     */
    toListFlowVersions() {
        return this.to('ListFlowVersions');
    }
    /**
     * Grants permission to list existing prompt flows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlows.html
     */
    toListFlows() {
        return this.to('ListFlows');
    }
    /**
     * Grants permission to get a list of foundation model agreement offers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toListFoundationModelAgreementOffers() {
        return this.to('ListFoundationModelAgreementOffers');
    }
    /**
     * Grants permission to list Bedrock foundation models that you can use
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListFoundationModels.html
     */
    toListFoundationModels() {
        return this.to('ListFoundationModels');
    }
    /**
     * Grants permission to list guardrails or its versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toListGuardrails() {
        return this.to('ListGuardrails');
    }
    /**
     * Grants permission to get list of Bedrock imported models
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListImportedModels.html
     */
    toListImportedModels() {
        return this.to('ListImportedModels');
    }
    /**
     * Grants permission to list inference profiles that you can use
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListInferenceProfiles.html
     */
    toListInferenceProfiles() {
        return this.to('ListInferenceProfiles');
    }
    /**
     * Grants permission to list ingestion jobs in a data source
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListIngestionJobs.html
     */
    toListIngestionJobs() {
        return this.to('ListIngestionJobs');
    }
    /**
     * Grants permission to get list of invocation step from a session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocationSteps.html
     */
    toListInvocationSteps() {
        return this.to('ListInvocationSteps');
    }
    /**
     * Grants permission to list invocations in a session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html
     */
    toListInvocations() {
        return this.to('ListInvocations');
    }
    /**
     * Grants permission to list documents in a knowledge base
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListKnowledgeBaseDocuments.html
     */
    toListKnowledgeBaseDocuments() {
        return this.to('ListKnowledgeBaseDocuments');
    }
    /**
     * Grants permission to list existing knowledge bases
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListKnowledgeBases.html
     */
    toListKnowledgeBases() {
        return this.to('ListKnowledgeBases');
    }
    /**
     * Grants permission to list marketplace model endpoints that you can use
     *
     * Access Level: Read
     */
    toListMarketplaceModelEndpoints() {
        return this.to('ListMarketplaceModelEndpoints');
    }
    /**
     * Grants permission to get the list of model copy jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelCopyJobs.html
     */
    toListModelCopyJobs() {
        return this.to('ListModelCopyJobs');
    }
    /**
     * Grants permission to get the list of model customization jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelCustomizationJobs.html
     */
    toListModelCustomizationJobs() {
        return this.to('ListModelCustomizationJobs');
    }
    /**
     * Grants permission to get the list of model evaluation jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelEvaluationJobs.html
     */
    toListModelEvaluationJobs() {
        return this.to('ListModelEvaluationJobs');
    }
    /**
     * Grants permission to get list of model import jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelImportJobs.html
     */
    toListModelImportJobs() {
        return this.to('ListModelImportJobs');
    }
    /**
     * Grants permission to list model invocation jobs that you created earlier
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelInvocationJobs.html
     */
    toListModelInvocationJobs() {
        return this.to('ListModelInvocationJobs');
    }
    /**
     * Grants permission to list prompt routers that you can use
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListPromptRouters.html
     */
    toListPromptRouters() {
        return this.to('ListPromptRouters');
    }
    /**
     * Grants permission to list existing prompts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListPrompts.html
     */
    toListPrompts() {
        return this.to('ListPrompts');
    }
    /**
     * Grants permission to list provisioned model throughputs that you created earlier
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListProvisionedModelThroughputs.html
     */
    toListProvisionedModelThroughputs() {
        return this.to('ListProvisionedModelThroughputs');
    }
    /**
     * Grants permission to list existing sessions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html
     */
    toListSessions() {
        return this.to('ListSessions');
    }
    /**
     * Grants permission to list tags for a Bedrock resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to optimize a prompt with user input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_OptimizePrompt.html
     */
    toOptimizePrompt() {
        return this.to('OptimizePrompt');
    }
    /**
     * Grants permission to prepare an existing agent to receive runtime requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareAgent.html
     */
    toPrepareAgent() {
        return this.to('PrepareAgent');
    }
    /**
     * Grants permission to apply the latest changes made to a prompt flow, so that they are reflected at runtime
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html
     */
    toPrepareFlow() {
        return this.to('PrepareFlow');
    }
    /**
     * Grants permission to put entitlement to access a foundation model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toPutFoundationModelEntitlement() {
        return this.to('PutFoundationModelEntitlement');
    }
    /**
     * Grants permission to put an invocation step into an invocation in session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_PutInvocationStep.html
     */
    toPutInvocationStep() {
        return this.to('PutInvocationStep');
    }
    /**
     * Grants permission to create an existing Invocation logging configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_PutModelInvocationLoggingConfiguration.html
     */
    toPutModelInvocationLoggingConfiguration() {
        return this.to('PutModelInvocationLoggingConfiguration');
    }
    /**
     * Adds a resource policy for a Bedrock resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy() {
        return this.to('PutResourcePolicy');
    }
    /**
     * Grants permission to put a use case for model access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toPutUseCaseForModelAccess() {
        return this.to('PutUseCaseForModelAccess');
    }
    /**
     * Grants permission to register a sagemaker endpoint as a marketplace model endpoint
     *
     * Access Level: Write
     */
    toRegisterMarketplaceModelEndpoint() {
        return this.to('RegisterMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to render an existing prompt or its version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toRenderPrompt() {
        return this.to('RenderPrompt');
    }
    /**
     * Grants permission to rank documents based on user input
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toRerank() {
        return this.to('Rerank');
    }
    /**
     * Grants permission to retrieve ingested data from a knowledge base
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toRetrieve() {
        return this.to('Retrieve');
    }
    /**
     * Grants permission to send user input to perform retrieval and generation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toRetrieveAndGenerate() {
        return this.to('RetrieveAndGenerate');
    }
    /**
     * Grants permission to start an ingestion job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StartIngestionJob.html
     */
    toStartIngestionJob() {
        return this.to('StartIngestionJob');
    }
    /**
     * Grants permission to stop a evaluation job while in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_StopEvaluationJob.html
     */
    toStopEvaluationJob() {
        return this.to('StopEvaluationJob');
    }
    /**
     * Grants permission to stop an ingestion job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StopIngestionJob.html
     */
    toStopIngestionJob() {
        return this.to('StopIngestionJob');
    }
    /**
     * Grants permission to stop a Bedrock model customization job while in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_StopModelCustomizationJob.html
     */
    toStopModelCustomizationJob() {
        return this.to('StopModelCustomizationJob');
    }
    /**
     * Grants permission to stop a model invocation job that you started earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_StopModelInvocationJob.html
     */
    toStopModelInvocationJob() {
        return this.to('StopModelInvocationJob');
    }
    /**
     * Grants permission to Tag a Bedrock resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to Untag a Bedrock resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an existing agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgent.html
     */
    toUpdateAgent() {
        return this.to('UpdateAgent');
    }
    /**
     * Grants permission to update an existing action group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html
     */
    toUpdateAgentActionGroup() {
        return this.to('UpdateAgentActionGroup');
    }
    /**
     * Grants permission to update an existing alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentAlias.html
     */
    toUpdateAgentAlias() {
        return this.to('UpdateAgentAlias');
    }
    /**
     * Grants permission to update an existing collaborator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentCollaborator.html
     */
    toUpdateAgentCollaborator() {
        return this.to('UpdateAgentCollaborator');
    }
    /**
     * Grants permission to update a knowledge base associated with an agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentKnowledgeBase.html
     */
    toUpdateAgentKnowledgeBase() {
        return this.to('UpdateAgentKnowledgeBase');
    }
    /**
     * Grants permission to update a blueprint for data automation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_UpdateBlueprint.html
     */
    toUpdateBlueprint() {
        return this.to('UpdateBlueprint');
    }
    /**
     * Grants permission to update a data automation project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_UpdateDataAutomationProject.html
     */
    toUpdateDataAutomationProject() {
        return this.to('UpdateDataAutomationProject');
    }
    /**
     * Grants permission to update a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateDataSource.html
     */
    toUpdateDataSource() {
        return this.to('UpdateDataSource');
    }
    /**
     * Grants permission to update a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateFlow.html
     */
    toUpdateFlow() {
        return this.to('UpdateFlow');
    }
    /**
     * Grants permission to update the configuration of an alias of a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateFlowAlias.html
     */
    toUpdateFlowAlias() {
        return this.to('UpdateFlowAlias');
    }
    /**
     * Grants permission to update a guardrail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toUpdateGuardrail() {
        return this.to('UpdateGuardrail');
    }
    /**
     * Grants permission to update a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateKnowledgeBase.html
     */
    toUpdateKnowledgeBase() {
        return this.to('UpdateKnowledgeBase');
    }
    /**
     * Grants permission to update a marketplace model endpoint
     *
     * Access Level: Write
     */
    toUpdateMarketplaceModelEndpoint() {
        return this.to('UpdateMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to update a prompt
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdatePrompt.html
     */
    toUpdatePrompt() {
        return this.to('UpdatePrompt');
    }
    /**
     * Grants permission to update a provisioned model throughput that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_UpdateProvisionedModelThroughput.html
     */
    toUpdateProvisionedModelThroughput() {
        return this.to('UpdateProvisionedModelThroughput');
    }
    /**
     * Grants permission to update an existing session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_UpdateSession.html
     */
    toUpdateSession() {
        return this.to('UpdateSession');
    }
    /**
     * Grants permission to validate prompt flow definitions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ValidateFlowDefinition.html
     */
    toValidateFlowDefinition() {
        return this.to('ValidateFlowDefinition');
    }
    /**
     * Adds a resource of type foundation-model to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFoundationModel(resourceId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}::foundation-model/${resourceId}`);
    }
    /**
     * Adds a resource of type async-invoke to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAsyncInvoke(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:async-invoke/${resourceId}`);
    }
    /**
     * Adds a resource of type inference-profile to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onInferenceProfile(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:inference-profile/${resourceId}`);
    }
    /**
     * Adds a resource of type default-prompt-router to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDefaultPromptRouter(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:default-prompt-router/${resourceId}`);
    }
    /**
     * Adds a resource of type prompt-router to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPromptRouter(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:prompt-router/${resourceId}`);
    }
    /**
     * Adds a resource of type application-inference-profile to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationInferenceProfile(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:application-inference-profile/${resourceId}`);
    }
    /**
     * Adds a resource of type custom-model to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomModel(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:custom-model/${resourceId}`);
    }
    /**
     * Adds a resource of type provisioned-model to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProvisionedModel(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:provisioned-model/${resourceId}`);
    }
    /**
     * Adds a resource of type model-customization-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelCustomizationJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-customization-job/${resourceId}`);
    }
    /**
     * Adds a resource of type agent to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param agentId - Identifier for the agentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAgent(agentId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:agent/${agentId}`);
    }
    /**
     * Adds a resource of type agent-alias to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param agentId - Identifier for the agentId.
     * @param agentAliasId - Identifier for the agentAliasId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAgentAlias(agentId, agentAliasId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:agent-alias/${agentId}/${agentAliasId}`);
    }
    /**
     * Adds a resource of type knowledge-base to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKnowledgeBase(knowledgeBaseId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:knowledge-base/${knowledgeBaseId}`);
    }
    /**
     * Adds a resource of type model-evaluation-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelEvaluationJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-evaluation-job/${resourceId}`);
    }
    /**
     * Adds a resource of type evaluation-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEvaluationJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:evaluation-job/${resourceId}`);
    }
    /**
     * Adds a resource of type model-invocation-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param jobIdentifier - Identifier for the jobIdentifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelInvocationJob(jobIdentifier, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-invocation-job/${jobIdentifier}`);
    }
    /**
     * Adds a resource of type guardrail to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param guardrailId - Identifier for the guardrailId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGuardrail(guardrailId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:guardrail/${guardrailId}`);
    }
    /**
     * Adds a resource of type flow to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowSummary.html
     *
     * @param flowId - Identifier for the flowId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFlow(flowId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:flow/${flowId}`);
    }
    /**
     * Adds a resource of type flow-alias to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowAliasSummary.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowAliasId - Identifier for the flowAliasId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFlowAlias(flowId, flowAliasId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:flow/${flowId}/alias/${flowAliasId}`);
    }
    /**
     * Adds a resource of type model-copy-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelCopyJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-copy-job/${resourceId}`);
    }
    /**
     * Adds a resource of type prompt to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptSummary.html
     *
     * @param promptId - Identifier for the promptId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPrompt(promptId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:prompt/${promptId}`);
    }
    /**
     * Adds a resource of type prompt-version to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptSummary.html
     *
     * @param promptId - Identifier for the promptId.
     * @param promptVersion - Identifier for the promptVersion.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPromptVersion(promptId, promptVersion, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:prompt/${promptId}:${promptVersion}`);
    }
    /**
     * Adds a resource of type model-import-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelImportJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-import-job/${resourceId}`);
    }
    /**
     * Adds a resource of type imported-model to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onImportedModel(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:imported-model/${resourceId}`);
    }
    /**
     * Adds a resource of type bedrock-marketplace-model-endpoint to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBedrockMarketplaceModelEndpoint(account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:marketplace/model-endpoint/all-access`);
    }
    /**
     * Adds a resource of type data-automation-project to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param projectId - Identifier for the projectId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataAutomationProject(projectId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:data-automation-project/${projectId}`);
    }
    /**
     * Adds a resource of type blueprint to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param blueprintId - Identifier for the blueprintId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBlueprint(blueprintId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:blueprint/${blueprintId}`);
    }
    /**
     * Adds a resource of type data-automation-invocation-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataAutomationInvocationJob(jobId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:data-automation-invocation/${jobId}`);
    }
    /**
     * Adds a resource of type data-automation-profile to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param profileId - Identifier for the profileId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataAutomationProfile(profileId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:data-automation-profile/${profileId}`);
    }
    /**
     * Adds a resource of type session to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSession(sessionId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:session/${sessionId}`);
    }
    /**
     * Filters access by creating requests based on the allowed set of values for each of the mandatory tags
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toCreateAgent()
     * - .toCreateAgentActionGroup()
     * - .toCreateAgentAlias()
     * - .toCreateEvaluationJob()
     * - .toCreateFlow()
     * - .toCreateFlowAlias()
     * - .toCreateGuardrail()
     * - .toCreateInferenceProfile()
     * - .toCreateKnowledgeBase()
     * - .toCreateModelCopyJob()
     * - .toCreateModelCustomizationJob()
     * - .toCreateModelEvaluationJob()
     * - .toCreateModelImportJob()
     * - .toCreateModelInvocationJob()
     * - .toCreatePrompt()
     * - .toCreatePromptRouter()
     * - .toCreatePromptVersion()
     * - .toCreateProvisionedModelThroughput()
     * - .toCreateSession()
     * - .toInvokeModel()
     * - .toPutResourcePolicy()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by having actions based on the tag value associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to resource types:
     * - async-invoke
     * - application-inference-profile
     * - custom-model
     * - provisioned-model
     * - model-customization-job
     * - agent
     * - agent-alias
     * - knowledge-base
     * - model-evaluation-job
     * - evaluation-job
     * - model-invocation-job
     * - guardrail
     * - flow
     * - flow-alias
     * - model-copy-job
     * - prompt
     * - prompt-version
     * - model-import-job
     * - imported-model
     * - session
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by creating requests based on the presence of mandatory tags in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toCreateAgent()
     * - .toCreateAgentActionGroup()
     * - .toCreateAgentAlias()
     * - .toCreateEvaluationJob()
     * - .toCreateFlow()
     * - .toCreateFlowAlias()
     * - .toCreateGuardrail()
     * - .toCreateInferenceProfile()
     * - .toCreateKnowledgeBase()
     * - .toCreateModelCopyJob()
     * - .toCreateModelCustomizationJob()
     * - .toCreateModelEvaluationJob()
     * - .toCreateModelImportJob()
     * - .toCreateModelInvocationJob()
     * - .toCreatePrompt()
     * - .toCreatePromptRouter()
     * - .toCreatePromptVersion()
     * - .toCreateProvisionedModelThroughput()
     * - .toCreateSession()
     * - .toInvokeModel()
     * - .toPutResourcePolicy()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the GuardrailIdentifier containing the GuardrailArn or the GuardrailArn:NumericVersion
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html#amazonbedrock-policy-keys
     *
     * Applies to actions:
     * - .toInvokeModel()
     * - .toInvokeModelWithResponseStream()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifGuardrailIdentifier(value, operator) {
        return this.if(`GuardrailIdentifier`, value, operator ?? 'ArnLike');
    }
    /**
     * Filters access by the specified inference profile
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toInvokeModel()
     * - .toInvokeModelWithResponseStream()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifInferenceProfileArn(value, operator) {
        return this.if(`InferenceProfileArn`, value, operator ?? 'ArnLike');
    }
    /**
     * Filters access by the Inline Agent Names, this will be used in InvokeInlineAgent API names
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html#amazonbedrock-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInlineAgentName(value, operator) {
        return this.if(`InlineAgentName`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the specified prompt router
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toInvokeModel()
     * - .toInvokeModelWithResponseStream()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifPromptRouterArn(value, operator) {
        return this.if(`PromptRouterArn`, value, operator ?? 'ArnLike');
    }
    /**
     * Filters access by the secretArn containing the credentials of the third party platform
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toAssociateThirdPartyKnowledgeBase()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifThirdPartyKnowledgeBaseCredentialsSecretArn(value, operator) {
        return this.if(`ThirdPartyKnowledgeBaseCredentialsSecretArn`, value, operator ?? 'ArnLike');
    }
    /**
     * Statement provider for service [bedrock](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'bedrock';
        this.accessLevelList = {
            'Permissions management': [
                'AllowVendedLogDeliveryForResource'
            ],
            Read: [
                'ApplyGuardrail',
                'DetectGeneratedContent',
                'GenerateQuery',
                'GetAgent',
                'GetAgentActionGroup',
                'GetAgentAlias',
                'GetAgentCollaborator',
                'GetAgentKnowledgeBase',
                'GetAgentMemory',
                'GetAgentVersion',
                'GetAsyncInvoke',
                'GetBlueprint',
                'GetBlueprintRecommendation',
                'GetCustomModel',
                'GetDataAutomationProject',
                'GetDataAutomationStatus',
                'GetDataSource',
                'GetEvaluationJob',
                'GetFlow',
                'GetFlowAlias',
                'GetFlowVersion',
                'GetFoundationModel',
                'GetFoundationModelAvailability',
                'GetGuardrail',
                'GetImportedModel',
                'GetInferenceProfile',
                'GetIngestionJob',
                'GetInvocationStep',
                'GetKnowledgeBase',
                'GetKnowledgeBaseDocuments',
                'GetMarketplaceModelEndpoint',
                'GetModelCopyJob',
                'GetModelCustomizationJob',
                'GetModelEvaluationJob',
                'GetModelImportJob',
                'GetModelInvocationJob',
                'GetModelInvocationLoggingConfiguration',
                'GetPrompt',
                'GetPromptRouter',
                'GetProvisionedModelThroughput',
                'GetResourcePolicy',
                'GetSession',
                'GetUseCaseForModelAccess',
                'InvokeAgent',
                'InvokeFlow',
                'InvokeInlineAgent',
                'InvokeModel',
                'InvokeModelWithResponseStream',
                'ListMarketplaceModelEndpoints',
                'ListTagsForResource',
                'OptimizePrompt',
                'RenderPrompt',
                'Retrieve',
                'ValidateFlowDefinition'
            ],
            Write: [
                'AssociateAgentCollaborator',
                'AssociateAgentKnowledgeBase',
                'AssociateThirdPartyKnowledgeBase',
                'BatchDeleteEvaluationJob',
                'CreateAgent',
                'CreateAgentActionGroup',
                'CreateAgentAlias',
                'CreateBlueprint',
                'CreateBlueprintVersion',
                'CreateDataAutomationProject',
                'CreateDataSource',
                'CreateEvaluationJob',
                'CreateFlow',
                'CreateFlowAlias',
                'CreateFlowVersion',
                'CreateFoundationModelAgreement',
                'CreateGuardrail',
                'CreateGuardrailVersion',
                'CreateInferenceProfile',
                'CreateInvocation',
                'CreateKnowledgeBase',
                'CreateMarketplaceModelEndpoint',
                'CreateModelCopyJob',
                'CreateModelCustomizationJob',
                'CreateModelEvaluationJob',
                'CreateModelImportJob',
                'CreateModelInvocationJob',
                'CreatePrompt',
                'CreatePromptRouter',
                'CreatePromptVersion',
                'CreateProvisionedModelThroughput',
                'CreateSession',
                'DeleteAgent',
                'DeleteAgentActionGroup',
                'DeleteAgentAlias',
                'DeleteAgentMemory',
                'DeleteAgentVersion',
                'DeleteBlueprint',
                'DeleteCustomModel',
                'DeleteDataAutomationProject',
                'DeleteDataSource',
                'DeleteFlow',
                'DeleteFlowAlias',
                'DeleteFlowVersion',
                'DeleteFoundationModelAgreement',
                'DeleteGuardrail',
                'DeleteImportedModel',
                'DeleteInferenceProfile',
                'DeleteKnowledgeBase',
                'DeleteKnowledgeBaseDocuments',
                'DeleteMarketplaceModelAgreement',
                'DeleteMarketplaceModelEndpoint',
                'DeleteModelInvocationLoggingConfiguration',
                'DeletePrompt',
                'DeletePromptRouter',
                'DeleteProvisionedModelThroughput',
                'DeleteResourcePolicy',
                'DeleteSession',
                'DeregisterMarketplaceModelEndpoint',
                'DisassociateAgentCollaborator',
                'DisassociateAgentKnowledgeBase',
                'EndSession',
                'IngestKnowledgeBaseDocuments',
                'InvokeBlueprintRecommendationAsync',
                'InvokeBuilder',
                'InvokeDataAutomationAsync',
                'PrepareAgent',
                'PrepareFlow',
                'PutFoundationModelEntitlement',
                'PutInvocationStep',
                'PutModelInvocationLoggingConfiguration',
                'PutResourcePolicy',
                'PutUseCaseForModelAccess',
                'RegisterMarketplaceModelEndpoint',
                'Rerank',
                'RetrieveAndGenerate',
                'StartIngestionJob',
                'StopEvaluationJob',
                'StopIngestionJob',
                'StopModelCustomizationJob',
                'StopModelInvocationJob',
                'UpdateAgent',
                'UpdateAgentActionGroup',
                'UpdateAgentAlias',
                'UpdateAgentCollaborator',
                'UpdateAgentKnowledgeBase',
                'UpdateBlueprint',
                'UpdateDataAutomationProject',
                'UpdateDataSource',
                'UpdateFlow',
                'UpdateFlowAlias',
                'UpdateGuardrail',
                'UpdateKnowledgeBase',
                'UpdateMarketplaceModelEndpoint',
                'UpdatePrompt',
                'UpdateProvisionedModelThroughput',
                'UpdateSession'
            ],
            List: [
                'ListAgentActionGroups',
                'ListAgentAliases',
                'ListAgentCollaborators',
                'ListAgentKnowledgeBases',
                'ListAgentVersions',
                'ListAgents',
                'ListAsyncInvokes',
                'ListBlueprints',
                'ListCustomModels',
                'ListDataAutomationProjects',
                'ListDataSources',
                'ListEvaluationJobs',
                'ListFlowAliases',
                'ListFlowVersions',
                'ListFlows',
                'ListFoundationModelAgreementOffers',
                'ListFoundationModels',
                'ListGuardrails',
                'ListImportedModels',
                'ListInferenceProfiles',
                'ListIngestionJobs',
                'ListInvocationSteps',
                'ListInvocations',
                'ListKnowledgeBaseDocuments',
                'ListKnowledgeBases',
                'ListModelCopyJobs',
                'ListModelCustomizationJobs',
                'ListModelEvaluationJobs',
                'ListModelImportJobs',
                'ListModelInvocationJobs',
                'ListPromptRouters',
                'ListPrompts',
                'ListProvisionedModelThroughputs',
                'ListSessions'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
}
exports.Bedrock = Bedrock;
//# sourceMappingURL=data:application/json;base64,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