import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [cloudfront-keyvaluestore](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudfrontkeyvaluestore.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CloudfrontKeyvaluestore extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to delete the key value pair specified by the key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_kvs_DeleteKey.html
     */
    toDeleteKey(): this;
    /**
     * Grants permission to return metadata information about Key Value Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_kvs_DescribeKeyValueStore.html
     */
    toDescribeKeyValueStore(): this;
    /**
     * Grants permission to return a key value pair
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_kvs_GetKey.html
     */
    toGetKey(): this;
    /**
     * Grants permission to returns a list of key value pairs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_kvs_ListKeys.html
     */
    toListKeys(): this;
    /**
     * Grants permission to create a new key value pair or replace the value of an existing key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_kvs_PutKey.html
     */
    toPutKey(): this;
    /**
     * Grants permission to put or delete multiple key value pairs in a single, all-or-nothing operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_kvs_UpdateKeys.html
     */
    toUpdateKeys(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type key-value-store to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/kvs-with-functions.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onKeyValueStore(resourceId: string, account?: string, partition?: string): this;
    /**
     * Statement provider for service [cloudfront-keyvaluestore](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudfrontkeyvaluestore.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
