import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [profile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectcustomerprofiles.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Profile extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add a profile key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_AddProfileKey.html
     */
    toAddProfileKey(): this;
    /**
     * Grants permission to retrieve a calculated attribute for the specific profiles in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_BatchGetCalculatedAttributeForProfile.html
     */
    toBatchGetCalculatedAttributeForProfile(): this;
    /**
     * Grants permission to get profiles in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_BatchGetProfile.html
     */
    toBatchGetProfile(): this;
    /**
     * Grants permission to create a calculated attribute definition in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateCalculatedAttributeDefinition.html
     */
    toCreateCalculatedAttributeDefinition(): this;
    /**
     * Grants permission to create a Domain
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html
     */
    toCreateDomain(): this;
    /**
     * Grants permission to put an event stream in a domain
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PutRolePolicy
     * - kinesis:DescribeStreamSummary
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateEventStream.html
     */
    toCreateEventStream(): this;
    /**
     * Grants permission to create an event trigger in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateEventTrigger.html
     */
    toCreateEventTrigger(): this;
    /**
     * Grants permission to create an integration workflow in a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateIntegrationWorkflow.html
     */
    toCreateIntegrationWorkflow(): this;
    /**
     * Grants permission to create a profile in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to create a segment definition in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateSegmentDefinition.html
     */
    toCreateSegmentDefinition(): this;
    /**
     * Grants permission to create a segment estimate in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateSegmentEstimate.html
     */
    toCreateSegmentEstimate(): this;
    /**
     * Grants permission to create a segment snapshot in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateSegmentSnapshot.html
     */
    toCreateSegmentSnapshot(): this;
    /**
     * Grants permission to create a snapshot in the domain
     *
     * Access Level: Write
     */
    toCreateSnapshot(): this;
    /**
     * Grants permission to delete a calculated attribute definition in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteCalculatedAttributeDefinition.html
     */
    toDeleteCalculatedAttributeDefinition(): this;
    /**
     * Grants permission to delete a Domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteDomain.html
     */
    toDeleteDomain(): this;
    /**
     * Grants permission to delete an event stream in a domain
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:DeleteRolePolicy
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteEventStream.html
     */
    toDeleteEventStream(): this;
    /**
     * Grants permission to delete an event trigger in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteEventTrigger.html
     */
    toDeleteEventTrigger(): this;
    /**
     * Grants permission to delete a integration in a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteIntegration.html
     */
    toDeleteIntegration(): this;
    /**
     * Grants permission to delete a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteProfile.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to delete a profile key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteProfileKey.html
     */
    toDeleteProfileKey(): this;
    /**
     * Grants permission to delete a profile object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteProfileObject.html
     */
    toDeleteProfileObject(): this;
    /**
     * Grants permission to delete a specific profile object type in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteProfileObjectType.html
     */
    toDeleteProfileObjectType(): this;
    /**
     * Grants permission to delete a segment definition in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteSegmentDefinition.html
     */
    toDeleteSegmentDefinition(): this;
    /**
     * Grants permission to delete a workflow in a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteWorkflow.html
     */
    toDeleteWorkflow(): this;
    /**
     * Grants permission to auto detect object type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DetectProfileObjectType.html
     */
    toDetectProfileObjectType(): this;
    /**
     * Grants permission to get a preview of auto merging in a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetAutoMergingPreview.html
     */
    toGetAutoMergingPreview(): this;
    /**
     * Grants permission to get a calculated attribute definition in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeDefinition.html
     */
    toGetCalculatedAttributeDefinition(): this;
    /**
     * Grants permission to retrieve a calculated attribute for a specific profile in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeForProfile.html
     */
    toGetCalculatedAttributeForProfile(): this;
    /**
     * Grants permission to get a specific domain in an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetDomain.html
     */
    toGetDomain(): this;
    /**
     * Grants permission to get a specific event stream in a domain
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - kinesis:DescribeStreamSummary
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetEventStream.html
     */
    toGetEventStream(): this;
    /**
     * Grants permission to get an event trigger in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetEventTrigger.html
     */
    toGetEventTrigger(): this;
    /**
     * Grants permission to get an identity resolution job in a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetIdentityResolutionJob.html
     */
    toGetIdentityResolutionJob(): this;
    /**
     * Grants permission to get a specific integrations in a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetIntegration.html
     */
    toGetIntegration(): this;
    /**
     * Grants permission to get profile matches in a domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html
     */
    toGetMatches(): this;
    /**
     * Grants permission to get a specific profile object type in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetProfileObjectType.html
     */
    toGetProfileObjectType(): this;
    /**
     * Grants permission to get a specific object type template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetProfileObjectTypeTemplate.html
     */
    toGetProfileObjectTypeTemplate(): this;
    /**
     * Grants permission to get a segment definition in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetSegmentDefinition.html
     */
    toGetSegmentDefinition(): this;
    /**
     * Grants permission to get a segment estimate in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetSegmentEstimate.html
     */
    toGetSegmentEstimate(): this;
    /**
     * Grants permission to determine if the given profiles are part of a segment in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetSegmentMembership.html
     */
    toGetSegmentMembership(): this;
    /**
     * Grants permission to get a segment snapshot in the domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetSegmentSnapshot.html
     */
    toGetSegmentSnapshot(): this;
    /**
     * Grants permission to get all the similar profiles in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetSimilarProfiles.html
     */
    toGetSimilarProfiles(): this;
    /**
     * Grants permission to get a snapshot in the domain
     *
     * Access Level: Read
     */
    toGetSnapshot(): this;
    /**
     * Grants permission to get workflow details in a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetWorkflow.html
     */
    toGetWorkflow(): this;
    /**
     * Grants permission to get workflow step details in a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetWorkflowSteps.html
     */
    toGetWorkflowSteps(): this;
    /**
     * Grants permission to list all the integrations in the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListAccountIntegrations.html
     */
    toListAccountIntegrations(): this;
    /**
     * Grants permission to list all the calculated attribute definitions in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListCalculatedAttributeDefinitions.html
     */
    toListCalculatedAttributeDefinitions(): this;
    /**
     * Grants permission to list all calculated attributes for a specific profile in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListCalculatedAttributesForProfile.html
     */
    toListCalculatedAttributesForProfile(): this;
    /**
     * Grants permission to list all the domains in an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListDomains.html
     */
    toListDomains(): this;
    /**
     * Grants permission to list all the event streams in a specific domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListEventStreams.html
     */
    toListEventStreams(): this;
    /**
     * Grants permission to list all the event triggers in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListEventTriggers.html
     */
    toListEventTriggers(): this;
    /**
     * Grants permission to list identity resolution jobs in a domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListIdentityResolutionJobs.html
     */
    toListIdentityResolutionJobs(): this;
    /**
     * Grants permission to list all the integrations in a specific domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListIntegrations.html
     */
    toListIntegrations(): this;
    /**
     * Grants permission to list all the attributes of a specific object type in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListObjectTypeAttributes.html
     */
    toListObjectTypeAttributes(): this;
    /**
     * Grants permission to list all the values of a profile attribute in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListProfileAttributeValues.html
     */
    toListProfileAttributeValues(): this;
    /**
     * Grants permission to list all the profile object type templates in the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListProfileObjectTypeTemplates.html
     */
    toListProfileObjectTypeTemplates(): this;
    /**
     * Grants permission to list all the profile object types in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListProfileObjectTypes.html
     */
    toListProfileObjectTypes(): this;
    /**
     * Grants permission to list all the profile objects for a profile
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListProfileObjects.html
     */
    toListProfileObjects(): this;
    /**
     * Grants permission to list all the rule-based matching result in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListRuleBasedMatches.html
     */
    toListRuleBasedMatches(): this;
    /**
     * Grants permission to list all the segment definitions in the domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListSegmentDefinitions.html
     */
    toListSegmentDefinitions(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all the workflows in a specific domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListWorkflows.html
     */
    toListWorkflows(): this;
    /**
     * Grants permission to merge profiles in a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MergeProfiles.html
     */
    toMergeProfiles(): this;
    /**
     * Grants permission to put a integration in a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_PutIntegration.html
     */
    toPutIntegration(): this;
    /**
     * Grants permission to put an object for a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_PutProfileObject.html
     */
    toPutProfileObject(): this;
    /**
     * Grants permission to put a specific profile object type in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_PutProfileObjectType.html
     */
    toPutProfileObjectType(): this;
    /**
     * Grants permission to search for profiles in a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html
     */
    toSearchProfiles(): this;
    /**
     * Grants permission to adds tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a calculated attribute definition in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateCalculatedAttributeDefinition.html
     */
    toUpdateCalculatedAttributeDefinition(): this;
    /**
     * Grants permission to update a Domain
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html
     */
    toUpdateDomain(): this;
    /**
     * Grants permission to update an event trigger in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateEventTrigger.html
     */
    toUpdateEventTrigger(): this;
    /**
     * Grants permission to update a profile in the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateProfile.html
     */
    toUpdateProfile(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type domains to the statement
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomains(domainName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type object-types to the statement
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/
     *
     * @param domainName - Identifier for the domainName.
     * @param objectTypeName - Identifier for the objectTypeName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onObjectTypes(domainName: string, objectTypeName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type integrations to the statement
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/
     *
     * @param domainName - Identifier for the domainName.
     * @param uri - Identifier for the uri.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIntegrations(domainName: string, uri: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type event-streams to the statement
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/
     *
     * @param domainName - Identifier for the domainName.
     * @param eventStreamName - Identifier for the eventStreamName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEventStreams(domainName: string, eventStreamName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type calculated-attributes to the statement
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/
     *
     * @param domainName - Identifier for the domainName.
     * @param calculatedAttributeName - Identifier for the calculatedAttributeName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCalculatedAttributes(domainName: string, calculatedAttributeName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type segment-definitions to the statement
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/
     *
     * @param domainName - Identifier for the domainName.
     * @param segmentDefinitionName - Identifier for the segmentDefinitionName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSegmentDefinitions(domainName: string, segmentDefinitionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type event-triggers to the statement
     *
     * https://docs.aws.amazon.com/customerprofiles/latest/APIReference/
     *
     * @param domainName - Identifier for the domainName.
     * @param eventTriggerName - Identifier for the eventTriggerName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEventTriggers(domainName: string, eventTriggerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a key that is present in the request the user makes to the customer profile service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to actions:
     * - .toCreateCalculatedAttributeDefinition()
     * - .toCreateDomain()
     * - .toCreateEventStream()
     * - .toCreateEventTrigger()
     * - .toCreateIntegrationWorkflow()
     * - .toCreateSegmentDefinition()
     * - .toPutIntegration()
     * - .toPutProfileObjectType()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to resource types:
     * - domains
     * - object-types
     * - integrations
     * - event-streams
     * - calculated-attributes
     * - segment-definitions
     * - event-triggers
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the list of all the tag key names present in the request the user makes to the customer profile service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to actions:
     * - .toCreateCalculatedAttributeDefinition()
     * - .toCreateDomain()
     * - .toCreateEventStream()
     * - .toCreateEventTrigger()
     * - .toCreateIntegrationWorkflow()
     * - .toCreateSegmentDefinition()
     * - .toPutIntegration()
     * - .toPutProfileObjectType()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [profile](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectcustomerprofiles.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
