"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Consoleapp = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [consoleapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconsolemobileapp.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Consoleapp extends shared_1.PolicyStatement {
    /**
     * Grants permission to retrieve the device identity for a Console Mobile App device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/consolemobileapp/latest/userguide/permissions-policies.html
     */
    toGetDeviceIdentity() {
        return this.to('GetDeviceIdentity');
    }
    /**
     * Grants permission to retrieve a list of device identities
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/consolemobileapp/latest/userguide/permissions-policies.html
     */
    toListDeviceIdentities() {
        return this.to('ListDeviceIdentities');
    }
    /**
     * Adds a resource of type DeviceIdentity to the statement
     *
     * https://docs.aws.amazon.com/consolemobileapp/latest/userguide/permissions-policies.html
     *
     * @param deviceId - Identifier for the deviceId.
     * @param identityId - Identifier for the identityId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDeviceIdentity(deviceId, identityId, account, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:consoleapp::${account ?? this.defaultAccount}:device/${deviceId}/identity/${identityId}`);
    }
    /**
     * Statement provider for service [consoleapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconsolemobileapp.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'consoleapp';
        this.accessLevelList = {
            Read: [
                'GetDeviceIdentity'
            ],
            List: [
                'ListDeviceIdentities'
            ]
        };
    }
}
exports.Consoleapp = Consoleapp;
//# sourceMappingURL=data:application/json;base64,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