"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CostOptimizationHub = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [cost-optimization-hub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostoptimizationhub.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class CostOptimizationHub extends shared_1.PolicyStatement {
    /**
     * Grants permission to get preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_GetPreferences.html
     */
    toGetPreferences() {
        return this.to('GetPreferences');
    }
    /**
     * Grants permission to get resource configuration and estimated cost impact for a recommendation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_GetRecommendation.html
     */
    toGetRecommendation() {
        return this.to('GetRecommendation');
    }
    /**
     * Grants permission to list enrollment statuses for the specified account or all members under a management account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_ListEnrollmentStatuses.html
     */
    toListEnrollmentStatuses() {
        return this.to('ListEnrollmentStatuses');
    }
    /**
     * Grants permission to list recommendation summaries by group
     *
     * Access Level: List
     *
     * Dependent actions:
     * - cost-optimization-hub:GetRecommendation
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_ListRecommendationSummaries.html
     */
    toListRecommendationSummaries() {
        return this.to('ListRecommendationSummaries');
    }
    /**
     * Grants permission to list summary view of recommendations
     *
     * Access Level: List
     *
     * Dependent actions:
     * - cost-optimization-hub:GetRecommendation
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_ListRecommendations.html
     */
    toListRecommendations() {
        return this.to('ListRecommendations');
    }
    /**
     * Grants permission to update the enrollment status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_UpdateEnrollmentStatus.html
     */
    toUpdateEnrollmentStatus() {
        return this.to('UpdateEnrollmentStatus');
    }
    /**
     * Grants permission to update preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_UpdatePreferences.html
     */
    toUpdatePreferences() {
        return this.to('UpdatePreferences');
    }
    /**
     * Statement provider for service [cost-optimization-hub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostoptimizationhub.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'cost-optimization-hub';
        this.accessLevelList = {
            Read: [
                'GetPreferences',
                'GetRecommendation'
            ],
            List: [
                'ListEnrollmentStatuses',
                'ListRecommendationSummaries',
                'ListRecommendations'
            ],
            Write: [
                'UpdateEnrollmentStatus',
                'UpdatePreferences'
            ]
        };
    }
}
exports.CostOptimizationHub = CostOptimizationHub;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29zdG9wdGltaXphdGlvbmh1Yi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNvc3RvcHRpbWl6YXRpb25odWIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EseUNBQStDO0FBRy9DOzs7O0dBSUc7QUFDSCxNQUFhLG1CQUFvQixTQUFRLHdCQUFlO0lBR3REOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLDZCQUE2QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBa0JEOzs7T0FHRztJQUNILFlBQVksS0FBZ0M7UUFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBMUdSLGtCQUFhLEdBQUcsdUJBQXVCLENBQUM7UUFxRnJDLG9CQUFlLEdBQW9CO1lBQzNDLElBQUksRUFBRTtnQkFDSixnQkFBZ0I7Z0JBQ2hCLG1CQUFtQjthQUNwQjtZQUNELElBQUksRUFBRTtnQkFDSix3QkFBd0I7Z0JBQ3hCLDZCQUE2QjtnQkFDN0IscUJBQXFCO2FBQ3RCO1lBQ0QsS0FBSyxFQUFFO2dCQUNMLHdCQUF3QjtnQkFDeEIsbUJBQW1CO2FBQ3BCO1NBQ0YsQ0FBQztJQVFGLENBQUM7Q0FDRjtBQTdHRCxrREE2R0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi8uLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uLy4uL3NoYXJlZCc7XG5pbXBvcnQgeyBhd3NfaWFtIGFzIGlhbSB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbY29zdC1vcHRpbWl6YXRpb24taHViXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3Njb3N0b3B0aW1pemF0aW9uaHViLmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgQ29zdE9wdGltaXphdGlvbkh1YiBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ2Nvc3Qtb3B0aW1pemF0aW9uLWh1Yic7XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBwcmVmZXJlbmNlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3cy1jb3N0LW1hbmFnZW1lbnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ29zdE9wdGltaXphdGlvbkh1Yl9HZXRQcmVmZXJlbmNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRQcmVmZXJlbmNlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0UHJlZmVyZW5jZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgcmVzb3VyY2UgY29uZmlndXJhdGlvbiBhbmQgZXN0aW1hdGVkIGNvc3QgaW1wYWN0IGZvciBhIHJlY29tbWVuZGF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzLWNvc3QtbWFuYWdlbWVudC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Db3N0T3B0aW1pemF0aW9uSHViX0dldFJlY29tbWVuZGF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlY29tbWVuZGF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRSZWNvbW1lbmRhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgZW5yb2xsbWVudCBzdGF0dXNlcyBmb3IgdGhlIHNwZWNpZmllZCBhY2NvdW50IG9yIGFsbCBtZW1iZXJzIHVuZGVyIGEgbWFuYWdlbWVudCBhY2NvdW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzLWNvc3QtbWFuYWdlbWVudC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Db3N0T3B0aW1pemF0aW9uSHViX0xpc3RFbnJvbGxtZW50U3RhdHVzZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEVucm9sbG1lbnRTdGF0dXNlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEVucm9sbG1lbnRTdGF0dXNlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgcmVjb21tZW5kYXRpb24gc3VtbWFyaWVzIGJ5IGdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBjb3N0LW9wdGltaXphdGlvbi1odWI6R2V0UmVjb21tZW5kYXRpb25cbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3cy1jb3N0LW1hbmFnZW1lbnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ29zdE9wdGltaXphdGlvbkh1Yl9MaXN0UmVjb21tZW5kYXRpb25TdW1tYXJpZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFJlY29tbWVuZGF0aW9uU3VtbWFyaWVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmVjb21tZW5kYXRpb25TdW1tYXJpZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHN1bW1hcnkgdmlldyBvZiByZWNvbW1lbmRhdGlvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGNvc3Qtb3B0aW1pemF0aW9uLWh1YjpHZXRSZWNvbW1lbmRhdGlvblxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzLWNvc3QtbWFuYWdlbWVudC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Db3N0T3B0aW1pemF0aW9uSHViX0xpc3RSZWNvbW1lbmRhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFJlY29tbWVuZGF0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFJlY29tbWVuZGF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSB0aGUgZW5yb2xsbWVudCBzdGF0dXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzLWNvc3QtbWFuYWdlbWVudC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Db3N0T3B0aW1pemF0aW9uSHViX1VwZGF0ZUVucm9sbG1lbnRTdGF0dXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlRW5yb2xsbWVudFN0YXR1cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlRW5yb2xsbWVudFN0YXR1cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBwcmVmZXJlbmNlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3MtY29zdC1tYW5hZ2VtZW50L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Nvc3RPcHRpbWl6YXRpb25IdWJfVXBkYXRlUHJlZmVyZW5jZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUHJlZmVyZW5jZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVByZWZlcmVuY2VzJyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgUmVhZDogW1xuICAgICAgJ0dldFByZWZlcmVuY2VzJyxcbiAgICAgICdHZXRSZWNvbW1lbmRhdGlvbidcbiAgICBdLFxuICAgIExpc3Q6IFtcbiAgICAgICdMaXN0RW5yb2xsbWVudFN0YXR1c2VzJyxcbiAgICAgICdMaXN0UmVjb21tZW5kYXRpb25TdW1tYXJpZXMnLFxuICAgICAgJ0xpc3RSZWNvbW1lbmRhdGlvbnMnXG4gICAgXSxcbiAgICBXcml0ZTogW1xuICAgICAgJ1VwZGF0ZUVucm9sbG1lbnRTdGF0dXMnLFxuICAgICAgJ1VwZGF0ZVByZWZlcmVuY2VzJ1xuICAgIF1cbiAgfTtcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtjb3N0LW9wdGltaXphdGlvbi1odWJdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c2Nvc3RvcHRpbWl6YXRpb25odWIuaHRtbCkuXG4gICAqXG4gICAqL1xuICBjb25zdHJ1Y3Rvcihwcm9wcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgfVxufVxuIl19