import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [mediapackagev2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediapackagev2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mediapackagev2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to cancel a harvest job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_CancelHarvestJob.html
     */
    toCancelHarvestJob(): this;
    /**
     * Grants permission to create a channel in a channel group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_CreateChannel.html
     */
    toCreateChannel(): this;
    /**
     * Grants permission to create a channel group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_CreateChannelGroup.html
     */
    toCreateChannelGroup(): this;
    /**
     * Grants permission to create a harvest job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_CreateHarvestJob.html
     */
    toCreateHarvestJob(): this;
    /**
     * Grants permission to create an origin endpoint for a channel
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_CreateOriginEndpoint.html
     */
    toCreateOriginEndpoint(): this;
    /**
     * Grants permission to delete a channel in a channel group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_DeleteChannel.html
     */
    toDeleteChannel(): this;
    /**
     * Grants permission to delete a channel group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_DeleteChannelGroup.html
     */
    toDeleteChannelGroup(): this;
    /**
     * Grants permission to delete a resource policy from a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_DeleteChannelPolicy.html
     */
    toDeleteChannelPolicy(): this;
    /**
     * Grants permission to delete an origin endpoint of a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_DeleteOriginEndpoint.html
     */
    toDeleteOriginEndpoint(): this;
    /**
     * Grants permission to delete a resource policy from an origin endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_DeleteOriginEndpointPolicy.html
     */
    toDeleteOriginEndpointPolicy(): this;
    /**
     * Grants permission to retrieve details of a channel in a channel group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_GetChannel.html
     */
    toGetChannel(): this;
    /**
     * Grants permission to retrieve details of a channel group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_GetChannelGroup.html
     */
    toGetChannelGroup(): this;
    /**
     * Grants permission to retrieve a resource policy for a channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_GetChannelPolicy.html
     */
    toGetChannelPolicy(): this;
    /**
     * Grants permission to retrieve details of an harvest job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_GetHarvestJob.html
     */
    toGetHarvestJob(): this;
    /**
     * Grants permission to make GetHeadObject requests to MediaPackage
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/dataplane-apis.html
     */
    toGetHeadObject(): this;
    /**
     * Grants permission to make GetObject requests to MediaPackage
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/dataplane-apis.html
     */
    toGetObject(): this;
    /**
     * Grants permission to retrieve details of an origin endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_GetOriginEndpoint.html
     */
    toGetOriginEndpoint(): this;
    /**
     * Grants permission to retrieve details of a resource policy for an origin endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_GetOriginEndpointPolicy.html
     */
    toGetOriginEndpointPolicy(): this;
    /**
     * Grants permission to make HarvestObject requests to MediaPackage
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/dataplane-apis.html
     */
    toHarvestObject(): this;
    /**
     * Grants permission to list all channel groups for an aws account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_ListChannelGroups.html
     */
    toListChannelGroups(): this;
    /**
     * Grants permission to list all channels in a channel group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_ListChannels.html
     */
    toListChannels(): this;
    /**
     * Grants permission to list all harvest jobs in a channel group, channel, origin endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_ListHarvestJobs.html
     */
    toListHarvestJobs(): this;
    /**
     * Grants permission to list all origin endpoints of a channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_ListOriginEndpoints.html
     */
    toListOriginEndpoints(): this;
    /**
     * Grants permission to list tags for the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to attach a resource policy for a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_PutChannelPolicy.html
     */
    toPutChannelPolicy(): this;
    /**
     * Grants permission to make PutObject requests to MediaPackage
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/dataplane-apis.html
     */
    toPutObject(): this;
    /**
     * Grants permission to attach a resource policy to an origin endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_PutOriginEndpointPolicy.html
     */
    toPutOriginEndpointPolicy(): this;
    /**
     * Grants permission to reset a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_ResetChannelState.html
     */
    toResetChannelState(): this;
    /**
     * Grants permission to reset an origin endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_ResetOriginEndpointState.html
     */
    toResetOriginEndpointState(): this;
    /**
     * Grants permission to add specified tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the specified tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a channel in a channel group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_UpdateChannel.html
     */
    toUpdateChannel(): this;
    /**
     * Grants permission to update a channel group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_UpdateChannelGroup.html
     */
    toUpdateChannelGroup(): this;
    /**
     * Grants permission to update an origin endpoint of a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/APIReference/API_UpdateOriginEndpoint.html
     */
    toUpdateOriginEndpoint(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ChannelGroup to the statement
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/channel-groups.html
     *
     * @param channelGroupName - Identifier for the channelGroupName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChannelGroup(channelGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ChannelPolicy to the statement
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/API_GetChannelPolicy.html
     *
     * @param channelGroupName - Identifier for the channelGroupName.
     * @param channelName - Identifier for the channelName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onChannelPolicy(channelGroupName: string, channelName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Channel to the statement
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/channels.html
     *
     * @param channelGroupName - Identifier for the channelGroupName.
     * @param channelName - Identifier for the channelName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChannel(channelGroupName: string, channelName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type OriginEndpointPolicy to the statement
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/API_GetOriginEndpointPolicy.html
     *
     * @param channelGroupName - Identifier for the channelGroupName.
     * @param channelName - Identifier for the channelName.
     * @param originEndpointName - Identifier for the originEndpointName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOriginEndpointPolicy(channelGroupName: string, channelName: string, originEndpointName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type OriginEndpoint to the statement
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/endpoints.html
     *
     * @param channelGroupName - Identifier for the channelGroupName.
     * @param channelName - Identifier for the channelName.
     * @param originEndpointName - Identifier for the originEndpointName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOriginEndpoint(channelGroupName: string, channelName: string, originEndpointName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type HarvestJob to the statement
     *
     * https://docs.aws.amazon.com/mediapackage/latest/userguide/API_HarvestJobListConfiguration.html
     *
     * @param channelGroupName - Identifier for the channelGroupName.
     * @param channelName - Identifier for the channelName.
     * @param originEndpointName - Identifier for the originEndpointName.
     * @param harvestJobName - Identifier for the harvestJobName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHarvestJob(channelGroupName: string, channelName: string, originEndpointName: string, harvestJobName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateChannel()
     * - .toCreateChannelGroup()
     * - .toCreateHarvestJob()
     * - .toCreateOriginEndpoint()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - ChannelGroup
     * - Channel
     * - OriginEndpoint
     * - HarvestJob
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateChannel()
     * - .toCreateChannelGroup()
     * - .toCreateHarvestJob()
     * - .toCreateOriginEndpoint()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [mediapackagev2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediapackagev2.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
