import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [emr-containers](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonemroneksemrcontainers.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class EmrContainers extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to cancel a job run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_CancelJobRun.html
     */
    toCancelJobRun(): this;
    /**
     * Grants permission to create a certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_CreateCertificate.html
     */
    toCreateCertificate(): this;
    /**
     * Grants permission to create a job template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_CreateJobTemplate.html
     */
    toCreateJobTemplate(): this;
    /**
     * Grants permission to create a managed endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifExecutionRoleArn()
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_CreateManagedEndpoint.html
     */
    toCreateManagedEndpoint(): this;
    /**
     * Grants permission to create a security configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_CreateSecurityConfiguration.html
     */
    toCreateSecurityConfiguration(): this;
    /**
     * Grants permission to create a virtual cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_CreateVirtualCluster.html
     */
    toCreateVirtualCluster(): this;
    /**
     * Grants permission to delete a job template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_DeleteJobTemplate.html
     */
    toDeleteJobTemplate(): this;
    /**
     * Grants permission to delete a managed endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_DeleteManagedEndpoint.html
     */
    toDeleteManagedEndpoint(): this;
    /**
     * Grants permission to delete a virtual cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_DeleteVirtualCluster.html
     */
    toDeleteVirtualCluster(): this;
    /**
     * Grants permission to describe a job run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_DescribeJobRun.html
     */
    toDescribeJobRun(): this;
    /**
     * Grants permission to describe a job template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_DescribeJobTemplate.html
     */
    toDescribeJobTemplate(): this;
    /**
     * Grants permission to describe a managed endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_DescribeManagedEndpoint.html
     */
    toDescribeManagedEndpoint(): this;
    /**
     * Grants permission to describe a security configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_DescribeSecurityConfiguration.html
     */
    toDescribeSecurityConfiguration(): this;
    /**
     * Grants permission to describe a virtual cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_DescribeVirtualCluster.html
     */
    toDescribeVirtualCluster(): this;
    /**
     * Grants permission to generate a session token used to connect to a managed endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_GetManagedEndpointSessionCredentials.html
     */
    toGetManagedEndpointSessionCredentials(): this;
    /**
     * Grants permission to list job runs associated with a virtual cluster
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_ListJobRuns.html
     */
    toListJobRuns(): this;
    /**
     * Grants permission to list job templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_ListJobTemplates.html
     */
    toListJobTemplates(): this;
    /**
     * Grants permission to list managed endpoints associated with a virtual cluster
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_ListManagedEndpoints.html
     */
    toListManagedEndpoints(): this;
    /**
     * Grants permission to list security configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_ListSecurityConfigurations.html
     */
    toListSecurityConfigurations(): this;
    /**
     * Grants permission to list tags for the specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list virtual clusters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_ListVirtualClusters.html
     */
    toListVirtualClusters(): this;
    /**
     * Grants permission to start a job run
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifExecutionRoleArn()
     * - .ifJobTemplateArn()
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_StartJobRun.html
     */
    toStartJobRun(): this;
    /**
     * Grants permission to tag the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type virtualCluster to the statement
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/virtual-cluster.html
     *
     * @param virtualClusterId - Identifier for the virtualClusterId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVirtualCluster(virtualClusterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type jobRun to the statement
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/job-runs.html
     *
     * @param virtualClusterId - Identifier for the virtualClusterId.
     * @param jobRunId - Identifier for the jobRunId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobRun(virtualClusterId: string, jobRunId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type jobTemplate to the statement
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/job-templates.html
     *
     * @param jobTemplateId - Identifier for the jobTemplateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobTemplate(jobTemplateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type managedEndpoint to the statement
     *
     * https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-create-eks-cluster.html#emr-studio-create-managed-endpoint
     *
     * @param virtualClusterId - Identifier for the virtualClusterId.
     * @param endpointId - Identifier for the endpointId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onManagedEndpoint(virtualClusterId: string, endpointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type securityConfiguration to the statement
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/security-configurations.html
     *
     * @param securityConfigurationId - Identifier for the securityConfigurationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSecurityConfiguration(securityConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type certificate to the statement
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/certificate.html
     *
     * @param certificateId - Identifier for the certificateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCertificate(certificateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tag key-value pairs present in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateJobTemplate()
     * - .toCreateManagedEndpoint()
     * - .toCreateSecurityConfiguration()
     * - .toCreateVirtualCluster()
     * - .toStartJobRun()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - virtualCluster
     * - jobRun
     * - jobTemplate
     * - managedEndpoint
     * - securityConfiguration
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys present in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateJobTemplate()
     * - .toCreateManagedEndpoint()
     * - .toCreateSecurityConfiguration()
     * - .toCreateVirtualCluster()
     * - .toStartJobRun()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the execution role arn present in the request
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/iam-execution-role.html
     *
     * Applies to actions:
     * - .toCreateManagedEndpoint()
     * - .toStartJobRun()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifExecutionRoleArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the job template arn present in the request
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/iam-job-template.html
     *
     * Applies to actions:
     * - .toStartJobRun()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifJobTemplateArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [emr-containers](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonemroneksemrcontainers.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
