import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [sms-voice-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsendusermessagingsmsandvoicev2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SmsVoiceV2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate an origination phone number or sender ID to a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_AssociateOriginationIdentity.html
     */
    toAssociateOriginationIdentity(): this;
    /**
     * Grants permission to associate a protect configuration to a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_AssociateProtectConfiguration.html
     */
    toAssociateProtectConfiguration(): this;
    /**
     * Grants permission to create a configuration set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateConfigurationSet.html
     */
    toCreateConfigurationSet(): this;
    /**
     * Grants permission to create an event destination within a configuration set
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateEventDestination.html
     */
    toCreateEventDestination(): this;
    /**
     * Grants permission to create an opt-out list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateOptOutList.html
     */
    toCreateOptOutList(): this;
    /**
     * Grants permission to create a pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreatePool.html
     */
    toCreatePool(): this;
    /**
     * Grants permission to create a protect configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateProtectConfiguration.html
     */
    toCreateProtectConfiguration(): this;
    /**
     * Grants permission to create a registration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateRegistration.html
     */
    toCreateRegistration(): this;
    /**
     * Grants permission to associate a registration with a phone number or another registration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateRegistrationAssociation.html
     */
    toCreateRegistrationAssociation(): this;
    /**
     * Grants permission to create a registration attachment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateRegistrationAttachment.html
     */
    toCreateRegistrationAttachment(): this;
    /**
     * Grants permission to create a registration version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateRegistrationVersion.html
     */
    toCreateRegistrationVersion(): this;
    /**
     * Grants permission to create a verified destination number
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateVerifiedDestinationNumber.html
     */
    toCreateVerifiedDestinationNumber(): this;
    /**
     * Grants permission to delete the account default protect configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteAccountDefaultProtectConfiguration.html
     */
    toDeleteAccountDefaultProtectConfiguration(): this;
    /**
     * Grants permission to delete a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteConfigurationSet.html
     */
    toDeleteConfigurationSet(): this;
    /**
     * Grants permission to delete the default message type for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteDefaultMessageType.html
     */
    toDeleteDefaultMessageType(): this;
    /**
     * Grants permission to delete the default sender ID for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteDefaultSenderId.html
     */
    toDeleteDefaultSenderId(): this;
    /**
     * Grants permission to delete an event destination within a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteEventDestination.html
     */
    toDeleteEventDestination(): this;
    /**
     * Grants permission to delete a keyword for a pool or origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteKeyword.html
     */
    toDeleteKeyword(): this;
    /**
     * Grants permission to delete an override for your account's media messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteMediaMessageSpendLimitOverride.html
     */
    toDeleteMediaMessageSpendLimitOverride(): this;
    /**
     * Grants permission to delete an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteOptOutList.html
     */
    toDeleteOptOutList(): this;
    /**
     * Grants permission to delete a destination phone number from an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteOptedOutNumber.html
     */
    toDeleteOptedOutNumber(): this;
    /**
     * Grants permission to delete a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeletePool.html
     */
    toDeletePool(): this;
    /**
     * Grants permission to delete a protect configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteProtectConfiguration.html
     */
    toDeleteProtectConfiguration(): this;
    /**
     * Grants permission to delete a phone number override for a protect configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteProtectConfigurationRuleSetNumberOverride.html
     */
    toDeleteProtectConfigurationRuleSetNumberOverride(): this;
    /**
     * Grants permission to delete a registration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteRegistration.html
     */
    toDeleteRegistration(): this;
    /**
     * Grants permission to delete a registration attachment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteRegistrationAttachment.html
     */
    toDeleteRegistrationAttachment(): this;
    /**
     * Grants permission to delete an optional registration field value
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteRegistrationFieldValue.html
     */
    toDeleteRegistrationFieldValue(): this;
    /**
     * Grants permission to delete a resource policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete an override for your account's text messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteTextMessageSpendLimitOverride.html
     */
    toDeleteTextMessageSpendLimitOverride(): this;
    /**
     * Grants permission to delete a verified destination number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteVerifiedDestinationNumber.html
     */
    toDeleteVerifiedDestinationNumber(): this;
    /**
     * Grants permission to delete an override for your account's voice messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DeleteVoiceMessageSpendLimitOverride.html
     */
    toDeleteVoiceMessageSpendLimitOverride(): this;
    /**
     * Grants permission to describe the attributes of your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeAccountAttributes.html
     */
    toDescribeAccountAttributes(): this;
    /**
     * Grants permission to describe the service quotas for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeAccountLimits.html
     */
    toDescribeAccountLimits(): this;
    /**
     * Grants permission to describe the configuration sets in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeConfigurationSets.html
     */
    toDescribeConfigurationSets(): this;
    /**
     * Grants permission to describe the keywords for a pool or origination phone number
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeKeywords.html
     */
    toDescribeKeywords(): this;
    /**
     * Grants permission to describe the opt-out lists in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeOptOutLists.html
     */
    toDescribeOptOutLists(): this;
    /**
     * Grants permission to describe the destination phone numbers in an opt-out list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeOptedOutNumbers.html
     */
    toDescribeOptedOutNumbers(): this;
    /**
     * Grants permission to describe the origination phone numbers in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribePhoneNumbers.html
     */
    toDescribePhoneNumbers(): this;
    /**
     * Grants permission to describe the pools in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribePools.html
     */
    toDescribePools(): this;
    /**
     * Grants permission to describe the protect configurations in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeProtectConfigurations.html
     */
    toDescribeProtectConfigurations(): this;
    /**
     * Grants permission to describe the registration attachments in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribePools.html
     */
    toDescribeRegistrationAttachments(): this;
    /**
     * Grants permission to describe the field definitions for a given registration type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeRegistrationFieldDefinitions.html
     */
    toDescribeRegistrationFieldDefinitions(): this;
    /**
     * Grants permission to describe the field values for a given registration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeRegistrationFieldValues.html
     */
    toDescribeRegistrationFieldValues(): this;
    /**
     * Grants permission to describe the section definitions for a given registration type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeRegistrationSectionDefinitions.html
     */
    toDescribeRegistrationSectionDefinitions(): this;
    /**
     * Grants permission to describe the registration types supported by the service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeRegistrationTypeDefinitions.html
     */
    toDescribeRegistrationTypeDefinitions(): this;
    /**
     * Grants permission to describe the versions for a given registration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeRegistrationVersions.html
     */
    toDescribeRegistrationVersions(): this;
    /**
     * Grants permission to describe the registrations in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeRegistrations.html
     */
    toDescribeRegistrations(): this;
    /**
     * Grants permission to describe the sender IDs in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeSenderIds.html
     */
    toDescribeSenderIds(): this;
    /**
     * Grants permission to describe the monthly spend limits for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeSpendLimits.html
     */
    toDescribeSpendLimits(): this;
    /**
     * Grants permission to describe the verified destination numbers in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeVerifiedDestinationNumbers.html
     */
    toDescribeVerifiedDestinationNumbers(): this;
    /**
     * Grants permission to disassociate an origination phone number or sender ID from a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DisassociateOriginationIdentity.html
     */
    toDisassociateOriginationIdentity(): this;
    /**
     * Grants permission to disassociate a protect configuration from a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DisassociateProtectConfiguration.html
     */
    toDisassociateProtectConfiguration(): this;
    /**
     * Grants permission to discard the latest version of a given registration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DiscardRegistrationVersion.html
     */
    toDiscardRegistrationVersion(): this;
    /**
     * Grants permission to get the country rule set for a protect configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_GetProtectConfigurationCountryRuleSet.html
     */
    toGetProtectConfigurationCountryRuleSet(): this;
    /**
     * Grants permission to get a resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_GetResourcePolicy.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to list all origination phone numbers and sender IDs associated to a pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_ListPoolOriginationIdentities.html
     */
    toListPoolOriginationIdentities(): this;
    /**
     * Grants permission to list all phone number overrides for a protect configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_ListProtectConfigurationRuleSetNumberOverrides.html
     */
    toListProtectConfigurationRuleSetNumberOverrides(): this;
    /**
     * Grants permission to list all resources associated to a registration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_ListRegistrationAssociations.html
     */
    toListRegistrationAssociations(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create or update a keyword for a pool or origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_PutKeyword.html
     */
    toPutKeyword(): this;
    /**
     * Grants permission to put feedback for a text, voice, or media message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_PutMessageFeedback.html
     */
    toPutMessageFeedback(): this;
    /**
     * Grants permission to put a destination phone number into an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_PutOptedOutNumber.html
     */
    toPutOptedOutNumber(): this;
    /**
     * Grants permission to put a phone number override for a protect configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_PutProtectConfigurationRuleSetNumberOverride.html
     */
    toPutProtectConfigurationRuleSetNumberOverride(): this;
    /**
     * Grants permission to put a registration field value
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_PutRegistrationFieldValue.html
     */
    toPutRegistrationFieldValue(): this;
    /**
     * Grants permission to put a resource policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_PutResourcePolicy.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to release an origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_ReleasePhoneNumber.html
     */
    toReleasePhoneNumber(): this;
    /**
     * Grants permission to release a sender ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_ReleaseSenderId.html
     */
    toReleaseSenderId(): this;
    /**
     * Grants permission to request an origination phone number
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:AssociateOriginationIdentity
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_RequestPhoneNumber.html
     */
    toRequestPhoneNumber(): this;
    /**
     * Grants permission to request an unregistered sender ID
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_RequestSenderId.html
     */
    toRequestSenderId(): this;
    /**
     * Grants permission to send a text or voice message containing a verification code to a destination phone number
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sms-voice:SendTextMessage
     * - sms-voice:SendVoiceMessage
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SendDestinationNumberVerificationCode.html
     */
    toSendDestinationNumberVerificationCode(): this;
    /**
     * Grants permission to send a media message to a destination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SendMediaMessage.html
     */
    toSendMediaMessage(): this;
    /**
     * Grants permission to send a text message to a destination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SendTextMessage.html
     */
    toSendTextMessage(): this;
    /**
     * Grants permission to send a voice message to a destination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SendVoiceMessage.html
     */
    toSendVoiceMessage(): this;
    /**
     * Grants permission to set a default protect configuration for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SetAccountDefaultProtectConfiguration.html
     */
    toSetAccountDefaultProtectConfiguration(): this;
    /**
     * Grants permission to set the default message feedback for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SetDefaultMessageFeedbackEnabled.html
     */
    toSetDefaultMessageFeedbackEnabled(): this;
    /**
     * Grants permission to set the default message type for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SetDefaultMessageType.html
     */
    toSetDefaultMessageType(): this;
    /**
     * Grants permission to set the default sender ID for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SetDefaultSenderId.html
     */
    toSetDefaultSenderId(): this;
    /**
     * Grants permission to set an override for your account's media messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SetMediaMessageSpendLimitOverride.html
     */
    toSetMediaMessageSpendLimitOverride(): this;
    /**
     * Grants permission to set an override for your account's text messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SetTextMessageSpendLimitOverride.html
     */
    toSetTextMessageSpendLimitOverride(): this;
    /**
     * Grants permission to set an override for your account's voice messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SetVoiceMessageSpendLimitOverride.html
     */
    toSetVoiceMessageSpendLimitOverride(): this;
    /**
     * Grants permission to submit the latest version of a given registration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_SubmitRegistrationVersion.html
     */
    toSubmitRegistrationVersion(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an event destination within a configuration set
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_UpdateEventDestination.html
     */
    toUpdateEventDestination(): this;
    /**
     * Grants permission to update an origination phone number's configuration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_UpdatePhoneNumber.html
     */
    toUpdatePhoneNumber(): this;
    /**
     * Grants permission to update a pool's configuration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_UpdatePool.html
     */
    toUpdatePool(): this;
    /**
     * Grants permission to update a protect configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_UpdateProtectConfiguration.html
     */
    toUpdateProtectConfiguration(): this;
    /**
     * Grants permission to update a country rule set for a protect configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_UpdateProtectConfigurationCountryRuleSet.html
     */
    toUpdateProtectConfigurationCountryRuleSet(): this;
    /**
     * Grants permission to update a sender ID's configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_UpdateSenderId.html
     */
    toUpdateSenderId(): this;
    /**
     * Grants permission to verify a destination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_VerifyDestinationNumber.html
     */
    toVerifyDestinationNumber(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ConfigurationSet to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateConfigurationSet.html
     *
     * @param configurationSetName - Identifier for the configurationSetName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfigurationSet(configurationSetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type OptOutList to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateOptOutList.html
     *
     * @param optOutListName - Identifier for the optOutListName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOptOutList(optOutListName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type PhoneNumber to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_RequestPhoneNumber.html
     *
     * @param phoneNumberId - Identifier for the phoneNumberId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPhoneNumber(phoneNumberId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Pool to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreatePool.html
     *
     * @param poolId - Identifier for the poolId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPool(poolId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ProtectConfiguration to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_CreateProtectConfiguration.html
     *
     * @param protectConfigurationId - Identifier for the protectConfigurationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProtectConfiguration(protectConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SenderId to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeSenderIds.html
     *
     * @param senderId - Identifier for the senderId.
     * @param isoCountryCode - Identifier for the isoCountryCode.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSenderId(senderId: string, isoCountryCode: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Registration to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeRegistrations.html
     *
     * @param registrationId - Identifier for the registrationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRegistration(registrationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type RegistrationAttachment to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeRegistrationAttachments.html
     *
     * @param registrationAttachmentId - Identifier for the registrationAttachmentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRegistrationAttachment(registrationAttachmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type VerifiedDestinationNumber to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_DescribeVerifiedDestinationNumbers.html
     *
     * @param verifiedDestinationNumberId - Identifier for the verifiedDestinationNumberId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVerifiedDestinationNumber(verifiedDestinationNumberId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Message to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference_smsvoicev2/API_PutMessageFeedback.html
     *
     * @param messageId - Identifier for the messageId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMessage(messageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateConfigurationSet()
     * - .toCreateOptOutList()
     * - .toCreatePool()
     * - .toCreateProtectConfiguration()
     * - .toCreateRegistration()
     * - .toCreateRegistrationAttachment()
     * - .toCreateVerifiedDestinationNumber()
     * - .toRequestPhoneNumber()
     * - .toRequestSenderId()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - ConfigurationSet
     * - OptOutList
     * - PhoneNumber
     * - Pool
     * - ProtectConfiguration
     * - SenderId
     * - Registration
     * - RegistrationAttachment
     * - VerifiedDestinationNumber
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateConfigurationSet()
     * - .toCreateOptOutList()
     * - .toCreatePool()
     * - .toCreateProtectConfiguration()
     * - .toCreateRegistration()
     * - .toCreateRegistrationAttachment()
     * - .toCreateVerifiedDestinationNumber()
     * - .toRequestPhoneNumber()
     * - .toRequestSenderId()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [sms-voice-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsendusermessagingsmsandvoicev2.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
