import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [entityresolution](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsentityresolution.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Entityresolution extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to give an AWS service or another account permission to use an AWS Entity Resolution resources
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_AddPolicyStatement.html
     */
    toAddPolicyStatement(): this;
    /**
     * Grants permission to batch delete unique Id
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_BatchDeleteUniqueId.html
     */
    toBatchDeleteUniqueId(): this;
    /**
     * Grants permission to create a idmapping workflow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_CreateIdMappingWorkflow.html
     */
    toCreateIdMappingWorkflow(): this;
    /**
     * Grants permission to create a IdNamespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_CreateIdNamespace.html
     */
    toCreateIdNamespace(): this;
    /**
     * Grants permission to create a matching workflow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_CreateMatchingWorkflow.html
     */
    toCreateMatchingWorkflow(): this;
    /**
     * Grants permission to create a schema mapping
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_CreateSchemaMapping.html
     */
    toCreateSchemaMapping(): this;
    /**
     * Grants permission to delete a idmapping workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_DeleteIdMappingWorkflow.html
     */
    toDeleteIdMappingWorkflow(): this;
    /**
     * Grants permission to delete a IdNamespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_DeleteIdNamespace.html
     */
    toDeleteIdNamespace(): this;
    /**
     * Grants permission to delete a matching workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_DeleteMatchingWorkflow.html
     */
    toDeleteMatchingWorkflow(): this;
    /**
     * Grants permission to delete permission given to an AWS service or another account permission to use an AWS Entity Resolution resources
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_DeletePolicyStatement.html
     */
    toDeletePolicyStatement(): this;
    /**
     * Grants permission to delete a schema mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_DeleteSchemaMapping.html
     */
    toDeleteSchemaMapping(): this;
    /**
     * Grants permission to get a idmapping job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetIdMappingJob.html
     */
    toGetIdMappingJob(): this;
    /**
     * Grants permission to get a idmapping workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetIdMappingWorkflow.html
     */
    toGetIdMappingWorkflow(): this;
    /**
     * Grants permission to get a IdNamespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetIdNamespace.html
     */
    toGetIdNamespace(): this;
    /**
     * Grants permission to get match Id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetMatchId.html
     */
    toGetMatchId(): this;
    /**
     * Grants permission to get a matching job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetMatchingJob.html
     */
    toGetMatchingJob(): this;
    /**
     * Grants permission to get a matching workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetMatchingWorkflow.html
     */
    toGetMatchingWorkflow(): this;
    /**
     * Grants permission to get a resource policy for an AWS Entity Resolution resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetPolicy.html
     */
    toGetPolicy(): this;
    /**
     * Grants permission to get provider service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetProviderService.html
     */
    toGetProviderService(): this;
    /**
     * Grants permission to get a schema mapping
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_GetSchemaMapping.html
     */
    toGetSchemaMapping(): this;
    /**
     * Grants permission to list idmapping jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_ListIdMappingJobs.html
     */
    toListIdMappingJobs(): this;
    /**
     * Grants permission to list idmapping workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_ListIdMappingWorkflows.html
     */
    toListIdMappingWorkflows(): this;
    /**
     * Grants permission to list IdNamespaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_ListIdNamespaces.html
     */
    toListIdNamespaces(): this;
    /**
     * Grants permission to list matching jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_ListMatchingJobs.html
     */
    toListMatchingJobs(): this;
    /**
     * Grants permission to list matching workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_ListMatchingWorkflows.html
     */
    toListMatchingWorkflows(): this;
    /**
     * Grants permission to list provider service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_ListProviderServices.html
     */
    toListProviderServices(): this;
    /**
     * Grants permission to list schema mappings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_ListSchemaMappings.html
     */
    toListSchemaMappings(): this;
    /**
     * Grants permission to List tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to put a resource policy for an AWS Entity Resolution resources
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_PutPolicy.html
     */
    toPutPolicy(): this;
    /**
     * Grants permission to start a idmapping job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_StartIdMappingJob.html
     */
    toStartIdMappingJob(): this;
    /**
     * Grants permission to start a matching job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_StartMatchingJob.html
     */
    toStartMatchingJob(): this;
    /**
     * Grants permission to adds tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a idmapping workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_UpdateIdMappingWorkflow.html
     */
    toUpdateIdMappingWorkflow(): this;
    /**
     * Grants permission to update a IdNamespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_UpdateIdNamespace.html
     */
    toUpdateIdNamespace(): this;
    /**
     * Grants permission to update a matching workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_UpdateMatchingWorkflow.html
     */
    toUpdateMatchingWorkflow(): this;
    /**
     * Grants permission to update a schema mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_UpdateSchemaMapping.html
     */
    toUpdateSchemaMapping(): this;
    /**
     * Grants permission to give an AWS service or another account permission to use IdNamespace within a workflow
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_UseIdNamespace.html
     */
    toUseIdNamespace(): this;
    /**
     * Grants permission to give an AWS service or another account permission to use workflow within a IdNamespace
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/entityresolution/latest/apireference/API_UseWorkflow.html
     */
    toUseWorkflow(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type MatchingWorkflow to the statement
     *
     * https://docs.aws.amazon.com/entityresolution/latest/userguide/
     *
     * @param workflowName - Identifier for the workflowName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMatchingWorkflow(workflowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SchemaMapping to the statement
     *
     * https://docs.aws.amazon.com/entityresolution/latest/userguide/
     *
     * @param schemaName - Identifier for the schemaName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSchemaMapping(schemaName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type IdMappingWorkflow to the statement
     *
     * https://docs.aws.amazon.com/entityresolution/latest/userguide/
     *
     * @param workflowName - Identifier for the workflowName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIdMappingWorkflow(workflowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ProviderService to the statement
     *
     * https://docs.aws.amazon.com/entityresolution/latest/userguide/
     *
     * @param providerName - Identifier for the providerName.
     * @param providerServiceName - Identifier for the providerServiceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProviderService(providerName: string, providerServiceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type IdNamespace to the statement
     *
     * https://docs.aws.amazon.com/entityresolution/latest/userguide/
     *
     * @param idNamespaceName - Identifier for the idNamespaceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIdNamespace(idNamespaceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a key that is present in the request the user makes to the entity resolution service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to actions:
     * - .toCreateIdMappingWorkflow()
     * - .toCreateIdNamespace()
     * - .toCreateMatchingWorkflow()
     * - .toCreateSchemaMapping()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to resource types:
     * - MatchingWorkflow
     * - SchemaMapping
     * - IdMappingWorkflow
     * - ProviderService
     * - IdNamespace
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the list of all the tag key names present in the request the user makes to the entity resolution service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to actions:
     * - .toCreateIdMappingWorkflow()
     * - .toCreateIdNamespace()
     * - .toCreateMatchingWorkflow()
     * - .toCreateSchemaMapping()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [entityresolution](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsentityresolution.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
