import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [finspace-api](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfinspaceapi.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class FinspaceApi extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to retrieve FinSpace programmatic access credentials
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/data-api/API_GetProgrammaticAccessCredentials.html
     */
    toGetProgrammaticAccessCredentials(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type credential to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCredential(account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [finspace-api](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfinspaceapi.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
