"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Freetier = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [freetier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfreetier.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Freetier extends shared_1.PolicyStatement {
    /**
     * Grants permission to get free tier alert preference (email address)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toGetFreeTierAlertPreference() {
        return this.to('GetFreeTierAlertPreference');
    }
    /**
     * Grants permission to get free tier usage limits and MTD usage status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toGetFreeTierUsage() {
        return this.to('GetFreeTierUsage');
    }
    /**
     * Grants permission to set free tier alert preference (email address)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toPutFreeTierAlertPreference() {
        return this.to('PutFreeTierAlertPreference');
    }
    /**
     * Statement provider for service [freetier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfreetier.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'freetier';
        this.accessLevelList = {
            Read: [
                'GetFreeTierAlertPreference',
                'GetFreeTierUsage'
            ],
            Write: [
                'PutFreeTierAlertPreference'
            ]
        };
    }
}
exports.Freetier = Freetier;
//# sourceMappingURL=data:application/json;base64,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