import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [omics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awshealthomics.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Omics extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to abort multipart read set uploads
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_AbortMultipartReadSetUpload.html
     */
    toAbortMultipartReadSetUpload(): this;
    /**
     * Grants permission to accept a share
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_AcceptShare.html
     */
    toAcceptShare(): this;
    /**
     * Grants permission to batch delete Read Sets in the given Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_BatchDeleteReadSet.html
     */
    toBatchDeleteReadSet(): this;
    /**
     * Grants permission to cancel an Annotation Import Job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CancelAnnotationImportJob.html
     */
    toCancelAnnotationImportJob(): this;
    /**
     * Grants permission to cancel a workflow run and stop all workflow tasks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CancelRun.html
     */
    toCancelRun(): this;
    /**
     * Grants permission to cancel a Variant Import Job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CancelVariantImportJob.html
     */
    toCancelVariantImportJob(): this;
    /**
     * Grants permission to complete a multipart read set upload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CompleteMultipartReadSetUpload.html
     */
    toCompleteMultipartReadSetUpload(): this;
    /**
     * Grants permission to create an Annotation Store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateAnnotationStore.html
     */
    toCreateAnnotationStore(): this;
    /**
     * Grants permission to create a Version in an Annotation Store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateAnnotationStoreVersion.html
     */
    toCreateAnnotationStoreVersion(): this;
    /**
     * Grants permission to create a multipart read set upload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateMultipartReadSetUpload.html
     */
    toCreateMultipartReadSetUpload(): this;
    /**
     * Grants permission to create a Reference Store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateReferenceStore.html
     */
    toCreateReferenceStore(): this;
    /**
     * Grants permission to create a new workflow run cache
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateRunCache.html
     */
    toCreateRunCache(): this;
    /**
     * Grants permission to create a new workflow run group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateRunGroup.html
     */
    toCreateRunGroup(): this;
    /**
     * Grants permission to create a Sequence Store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateSequenceStore.html
     */
    toCreateSequenceStore(): this;
    /**
     * Grants permission to create a share
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateShare.html
     */
    toCreateShare(): this;
    /**
     * Grants permission to create a Variant Store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateVariantStore.html
     */
    toCreateVariantStore(): this;
    /**
     * Grants permission to create a new workflow with a workflow definition and template of workflow parameters
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateWorkflow.html
     */
    toCreateWorkflow(): this;
    /**
     * Grants permission to create a new workflow version with a workflow definition and template of workflow parameters
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateWorkflowVersion.html
     */
    toCreateWorkflowVersion(): this;
    /**
     * Grants permission to delete an Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteAnnotationStore.html
     */
    toDeleteAnnotationStore(): this;
    /**
     * Grants permission to delete Versions in an Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteAnnotationStoreVersions.html
     */
    toDeleteAnnotationStoreVersions(): this;
    /**
     * Grants permission to delete a Reference in the given Reference Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteReference.html
     */
    toDeleteReference(): this;
    /**
     * Grants permission to delete a Reference Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteReferenceStore.html
     */
    toDeleteReferenceStore(): this;
    /**
     * Grants permission to delete a workflow run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteRun.html
     */
    toDeleteRun(): this;
    /**
     * Grants permission to delete a workflow run cache
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteRunCache.html
     */
    toDeleteRunCache(): this;
    /**
     * Grants permission to delete a workflow run group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteRunGroup.html
     */
    toDeleteRunGroup(): this;
    /**
     * Grants permission to delete an access policy on a given store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteS3AccessPolicy.html
     */
    toDeleteS3AccessPolicy(): this;
    /**
     * Grants permission to delete a Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteSequenceStore.html
     */
    toDeleteSequenceStore(): this;
    /**
     * Grants permission to delete a share
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteShare.html
     */
    toDeleteShare(): this;
    /**
     * Grants permission to delete a Variant Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteVariantStore.html
     */
    toDeleteVariantStore(): this;
    /**
     * Grants permission to delete a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteWorkflow.html
     */
    toDeleteWorkflow(): this;
    /**
     * Grants permission to delete a workflow version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteWorkflowVersion.html
     */
    toDeleteWorkflowVersion(): this;
    /**
     * Grants permission to get the status of an Annotation Import Job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetAnnotationImportJob.html
     */
    toGetAnnotationImportJob(): this;
    /**
     * Grants permission to get detailed information about an Annotation Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetAnnotationStore.html
     */
    toGetAnnotationStore(): this;
    /**
     * Grants permission to get detailed information about a version in an Annotation Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetAnnotationStoreVersion.html
     */
    toGetAnnotationStoreVersion(): this;
    /**
     * Grants permission to get a Read Set in the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSet.html
     */
    toGetReadSet(): this;
    /**
     * Grants permission to get details about a Read Set activation job for the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSetActivationJob.html
     */
    toGetReadSetActivationJob(): this;
    /**
     * Grants permission to get details about a Read Set export job for the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSetExportJob.html
     */
    toGetReadSetExportJob(): this;
    /**
     * Grants permission to get details about a Read Set import job for the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSetImportJob.html
     */
    toGetReadSetImportJob(): this;
    /**
     * Grants permission to get details about a Read Set in the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSetMetadata.html
     */
    toGetReadSetMetadata(): this;
    /**
     * Grants permission to get a Reference in the given Reference Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReference.html
     */
    toGetReference(): this;
    /**
     * Grants permission to get details about a Reference import job for the given Reference Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReferenceImportJob.html
     */
    toGetReferenceImportJob(): this;
    /**
     * Grants permission to get details about a Reference in the given Reference Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReferenceMetadata.html
     */
    toGetReferenceMetadata(): this;
    /**
     * Grants permission to get details about a Reference Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReferenceStore.html
     */
    toGetReferenceStore(): this;
    /**
     * Grants permission to retrieve workflow run details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetRun.html
     */
    toGetRun(): this;
    /**
     * Grants permission to retrieve workflow run cache details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetRunCache.html
     */
    toGetRunCache(): this;
    /**
     * Grants permission to retrieve workflow run group details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetRunGroup.html
     */
    toGetRunGroup(): this;
    /**
     * Grants permission to retrieve workflow task details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetRunTask.html
     */
    toGetRunTask(): this;
    /**
     * Grants permission to get details about an access policy on a given store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetS3AccessPolicy.html
     */
    toGetS3AccessPolicy(): this;
    /**
     * Grants permission to get details about a Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetSequenceStore.html
     */
    toGetSequenceStore(): this;
    /**
     * Grants permission to get detailed information about a Share
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetShare.html
     */
    toGetShare(): this;
    /**
     * Grants permission to get the status of a Variant Import Job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetVariantImportJob.html
     */
    toGetVariantImportJob(): this;
    /**
     * Grants permission to get detailed information about a Variant Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetVariantStore.html
     */
    toGetVariantStore(): this;
    /**
     * Grants permission to retrieve workflow details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetWorkflow.html
     */
    toGetWorkflow(): this;
    /**
     * Grants permission to retrieve workflow version details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetWorkflowVersion.html
     */
    toGetWorkflowVersion(): this;
    /**
     * Grants permission to get a list of Annotation Import Jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListAnnotationImportJobs.html
     */
    toListAnnotationImportJobs(): this;
    /**
     * Grants permission to retrieve a list of information about Versions in an Annotation Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListAnnotationStoreVersions.html
     */
    toListAnnotationStoreVersions(): this;
    /**
     * Grants permission to retrieve a list of information about Annotation Stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListAnnotationStores.html
     */
    toListAnnotationStores(): this;
    /**
     * Grants permission to list multipart read set uploads
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListMultipartReadSetUploads.html
     */
    toListMultipartReadSetUploads(): this;
    /**
     * Grants permission to list Read Set activation jobs for the given Sequence Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSetActivationJobs.html
     */
    toListReadSetActivationJobs(): this;
    /**
     * Grants permission to list Read Set export jobs for the given Sequence Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSetExportJobs.html
     */
    toListReadSetExportJobs(): this;
    /**
     * Grants permission to list Read Set import jobs for the given Sequence Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSetImportJobs.html
     */
    toListReadSetImportJobs(): this;
    /**
     * Grants permission to list read set upload parts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSetUploadParts.html
     */
    toListReadSetUploadParts(): this;
    /**
     * Grants permission to list Read Sets in the given Sequence Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSets.html
     */
    toListReadSets(): this;
    /**
     * Grants permission to list Reference import jobs for the given Reference Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReferenceImportJobs.html
     */
    toListReferenceImportJobs(): this;
    /**
     * Grants permission to list Reference Stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReferenceStores.html
     */
    toListReferenceStores(): this;
    /**
     * Grants permission to list References in the given Reference Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReferences.html
     */
    toListReferences(): this;
    /**
     * Grants permission to retrieve a list of workflow run caches
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListRunCaches.html
     */
    toListRunCaches(): this;
    /**
     * Grants permission to retrieve a list of workflow run groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListRunGroups.html
     */
    toListRunGroups(): this;
    /**
     * Grants permission to retrieve a list of tasks for a workflow run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListRunTasks.html
     */
    toListRunTasks(): this;
    /**
     * Grants permission to retrieve a list of workflow runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListRuns.html
     */
    toListRuns(): this;
    /**
     * Grants permission to list Sequence Stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListSequenceStores.html
     */
    toListSequenceStores(): this;
    /**
     * Grants permission to retrieve a list of information about shares
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListShares.html
     */
    toListShares(): this;
    /**
     * Grants permission to retrieve a list of resource AWS tags
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to get a list of Variant Import Jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListVariantImportJobs.html
     */
    toListVariantImportJobs(): this;
    /**
     * Grants permission to retrieve a list of metadata for Variant Stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListVariantStores.html
     */
    toListVariantStores(): this;
    /**
     * Grants permission to retrieve a list of available versions for a workflow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListWorkflowVersions.html
     */
    toListWorkflowVersions(): this;
    /**
     * Grants permission to retrieve a list of available workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListWorkflows.html
     */
    toListWorkflows(): this;
    /**
     * Grants permission to put an access policy on a given store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_PutS3AccessPolicy.html
     */
    toPutS3AccessPolicy(): this;
    /**
     * Grants permission to import a list of Annotation files to an Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartAnnotationImportJob.html
     */
    toStartAnnotationImportJob(): this;
    /**
     * Grants permission to start a Read Set activation job from the given Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartReadSetActivationJob.html
     */
    toStartReadSetActivationJob(): this;
    /**
     * Grants permission to start a Read Set export job from the given Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartReadSetExportJob.html
     */
    toStartReadSetExportJob(): this;
    /**
     * Grants permission to start a Read Set import job into the given Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartReadSetImportJob.html
     */
    toStartReadSetImportJob(): this;
    /**
     * Grants permission to start a Reference import job into the given Reference Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartReferenceImportJob.html
     */
    toStartReferenceImportJob(): this;
    /**
     * Grants permission to start a workflow run
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartRun.html
     */
    toStartRun(): this;
    /**
     * Grants permission to import a list of variant files to an Variant Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartVariantImportJob.html
     */
    toStartVariantImportJob(): this;
    /**
     * Grants permission to add AWS tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove resource AWS tags
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update information about the Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateAnnotationStore.html
     */
    toUpdateAnnotationStore(): this;
    /**
     * Grants permission to update information about the Version in an Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateAnnotationStoreVersion.html
     */
    toUpdateAnnotationStoreVersion(): this;
    /**
     * Grants permission to update a workflow run cache
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateRunCache.html
     */
    toUpdateRunCache(): this;
    /**
     * Grants permission to update a workflow run group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateRunGroup.html
     */
    toUpdateRunGroup(): this;
    /**
     * Grants permission to update details about a Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateSequenceStore.html
     */
    toUpdateSequenceStore(): this;
    /**
     * Grants permission to update metadata about the Variant Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateVariantStore.html
     */
    toUpdateVariantStore(): this;
    /**
     * Grants permission to update workflow details
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateWorkflow.html
     */
    toUpdateWorkflow(): this;
    /**
     * Grants permission to update workflow version details
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateWorkflowVersion.html
     */
    toUpdateWorkflowVersion(): this;
    /**
     * Grants permission to upload read set parts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UploadReadSetPart.html
     */
    toUploadReadSetPart(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type AnnotationStore to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_AnnotationStoreItem.html
     *
     * @param annotationStoreName - Identifier for the annotationStoreName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAnnotationStore(annotationStoreName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type AnnotationStoreVersion to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_AnnotationStoreVersionItem.html
     *
     * @param annotationStoreName - Identifier for the annotationStoreName.
     * @param annotationStoreVersionName - Identifier for the annotationStoreVersionName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAnnotationStoreVersion(annotationStoreName: string, annotationStoreVersionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type readSet to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ReadSetFiles.html
     *
     * @param sequenceStoreId - Identifier for the sequenceStoreId.
     * @param readSetId - Identifier for the readSetId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReadSet(sequenceStoreId: string, readSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type reference to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ReferenceFiles.html
     *
     * @param referenceStoreId - Identifier for the referenceStoreId.
     * @param referenceId - Identifier for the referenceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReference(referenceStoreId: string, referenceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type referenceStore to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ReferenceStoreDetail.html
     *
     * @param referenceStoreId - Identifier for the referenceStoreId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReferenceStore(referenceStoreId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type run to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_RunListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRun(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type runCache to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_RunCacheListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRunCache(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type runGroup to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_RunGroupListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRunGroup(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type sequenceStore to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_SequenceStoreDetail.html
     *
     * @param sequenceStoreId - Identifier for the sequenceStoreId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSequenceStore(sequenceStoreId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TaggingResource to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_TagResource.html
     *
     * @param tagKey - Identifier for the tagKey.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTaggingResource(tagKey: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TaskResource to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_TaskListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTaskResource(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type VariantStore to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_VariantStoreItem.html
     *
     * @param variantStoreName - Identifier for the variantStoreName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVariantStore(variantStoreName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workflow to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_WorkflowListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkflow(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type WorkflowVersion to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_WorkflowVersionListItem.html
     *
     * @param id - Identifier for the id.
     * @param versionName - Identifier for the versionName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkflowVersion(id: string, versionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAnnotationStore()
     * - .toCreateAnnotationStoreVersion()
     * - .toCreateReferenceStore()
     * - .toCreateRunCache()
     * - .toCreateRunGroup()
     * - .toCreateSequenceStore()
     * - .toCreateVariantStore()
     * - .toCreateWorkflow()
     * - .toCreateWorkflowVersion()
     * - .toStartRun()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - AnnotationStore
     * - AnnotationStoreVersion
     * - readSet
     * - reference
     * - referenceStore
     * - run
     * - runCache
     * - runGroup
     * - sequenceStore
     * - VariantStore
     * - workflow
     * - WorkflowVersion
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAnnotationStore()
     * - .toCreateAnnotationStoreVersion()
     * - .toCreateReferenceStore()
     * - .toCreateRunCache()
     * - .toCreateRunGroup()
     * - .toCreateSequenceStore()
     * - .toCreateVariantStore()
     * - .toCreateWorkflow()
     * - .toCreateWorkflowVersion()
     * - .toStartRun()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [omics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awshealthomics.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
