import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [inspector-scan](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspectorscan.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class InspectorScan extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to scan the customer provided SBOM and return vulnerabilities detected within
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ScanSbom.html
     */
    toScanSbom(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [inspector-scan](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspectorscan.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
