"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InspectorScan = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [inspector-scan](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspectorscan.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class InspectorScan extends shared_1.PolicyStatement {
    /**
     * Grants permission to scan the customer provided SBOM and return vulnerabilities detected within
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ScanSbom.html
     */
    toScanSbom() {
        return this.to('ScanSbom');
    }
    /**
     * Statement provider for service [inspector-scan](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspectorscan.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'inspector-scan';
        this.accessLevelList = {
            Read: [
                'ScanSbom'
            ]
        };
    }
}
exports.InspectorScan = InspectorScan;
//# sourceMappingURL=data:application/json;base64,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