"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iq = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [iq](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiq.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iq extends shared_1.PolicyStatement {
    /**
     * Grants permission to accept an incoming voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toAcceptCall() {
        return this.to('AcceptCall');
    }
    /**
     * Grants permission to approve a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApprovePaymentRequest() {
        return this.to('ApprovePaymentRequest');
    }
    /**
     * Grants permission to approve a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApproveProposal() {
        return this.to('ApproveProposal');
    }
    /**
     * Grants permission to archive a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toArchiveConversation() {
        return this.to('ArchiveConversation');
    }
    /**
     * Grants permission to complete a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCompleteProposal() {
        return this.to('CompleteProposal');
    }
    /**
     * Grants permission to respond to a request or send a direct message to initiate a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateConversation() {
        return this.to('CreateConversation');
    }
    /**
     * Grants permission to create an expert profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateExpert() {
        return this.to('CreateExpert');
    }
    /**
     * Grants permission to create a listing
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateListing() {
        return this.to('CreateListing');
    }
    /**
     * Grants permission to create a milestone proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateMilestoneProposal() {
        return this.to('CreateMilestoneProposal');
    }
    /**
     * Grants permission to create a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreatePaymentRequest() {
        return this.to('CreatePaymentRequest');
    }
    /**
     * Grants permission to submit new requests
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to submit new requests
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateRequest() {
        return this.to('CreateRequest');
    }
    /**
     * Grants permission to create a scheduled proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateScheduledProposal() {
        return this.to('CreateScheduledProposal');
    }
    /**
     * Grants permission to create a seller profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateSeller() {
        return this.to('CreateSeller');
    }
    /**
     * Grants permission to create an upfront proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateUpfrontProposal() {
        return this.to('CreateUpfrontProposal');
    }
    /**
     * Grants permission to decline an incoming voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toDeclineCall() {
        return this.to('DeclineCall');
    }
    /**
     * Grants permission to delete an existing attachment
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toDeleteAttachment() {
        return this.to('DeleteAttachment');
    }
    /**
     * Grants permission to disable individual public profile page
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toDisableIndividualPublicProfile() {
        return this.to('DisableIndividualPublicProfile');
    }
    /**
     * Grants permission to download existing attachment
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toDownloadAttachment() {
        return this.to('DownloadAttachment');
    }
    /**
     * Grants permission to enable individual public profile page
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toEnableIndividualPublicProfile() {
        return this.to('EnableIndividualPublicProfile');
    }
    /**
     * Grants permission to end a voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toEndCall() {
        return this.to('EndCall');
    }
    /**
     * Grants permission to read buyer information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetBuyer() {
        return this.to('GetBuyer');
    }
    /**
     * Grants permission to read details of a voice/video call
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetCall() {
        return this.to('GetCall');
    }
    /**
     * Grants permission to read the chat environment details about a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatInfo() {
        return this.to('GetChatInfo');
    }
    /**
     * Grants permission to read chat messages in a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatMessages() {
        return this.to('GetChatMessages');
    }
    /**
     * Grants permission to request a websocket token for the conversation notifications
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatToken() {
        return this.to('GetChatToken');
    }
    /**
     * Grants permission to read chat messages in a company conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetCompanyChatMessages() {
        return this.to('GetCompanyChatMessages');
    }
    /**
     * Grants permission to read a company profile
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetCompanyProfile() {
        return this.to('GetCompanyProfile');
    }
    /**
     * Grants permission to read details of a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetConversation() {
        return this.to('GetConversation');
    }
    /**
     * Grants permission to read expert information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetExpert() {
        return this.to('GetExpert');
    }
    /**
     * Grants permission to read a listing
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetListing() {
        return this.to('GetListing');
    }
    /**
     * Grants permission to read a seller profile information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetMarketplaceSeller() {
        return this.to('GetMarketplaceSeller');
    }
    /**
     * Grants permission to read a payment request
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetPaymentRequest() {
        return this.to('GetPaymentRequest');
    }
    /**
     * Grants permission to read a proposal
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetProposal() {
        return this.to('GetProposal');
    }
    /**
     * Grants permission to get a created request
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetRequest() {
        return this.to('GetRequest');
    }
    /**
     * Grants permission to read a review for an expert
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetReview() {
        return this.to('GetReview');
    }
    /**
     * Grants permission to hide a request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toHideRequest() {
        return this.to('HideRequest');
    }
    /**
     * Grants permission to start a voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toInitiateCall() {
        return this.to('InitiateCall');
    }
    /**
     * Grants permission to link an AWS certification to individual profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toLinkAwsCertification() {
        return this.to('LinkAwsCertification');
    }
    /**
     * Grants permission to list existing attachments
     *
     * Access Level: List
     *
     * https://aws.amazon.com/iq/
     */
    toListAttachments() {
        return this.to('ListAttachments');
    }
    /**
     * Grants permission to list existing conversations
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListConversations() {
        return this.to('ListConversations');
    }
    /**
     * Grants permission to list access logs of expert activity
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListExpertAccessLogs() {
        return this.to('ListExpertAccessLogs');
    }
    /**
     * Grants permission to list listings
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListListings() {
        return this.to('ListListings');
    }
    /**
     * Grants permission to list payment requests
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListPaymentRequests() {
        return this.to('ListPaymentRequests');
    }
    /**
     * Grants permission to list proposals
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListProposals() {
        return this.to('ListProposals');
    }
    /**
     * Grants permission to list requests that are created
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListRequests() {
        return this.to('ListRequests');
    }
    /**
     * Grants permission to list reviews for an expert
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListReviews() {
        return this.to('ListReviews');
    }
    /**
     * Grants permission to mark a message as read in a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toMarkChatMessageRead() {
        return this.to('MarkChatMessageRead');
    }
    /**
     * Grants permission to reject a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectPaymentRequest() {
        return this.to('RejectPaymentRequest');
    }
    /**
     * Grants permission to reject a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectProposal() {
        return this.to('RejectProposal');
    }
    /**
     * Grants permission to send a message in a conversation as a company
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toSendCompanyChatMessage() {
        return this.to('SendCompanyChatMessage');
    }
    /**
     * Grants permission to send a message in a conversation as an individual
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toSendIndividualChatMessage() {
        return this.to('SendIndividualChatMessage');
    }
    /**
     * Grants permission to unarchive a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUnarchiveConversation() {
        return this.to('UnarchiveConversation');
    }
    /**
     * Grants permission to unlink an AWS certification from individual profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUnlinkAwsCertification() {
        return this.to('UnlinkAwsCertification');
    }
    /**
     * Grants permission to update a company profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateCompanyProfile() {
        return this.to('UpdateCompanyProfile');
    }
    /**
     * Grants permission to add more participants into a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateConversationMembers() {
        return this.to('UpdateConversationMembers');
    }
    /**
     * Grants permission to update an expert information
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateExpert() {
        return this.to('UpdateExpert');
    }
    /**
     * Grants permission to update a listing
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateListing() {
        return this.to('UpdateListing');
    }
    /**
     * Grants permission to update a request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateRequest() {
        return this.to('UpdateRequest');
    }
    /**
     * Grants permission to upload an attachment
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUploadAttachment() {
        return this.to('UploadAttachment');
    }
    /**
     * Grants permission to withdraw a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawPaymentRequest() {
        return this.to('WithdrawPaymentRequest');
    }
    /**
     * Grants permission to withdraw a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawProposal() {
        return this.to('WithdrawProposal');
    }
    /**
     * Grants permission to write a review for an expert
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWriteReview() {
        return this.to('WriteReview');
    }
    /**
     * Adds a resource of type conversation to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConversation(conversationId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::conversation/${conversationId}`);
    }
    /**
     * Adds a resource of type buyer to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param buyerId - Identifier for the buyerId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBuyer(buyerId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::buyer/${buyerId}`);
    }
    /**
     * Adds a resource of type expert to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param expertId - Identifier for the expertId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onExpert(expertId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::expert/${expertId}`);
    }
    /**
     * Adds a resource of type call to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param callId - Identifier for the callId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCall(callId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::call/${callId}`);
    }
    /**
     * Adds a resource of type token to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param tokenId - Identifier for the tokenId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onToken(tokenId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::token/${tokenId}`);
    }
    /**
     * Adds a resource of type proposal to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProposal(conversationId, proposalId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::proposal/${conversationId}/${proposalId}`);
    }
    /**
     * Adds a resource of type paymentRequest to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param paymentRequestId - Identifier for the paymentRequestId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPaymentRequest(conversationId, proposalId, paymentRequestId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::paymentRequest/${conversationId}/${proposalId}/${paymentRequestId}`);
    }
    /**
     * Adds a resource of type paymentSchedule to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param versionId - Identifier for the versionId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPaymentSchedule(conversationId, proposalId, versionId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::paymentSchedule/${conversationId}/${proposalId}/${versionId}`);
    }
    /**
     * Adds a resource of type seller to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param sellerAwsAccountId - Identifier for the sellerAwsAccountId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSeller(sellerAwsAccountId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::seller/${sellerAwsAccountId}`);
    }
    /**
     * Adds a resource of type company to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param companyId - Identifier for the companyId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCompany(companyId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::company/${companyId}`);
    }
    /**
     * Adds a resource of type request to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param requestId - Identifier for the requestId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRequest(requestId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::request/${requestId}`);
    }
    /**
     * Adds a resource of type listing to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param listingId - Identifier for the listingId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onListing(listingId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::listing/${listingId}`);
    }
    /**
     * Adds a resource of type attachment to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param attachmentId - Identifier for the attachmentId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAttachment(attachmentId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq:${region ?? this.defaultRegion}::attachment/${attachmentId}`);
    }
    /**
     * Adds a resource of type permission to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param permissionRequestId - Identifier for the permissionRequestId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPermission(permissionRequestId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq-permission:${region ?? this.defaultRegion}::permission/${permissionRequestId}`);
    }
    /**
     * Statement provider for service [iq](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiq.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'iq';
        this.accessLevelList = {
            Write: [
                'AcceptCall',
                'ApprovePaymentRequest',
                'ApproveProposal',
                'ArchiveConversation',
                'CompleteProposal',
                'CreateConversation',
                'CreateExpert',
                'CreateListing',
                'CreateMilestoneProposal',
                'CreatePaymentRequest',
                'CreateProject',
                'CreateRequest',
                'CreateScheduledProposal',
                'CreateSeller',
                'CreateUpfrontProposal',
                'DeclineCall',
                'DeleteAttachment',
                'DisableIndividualPublicProfile',
                'EnableIndividualPublicProfile',
                'EndCall',
                'HideRequest',
                'InitiateCall',
                'LinkAwsCertification',
                'MarkChatMessageRead',
                'RejectPaymentRequest',
                'RejectProposal',
                'SendCompanyChatMessage',
                'SendIndividualChatMessage',
                'UnarchiveConversation',
                'UnlinkAwsCertification',
                'UpdateCompanyProfile',
                'UpdateConversationMembers',
                'UpdateExpert',
                'UpdateListing',
                'UpdateRequest',
                'UploadAttachment',
                'WithdrawPaymentRequest',
                'WithdrawProposal',
                'WriteReview'
            ],
            Read: [
                'DownloadAttachment',
                'GetBuyer',
                'GetCall',
                'GetChatInfo',
                'GetChatMessages',
                'GetChatToken',
                'GetCompanyChatMessages',
                'GetCompanyProfile',
                'GetConversation',
                'GetExpert',
                'GetListing',
                'GetMarketplaceSeller',
                'GetPaymentRequest',
                'GetProposal',
                'GetRequest',
                'GetReview',
                'ListConversations',
                'ListExpertAccessLogs',
                'ListListings',
                'ListPaymentRequests',
                'ListProposals',
                'ListRequests',
                'ListReviews'
            ],
            List: [
                'ListAttachments'
            ]
        };
    }
}
exports.Iq = Iq;
//# sourceMappingURL=data:application/json;base64,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