import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [cassandra](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkeyspacesforapachecassandra.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cassandra extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to alter a keyspace or table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toAlter(): this;
    /**
     * Grants permission to alter a multiregion keyspace or table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toAlterMultiRegionResource(): this;
    /**
     * Grants permission to create a keyspace or table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toCreate(): this;
    /**
     * Grants permission to create a multiregion keyspace or table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toCreateMultiRegionResource(): this;
    /**
     * Grants permission to drop a keyspace or table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toDrop(): this;
    /**
     * Grants permission to drop a multiregion keyspace or table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toDropMultiRegionResource(): this;
    /**
     * Grants permission to INSERT, UPDATE or DELETE data in a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toModify(): this;
    /**
     * Grants permission to INSERT, UPDATE or DELETE data in a multiregion table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toModifyMultiRegionResource(): this;
    /**
     * Grants permission to restore table from a backup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toRestore(): this;
    /**
     * Grants permission to restore multiregion table from a backup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toRestoreMultiRegionTable(): this;
    /**
     * Grants permission to SELECT data from a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toSelect(): this;
    /**
     * Grants permission to SELECT data from a multiregion table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toSelectMultiRegionResource(): this;
    /**
     * Grants permission to tag a multiregion keyspace or table
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toTagMultiRegionResource(): this;
    /**
     * Grants permission to tag a keyspace or table
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a multiregion keyspace or table
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toUnTagMultiRegionResource(): this;
    /**
     * Grants permission to untag a keyspace or table
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toUntagResource(): this;
    /**
     * Grants permission to UPDATE the partitioner in a system table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/
     */
    toUpdatePartitioner(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type keyspace to the statement
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/what-is.html
     *
     * @param keyspaceName - Identifier for the keyspaceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKeyspace(keyspaceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type table to the statement
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/what-is.html
     *
     * @param keyspaceName - Identifier for the keyspaceName.
     * @param tableName - Identifier for the tableName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTable(keyspaceName: string, tableName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters actions based on the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toAlter()
     * - .toAlterMultiRegionResource()
     * - .toCreate()
     * - .toCreateMultiRegionResource()
     * - .toTagMultiRegionResource()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - keyspace
     * - table
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toAlter()
     * - .toAlterMultiRegionResource()
     * - .toCreate()
     * - .toCreateMultiRegionResource()
     * - .toTagMultiRegionResource()
     * - .toTagResource()
     * - .toUnTagMultiRegionResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [cassandra](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkeyspacesforapachecassandra.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
