import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [geo-maps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationservicemaps.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class GeoMaps extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to retrieve the static map
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geomaps_GetStaticMap.html
     */
    toGetStaticMap(): this;
    /**
     * Grants permission to retrieve the map tile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geomaps_GetTile.html
     */
    toGetTile(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type provider to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/Welcome.html
     *
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProvider(region?: string, partition?: string): this;
    /**
     * Statement provider for service [geo-maps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationservicemaps.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
