"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceManagement = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceManagement extends shared_1.PolicyStatement {
    /**
     * Grants permission to view additional seller notification recipients
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toGetAdditionalSellerNotificationRecipients() {
        return this.to('GetAdditionalSellerNotificationRecipients');
    }
    /**
     * Grants permission to view bank account verification status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toGetBankAccountVerificationDetails() {
        return this.to('GetBankAccountVerificationDetails');
    }
    /**
     * Grants permission to view secondary user account verification status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toGetSecondaryUserVerificationDetails() {
        return this.to('GetSecondaryUserVerificationDetails');
    }
    /**
     * Grants permission to view account verification status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toGetSellerVerificationDetails() {
        return this.to('GetSellerVerificationDetails');
    }
    /**
     * Grants permission to update additional seller notification recipients
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toPutAdditionalSellerNotificationRecipients() {
        return this.to('PutAdditionalSellerNotificationRecipients');
    }
    /**
     * Grants permission to update bank account verification status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toPutBankAccountVerificationDetails() {
        return this.to('PutBankAccountVerificationDetails');
    }
    /**
     * Grants permission to update secondary user account verification status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toPutSecondaryUserVerificationDetails() {
        return this.to('PutSecondaryUserVerificationDetails');
    }
    /**
     * Grants permission to update account verification status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toPutSellerVerificationDetails() {
        return this.to('PutSellerVerificationDetails');
    }
    /**
     * Allows access to the File Upload page inside the AWS Marketplace Management Portal
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toUploadFiles() {
        return this.to('uploadFiles');
    }
    /**
     * Allows access to the Marketing page inside the AWS Marketplace Management Portal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewMarketing() {
        return this.to('viewMarketing');
    }
    /**
     * Allows access to the Reports page inside the AWS Marketplace Management Portal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewReports() {
        return this.to('viewReports');
    }
    /**
     * Allows access to the Settings page inside the AWS Marketplace Management Portal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewSettings() {
        return this.to('viewSettings');
    }
    /**
     * Allows access to the Customer Support Eligibility page inside the AWS Marketplace Management Portal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewSupport() {
        return this.to('viewSupport');
    }
    /**
     * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace-management';
        this.accessLevelList = {
            Read: [
                'GetAdditionalSellerNotificationRecipients',
                'GetBankAccountVerificationDetails',
                'GetSecondaryUserVerificationDetails',
                'GetSellerVerificationDetails'
            ],
            Write: [
                'PutAdditionalSellerNotificationRecipients',
                'PutBankAccountVerificationDetails',
                'PutSecondaryUserVerificationDetails',
                'PutSellerVerificationDetails',
                'uploadFiles'
            ],
            List: [
                'viewMarketing',
                'viewReports',
                'viewSettings',
                'viewSupport'
            ]
        };
    }
}
exports.AwsMarketplaceManagement = AwsMarketplaceManagement;
//# sourceMappingURL=data:application/json;base64,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