"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mechanicalturk = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mechanicalturk extends shared_1.PolicyStatement {
    /**
     * The AcceptQualificationRequest operation grants a Worker's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     */
    toAcceptQualificationRequest() {
        return this.to('AcceptQualificationRequest');
    }
    /**
     * The ApproveAssignment operation approves the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     */
    toApproveAssignment() {
        return this.to('ApproveAssignment');
    }
    /**
     * The AssociateQualificationWithWorker operation gives a Worker a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     */
    toAssociateQualificationWithWorker() {
        return this.to('AssociateQualificationWithWorker');
    }
    /**
     * The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     */
    toCreateAdditionalAssignmentsForHIT() {
        return this.to('CreateAdditionalAssignmentsForHIT');
    }
    /**
     * The CreateHIT operation creates a new HIT (Human Intelligence Task)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     */
    toCreateHIT() {
        return this.to('CreateHIT');
    }
    /**
     * The CreateHITType operation creates a new HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     */
    toCreateHITType() {
        return this.to('CreateHITType');
    }
    /**
     * The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     */
    toCreateHITWithHITType() {
        return this.to('CreateHITWithHITType');
    }
    /**
     * The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     */
    toCreateQualificationType() {
        return this.to('CreateQualificationType');
    }
    /**
     * The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     */
    toCreateWorkerBlock() {
        return this.to('CreateWorkerBlock');
    }
    /**
     * The DeleteHIT operation disposes of a HIT that is no longer needed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     */
    toDeleteHIT() {
        return this.to('DeleteHIT');
    }
    /**
     * The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     */
    toDeleteQualificationType() {
        return this.to('DeleteQualificationType');
    }
    /**
     * The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     */
    toDeleteWorkerBlock() {
        return this.to('DeleteWorkerBlock');
    }
    /**
     * The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     */
    toDisassociateQualificationFromWorker() {
        return this.to('DisassociateQualificationFromWorker');
    }
    /**
     * The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     */
    toGetAccountBalance() {
        return this.to('GetAccountBalance');
    }
    /**
     * The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     */
    toGetAssignment() {
        return this.to('GetAssignment');
    }
    /**
     * The GetFileUploadURL operation generates and returns a temporary URL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     */
    toGetFileUploadURL() {
        return this.to('GetFileUploadURL');
    }
    /**
     * The GetHIT operation retrieves the details of the specified HIT
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     */
    toGetHIT() {
        return this.to('GetHIT');
    }
    /**
     * The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     */
    toGetQualificationScore() {
        return this.to('GetQualificationScore');
    }
    /**
     * The GetQualificationType operation retrieves information about a Qualification type using its ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     */
    toGetQualificationType() {
        return this.to('GetQualificationType');
    }
    /**
     * The ListAssignmentsForHIT operation retrieves completed assignments for a HIT
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     */
    toListAssignmentsForHIT() {
        return this.to('ListAssignmentsForHIT');
    }
    /**
     * The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     */
    toListBonusPayments() {
        return this.to('ListBonusPayments');
    }
    /**
     * The ListHITs operation returns all of a Requester's HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     */
    toListHITs() {
        return this.to('ListHITs');
    }
    /**
     * The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     */
    toListHITsForQualificationType() {
        return this.to('ListHITsForQualificationType');
    }
    /**
     * The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     */
    toListQualificationRequests() {
        return this.to('ListQualificationRequests');
    }
    /**
     * The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     */
    toListQualificationTypes() {
        return this.to('ListQualificationTypes');
    }
    /**
     * The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     */
    toListReviewPolicyResultsForHIT() {
        return this.to('ListReviewPolicyResultsForHIT');
    }
    /**
     * The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     */
    toListReviewableHITs() {
        return this.to('ListReviewableHITs');
    }
    /**
     * The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     */
    toListWorkerBlocks() {
        return this.to('ListWorkerBlocks');
    }
    /**
     * The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     */
    toListWorkersWithQualificationType() {
        return this.to('ListWorkersWithQualificationType');
    }
    /**
     * The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     */
    toNotifyWorkers() {
        return this.to('NotifyWorkers');
    }
    /**
     * The RejectAssignment operation rejects the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     */
    toRejectAssignment() {
        return this.to('RejectAssignment');
    }
    /**
     * The RejectQualificationRequest operation rejects a user's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     */
    toRejectQualificationRequest() {
        return this.to('RejectQualificationRequest');
    }
    /**
     * The SendBonus operation issues a payment of money from your account to a Worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     */
    toSendBonus() {
        return this.to('SendBonus');
    }
    /**
     * The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     */
    toSendTestEventNotification() {
        return this.to('SendTestEventNotification');
    }
    /**
     * The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     */
    toUpdateExpirationForHIT() {
        return this.to('UpdateExpirationForHIT');
    }
    /**
     * The UpdateHITReviewStatus operation toggles the status of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     */
    toUpdateHITReviewStatus() {
        return this.to('UpdateHITReviewStatus');
    }
    /**
     * The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     */
    toUpdateHITTypeOfHIT() {
        return this.to('UpdateHITTypeOfHIT');
    }
    /**
     * The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     */
    toUpdateNotificationSettings() {
        return this.to('UpdateNotificationSettings');
    }
    /**
     * The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     */
    toUpdateQualificationType() {
        return this.to('UpdateQualificationType');
    }
    /**
     * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'mechanicalturk';
        this.accessLevelList = {
            Write: [
                'AcceptQualificationRequest',
                'ApproveAssignment',
                'AssociateQualificationWithWorker',
                'CreateAdditionalAssignmentsForHIT',
                'CreateHIT',
                'CreateHITType',
                'CreateHITWithHITType',
                'CreateQualificationType',
                'CreateWorkerBlock',
                'DeleteHIT',
                'DeleteQualificationType',
                'DeleteWorkerBlock',
                'DisassociateQualificationFromWorker',
                'NotifyWorkers',
                'RejectAssignment',
                'RejectQualificationRequest',
                'SendBonus',
                'SendTestEventNotification',
                'UpdateExpirationForHIT',
                'UpdateHITReviewStatus',
                'UpdateHITTypeOfHIT',
                'UpdateNotificationSettings',
                'UpdateQualificationType'
            ],
            Read: [
                'GetAccountBalance',
                'GetAssignment',
                'GetFileUploadURL',
                'GetHIT',
                'GetQualificationScore',
                'GetQualificationType'
            ],
            List: [
                'ListAssignmentsForHIT',
                'ListBonusPayments',
                'ListHITs',
                'ListHITsForQualificationType',
                'ListQualificationRequests',
                'ListQualificationTypes',
                'ListReviewPolicyResultsForHIT',
                'ListReviewableHITs',
                'ListWorkerBlocks',
                'ListWorkersWithQualificationType'
            ]
        };
    }
}
exports.Mechanicalturk = Mechanicalturk;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWVjaGFuaWNhbHR1cmsuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtZWNoYW5pY2FsdHVyay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx5Q0FBK0M7QUFHL0M7Ozs7R0FJRztBQUNILE1BQWEsY0FBZSxTQUFRLHdCQUFlO0lBR2pEOzs7Ozs7T0FNRztJQUNJLDRCQUE0QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1DQUFtQztRQUN4QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFDQUFxQztRQUMxQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUNBQXFDLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxRQUFRO1FBQ2IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNCLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDhCQUE4QjtRQUNuQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLCtCQUErQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNEJBQTRCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQy9DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBa0REOzs7T0FHRztJQUNILFlBQVksS0FBZ0M7UUFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBcGVSLGtCQUFhLEdBQUcsZ0JBQWdCLENBQUM7UUErYTlCLG9CQUFlLEdBQW9CO1lBQzNDLEtBQUssRUFBRTtnQkFDTCw0QkFBNEI7Z0JBQzVCLG1CQUFtQjtnQkFDbkIsa0NBQWtDO2dCQUNsQyxtQ0FBbUM7Z0JBQ25DLFdBQVc7Z0JBQ1gsZUFBZTtnQkFDZixzQkFBc0I7Z0JBQ3RCLHlCQUF5QjtnQkFDekIsbUJBQW1CO2dCQUNuQixXQUFXO2dCQUNYLHlCQUF5QjtnQkFDekIsbUJBQW1CO2dCQUNuQixxQ0FBcUM7Z0JBQ3JDLGVBQWU7Z0JBQ2Ysa0JBQWtCO2dCQUNsQiw0QkFBNEI7Z0JBQzVCLFdBQVc7Z0JBQ1gsMkJBQTJCO2dCQUMzQix3QkFBd0I7Z0JBQ3hCLHVCQUF1QjtnQkFDdkIsb0JBQW9CO2dCQUNwQiw0QkFBNEI7Z0JBQzVCLHlCQUF5QjthQUMxQjtZQUNELElBQUksRUFBRTtnQkFDSixtQkFBbUI7Z0JBQ25CLGVBQWU7Z0JBQ2Ysa0JBQWtCO2dCQUNsQixRQUFRO2dCQUNSLHVCQUF1QjtnQkFDdkIsc0JBQXNCO2FBQ3ZCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLHVCQUF1QjtnQkFDdkIsbUJBQW1CO2dCQUNuQixVQUFVO2dCQUNWLDhCQUE4QjtnQkFDOUIsMkJBQTJCO2dCQUMzQix3QkFBd0I7Z0JBQ3hCLCtCQUErQjtnQkFDL0Isb0JBQW9CO2dCQUNwQixrQkFBa0I7Z0JBQ2xCLGtDQUFrQzthQUNuQztTQUNGLENBQUM7SUFRRixDQUFDO0NBQ0Y7QUF2ZUQsd0NBdWVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi8uLi9zaGFyZWQnO1xuaW1wb3J0IHsgYXdzX2lhbSBhcyBpYW0gfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW21lY2hhbmljYWx0dXJrXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b25tZWNoYW5pY2FsdHVyay5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIE1lY2hhbmljYWx0dXJrIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnbWVjaGFuaWNhbHR1cmsnO1xuXG4gIC8qKlxuICAgKiBUaGUgQWNjZXB0UXVhbGlmaWNhdGlvblJlcXVlc3Qgb3BlcmF0aW9uIGdyYW50cyBhIFdvcmtlcidzIHJlcXVlc3QgZm9yIGEgUXVhbGlmaWNhdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0FjY2VwdFF1YWxpZmljYXRpb25SZXF1ZXN0T3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0FjY2VwdFF1YWxpZmljYXRpb25SZXF1ZXN0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBY2NlcHRRdWFsaWZpY2F0aW9uUmVxdWVzdCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBcHByb3ZlQXNzaWdubWVudCBvcGVyYXRpb24gYXBwcm92ZXMgdGhlIHJlc3VsdHMgb2YgYSBjb21wbGV0ZWQgYXNzaWdubWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0FwcHJvdmVBc3NpZ25tZW50T3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0FwcHJvdmVBc3NpZ25tZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBcHByb3ZlQXNzaWdubWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBc3NvY2lhdGVRdWFsaWZpY2F0aW9uV2l0aFdvcmtlciBvcGVyYXRpb24gZ2l2ZXMgYSBXb3JrZXIgYSBRdWFsaWZpY2F0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU01lY2hUdXJrL2xhdGVzdC9BV1NNdHVya0FQSS9BcGlSZWZlcmVuY2VfQXNzb2NpYXRlUXVhbGlmaWNhdGlvbldpdGhXb3JrZXJPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQXNzb2NpYXRlUXVhbGlmaWNhdGlvbldpdGhXb3JrZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Fzc29jaWF0ZVF1YWxpZmljYXRpb25XaXRoV29ya2VyJyk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIENyZWF0ZUFkZGl0aW9uYWxBc3NpZ25tZW50c0ZvckhJVCBvcGVyYXRpb24gaW5jcmVhc2VzIHRoZSBtYXhpbXVtIG51bWJlciBvZiBhc3NpZ25tZW50cyBvZiBhbiBleGlzdGluZyBISVRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9DcmVhdGVBZGRpdGlvbmFsQXNzaWdubWVudHNGb3JISVRPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlQWRkaXRpb25hbEFzc2lnbm1lbnRzRm9ySElUKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVBZGRpdGlvbmFsQXNzaWdubWVudHNGb3JISVQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgQ3JlYXRlSElUIG9wZXJhdGlvbiBjcmVhdGVzIGEgbmV3IEhJVCAoSHVtYW4gSW50ZWxsaWdlbmNlIFRhc2spXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU01lY2hUdXJrL2xhdGVzdC9BV1NNdHVya0FQSS9BcGlSZWZlcmVuY2VfQ3JlYXRlSElUT3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUhJVCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlSElUJyk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIENyZWF0ZUhJVFR5cGUgb3BlcmF0aW9uIGNyZWF0ZXMgYSBuZXcgSElUIHR5cGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9DcmVhdGVISVRUeXBlT3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUhJVFR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUhJVFR5cGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgQ3JlYXRlSElUV2l0aEhJVFR5cGUgb3BlcmF0aW9uIGNyZWF0ZXMgYSBuZXcgSHVtYW4gSW50ZWxsaWdlbmNlIFRhc2sgKEhJVCkgdXNpbmcgYW4gZXhpc3RpbmcgSElUVHlwZUlEIGdlbmVyYXRlZCBieSB0aGUgQ3JlYXRlSElUVHlwZSBvcGVyYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9DcmVhdGVISVRXaXRoSElUVHlwZU9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVISVRXaXRoSElUVHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlSElUV2l0aEhJVFR5cGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgQ3JlYXRlUXVhbGlmaWNhdGlvblR5cGUgb3BlcmF0aW9uIGNyZWF0ZXMgYSBuZXcgUXVhbGlmaWNhdGlvbiB0eXBlLCB3aGljaCBpcyByZXByZXNlbnRlZCBieSBhIFF1YWxpZmljYXRpb25UeXBlIGRhdGEgc3RydWN0dXJlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU01lY2hUdXJrL2xhdGVzdC9BV1NNdHVya0FQSS9BcGlSZWZlcmVuY2VfQ3JlYXRlUXVhbGlmaWNhdGlvblR5cGVPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlUXVhbGlmaWNhdGlvblR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVF1YWxpZmljYXRpb25UeXBlJyk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIENyZWF0ZVdvcmtlckJsb2NrIG9wZXJhdGlvbiBhbGxvd3MgeW91IHRvIHByZXZlbnQgYSBXb3JrZXIgZnJvbSB3b3JraW5nIG9uIHlvdXIgSElUc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0NyZWF0ZVdvcmtlckJsb2NrT3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVdvcmtlckJsb2NrKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVXb3JrZXJCbG9jaycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBEZWxldGVISVQgb3BlcmF0aW9uIGRpc3Bvc2VzIG9mIGEgSElUIHRoYXQgaXMgbm8gbG9uZ2VyIG5lZWRlZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0RlbGV0ZUhJVE9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVISVQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUhJVCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBEZWxldGVRdWFsaWZpY2F0aW9uVHlwZSBkaXNwb3NlcyBhIFF1YWxpZmljYXRpb24gdHlwZSBhbmQgZGlzcG9zZXMgYW55IEhJVCB0eXBlcyB0aGF0IGFyZSBhc3NvY2lhdGVkIHdpdGggdGhlIFF1YWxpZmljYXRpb24gdHlwZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0RlbGV0ZVF1YWxpZmljYXRpb25UeXBlT3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVF1YWxpZmljYXRpb25UeXBlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVRdWFsaWZpY2F0aW9uVHlwZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBEZWxldGVXb3JrZXJCbG9jayBvcGVyYXRpb24gYWxsb3dzIHlvdSB0byByZWluc3RhdGUgYSBibG9ja2VkIFdvcmtlciB0byB3b3JrIG9uIHlvdXIgSElUc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0RlbGV0ZVdvcmtlckJsb2NrT3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVdvcmtlckJsb2NrKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVXb3JrZXJCbG9jaycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBEaXNhc3NvY2lhdGVRdWFsaWZpY2F0aW9uRnJvbVdvcmtlciByZXZva2VzIGEgcHJldmlvdXNseSBncmFudGVkIFF1YWxpZmljYXRpb24gZnJvbSBhIHVzZXJcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9EaXNhc3NvY2lhdGVRdWFsaWZpY2F0aW9uRnJvbVdvcmtlck9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EaXNhc3NvY2lhdGVRdWFsaWZpY2F0aW9uRnJvbVdvcmtlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGlzYXNzb2NpYXRlUXVhbGlmaWNhdGlvbkZyb21Xb3JrZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgR2V0QWNjb3VudEJhbGFuY2Ugb3BlcmF0aW9uIHJldHJpZXZlcyB0aGUgYW1vdW50IG9mIG1vbmV5IGluIHlvdXIgQW1hem9uIE1lY2hhbmljYWwgVHVyayBhY2NvdW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9HZXRBY2NvdW50QmFsYW5jZU9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRBY2NvdW50QmFsYW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QWNjb3VudEJhbGFuY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgR2V0QXNzaWdubWVudCByZXRyaWV2ZXMgYW4gYXNzaWdubWVudCB3aXRoIGFuIEFzc2lnbm1lbnRTdGF0dXMgdmFsdWUgb2YgU3VibWl0dGVkLCBBcHByb3ZlZCwgb3IgUmVqZWN0ZWQsIHVzaW5nIHRoZSBhc3NpZ25tZW50J3MgSURcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0dldEFzc2lnbm1lbnRPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0QXNzaWdubWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QXNzaWdubWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBHZXRGaWxlVXBsb2FkVVJMIG9wZXJhdGlvbiBnZW5lcmF0ZXMgYW5kIHJldHVybnMgYSB0ZW1wb3JhcnkgVVJMXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9HZXRGaWxlVXBsb2FkVVJMT3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEZpbGVVcGxvYWRVUkwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEZpbGVVcGxvYWRVUkwnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgR2V0SElUIG9wZXJhdGlvbiByZXRyaWV2ZXMgdGhlIGRldGFpbHMgb2YgdGhlIHNwZWNpZmllZCBISVRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0dldEhJVE9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRISVQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEhJVCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBHZXRRdWFsaWZpY2F0aW9uU2NvcmUgb3BlcmF0aW9uIHJldHVybnMgdGhlIHZhbHVlIG9mIGEgV29ya2VyJ3MgUXVhbGlmaWNhdGlvbiBmb3IgYSBnaXZlbiBRdWFsaWZpY2F0aW9uIHR5cGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0dldFF1YWxpZmljYXRpb25TY29yZU9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRRdWFsaWZpY2F0aW9uU2NvcmUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFF1YWxpZmljYXRpb25TY29yZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBHZXRRdWFsaWZpY2F0aW9uVHlwZSBvcGVyYXRpb24gcmV0cmlldmVzIGluZm9ybWF0aW9uIGFib3V0IGEgUXVhbGlmaWNhdGlvbiB0eXBlIHVzaW5nIGl0cyBJRFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU01lY2hUdXJrL2xhdGVzdC9BV1NNdHVya0FQSS9BcGlSZWZlcmVuY2VfR2V0UXVhbGlmaWNhdGlvblR5cGVPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0UXVhbGlmaWNhdGlvblR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFF1YWxpZmljYXRpb25UeXBlJyk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIExpc3RBc3NpZ25tZW50c0ZvckhJVCBvcGVyYXRpb24gcmV0cmlldmVzIGNvbXBsZXRlZCBhc3NpZ25tZW50cyBmb3IgYSBISVRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0xpc3RBc3NpZ25tZW50c0ZvckhJVE9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0QXNzaWdubWVudHNGb3JISVQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RBc3NpZ25tZW50c0ZvckhJVCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBMaXN0Qm9udXNQYXltZW50cyBvcGVyYXRpb24gcmV0cmlldmVzIHRoZSBhbW91bnRzIG9mIGJvbnVzZXMgeW91IGhhdmUgcGFpZCB0byBXb3JrZXJzIGZvciBhIGdpdmVuIEhJVCBvciBhc3NpZ25tZW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9MaXN0Qm9udXNQYXltZW50c09wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Qm9udXNQYXltZW50cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEJvbnVzUGF5bWVudHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgTGlzdEhJVHMgb3BlcmF0aW9uIHJldHVybnMgYWxsIG9mIGEgUmVxdWVzdGVyJ3MgSElUc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU01lY2hUdXJrL2xhdGVzdC9BV1NNdHVya0FQSS9BcGlSZWZlcmVuY2VfTGlzdEhJVHNPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEhJVHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RISVRzJyk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIExpc3RISVRzRm9yUXVhbGlmaWNhdGlvblR5cGUgb3BlcmF0aW9uIHJldHVybnMgdGhlIEhJVHMgdGhhdCB1c2UgdGhlIGdpdmVuIFF1YWxpZmlmY2F0aW9uVHlwZSBmb3IgYSBRdWFsaWZpY2F0aW9uUmVxdWlyZW1lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0xpc3RISVRzRm9yUXVhbGlmaWNhdGlvblR5cGVPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEhJVHNGb3JRdWFsaWZpY2F0aW9uVHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEhJVHNGb3JRdWFsaWZpY2F0aW9uVHlwZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBMaXN0UXVhbGlmaWNhdGlvblJlcXVlc3RzIG9wZXJhdGlvbiByZXRyaWV2ZXMgcmVxdWVzdHMgZm9yIFF1YWxpZmljYXRpb25zIG9mIGEgcGFydGljdWxhciBRdWFsaWZpY2F0aW9uIHR5cGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0xpc3RRdWFsaWZpY2F0aW9uUmVxdWVzdHNPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFF1YWxpZmljYXRpb25SZXF1ZXN0cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFF1YWxpZmljYXRpb25SZXF1ZXN0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBMaXN0UXVhbGlmaWNhdGlvblR5cGVzIG9wZXJhdGlvbiBzZWFyY2hlcyBmb3IgUXVhbGlmaWNhdGlvbiB0eXBlcyB1c2luZyB0aGUgc3BlY2lmaWVkIHNlYXJjaCBxdWVyeSwgYW5kIHJldHVybnMgYSBsaXN0IG9mIFF1YWxpZmljYXRpb24gdHlwZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX0xpc3RRdWFsaWZpY2F0aW9uVHlwZXNPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFF1YWxpZmljYXRpb25UeXBlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFF1YWxpZmljYXRpb25UeXBlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBMaXN0UmV2aWV3UG9saWN5UmVzdWx0c0ZvckhJVCBvcGVyYXRpb24gcmV0cmlldmVzIHRoZSBjb21wdXRlZCByZXN1bHRzIGFuZCB0aGUgYWN0aW9ucyB0YWtlbiBpbiB0aGUgY291cnNlIG9mIGV4ZWN1dGluZyB5b3VyIFJldmlldyBQb2xpY2llcyBkdXJpbmcgYSBDcmVhdGVISVQgb3BlcmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9MaXN0UmV2aWV3UG9saWN5UmVzdWx0c0ZvckhJVE9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UmV2aWV3UG9saWN5UmVzdWx0c0ZvckhJVCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFJldmlld1BvbGljeVJlc3VsdHNGb3JISVQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgTGlzdFJldmlld2FibGVISVRzIG9wZXJhdGlvbiByZXR1cm5zIGFsbCBvZiBhIFJlcXVlc3RlcidzIEhJVHMgdGhhdCBoYXZlIG5vdCBiZWVuIGFwcHJvdmVkIG9yIHJlamVjdGVkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9MaXN0UmV2aWV3YWJsZUhJVHNPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFJldmlld2FibGVISVRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmV2aWV3YWJsZUhJVHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgTGlzdFdvcmtlcnNCbG9ja3Mgb3BlcmF0aW9uIHJldHJpZXZlcyBhIGxpc3Qgb2YgV29ya2VycyB3aG8gYXJlIGJsb2NrZWQgZnJvbSB3b3JraW5nIG9uIHlvdXIgSElUc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU01lY2hUdXJrL2xhdGVzdC9BV1NNdHVya0FQSS9BcGlSZWZlcmVuY2VfTGlzdFdvcmtlckJsb2Nrc09wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0V29ya2VyQmxvY2tzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0V29ya2VyQmxvY2tzJyk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIExpc3RXb3JrZXJzV2l0aFF1YWxpZmljYXRpb25UeXBlIG9wZXJhdGlvbiByZXR1cm5zIGFsbCBvZiB0aGUgV29ya2VycyB3aXRoIGEgZ2l2ZW4gUXVhbGlmaWNhdGlvbiB0eXBlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9MaXN0V29ya2Vyc1dpdGhRdWFsaWZpY2F0aW9uVHlwZU9wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0V29ya2Vyc1dpdGhRdWFsaWZpY2F0aW9uVHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFdvcmtlcnNXaXRoUXVhbGlmaWNhdGlvblR5cGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgTm90aWZ5V29ya2VycyBvcGVyYXRpb24gc2VuZHMgYW4gZW1haWwgdG8gb25lIG9yIG1vcmUgV29ya2VycyB0aGF0IHlvdSBzcGVjaWZ5IHdpdGggdGhlIFdvcmtlciBJRFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX05vdGlmeVdvcmtlcnNPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTm90aWZ5V29ya2VycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTm90aWZ5V29ya2VycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBSZWplY3RBc3NpZ25tZW50IG9wZXJhdGlvbiByZWplY3RzIHRoZSByZXN1bHRzIG9mIGEgY29tcGxldGVkIGFzc2lnbm1lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9SZWplY3RBc3NpZ25tZW50T3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1JlamVjdEFzc2lnbm1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1JlamVjdEFzc2lnbm1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgUmVqZWN0UXVhbGlmaWNhdGlvblJlcXVlc3Qgb3BlcmF0aW9uIHJlamVjdHMgYSB1c2VyJ3MgcmVxdWVzdCBmb3IgYSBRdWFsaWZpY2F0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU01lY2hUdXJrL2xhdGVzdC9BV1NNdHVya0FQSS9BcGlSZWZlcmVuY2VfUmVqZWN0UXVhbGlmaWNhdGlvblJlcXVlc3RPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUmVqZWN0UXVhbGlmaWNhdGlvblJlcXVlc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1JlamVjdFF1YWxpZmljYXRpb25SZXF1ZXN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIFNlbmRCb251cyBvcGVyYXRpb24gaXNzdWVzIGEgcGF5bWVudCBvZiBtb25leSBmcm9tIHlvdXIgYWNjb3VudCB0byBhIFdvcmtlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX1NlbmRCb251c09wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TZW5kQm9udXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NlbmRCb251cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBTZW5kVGVzdEV2ZW50Tm90aWZpY2F0aW9uIG9wZXJhdGlvbiBjYXVzZXMgQW1hem9uIE1lY2hhbmljYWwgVHVyayB0byBzZW5kIGEgbm90aWZpY2F0aW9uIG1lc3NhZ2UgYXMgaWYgYSBISVQgZXZlbnQgb2NjdXJyZWQsIGFjY29yZGluZyB0byB0aGUgcHJvdmlkZWQgbm90aWZpY2F0aW9uIHNwZWNpZmljYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9TZW5kVGVzdEV2ZW50Tm90aWZpY2F0aW9uT3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1NlbmRUZXN0RXZlbnROb3RpZmljYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NlbmRUZXN0RXZlbnROb3RpZmljYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgVXBkYXRlRXhwaXJhdGlvbkZvckhJVCBvcGVyYXRpb24gYWxsb3dzIHlvdSBleHRlbmQgdGhlIGV4cGlyYXRpb24gdGltZSBvZiBhIEhJVCBiZXlvbmQgaXMgY3VycmVudCBleHBpcmF0aW9uIG9yIGV4cGlyZSBhIEhJVCBpbW1lZGlhdGVseVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX1VwZGF0ZUV4cGlyYXRpb25Gb3JISVRPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlRXhwaXJhdGlvbkZvckhJVCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlRXhwaXJhdGlvbkZvckhJVCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBVcGRhdGVISVRSZXZpZXdTdGF0dXMgb3BlcmF0aW9uIHRvZ2dsZXMgdGhlIHN0YXR1cyBvZiBhIEhJVFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX1VwZGF0ZUhJVFJldmlld1N0YXR1c09wZXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVISVRSZXZpZXdTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUhJVFJldmlld1N0YXR1cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBVcGRhdGVISVRUeXBlT2ZISVQgb3BlcmF0aW9uIGFsbG93cyB5b3UgdG8gY2hhbmdlIHRoZSBISVRUeXBlIHByb3BlcnRpZXMgb2YgYSBISVRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTTWVjaFR1cmsvbGF0ZXN0L0FXU010dXJrQVBJL0FwaVJlZmVyZW5jZV9VcGRhdGVISVRUeXBlT2ZISVRPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlSElUVHlwZU9mSElUKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVISVRUeXBlT2ZISVQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgVXBkYXRlTm90aWZpY2F0aW9uU2V0dGluZ3Mgb3BlcmF0aW9uIGNyZWF0ZXMsIHVwZGF0ZXMsIGRpc2FibGVzIG9yIHJlLWVuYWJsZXMgbm90aWZpY2F0aW9ucyBmb3IgYSBISVQgdHlwZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NNZWNoVHVyay9sYXRlc3QvQVdTTXR1cmtBUEkvQXBpUmVmZXJlbmNlX1VwZGF0ZU5vdGlmaWNhdGlvblNldHRpbmdzT3BlcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZU5vdGlmaWNhdGlvblNldHRpbmdzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVOb3RpZmljYXRpb25TZXR0aW5ncycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBVcGRhdGVRdWFsaWZpY2F0aW9uVHlwZSBvcGVyYXRpb24gbW9kaWZpZXMgdGhlIGF0dHJpYnV0ZXMgb2YgYW4gZXhpc3RpbmcgUXVhbGlmaWNhdGlvbiB0eXBlLCB3aGljaCBpcyByZXByZXNlbnRlZCBieSBhIFF1YWxpZmljYXRpb25UeXBlIGRhdGEgc3RydWN0dXJlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU01lY2hUdXJrL2xhdGVzdC9BV1NNdHVya0FQSS9BcGlSZWZlcmVuY2VfVXBkYXRlUXVhbGlmaWNhdGlvblR5cGVPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUXVhbGlmaWNhdGlvblR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVF1YWxpZmljYXRpb25UeXBlJyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgV3JpdGU6IFtcbiAgICAgICdBY2NlcHRRdWFsaWZpY2F0aW9uUmVxdWVzdCcsXG4gICAgICAnQXBwcm92ZUFzc2lnbm1lbnQnLFxuICAgICAgJ0Fzc29jaWF0ZVF1YWxpZmljYXRpb25XaXRoV29ya2VyJyxcbiAgICAgICdDcmVhdGVBZGRpdGlvbmFsQXNzaWdubWVudHNGb3JISVQnLFxuICAgICAgJ0NyZWF0ZUhJVCcsXG4gICAgICAnQ3JlYXRlSElUVHlwZScsXG4gICAgICAnQ3JlYXRlSElUV2l0aEhJVFR5cGUnLFxuICAgICAgJ0NyZWF0ZVF1YWxpZmljYXRpb25UeXBlJyxcbiAgICAgICdDcmVhdGVXb3JrZXJCbG9jaycsXG4gICAgICAnRGVsZXRlSElUJyxcbiAgICAgICdEZWxldGVRdWFsaWZpY2F0aW9uVHlwZScsXG4gICAgICAnRGVsZXRlV29ya2VyQmxvY2snLFxuICAgICAgJ0Rpc2Fzc29jaWF0ZVF1YWxpZmljYXRpb25Gcm9tV29ya2VyJyxcbiAgICAgICdOb3RpZnlXb3JrZXJzJyxcbiAgICAgICdSZWplY3RBc3NpZ25tZW50JyxcbiAgICAgICdSZWplY3RRdWFsaWZpY2F0aW9uUmVxdWVzdCcsXG4gICAgICAnU2VuZEJvbnVzJyxcbiAgICAgICdTZW5kVGVzdEV2ZW50Tm90aWZpY2F0aW9uJyxcbiAgICAgICdVcGRhdGVFeHBpcmF0aW9uRm9ySElUJyxcbiAgICAgICdVcGRhdGVISVRSZXZpZXdTdGF0dXMnLFxuICAgICAgJ1VwZGF0ZUhJVFR5cGVPZkhJVCcsXG4gICAgICAnVXBkYXRlTm90aWZpY2F0aW9uU2V0dGluZ3MnLFxuICAgICAgJ1VwZGF0ZVF1YWxpZmljYXRpb25UeXBlJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0dldEFjY291bnRCYWxhbmNlJyxcbiAgICAgICdHZXRBc3NpZ25tZW50JyxcbiAgICAgICdHZXRGaWxlVXBsb2FkVVJMJyxcbiAgICAgICdHZXRISVQnLFxuICAgICAgJ0dldFF1YWxpZmljYXRpb25TY29yZScsXG4gICAgICAnR2V0UXVhbGlmaWNhdGlvblR5cGUnXG4gICAgXSxcbiAgICBMaXN0OiBbXG4gICAgICAnTGlzdEFzc2lnbm1lbnRzRm9ySElUJyxcbiAgICAgICdMaXN0Qm9udXNQYXltZW50cycsXG4gICAgICAnTGlzdEhJVHMnLFxuICAgICAgJ0xpc3RISVRzRm9yUXVhbGlmaWNhdGlvblR5cGUnLFxuICAgICAgJ0xpc3RRdWFsaWZpY2F0aW9uUmVxdWVzdHMnLFxuICAgICAgJ0xpc3RRdWFsaWZpY2F0aW9uVHlwZXMnLFxuICAgICAgJ0xpc3RSZXZpZXdQb2xpY3lSZXN1bHRzRm9ySElUJyxcbiAgICAgICdMaXN0UmV2aWV3YWJsZUhJVHMnLFxuICAgICAgJ0xpc3RXb3JrZXJCbG9ja3MnLFxuICAgICAgJ0xpc3RXb3JrZXJzV2l0aFF1YWxpZmljYXRpb25UeXBlJ1xuICAgIF1cbiAgfTtcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFttZWNoYW5pY2FsdHVya10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9ubWVjaGFuaWNhbHR1cmsuaHRtbCkuXG4gICAqXG4gICAqL1xuICBjb25zdHJ1Y3Rvcihwcm9wcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgfVxufVxuIl19