import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [mapcredits](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationaccelerationprogramcredits.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mapcredits extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to view the user's associated Migration Acceleration Program agreements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toListAssociatedPrograms(): this;
    /**
     * Grants permission to view Migration Acceleration Program agreements credits associated with the user's payer account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toListQuarterCredits(): this;
    /**
     * Grants permission to view Migration Acceleration Program agreements eligible spend associated with the user's payer account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toListQuarterSpend(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type agreement to the statement
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @param agreement - Identifier for the agreement.
     * @param agreementId - Identifier for the agreementId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAgreement(agreement: string, agreementId: string, partition?: string): this;
    /**
     * Statement provider for service [mapcredits](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationaccelerationprogramcredits.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
