"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mobileanalytics = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [mobileanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmobileanalytics.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mobileanalytics extends shared_1.PolicyStatement {
    /**
     * Grant access to financial metrics for an app
     *
     * Access Level: Read
     */
    toGetFinancialReports() {
        return this.to('GetFinancialReports');
    }
    /**
     * Grant access to standard metrics for an app
     *
     * Access Level: Read
     */
    toGetReports() {
        return this.to('GetReports');
    }
    /**
     * The PutEvents operation records one or more events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html
     */
    toPutEvents() {
        return this.to('PutEvents');
    }
    /**
     * Statement provider for service [mobileanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmobileanalytics.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'mobileanalytics';
        this.accessLevelList = {
            Read: [
                'GetFinancialReports',
                'GetReports'
            ],
            Write: [
                'PutEvents'
            ]
        };
    }
}
exports.Mobileanalytics = Mobileanalytics;
//# sourceMappingURL=data:application/json;base64,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