import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [networkflowmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_networkflowmonitor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Networkflowmonitor extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a monitor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_CreateMonitor.html
     */
    toCreateMonitor(): this;
    /**
     * Grants permission to create a scope
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_CreateScope.html
     */
    toCreateScope(): this;
    /**
     * Grants permission to delete a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_DeleteMonitor.html
     */
    toDeleteMonitor(): this;
    /**
     * Grants permission to delete a scope
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_DeleteScope.html
     */
    toDeleteScope(): this;
    /**
     * Grants permission to get information about a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetMonitor.html
     */
    toGetMonitor(): this;
    /**
     * Grants permission to get the results of a query that retrieves top contributors data for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsMonitorTopContributors.html
     */
    toGetQueryResultsMonitorTopContributors(): this;
    /**
     * Grants permission to get the results of a query that retrieves top contributors for workload insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributors.html
     */
    toGetQueryResultsWorkloadInsightsTopContributors(): this;
    /**
     * Grants permission to get the results of a query that retrieves top contributors data points for workload insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributorsData.html
     */
    toGetQueryResultsWorkloadInsightsTopContributorsData(): this;
    /**
     * Grants permission to get the status of a query that retrieves top contributors data for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryStatusMonitorTopContributors.html
     */
    toGetQueryStatusMonitorTopContributors(): this;
    /**
     * Grants permission to get the status of a query that retrieves top contributors for workload insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryStatusWorkloadInsightsTopContributors.html
     */
    toGetQueryStatusWorkloadInsightsTopContributors(): this;
    /**
     * Grants permission to get the status of a query that retrieves top contributors data points for workload insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryStatusWorkloadInsightsTopContributorsData.html
     */
    toGetQueryStatusWorkloadInsightsTopContributorsData(): this;
    /**
     * Grants permission to get information about a scope
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetScope.html
     */
    toGetScope(): this;
    /**
     * Grants permission to list all monitors in an account and their statuses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_ListMonitors.html
     */
    toListMonitors(): this;
    /**
     * Grants permission to get all scopes for an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_ListScopes.html
     */
    toListScopes(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to publish a report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_Publish.html
     */
    toPublish(): this;
    /**
     * Grants permission to start a query for retrieving top contributors data for a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StartQueryMonitorTopContributors.html
     */
    toStartQueryMonitorTopContributors(): this;
    /**
     * Grants permission to start a query for retrieving top contributors data for workload insights
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StartQueryWorkloadInsightsTopContributors.html
     */
    toStartQueryWorkloadInsightsTopContributors(): this;
    /**
     * Grants permission to start a query for retrieving top contributors data points for workload insights
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StartQueryWorkloadInsightsTopContributorsData.html
     */
    toStartQueryWorkloadInsightsTopContributorsData(): this;
    /**
     * Grants permission to stop a query for retrieving top contributors data for a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StopQueryMonitorTopContributors.html
     */
    toStopQueryMonitorTopContributors(): this;
    /**
     * Grants permission to stop a query for retrieving top contributors for workload insights
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StopQueryWorkloadInsightsTopContributors.html
     */
    toStopQueryWorkloadInsightsTopContributors(): this;
    /**
     * Grants permission to stop a query for retrieving top contributors data points for workload insights
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StopQueryWorkloadInsightsTopContributorsData.html
     */
    toStopQueryWorkloadInsightsTopContributorsData(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_UpdateMonitor.html
     */
    toUpdateMonitor(): this;
    /**
     * Grants permission to update a scope
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_UpdateScope.html
     */
    toUpdateScope(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type monitor to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-NetworkFlowMonitor-configure-monitors.html
     *
     * @param monitorName - Identifier for the monitorName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMonitor(monitorName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type scope to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-NetworkFlowMonitor-organizations.html
     *
     * @param scopeId - Identifier for the scopeId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScope(scopeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateMonitor()
     * - .toCreateScope()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - monitor
     * - scope
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateMonitor()
     * - .toCreateScope()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [networkflowmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_networkflowmonitor.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
