"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Networkflowmonitor = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [networkflowmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_networkflowmonitor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Networkflowmonitor extends shared_1.PolicyStatement {
    /**
     * Grants permission to create a monitor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_CreateMonitor.html
     */
    toCreateMonitor() {
        return this.to('CreateMonitor');
    }
    /**
     * Grants permission to create a scope
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_CreateScope.html
     */
    toCreateScope() {
        return this.to('CreateScope');
    }
    /**
     * Grants permission to delete a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_DeleteMonitor.html
     */
    toDeleteMonitor() {
        return this.to('DeleteMonitor');
    }
    /**
     * Grants permission to delete a scope
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_DeleteScope.html
     */
    toDeleteScope() {
        return this.to('DeleteScope');
    }
    /**
     * Grants permission to get information about a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetMonitor.html
     */
    toGetMonitor() {
        return this.to('GetMonitor');
    }
    /**
     * Grants permission to get the results of a query that retrieves top contributors data for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsMonitorTopContributors.html
     */
    toGetQueryResultsMonitorTopContributors() {
        return this.to('GetQueryResultsMonitorTopContributors');
    }
    /**
     * Grants permission to get the results of a query that retrieves top contributors for workload insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributors.html
     */
    toGetQueryResultsWorkloadInsightsTopContributors() {
        return this.to('GetQueryResultsWorkloadInsightsTopContributors');
    }
    /**
     * Grants permission to get the results of a query that retrieves top contributors data points for workload insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributorsData.html
     */
    toGetQueryResultsWorkloadInsightsTopContributorsData() {
        return this.to('GetQueryResultsWorkloadInsightsTopContributorsData');
    }
    /**
     * Grants permission to get the status of a query that retrieves top contributors data for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryStatusMonitorTopContributors.html
     */
    toGetQueryStatusMonitorTopContributors() {
        return this.to('GetQueryStatusMonitorTopContributors');
    }
    /**
     * Grants permission to get the status of a query that retrieves top contributors for workload insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryStatusWorkloadInsightsTopContributors.html
     */
    toGetQueryStatusWorkloadInsightsTopContributors() {
        return this.to('GetQueryStatusWorkloadInsightsTopContributors');
    }
    /**
     * Grants permission to get the status of a query that retrieves top contributors data points for workload insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryStatusWorkloadInsightsTopContributorsData.html
     */
    toGetQueryStatusWorkloadInsightsTopContributorsData() {
        return this.to('GetQueryStatusWorkloadInsightsTopContributorsData');
    }
    /**
     * Grants permission to get information about a scope
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetScope.html
     */
    toGetScope() {
        return this.to('GetScope');
    }
    /**
     * Grants permission to list all monitors in an account and their statuses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_ListMonitors.html
     */
    toListMonitors() {
        return this.to('ListMonitors');
    }
    /**
     * Grants permission to get all scopes for an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_ListScopes.html
     */
    toListScopes() {
        return this.to('ListScopes');
    }
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to publish a report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_Publish.html
     */
    toPublish() {
        return this.to('Publish');
    }
    /**
     * Grants permission to start a query for retrieving top contributors data for a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StartQueryMonitorTopContributors.html
     */
    toStartQueryMonitorTopContributors() {
        return this.to('StartQueryMonitorTopContributors');
    }
    /**
     * Grants permission to start a query for retrieving top contributors data for workload insights
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StartQueryWorkloadInsightsTopContributors.html
     */
    toStartQueryWorkloadInsightsTopContributors() {
        return this.to('StartQueryWorkloadInsightsTopContributors');
    }
    /**
     * Grants permission to start a query for retrieving top contributors data points for workload insights
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StartQueryWorkloadInsightsTopContributorsData.html
     */
    toStartQueryWorkloadInsightsTopContributorsData() {
        return this.to('StartQueryWorkloadInsightsTopContributorsData');
    }
    /**
     * Grants permission to stop a query for retrieving top contributors data for a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StopQueryMonitorTopContributors.html
     */
    toStopQueryMonitorTopContributors() {
        return this.to('StopQueryMonitorTopContributors');
    }
    /**
     * Grants permission to stop a query for retrieving top contributors for workload insights
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StopQueryWorkloadInsightsTopContributors.html
     */
    toStopQueryWorkloadInsightsTopContributors() {
        return this.to('StopQueryWorkloadInsightsTopContributors');
    }
    /**
     * Grants permission to stop a query for retrieving top contributors data points for workload insights
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_StopQueryWorkloadInsightsTopContributorsData.html
     */
    toStopQueryWorkloadInsightsTopContributorsData() {
        return this.to('StopQueryWorkloadInsightsTopContributorsData');
    }
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_UpdateMonitor.html
     */
    toUpdateMonitor() {
        return this.to('UpdateMonitor');
    }
    /**
     * Grants permission to update a scope
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_UpdateScope.html
     */
    toUpdateScope() {
        return this.to('UpdateScope');
    }
    /**
     * Adds a resource of type monitor to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-NetworkFlowMonitor-configure-monitors.html
     *
     * @param monitorName - Identifier for the monitorName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMonitor(monitorName, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:networkflowmonitor:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:monitor/${monitorName}`);
    }
    /**
     * Adds a resource of type scope to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-NetworkFlowMonitor-organizations.html
     *
     * @param scopeId - Identifier for the scopeId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScope(scopeId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:networkflowmonitor:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:scope/${scopeId}`);
    }
    /**
     * Filters access by the tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateMonitor()
     * - .toCreateScope()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - monitor
     * - scope
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateMonitor()
     * - .toCreateScope()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Statement provider for service [networkflowmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_networkflowmonitor.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'networkflowmonitor';
        this.accessLevelList = {
            Write: [
                'CreateMonitor',
                'CreateScope',
                'DeleteMonitor',
                'DeleteScope',
                'Publish',
                'StartQueryMonitorTopContributors',
                'StartQueryWorkloadInsightsTopContributors',
                'StartQueryWorkloadInsightsTopContributorsData',
                'StopQueryMonitorTopContributors',
                'StopQueryWorkloadInsightsTopContributors',
                'StopQueryWorkloadInsightsTopContributorsData',
                'UpdateMonitor',
                'UpdateScope'
            ],
            Read: [
                'GetMonitor',
                'GetQueryResultsMonitorTopContributors',
                'GetQueryResultsWorkloadInsightsTopContributors',
                'GetQueryResultsWorkloadInsightsTopContributorsData',
                'GetQueryStatusMonitorTopContributors',
                'GetQueryStatusWorkloadInsightsTopContributors',
                'GetQueryStatusWorkloadInsightsTopContributorsData',
                'GetScope',
                'ListTagsForResource'
            ],
            List: [
                'ListMonitors',
                'ListScopes'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
}
exports.Networkflowmonitor = Networkflowmonitor;
//# sourceMappingURL=data:application/json;base64,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