import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [opsworks-cm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworksconfigurationmanagement.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class OpsworksCm extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a node to a configuration management server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_AssociateNode.html
     */
    toAssociateNode(): this;
    /**
     * Grants permission to create a backup for the specified server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateBackup.html
     */
    toCreateBackup(): this;
    /**
     * Grants permission to create a new server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateServer.html
     */
    toCreateServer(): this;
    /**
     * Grants permission to delete the specified backup and possibly its S3 bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DeleteBackup.html
     */
    toDeleteBackup(): this;
    /**
     * Grants permission to delete the specified server with its corresponding CloudFormation stack and possibly the S3 bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DeleteServer.html
     */
    toDeleteServer(): this;
    /**
     * Grants permission to describe the service limits for the user's account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeAccountAttributes.html
     */
    toDescribeAccountAttributes(): this;
    /**
     * Grants permission to describe a single backup, all backups of a specified server or all backups of the user's account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeBackups.html
     */
    toDescribeBackups(): this;
    /**
     * Grants permission to describe all events of the specified server
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeEvents.html
     */
    toDescribeEvents(): this;
    /**
     * Grants permission to describe the association status for the specified node token and the specified server
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeNodeAssociationStatus.html
     */
    toDescribeNodeAssociationStatus(): this;
    /**
     * Grants permission to describe the specified server or all servers of the user's account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeServers.html
     */
    toDescribeServers(): this;
    /**
     * Grants permission to disassociate a specified node from a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DisassociateNode.html
     */
    toDisassociateNode(): this;
    /**
     * Grants permission to export an engine attribute from a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_ExportServerEngineAttribute.html
     */
    toExportServerEngineAttribute(): this;
    /**
     * Grants permission to list the tags that are applied to the specified server or backup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to apply a backup to specified server. Possibly swaps out the ec2-instance if specified
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_RestoreServer.html
     */
    toRestoreServer(): this;
    /**
     * Grants permission to start the server maintenance immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_StartMaintenance.html
     */
    toStartMaintenance(): this;
    /**
     * Grants permission to apply tags to the specified server or backup
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from the specified server or backup
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update general server settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_UpdateServer.html
     */
    toUpdateServer(): this;
    /**
     * Grants permission to update server settings specific to the configuration management type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_UpdateServerEngineAttributes.html
     */
    toUpdateServerEngineAttributes(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type server to the statement
     *
     * @param serverName - Identifier for the serverName.
     * @param uniqueId - Identifier for the uniqueId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onServer(serverName: string, uniqueId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type backup to the statement
     *
     * @param serverName - Identifier for the serverName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBackup(serverName: string, account?: string, partition?: string): this;
    /**
     * Statement provider for service [opsworks-cm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworksconfigurationmanagement.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
