import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [partnercentral](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspartnercentralselling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Partnercentral extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept Engagement Invitations on AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_AcceptEngagementInvitation.html
     */
    toAcceptEngagementInvitation(): this;
    /**
     * Grants permission to assign Opportunities on AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_AssignOpportunity.html
     */
    toAssignOpportunity(): this;
    /**
     * Grants permission to associate Opportunities on AWS Partner Central with other entities
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     * - .ifRelatedEntityType()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_AssociateOpportunity.html
     */
    toAssociateOpportunity(): this;
    /**
     * Grants permission to creating engagements in AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_CreateEngagement.html
     */
    toCreateEngagement(): this;
    /**
     * Grants permission to creating engagement invitations in AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_CreateEngagementInvitation.html
     */
    toCreateEngagementInvitation(): this;
    /**
     * Grants permission to create new Opportunities on AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_CreateOpportunity.html
     */
    toCreateOpportunity(): this;
    /**
     * Grants permission to creating resource snapshots in AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_CreateResourceSnapshot.html
     */
    toCreateResourceSnapshot(): this;
    /**
     * Grants permission to creating resource snapshot jobs in AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_CreateResourceSnapshotJob.html
     */
    toCreateResourceSnapshotJob(): this;
    /**
     * Grants permission to deleting resource snapshot jobs on AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_DeleteResourceSnapshotJob.html
     */
    toDeleteResourceSnapshotJob(): this;
    /**
     * Grants permission to disassociate Opportunities on AWS Partner Central from other entities
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     * - .ifRelatedEntityType()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_DisassociateOpportunity.html
     */
    toDisassociateOpportunity(): this;
    /**
     * Grants permission to retrieve AWS Opportunity Summaries for Opportunities on AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_GetAwsOpportunitySummary.html
     */
    toGetAwsOpportunitySummary(): this;
    /**
     * Grants permission to retrieval of engagement details in AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_GetEngagement.html
     */
    toGetEngagement(): this;
    /**
     * Grants permission to retrieve details of Engagement Invitations on AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_GetEngagementInvitation.html
     */
    toGetEngagementInvitation(): this;
    /**
     * Grants permission to retrieve details of Opportunities on AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_GetOpportunity.html
     */
    toGetOpportunity(): this;
    /**
     * Grants permission to retrieving resource snapshot details in AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_GetResourceSnapshot.html
     */
    toGetResourceSnapshot(): this;
    /**
     * Grants permission to retrieving resource snapshot job details in AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_GetResourceSnapshotJob.html
     */
    toGetResourceSnapshotJob(): this;
    /**
     * Grants permission to retrieving system settings settings in AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_GetSellingSystemSettings.html
     */
    toGetSellingSystemSettings(): this;
    /**
     * Grants permission to listing engagements by accepting invitation tasks in AWS Partner Central
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListEngagementByAcceptingInvitationTasks.html
     */
    toListEngagementByAcceptingInvitationTasks(): this;
    /**
     * Grants permission to listing engagements from opportunity tasks in AWS Partner Central
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListEngagementFromOpportunityTasks.html
     */
    toListEngagementFromOpportunityTasks(): this;
    /**
     * Grants permission to list Engagement Invitations on AWS Partner Central
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListEngagementInvitations.html
     */
    toListEngagementInvitations(): this;
    /**
     * Grants permission to listing engagement members in AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListEngagementMembers.html
     */
    toListEngagementMembers(): this;
    /**
     * Grants permission to listing engagement resource associations in AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListEngagementResourceAssociations.html
     */
    toListEngagementResourceAssociations(): this;
    /**
     * Grants permission to listing engagements in AWS Partner Central
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListEngagements.html
     */
    toListEngagements(): this;
    /**
     * Grants permission to list Opportunities on AWS Partner Central
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListOpportunities.html
     */
    toListOpportunities(): this;
    /**
     * Grants permission to listing resource snapshot jobs in AWS Partner Central
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListResourceSnapshotJobs.html
     */
    toListResourceSnapshotJobs(): this;
    /**
     * Grants permission to listing resource snapshots in AWS Partner Central
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListResourceSnapshots.html
     */
    toListResourceSnapshots(): this;
    /**
     * Grants permission to list Solutions on AWS Partner Central
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListSolutions.html
     */
    toListSolutions(): this;
    /**
     * Grants permission to add lists tags to a resource. Supported resource: ResourceSnapshotJob
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to put system settings settings in AWS Partner Central
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_PutSellingSystemSettings.html
     */
    toPutSellingSystemSettings(): this;
    /**
     * Grants permission to reject Engagement Invitations on AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_RejectEngagementInvitation.html
     */
    toRejectEngagementInvitation(): this;
    /**
     * Grants permission to initiate tasks that start Engagements on AWS Partner Central by accepting an Engagement Invitation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * Dependent actions:
     * - partnercentral:AcceptEngagementInvitation
     * - partnercentral:CreateOpportunity
     * - partnercentral:CreateResourceSnapshotJob
     * - partnercentral:GetEngagementInvitation
     * - partnercentral:StartResourceSnapshotJob
     * - partnercentral:SubmitOpportunity
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_StartEngagementByAcceptingInvitationTask.html
     */
    toStartEngagementByAcceptingInvitationTask(): this;
    /**
     * Grants permission to initiate tasks that start Engagements from Opportunities on AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * Dependent actions:
     * - partnercentral:CreateEngagement
     * - partnercentral:CreateEngagementInvitation
     * - partnercentral:CreateResourceSnapshotJob
     * - partnercentral:GetOpportunity
     * - partnercentral:StartResourceSnapshotJob
     * - partnercentral:SubmitOpportunity
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_StartEngagementFromOpportunityTask.html
     */
    toStartEngagementFromOpportunityTask(): this;
    /**
     * Grants permission to starting resource snapshot jobs in AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_StartResourceSnapshotJob.html
     */
    toStartResourceSnapshotJob(): this;
    /**
     * Grants permission to stopping resource snapshot jobs in AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_StopResourceSnapshotJob.html
     */
    toStopResourceSnapshotJob(): this;
    /**
     * Grants permission to submit Opportunities on AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_SubmitOpportunity.html
     */
    toSubmitOpportunity(): this;
    /**
     * Grants permission to add new tags to a resource. Supported resource: ResourceSnapshotJob
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource. Supported resource: ResourceSnapshotJob
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update Opportunities on AWS Partner Central
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCatalog()
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_UpdateOpportunity.html
     */
    toUpdateOpportunity(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Engagement to the statement
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/working-with-multi-partner-opportunities.html
     *
     * @param catalog - Identifier for the catalog.
     * @param identifier - Identifier for the identifier.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEngagement(catalog: string, identifier: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type engagement-by-accepting-invitation-task to the statement
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/working-with-multi-partner-opportunities.html
     *
     * @param catalog - Identifier for the catalog.
     * @param taskId - Identifier for the taskId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEngagementByAcceptingInvitationTask(catalog: string, taskId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type engagement-from-opportunity-task to the statement
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/working-with-multi-partner-opportunities.html
     *
     * @param catalog - Identifier for the catalog.
     * @param taskId - Identifier for the taskId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEngagementFromOpportunityTask(catalog: string, taskId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type engagement-invitation to the statement
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/working-with-multi-partner-opportunities.html
     *
     * @param catalog - Identifier for the catalog.
     * @param identifier - Identifier for the identifier.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEngagementInvitation(catalog: string, identifier: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Opportunity to the statement
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/working-with-your-opportunities.html
     *
     * @param catalog - Identifier for the catalog.
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOpportunity(catalog: string, identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type resource-snapshot-job to the statement
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/working-with-multi-partner-opportunities.html
     *
     * @param catalog - Identifier for the catalog.
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onResourceSnapshotJob(catalog: string, identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ResourceSnapshot to the statement
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/working-with-multi-partner-opportunities.html
     *
     * @param catalog - Identifier for the catalog.
     * @param engagementIdentifier - Identifier for the engagementIdentifier.
     * @param resourceType - Identifier for the resourceType.
     * @param resourceIdentifier - Identifier for the resourceIdentifier.
     * @param templateIdentifier - Identifier for the templateIdentifier.
     * @param snapshotRevision - Identifier for the snapshotRevision.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onResourceSnapshot(catalog: string, engagementIdentifier: string, resourceType: string, resourceIdentifier: string, templateIdentifier: string, snapshotRevision: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Solution to the statement
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/API_ListSolutions.html
     *
     * @param catalog - Identifier for the catalog.
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSolution(catalog: string, identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateResourceSnapshotJob()
     * - .toStartEngagementByAcceptingInvitationTask()
     * - .toStartEngagementFromOpportunityTask()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toDeleteResourceSnapshotJob()
     * - .toGetResourceSnapshotJob()
     * - .toListTagsForResource()
     * - .toStartResourceSnapshotJob()
     * - .toStopResourceSnapshotJob()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateResourceSnapshotJob()
     * - .toDeleteResourceSnapshotJob()
     * - .toGetResourceSnapshotJob()
     * - .toListTagsForResource()
     * - .toStartEngagementByAcceptingInvitationTask()
     * - .toStartEngagementFromOpportunityTask()
     * - .toStartResourceSnapshotJob()
     * - .toStopResourceSnapshotJob()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a specific Catalog. Accepted values: [AWS, Sandbox]
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/access-control.html#managing-permissions-with-condition-keyspage.html#Catalog
     *
     * Applies to actions:
     * - .toAcceptEngagementInvitation()
     * - .toAssignOpportunity()
     * - .toAssociateOpportunity()
     * - .toCreateEngagement()
     * - .toCreateEngagementInvitation()
     * - .toCreateOpportunity()
     * - .toCreateResourceSnapshot()
     * - .toCreateResourceSnapshotJob()
     * - .toDeleteResourceSnapshotJob()
     * - .toDisassociateOpportunity()
     * - .toGetAwsOpportunitySummary()
     * - .toGetEngagement()
     * - .toGetEngagementInvitation()
     * - .toGetOpportunity()
     * - .toGetResourceSnapshot()
     * - .toGetResourceSnapshotJob()
     * - .toGetSellingSystemSettings()
     * - .toListEngagementByAcceptingInvitationTasks()
     * - .toListEngagementFromOpportunityTasks()
     * - .toListEngagementInvitations()
     * - .toListEngagementMembers()
     * - .toListEngagementResourceAssociations()
     * - .toListEngagements()
     * - .toListOpportunities()
     * - .toListResourceSnapshotJobs()
     * - .toListResourceSnapshots()
     * - .toListSolutions()
     * - .toListTagsForResource()
     * - .toRejectEngagementInvitation()
     * - .toStartEngagementByAcceptingInvitationTask()
     * - .toStartEngagementFromOpportunityTask()
     * - .toStartResourceSnapshotJob()
     * - .toStopResourceSnapshotJob()
     * - .toSubmitOpportunity()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateOpportunity()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCatalog(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by entity types for Opportunity association. Accepted values: [Solutions, AwsProducts, AwsMarketplaceOffers]
     *
     * https://docs.aws.amazon.com/partner-central/latest/APIReference/access-control.html#managing-permissions-with-condition-keyspage.html#RelatedEntityType
     *
     * Applies to actions:
     * - .toAssociateOpportunity()
     * - .toDisassociateOpportunity()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRelatedEntityType(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [partnercentral](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspartnercentralselling.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
