import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [pi](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsperformanceinsights.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Pi extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to call CreatePerformanceAnalysisReport API to create a Performance Analysis Report for a specified DB instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_CreatePerformanceAnalysisReport.html
     */
    toCreatePerformanceAnalysisReport(): this;
    /**
     * Grants permission to call DeletePerformanceAnalysisReport API to delete a Performance Analysis Report for a specified DB instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_DeletePerformanceAnalysisReport.html
     */
    toDeletePerformanceAnalysisReport(): this;
    /**
     * Grants permission to call DescribeDimensionKeys API to retrieve the top N dimension keys for a metric for a specific time period
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDimensions()
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_DescribeDimensionKeys.html
     */
    toDescribeDimensionKeys(): this;
    /**
     * Grants permission to call GetDimensionKeyDetails API to retrieve the attributes of the specified dimension group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDimensions()
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetDimensionKeyDetails.html
     */
    toGetDimensionKeyDetails(): this;
    /**
     * Grants permission to call GetPerformanceAnalysisReport API to retrieve a Performance Analysis Report for a specified DB instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetPerformanceAnalysisReport.html
     */
    toGetPerformanceAnalysisReport(): this;
    /**
     * Grants permission to call GetResourceMetadata API to retrieve the metadata for different features
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetResourceMetadata.html
     */
    toGetResourceMetadata(): this;
    /**
     * Grants permission to call GetResourceMetrics API to retrieve PI metrics for a set of data sources, over a time period
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDimensions()
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetResourceMetrics.html
     */
    toGetResourceMetrics(): this;
    /**
     * Grants permission to call ListAvailableResourceDimensions API to retrieve the dimensions that can be queried for each specified metric type on a specified DB instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_ListAvailableResourceDimensions.html
     */
    toListAvailableResourceDimensions(): this;
    /**
     * Grants permission to call ListAvailableResourceMetrics API to retrieve metrics of the specified types that can be queried for a specified DB instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_ListAvailableResourceMetrics.html
     */
    toListAvailableResourceMetrics(): this;
    /**
     * Grants permission to call ListPerformanceAnalysisReports API to list Performance Analysis Reports for a specified DB instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_ListPerformanceAnalysisReports.html
     */
    toListPerformanceAnalysisReports(): this;
    /**
     * Grants permission to call ListTagsForResource API to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to call TagResource API to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to call UntagResource API to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type metric-resource to the statement
     *
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.access-control.html
     *
     * @param serviceType - Identifier for the serviceType.
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMetricResource(serviceType: string, identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type perf-reports-resource to the statement
     *
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.access-control.html
     *
     * @param serviceType - Identifier for the serviceType.
     * @param identifier - Identifier for the identifier.
     * @param reportId - Identifier for the reportId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPerfReportsResource(serviceType: string, identifier: string, reportId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * Applies to actions:
     * - .toCreatePerformanceAnalysisReport()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * Applies to resource types:
     * - perf-reports-resource
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * Applies to actions:
     * - .toCreatePerformanceAnalysisReport()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the requested dimensions
     *
     * Applies to actions:
     * - .toDescribeDimensionKeys()
     * - .toGetDimensionKeyDetails()
     * - .toGetResourceMetrics()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDimensions(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [pi](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsperformanceinsights.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
