import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [mobiletargeting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpoint.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mobiletargeting extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an app
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps.html#CreateApp
     */
    toCreateApp(): this;
    /**
     * Grants permission to create a campaign for an app
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns.html#CreateCampaign
     */
    toCreateCampaign(): this;
    /**
     * Grants permission to create an email template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#CreateEmailTemplate
     */
    toCreateEmailTemplate(): this;
    /**
     * Grants permission to create an export job that exports endpoint definitions to Amazon S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-jobs-export.html#CreateExportJob
     */
    toCreateExportJob(): this;
    /**
     * Grants permission to import endpoint definitions from to create a segment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-jobs-import.html#CreateImportJob
     */
    toCreateImportJob(): this;
    /**
     * Grants permission to create an in-app message template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-inapp.html#CreateInAppTemplate
     */
    toCreateInAppTemplate(): this;
    /**
     * Grants permission to create a Journey for an app
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys.html#CreateJourney
     */
    toCreateJourney(): this;
    /**
     * Grants permission to create a push notification template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#CreatePushTemplate
     */
    toCreatePushTemplate(): this;
    /**
     * Grants permission to create an Amazon Pinpoint configuration for a recommender model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html#CreateRecommenderConfiguration
     */
    toCreateRecommenderConfiguration(): this;
    /**
     * Grants permission to create a segment that is based on endpoint data reported to Pinpoint by your app. To allow a user to create a segment by importing endpoint data from outside of Pinpoint, allow the mobiletargeting:CreateImportJob action
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments.html#CreateSegment
     */
    toCreateSegment(): this;
    /**
     * Grants permission to create an sms message template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#CreateSmsTemplate
     */
    toCreateSmsTemplate(): this;
    /**
     * Grants permission to create a voice message template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#CreateVoiceTemplate
     */
    toCreateVoiceTemplate(): this;
    /**
     * Grants permission to delete the ADM channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-adm.html#DeleteAdmChannel
     */
    toDeleteAdmChannel(): this;
    /**
     * Grants permission to delete the APNs channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns.html#DeleteApnsChannel
     */
    toDeleteApnsChannel(): this;
    /**
     * Grants permission to delete the APNs sandbox channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_sandbox.html#DeleteApnsSandboxChannel
     */
    toDeleteApnsSandboxChannel(): this;
    /**
     * Grants permission to delete the APNs VoIP channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_voip.html#DeleteApnsVoipChannel
     */
    toDeleteApnsVoipChannel(): this;
    /**
     * Grants permission to delete the APNs VoIP sandbox channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_voip_sandbox.html#DeleteApnsVoipSandboxChannel
     */
    toDeleteApnsVoipSandboxChannel(): this;
    /**
     * Grants permission to delete a specific campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id.html#DeleteApp
     */
    toDeleteApp(): this;
    /**
     * Grants permission to delete the Baidu channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-baidu.html#DeleteBaiduChannel
     */
    toDeleteBaiduChannel(): this;
    /**
     * Grants permission to delete a specific campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#DeleteCampaign
     */
    toDeleteCampaign(): this;
    /**
     * Grants permission to delete the email channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-email.html#DeleteEmailChannel
     */
    toDeleteEmailChannel(): this;
    /**
     * Grants permission to delete an email template or an email template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#DeleteEmailTemplate
     */
    toDeleteEmailTemplate(): this;
    /**
     * Grants permission to delete an endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html#DeleteEndpoint
     */
    toDeleteEndpoint(): this;
    /**
     * Grants permission to delete the event stream for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-eventstream.html#DeleteEventStream
     */
    toDeleteEventStream(): this;
    /**
     * Grants permission to delete the GCM channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-gcm.html#DeleteGcmChannel
     */
    toDeleteGcmChannel(): this;
    /**
     * Grants permission to delete an in-app message template or an in-app message template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-inapp.html#DeleteInAppTemplate
     */
    toDeleteInAppTemplate(): this;
    /**
     * Grants permission to delete a specific journey
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#DeleteJourney
     */
    toDeleteJourney(): this;
    /**
     * Grants permission to delete a push notification template or a push notification template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#DeletePushTemplate
     */
    toDeletePushTemplate(): this;
    /**
     * Grants permission to delete an Amazon Pinpoint configuration for a recommender model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#DeleteRecommenderConfiguration
     */
    toDeleteRecommenderConfiguration(): this;
    /**
     * Grants permission to delete a specific segment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments-segment-id.html#DeleteSegment
     */
    toDeleteSegment(): this;
    /**
     * Grants permission to delete the SMS channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-sms.html#DeleteSmsChannel
     */
    toDeleteSmsChannel(): this;
    /**
     * Grants permission to delete an sms message template or an sms message template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#DeleteSmsTemplate
     */
    toDeleteSmsTemplate(): this;
    /**
     * Grants permission to delete all of the endpoints that are associated with a user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-users-user-id.html#DeleteUserEndpoints
     */
    toDeleteUserEndpoints(): this;
    /**
     * Grants permission to delete the Voice channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-voice.html#DeleteVoiceChannel
     */
    toDeleteVoiceChannel(): this;
    /**
     * Grants permission to delete a voice message template or a voice message template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#DeleteVoiceTemplate
     */
    toDeleteVoiceTemplate(): this;
    /**
     * Grants permission to retrieve information about the Amazon Device Messaging (ADM) channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-adm.html#GetAdmChannel
     */
    toGetAdmChannel(): this;
    /**
     * Grants permission to retrieve information about the APNs channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns.html#GetApnsChannel
     */
    toGetApnsChannel(): this;
    /**
     * Grants permission to retrieve information about the APNs sandbox channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_sandbox.html#GetApnsSandboxChannel
     */
    toGetApnsSandboxChannel(): this;
    /**
     * Grants permission to retrieve information about the APNs VoIP channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_voip.html#GetApnsVoipChannel
     */
    toGetApnsVoipChannel(): this;
    /**
     * Grants permission to retrieve information about the APNs VoIP sandbox channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_voip_sandbox.html#GetApnsVoipSandboxChannel
     */
    toGetApnsVoipSandboxChannel(): this;
    /**
     * Grants permission to retrieve information about a specific app in your Amazon Pinpoint account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id.html#GetApp
     */
    toGetApp(): this;
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard metric that applies to an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-kpis-daterange-kpi-name.html#GetApplicationDateRangeKpi
     */
    toGetApplicationDateRangeKpi(): this;
    /**
     * Grants permission to retrieve the default settings for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-settings.html#GetApplicationSettings
     */
    toGetApplicationSettings(): this;
    /**
     * Grants permission to retrieve a list of apps in your Amazon Pinpoint account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps.html#GetApps
     */
    toGetApps(): this;
    /**
     * Grants permission to retrieve information about the Baidu channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-baidu.html#GetBaiduChannel
     */
    toGetBaiduChannel(): this;
    /**
     * Grants permission to retrieve information about a specific campaign
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#GetCampaign
     */
    toGetCampaign(): this;
    /**
     * Grants permission to retrieve information about the activities performed by a campaign
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id-activities.html#GetCampaignActivities
     */
    toGetCampaignActivities(): this;
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard metric that applies to a campaign
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id-kpis-daterange-kpi-name.html#GetCampaignDateRangeKpi
     */
    toGetCampaignDateRangeKpi(): this;
    /**
     * Grants permission to retrieve information about a specific campaign version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id-versions-version.html#GetCampaignVersion
     */
    toGetCampaignVersion(): this;
    /**
     * Grants permission to retrieve information about the current and prior versions of a campaign
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id-versions.html#GetCampaignVersions
     */
    toGetCampaignVersions(): this;
    /**
     * Grants permission to retrieve information about all campaigns for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns.html#GetCampaigns
     */
    toGetCampaigns(): this;
    /**
     * Grants permission to get all channels information for your app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels.html#GetChannels
     */
    toGetChannels(): this;
    /**
     * Grants permission to obtain information about the email channel in an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-email.html#GetEmailChannel
     */
    toGetEmailChannel(): this;
    /**
     * Grants permission to retrieve information about a specific or the active version of an email template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#GetEmailTemplate
     */
    toGetEmailTemplate(): this;
    /**
     * Grants permission to retrieve information about a specific endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html#GetEndpoint
     */
    toGetEndpoint(): this;
    /**
     * Grants permission to retrieve information about the event stream for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-eventstream.html#GetEventStream
     */
    toGetEventStream(): this;
    /**
     * Grants permission to obtain information about a specific export job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-jobs-export-job-id.html#GetExportJob
     */
    toGetExportJob(): this;
    /**
     * Grants permission to retrieve a list of all of the export jobs for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-jobs-export.html#GetExportJobs
     */
    toGetExportJobs(): this;
    /**
     * Grants permission to retrieve information about the GCM channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-gcm.html#GetGcmChannel
     */
    toGetGcmChannel(): this;
    /**
     * Grants permission to retrieve information about a specific import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-jobs-import-job-id.html#GetImportJob
     */
    toGetImportJob(): this;
    /**
     * Grants permission to retrieve information about all import jobs for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-jobs-import.html#GetImportJobs
     */
    toGetImportJobs(): this;
    /**
     * Grants permission to retrive in-app messages for the given endpoint id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id-inappmessages.html#GetInAppMessages
     */
    toGetInAppMessages(): this;
    /**
     * Grants permission to retrieve information about a specific or the active version of an in-app message template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-inapp.html#GetInAppTemplate
     */
    toGetInAppTemplate(): this;
    /**
     * Grants permission to retrieve information about a specific journey
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#GetJourney
     */
    toGetJourney(): this;
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard engagement metric that applies to a journey
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-kpis-daterange-kpi-name.html#GetJourneyDateRangeKpi
     */
    toGetJourneyDateRangeKpi(): this;
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard execution metric that applies to a journey activity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-activities-journey-activity-id-execution-metrics.html#GetJourneyExecutionActivityMetrics
     */
    toGetJourneyExecutionActivityMetrics(): this;
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard execution metric that applies to a journey
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-execution-metrics.html#GetJourneyExecutionMetrics
     */
    toGetJourneyExecutionMetrics(): this;
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard execution metric that applies to a journey activity for a single journey run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-runs-run-id-activities-journey-activity-id-execution-metrics.html#GetJourneyRunExecutionActivityMetrics
     */
    toGetJourneyRunExecutionActivityMetrics(): this;
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard execution metric that applies to a journey for a single journey run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-runs-run-id-execution-metrics.html#GetJourneyRunExecutionMetrics
     */
    toGetJourneyRunExecutionMetrics(): this;
    /**
     * Grants permission to retrieve information about all journey runs for a journey
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-runs.html
     */
    toGetJourneyRuns(): this;
    /**
     * Grants permission to retrieve information about a specific or the active version of an push notification template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#GetPushTemplate
     */
    toGetPushTemplate(): this;
    /**
     * Grants permission to retrieve information about an Amazon Pinpoint configuration for a recommender model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#GetRecommenderConfiguration
     */
    toGetRecommenderConfiguration(): this;
    /**
     * Grants permission to retrieve information about all the recommender model configurations that are associated with an Amazon Pinpoint account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html#GetRecommenderConfigurations
     */
    toGetRecommenderConfigurations(): this;
    /**
     * Grants permission to mobiletargeting:GetReports
     *
     * Access Level: Read
     */
    toGetReports(): this;
    /**
     * Grants permission to retrieve information about a specific segment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments-segment-id.html#GetSegment
     */
    toGetSegment(): this;
    /**
     * Grants permission to retrieve information about jobs that export endpoint definitions from segments to Amazon S3
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments-segment-id-jobs-export.html#GetSegmentExportJobs
     */
    toGetSegmentExportJobs(): this;
    /**
     * Grants permission to retrieve information about jobs that create segments by importing endpoint definitions from
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments-segment-id-jobs-import.html#GetSegmentImportJobs
     */
    toGetSegmentImportJobs(): this;
    /**
     * Grants permission to retrieve information about a specific segment version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments-segment-id-versions-version.html#GetSegmentVersion
     */
    toGetSegmentVersion(): this;
    /**
     * Grants permission to retrieve information about the current and prior versions of a segment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments-segment-id-versions.html#GetSegmentVersions
     */
    toGetSegmentVersions(): this;
    /**
     * Grants permission to retrieve information about the segments for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments.html#GetSegments
     */
    toGetSegments(): this;
    /**
     * Grants permission to obtain information about the SMS channel in an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-sms.html#GetSmsChannel
     */
    toGetSmsChannel(): this;
    /**
     * Grants permission to retrieve information about a specific or the active version of an sms message template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#GetSmsTemplate
     */
    toGetSmsTemplate(): this;
    /**
     * Grants permission to retrieve information about the endpoints that are associated with a user ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-users-user-id.html#GetUserEndpoints
     */
    toGetUserEndpoints(): this;
    /**
     * Grants permission to obtain information about the Voice channel in an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-voice.html#GetVoiceChannel
     */
    toGetVoiceChannel(): this;
    /**
     * Grants permission to retrieve information about a specific or the active version of a voice message template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#GetVoiceTemplate
     */
    toGetVoiceTemplate(): this;
    /**
     * Grants permission to retrieve information about all journeys for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys.html#ListJourneys
     */
    toListJourneys(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html#ListTagsForResource
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to retrieve all versions about a specific template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-template-type-versions.html#ListTemplateVersions
     */
    toListTemplateVersions(): this;
    /**
     * Grants permission to retrieve metadata about the queried templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates.html#ListTemplates
     */
    toListTemplates(): this;
    /**
     * Grants permission to obtain metadata for a phone number, such as the number type (mobile, landline, or VoIP), location, and provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/phone-number-validate.html#PhoneNumberValidate
     */
    toPhoneNumberValidate(): this;
    /**
     * Grants permission to create or update an event stream for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-eventstream.html#PutEventStream
     */
    toPutEventStream(): this;
    /**
     * Grants permission to create or update events for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-events.html#PutEvents
     */
    toPutEvents(): this;
    /**
     * Grants permission to remove the attributes for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-attributes-attribute-type.html#RemoveAttributes
     */
    toRemoveAttributes(): this;
    /**
     * Grants permission to send an SMS message or push notification to specific endpoints
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#SendMessages
     */
    toSendMessages(): this;
    /**
     * Grants permission to send an OTP code to a user of your application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-otp.html#SendOTPMessage
     */
    toSendOTPMessage(): this;
    /**
     * Grants permission to send an SMS message or push notification to all endpoints that are associated with a specific user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-users-messages.html#SendUsersMessages
     */
    toSendUsersMessages(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html#TagResource
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html#UntagResource
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the Amazon Device Messaging (ADM) channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-adm.html#UpdateAdmChannel
     */
    toUpdateAdmChannel(): this;
    /**
     * Grants permission to update the Apple Push Notification service (APNs) channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns.html#UpdateApnsChannel
     */
    toUpdateApnsChannel(): this;
    /**
     * Grants permission to update the Apple Push Notification service (APNs) sandbox channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_sandbox.html#UpdateApnsSandboxChannel
     */
    toUpdateApnsSandboxChannel(): this;
    /**
     * Grants permission to update the Apple Push Notification service (APNs) VoIP channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_voip.html#UpdateApnsVoipChannel
     */
    toUpdateApnsVoipChannel(): this;
    /**
     * Grants permission to update the Apple Push Notification service (APNs) VoIP sandbox channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-apns_voip_sandbox.html#UpdateApnsVoipSandboxChannel
     */
    toUpdateApnsVoipSandboxChannel(): this;
    /**
     * Grants permission to update the default settings for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-settings.html#UpdateApplicationSettings
     */
    toUpdateApplicationSettings(): this;
    /**
     * Grants permission to update the Baidu channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-baidu.html#UpdateBaiduChannel
     */
    toUpdateBaiduChannel(): this;
    /**
     * Grants permission to update a specific campaign
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#UpdateCampaign
     */
    toUpdateCampaign(): this;
    /**
     * Grants permission to update the email channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-email.html#UpdateEmailChannel
     */
    toUpdateEmailChannel(): this;
    /**
     * Grants permission to update a specific email template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#UpdateEmailTemplate
     */
    toUpdateEmailTemplate(): this;
    /**
     * Grants permission to create an endpoint or update the information for an endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html#UpdateEndpoint
     */
    toUpdateEndpoint(): this;
    /**
     * Grants permission to create or update endpoints as a batch operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints.html#UpdateEndpointsBatch
     */
    toUpdateEndpointsBatch(): this;
    /**
     * Grants permission to update the Firebase Cloud Messaging (FCM) or Google Cloud Messaging (GCM) API key that allows to send push notifications to your Android app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-gcm.html#UpdateGcmChannel
     */
    toUpdateGcmChannel(): this;
    /**
     * Grants permission to update a specific in-app message template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-inapp.html#UpdateInAppTemplate
     */
    toUpdateInAppTemplate(): this;
    /**
     * Grants permission to update a specific journey
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#UpdateJourney
     */
    toUpdateJourney(): this;
    /**
     * Grants permission to update a specific journey state
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-state.html#UpdateJourneyState
     */
    toUpdateJourneyState(): this;
    /**
     * Grants permission to update a specific push notification template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#UpdatePushTemplate
     */
    toUpdatePushTemplate(): this;
    /**
     * Grants permission to update an Amazon Pinpoint configuration for a recommender model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#UpdateRecommenderConfiguration
     */
    toUpdateRecommenderConfiguration(): this;
    /**
     * Grants permission to update a specific segment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments-segment-id.html#UpdateSegment
     */
    toUpdateSegment(): this;
    /**
     * Grants permission to update the SMS channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-sms.html#UpdateSmsChannel
     */
    toUpdateSmsChannel(): this;
    /**
     * Grants permission to update a specific sms message template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#UpdateSmsTemplate
     */
    toUpdateSmsTemplate(): this;
    /**
     * Grants permission to update the active version parameter of a specific template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-template-type-active-version.html#UpdateTemplateActiveVersion
     */
    toUpdateTemplateActiveVersion(): this;
    /**
     * Grants permission to update the Voice channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels-voice.html#UpdateVoiceChannel
     */
    toUpdateVoiceChannel(): this;
    /**
     * Grants permission to update a specific voice message template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#UpdateVoiceTemplate
     */
    toUpdateVoiceTemplate(): this;
    /**
     * Grants permission to check the validity of One-Time Passwords (OTPs)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-verify-otp.html#VerifyOTPMessage
     */
    toVerifyOTPMessage(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type app to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApp(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type apps to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApps(resourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type campaign to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html
     *
     * @param appId - Identifier for the appId.
     * @param campaignId - Identifier for the campaignId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCampaign(appId: string, campaignId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type journey to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html
     *
     * @param appId - Identifier for the appId.
     * @param journeyId - Identifier for the journeyId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJourney(appId: string, journeyId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type journeys to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onJourneys(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type segment to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-segments-segment-id.html
     *
     * @param appId - Identifier for the appId.
     * @param segmentId - Identifier for the segmentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSegment(appId: string, segmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type template to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param templateType - Identifier for the templateType.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTemplate(templateName: string, templateType: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type templates to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTemplates(account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type recommender to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html
     *
     * @param recommenderId - Identifier for the recommenderId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRecommender(recommenderId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type recommenders to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRecommenders(resourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type phone-number-validate to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/phone-number-validate.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPhoneNumberValidate(account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type channels to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onChannels(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type channel to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-channels.html
     *
     * @param appId - Identifier for the appId.
     * @param channelType - Identifier for the channelType.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onChannel(appId: string, channelType: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type event-stream to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-eventstream.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEventStream(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type events to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-events.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEvents(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type messages to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMessages(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type verify-otp to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-verify-otp.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onVerifyOtp(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type otp to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-verify-otp.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOtp(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type attribute to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-attributes-attribute-type.html
     *
     * @param appId - Identifier for the appId.
     * @param attributeType - Identifier for the attributeType.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAttribute(appId: string, attributeType: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-users-user-id.html
     *
     * @param appId - Identifier for the appId.
     * @param userId - Identifier for the userId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onUser(appId: string, userId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type endpoint to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html
     *
     * @param appId - Identifier for the appId.
     * @param endpointId - Identifier for the endpointId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEndpoint(appId: string, endpointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type import-job to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-jobs-import-job-id.html
     *
     * @param appId - Identifier for the appId.
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onImportJob(appId: string, jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type export-job to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-jobs-export-job-id.html
     *
     * @param appId - Identifier for the appId.
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onExportJob(appId: string, jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type application-metrics to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-kpis-daterange-kpi-name.html
     *
     * @param appId - Identifier for the appId.
     * @param kpiName - Identifier for the kpiName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApplicationMetrics(appId: string, kpiName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type campaign-metrics to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id-kpis-daterange-kpi-name.html
     *
     * @param appId - Identifier for the appId.
     * @param campaignId - Identifier for the campaignId.
     * @param kpiName - Identifier for the kpiName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCampaignMetrics(appId: string, campaignId: string, kpiName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type journey-metrics to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-kpis-daterange-kpi-name.html
     *
     * @param appId - Identifier for the appId.
     * @param journeyId - Identifier for the journeyId.
     * @param kpiName - Identifier for the kpiName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onJourneyMetrics(appId: string, journeyId: string, kpiName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type journey-execution-metrics to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-execution-metrics.html
     *
     * @param appId - Identifier for the appId.
     * @param journeyId - Identifier for the journeyId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onJourneyExecutionMetrics(appId: string, journeyId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type journey-execution-activity-metrics to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-activities-journey-activity-id-execution-metrics.html
     *
     * @param appId - Identifier for the appId.
     * @param journeyId - Identifier for the journeyId.
     * @param journeyActivityId - Identifier for the journeyActivityId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onJourneyExecutionActivityMetrics(appId: string, journeyId: string, journeyActivityId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type reports to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/reports.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onReports(account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a key that is present in the request the user makes to the pinpoint service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to actions:
     * - .toCreateApp()
     * - .toCreateCampaign()
     * - .toCreateEmailTemplate()
     * - .toCreateInAppTemplate()
     * - .toCreateJourney()
     * - .toCreatePushTemplate()
     * - .toCreateSegment()
     * - .toCreateSmsTemplate()
     * - .toCreateVoiceTemplate()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCampaign()
     * - .toUpdateEmailTemplate()
     * - .toUpdateInAppTemplate()
     * - .toUpdateJourney()
     * - .toUpdateJourneyState()
     * - .toUpdatePushTemplate()
     * - .toUpdateSegment()
     * - .toUpdateSmsTemplate()
     * - .toUpdateVoiceTemplate()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to actions:
     * - .toCreateApp()
     * - .toCreateCampaign()
     * - .toCreateEmailTemplate()
     * - .toCreateInAppTemplate()
     * - .toCreateJourney()
     * - .toCreatePushTemplate()
     * - .toCreateSegment()
     * - .toCreateSmsTemplate()
     * - .toCreateVoiceTemplate()
     *
     * Applies to resource types:
     * - app
     * - campaign
     * - journey
     * - segment
     * - template
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the list of all the tag key names present in the request the user makes to the pinpoint service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-permissions.html#iam-contextkeys
     *
     * Applies to actions:
     * - .toCreateApp()
     * - .toCreateCampaign()
     * - .toCreateEmailTemplate()
     * - .toCreateInAppTemplate()
     * - .toCreateJourney()
     * - .toCreatePushTemplate()
     * - .toCreateSegment()
     * - .toCreateSmsTemplate()
     * - .toCreateVoiceTemplate()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCampaign()
     * - .toUpdateEmailTemplate()
     * - .toUpdateInAppTemplate()
     * - .toUpdateJourney()
     * - .toUpdateJourneyState()
     * - .toUpdatePushTemplate()
     * - .toUpdateSegment()
     * - .toUpdateSmsTemplate()
     * - .toUpdateVoiceTemplate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [mobiletargeting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpoint.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
