import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [pca-connector-ad](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecaconnectorforactivedirectory.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class PcaConnectorAd extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a Connector in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - acm-pca:DescribeCertificateAuthority
     * - acm-pca:GetCertificate
     * - acm-pca:GetCertificateAuthorityCertificate
     * - acm-pca:IssueCertificate
     * - ec2:CreateTags
     * - ec2:CreateVpcEndpoint
     * - ec2:DescribeVpcEndpoints
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html
     */
    toCreateConnector(): this;
    /**
     * Grants permission to create a DirectoryRegistration in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html
     */
    toCreateDirectoryRegistration(): this;
    /**
     * Grants permission to create a ServicePrincipalName for a DirectoryRegistration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UpdateAuthorizedApplication
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateServicePrincipalName.html
     */
    toCreateServicePrincipalName(): this;
    /**
     * Grants permission to create a Template for a Connector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html
     */
    toCreateTemplate(): this;
    /**
     * Grants permission to create a TemplateGroupAccessControlEntry for a Template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplateGroupAccessControlEntry.html
     */
    toCreateTemplateGroupAccessControlEntry(): this;
    /**
     * Grants permission to delete a Connector in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DeleteVpcEndpoints
     * - ec2:DescribeVpcEndpoints
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteConnector.html
     */
    toDeleteConnector(): this;
    /**
     * Grants permission to delete a DirectoryRegistration in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     * - ds:UpdateAuthorizedApplication
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration.html
     */
    toDeleteDirectoryRegistration(): this;
    /**
     * Grants permission to delete a ServicePrincipalName for a DirectoryRegistration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UpdateAuthorizedApplication
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteServicePrincipalName.html
     */
    toDeleteServicePrincipalName(): this;
    /**
     * Grants permission to delete a Template for a Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteTemplate.html
     */
    toDeleteTemplate(): this;
    /**
     * Grants permission to delete a TemplateGroupAccessControlEntry for a Template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteTemplateGroupAccessControlEntry.html
     */
    toDeleteTemplateGroupAccessControlEntry(): this;
    /**
     * Grants permission to get a Connector in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_GetConnector.html
     */
    toGetConnector(): this;
    /**
     * Grants permission to get a DirectoryRegistration in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_GetDirectoryRegistration.html
     */
    toGetDirectoryRegistration(): this;
    /**
     * Grants permission to get a ServicePrincipalName for a DirectoryRegistration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_GetServicePrincipalName.html
     */
    toGetServicePrincipalName(): this;
    /**
     * Grants permission to get a Template for a Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_GetTemplate.html
     */
    toGetTemplate(): this;
    /**
     * Grants permission to get a TemplateGroupAccessControlEntry for a Template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_GetTemplateGroupAccessControlEntry.html
     */
    toGetTemplateGroupAccessControlEntry(): this;
    /**
     * Grants permission to list the Connectors in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors.html
     */
    toListConnectors(): this;
    /**
     * Grants permission to list the DirectoryRegistrations in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListDirectoryRegistrations.html
     */
    toListDirectoryRegistrations(): this;
    /**
     * Grants permission to list the ServicePrincipalNames for a DirectoryRegistration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListServicePrincipalNames.html
     */
    toListServicePrincipalNames(): this;
    /**
     * Grants permission to list the tags for a pca-connector-ad resource in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list the TemplateGroupAccessControlEntries for a Template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListTemplateGroupAccessControlEntries.html
     */
    toListTemplateGroupAccessControlEntries(): this;
    /**
     * Grants permission to list the Templates for a Connector
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListTemplates.html
     */
    toListTemplates(): this;
    /**
     * Grants permission to tag a pca-connector-ad resource in your account
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a pca-connector-ad resource in your account
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a Template for a Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_UpdateTemplate.html
     */
    toUpdateTemplate(): this;
    /**
     * Grants permission to update a TemplateGroupAccessControlEntry for a Template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_UpdateTemplateGroupAccessControlEntry.html
     */
    toUpdateTemplateGroupAccessControlEntry(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Connector to the statement
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_Connector.html
     *
     * @param connectorId - Identifier for the connectorId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnector(connectorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type DirectoryRegistration to the statement
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DirectoryRegistration.html
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDirectoryRegistration(directoryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Template to the statement
     *
     * https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_Template.html
     *
     * @param connectorId - Identifier for the connectorId.
     * @param templateId - Identifier for the templateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTemplate(connectorId: string, templateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by on the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecaconnectorforactivedirectory.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateConnector()
     * - .toCreateDirectoryRegistration()
     * - .toCreateTemplate()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by on the tags associated with the resource
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecaconnectorforactivedirectory.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateConnector()
     * - .toCreateDirectoryRegistration()
     * - .toCreateTemplate()
     *
     * Applies to resource types:
     * - Connector
     * - DirectoryRegistration
     * - Template
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by on the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecaconnectorforactivedirectory.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateConnector()
     * - .toCreateDirectoryRegistration()
     * - .toCreateTemplate()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [pca-connector-ad](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecaconnectorforactivedirectory.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
