import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [pca-connector-scep](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecaconnectorforscep.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class PcaConnectorScep extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a Challenge for a Connector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_CreateChallenge.html
     */
    toCreateChallenge(): this;
    /**
     * Grants permission to create a SCEP Connector in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - acm-pca:DescribeCertificateAuthority
     * - acm-pca:GetCertificate
     * - acm-pca:GetCertificateAuthorityCertificate
     * - acm-pca:IssueCertificate
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_CreateConnector.html
     */
    toCreateConnector(): this;
    /**
     * Grants permission to delete a Challenge for a Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_DeleteChallenge.html
     */
    toDeleteChallenge(): this;
    /**
     * Grants permission to delete a SCEP Connector in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_DeleteConnector.html
     */
    toDeleteConnector(): this;
    /**
     * Grants permission to get a Challenge for a Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_GetChallengeMetadata.html
     */
    toGetChallengeMetadata(): this;
    /**
     * Grants permission to get a Challenge password for a Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_GetChallengePassword.html
     */
    toGetChallengePassword(): this;
    /**
     * Grants permission to get a SCEP Connector in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_GetConnector.html
     */
    toGetConnector(): this;
    /**
     * Grants permission to list Challenges for a Connector
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_ListChallengeMetadata.html
     */
    toListChallengeMetadata(): this;
    /**
     * Grants permission to list the SCEP Connectors in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_ListConnectors.html
     */
    toListConnectors(): this;
    /**
     * Grants permission to list the tags for a pca-connector-scep resource in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to tag a pca-connector-scep resource in your account
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a pca-connector-scep resource in your account
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Challenge to the statement
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_Challenge.html
     *
     * @param connectorId - Identifier for the connectorId.
     * @param challengeId - Identifier for the challengeId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChallenge(connectorId: string, challengeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Connector to the statement
     *
     * https://docs.aws.amazon.com/pca-connector-scep/latest/APIReference/API_Connector.html
     *
     * @param connectorId - Identifier for the connectorId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnector(connectorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/privateca/latest/userguide/connector-for-scep.htmlreference_policies_iam-condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateChallenge()
     * - .toCreateConnector()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/privateca/latest/userguide/connector-for-scep.htmlreference_policies_iam-condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - Challenge
     * - Connector
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/privateca/latest/userguide/connector-for-scep.htmlreference_policies_iam-condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateChallenge()
     * - .toCreateConnector()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [pca-connector-scep](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecaconnectorforscep.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
