import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [vpce](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatelink.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Vpce extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to manage multi-region VPC endpoints and VPC endpoint service configurations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/privatelink/vpc/latest/privatelink/security_iam_service-with-iam.html
     */
    toAllowMultiRegion(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [vpce](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatelink.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
