import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [route53profiles](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53profiles.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Route53profiles extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associates a Profile to the customer VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_AssociateProfile.html
     */
    toAssociateProfile(): this;
    /**
     * Grants permission to associates a resource, such as DNS Firewall rule group, private hosted zone, resolver rule, etc. to a specified Profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_AssociateResourceToProfile.html
     */
    toAssociateResourceToProfile(): this;
    /**
     * Grants permission to create a new Profile resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to delete a Profile specified by the ProfileId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_DeleteProfile.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to delete an association between a customer VPC and the specified Profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_DisassociateProfile.html
     */
    toDisassociateProfile(): this;
    /**
     * Grants permission to delete the asoociation between the resource. such as DNS Firewall rule group, private hosted zone, resolver rule, etc. and the specified Profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_DisassociateResourceFromProfile.html
     */
    toDisassociateResourceFromProfile(): this;
    /**
     * Grants permission to get a Profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_GetProfile.html
     */
    toGetProfile(): this;
    /**
     * Grants permission to get a Profile to a VPC association specified by the Profile association ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_GetProfileAssociation.html
     */
    toGetProfileAssociation(): this;
    /**
     * Grants permission to read the RAM access control policy for a Profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/sharing-profiles.html
     */
    toGetProfilePolicy(): this;
    /**
     * Grants permission to get a Profile resource association based on the ProfileResourceAssociationId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_GetProfileResourceAssociation.html
     */
    toGetProfileResourceAssociation(): this;
    /**
     * Grants permission to list all VPCs the specified Profile is associated to
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_ListProfileAssociations.html
     */
    toListProfileAssociations(): this;
    /**
     * Grants permission to list all the associations between the resources, such as DNS Firewall rule groups, private hosted zones, resolver rules, etc. for the given Profile ID
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_ListProfileResourceAssociations.html
     */
    toListProfileResourceAssociations(): this;
    /**
     * Grants permission to list all the Profiles created by, and shared to the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_ListProfiles.html
     */
    toListProfiles(): this;
    /**
     * Grants permission to list all tags associated with the resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to define the RAM access control policy for a Profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/sharing-profiles.html
     */
    toPutProfilePolicy(): this;
    /**
     * Grants permission to add a tag to the given resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to delete a tag from the given resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the Profile resource association name or the resource properties or both, if both name and resource properties are null, the api returns the existing Profile resource association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_UpdateProfileResourceAssociation.html
     */
    toUpdateProfileResourceAssociation(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type profile-association to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfileAssociation(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toAssociateProfile()
     * - .toCreateProfile()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - profile
     * - profile-association
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toAssociateProfile()
     * - .toCreateProfile()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [route53profiles](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53profiles.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
