"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SagemakerDataScienceAssistant = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [sagemaker-data-science-assistant](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerdatascienceassistant.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SagemakerDataScienceAssistant extends shared_1.PolicyStatement {
    /**
     * Grants permission to start a conversation with SageMaker data science assistant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker-dsa/APIReference/
     */
    toSendConversation() {
        return this.to('SendConversation');
    }
    /**
     * Statement provider for service [sagemaker-data-science-assistant](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerdatascienceassistant.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'sagemaker-data-science-assistant';
        this.accessLevelList = {
            Write: [
                'SendConversation'
            ]
        };
    }
}
exports.SagemakerDataScienceAssistant = SagemakerDataScienceAssistant;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2FnZW1ha2VyZGF0YXNjaWVuY2Vhc3Npc3RhbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzYWdlbWFrZXJkYXRhc2NpZW5jZWFzc2lzdGFudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx5Q0FBK0M7QUFHL0M7Ozs7R0FJRztBQUNILE1BQWEsNkJBQThCLFNBQVEsd0JBQWU7SUFHaEU7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFRRDs7O09BR0c7SUFDSCxZQUFZLEtBQWdDO1FBQzFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQXhCUixrQkFBYSxHQUFHLGtDQUFrQyxDQUFDO1FBYWhELG9CQUFlLEdBQW9CO1lBQzNDLEtBQUssRUFBRTtnQkFDTCxrQkFBa0I7YUFDbkI7U0FDRixDQUFDO0lBUUYsQ0FBQztDQUNGO0FBM0JELHNFQTJCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uLy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnLi4vLi4vc2hhcmVkJztcbmltcG9ydCB7IGF3c19pYW0gYXMgaWFtIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtzYWdlbWFrZXItZGF0YS1zY2llbmNlLWFzc2lzdGFudF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9uc2FnZW1ha2VyZGF0YXNjaWVuY2Vhc3Npc3RhbnQuaHRtbCkuXG4gKlxuICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBTYWdlbWFrZXJEYXRhU2NpZW5jZUFzc2lzdGFudCBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ3NhZ2VtYWtlci1kYXRhLXNjaWVuY2UtYXNzaXN0YW50JztcblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RhcnQgYSBjb252ZXJzYXRpb24gd2l0aCBTYWdlTWFrZXIgZGF0YSBzY2llbmNlIGFzc2lzdGFudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zYWdlbWFrZXItZHNhL0FQSVJlZmVyZW5jZS9cbiAgICovXG4gIHB1YmxpYyB0b1NlbmRDb252ZXJzYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NlbmRDb252ZXJzYXRpb24nKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ1NlbmRDb252ZXJzYXRpb24nXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW3NhZ2VtYWtlci1kYXRhLXNjaWVuY2UtYXNzaXN0YW50XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b25zYWdlbWFrZXJkYXRhc2NpZW5jZWFzc2lzdGFudC5odG1sKS5cbiAgICpcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByb3BzPzogaWFtLlBvbGljeVN0YXRlbWVudFByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICB9XG59XG4iXX0=