"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Signin = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [signin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssignin.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Signin extends shared_1.PolicyStatement {
    /**
     * Grants permission to create an Identity Center application that represents the AWS Management Console on an Identity Center organization instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:CreateApplication
     * - sso:GetSharedSsoConfiguration
     * - sso:ListApplications
     * - sso:PutApplicationAccessScope
     * - sso:PutApplicationAssignmentConfiguration
     * - sso:PutApplicationAuthenticationMethod
     * - sso:PutApplicationGrant
     *
     * https://docs.aws.amazon.com/signin/latest/APIReference/create-trusted-identity-propagation-application-for-console.html
     */
    toCreateTrustedIdentityPropagationApplicationForConsole() {
        return this.to('CreateTrustedIdentityPropagationApplicationForConsole');
    }
    /**
     * Grants permission to list all Identity Center applications that represent the AWS Management Console
     *
     * Access Level: List
     *
     * Dependent actions:
     * - sso:GetSharedSsoConfiguration
     * - sso:ListApplications
     *
     * https://docs.aws.amazon.com/signin/latest/APIReference/list-trusted-identity-propagation-application-for-console.html
     */
    toListTrustedIdentityPropagationApplicationsForConsole() {
        return this.to('ListTrustedIdentityPropagationApplicationsForConsole');
    }
    /**
     * Statement provider for service [signin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssignin.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'signin';
        this.accessLevelList = {
            Write: [
                'CreateTrustedIdentityPropagationApplicationForConsole'
            ],
            List: [
                'ListTrustedIdentityPropagationApplicationsForConsole'
            ]
        };
    }
}
exports.Signin = Signin;
//# sourceMappingURL=data:application/json;base64,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